UNIT SubPro;

INTERFACE

const
   SCROLL_X_GAP : byte = 8;
   SCROLL_Y_GAP : byte = 40;
   SCROLL_X_WIDE : byte = 15;
   SCROLL_Y_WIDE : byte = 8;
   TILE_X_SIZE = 2;
   TILE_Y_SIZE = 16;

   MAX_TILE = 1000;
   MAX_CHARACTER = 8;
   IMAGE_SIZE = 134;
   CHARACTER_SIZE = 518;
   PALETTE_SIZE = 48;

type
   tile_T = array[1..IMAGE_SIZE] of byte;
   character_T = array[1..CHARACTER_SIZE] of byte;
   map_T = array[0..20000] of word;
   palette_T = array[0..15,1..3] of byte;

var
   tile_data : array[0..MAX_TILE-1] of ^tile_T;
   character_data : array[0..MAX_CHARACTER-1] of ^character_T;
   map_data : ^map_T;
   x_max, y_max : word;
   palette_data : palette_T;


 procedure initGraph;
 procedure closeGraph;
 procedure setPalette(palette_number : byte);
 procedure setRGB(Color, Red, Green, Blue : byte);
 procedure waitVerticalRetrace(count : integer);
 function  readMap(x,y : integer) : word;
 procedure printImage(X, Y: Integer; var BitMap);
 procedure printSprite16(X, Y: Integer; var BitMap);
 procedure printSprite32(X, Y: Integer; var BitMap);
 procedure flipPage;
 procedure putPCX16(fn : string);

IMPLEMENTATION

procedure initGraph; assembler;
asm
   mov ah, $00
   mov al, $12
   int $10
end;

procedure closeGraph; assembler;
asm
   mov ah, $00
   mov al, $03
   int $10
end;

procedure setPalette(palette_number : byte); assembler;
asm
   mov ah,$10
   mov al, 0
   mov bh, palette_number
   mov bl, palette_number
   int $10
end;

procedure setRGB(Color, Red, Green, Blue : byte); assembler;
asm
   mov dx,$3c8;
   mov al,Color;
   out dx,al;
   inc dx;
   mov al,Red;
   out dx,al;
   mov al,Green;
   out dx,al;
   mov al,Blue;
   out dx,al;
end;

procedure waitVerticalRetrace(count : integer);
var
   c : char;
begin
   while count > 0 do begin
      while (port[$03DA] and 8) > 0 do;
      while (port[$03DA] and 8) = 0 do;
      dec(count);
   end;
end;

function readMap(x,y : integer) : word;
begin
   if x < 0 then x := x_max + x -1;
   if y < 0 then y := y_max + y -1;
   if x > x_max - 1 then x := x - x_max;
   if y > y_max - 1 then y := y - y_max;
   readMap := map_data^[y * x_max + x];
end;

procedure printImage(X, Y: Integer; var BitMap);
var
   sour_seg, sour_off, dest_seg, dest_off : word;
   plane : byte;
   i : integer;
begin
   plane := 4;
   sour_seg := seg(BitMap);
   sour_off := ofs(BitMap) + 4;

   dest_seg := $A960 + (y * TILE_Y_SIZE) * 5;
   dest_off := x * TILE_X_SIZE;

   asm
      push ds
      push es

      mov ax, sour_seg
      mov ds, ax
      mov ax, dest_seg
      mov es, ax
      mov dx, $3C4

@MAIN_LOOP:
      mov si, sour_off
      mov di, dest_off
      mov al, plane

@JUMP2:
      cmp al, 8
      je @JUMP3
      shl al, 1
      add si, TILE_X_SIZE
      jmp @JUMP2

@JUMP3:
      mov al, $02
      mov ah, plane
      out dx, ax
      mov cx, TILE_Y_SIZE

@JUMP4:

      movsw

      add si, TILE_X_SIZE * 3
      add di, 80 - TILE_X_SIZE
      loop @JUMP4

      shr plane, 1
      cmp plane, 0
      jne @MAIN_LOOP

      mov dx, $3C4
      mov ax, $0F02
      out dx, ax

      pop es
      pop ds
   end;

end;

procedure printSprite16(X, Y: Integer; var BitMap);
const
   SPRITE_X_SIZE = 2;
   SPRITE_Y_SIZE = 16;
var
   sour_seg, sour_off, dest_seg, dest_off : word;
   plane : byte;
   read_plane : integer;
begin
   plane := 4;
   read_plane := 2;

   sour_seg := seg(BitMap);
   sour_off := ofs(BitMap) + 4;

   dest_seg := $A960 + (y * TILE_Y_SIZE) * 5;
   dest_off := x * (TILE_X_SIZE);

   asm
      push ds
      push es

      mov ax, sour_seg
      mov ds, ax
      mov ax, dest_seg
      mov es, ax
      mov dx, $3C4

@MAIN_LOOP:
      mov si, sour_off
      mov di, dest_off
      mov al, plane

@JUMP2:
      cmp al, 8
      je @JUMP3
      shl al, 1
      add si, SPRITE_X_SIZE
      jmp @JUMP2

@JUMP3:
      mov dx, $3C4
      mov al, $02
      mov ah, plane
      out dx, ax

      mov dx, $3CE
      mov al, $04
      mov ah, byte ptr read_plane
      out dx, ax

      mov cx, SPRITE_Y_SIZE

@JUMP4:

      mov bx, si
      mov dx, 3
      sub dx, word ptr read_plane
      shl dx, 1
      sub bx, dx
      mov ax, ds:[bx]
      not ax
      and ax, es:[di]
      mov dx, ds:[bx]
      and dx, ds:[si]
      or  ax, dx
      mov es:[di],ax
      inc si
      inc di
      inc si
      inc di

      add si, SPRITE_X_SIZE * 3
      add di, 80 - SPRITE_X_SIZE
      loop @JUMP4

      shr plane, 1
      dec read_plane
      cmp plane, 0
      jne @MAIN_LOOP

      mov dx, $3C4
      mov ax, $0F02
      out dx, ax

      pop es
      pop ds

   end;

end;

procedure printSprite32(X, Y: Integer; var BitMap);
const
   SPRITE_X_SIZE = 4;
   SPRITE_Y_SIZE = 32;
var
   sour_seg, sour_off, dest_seg, dest_off : word;
   plane : byte;
   read_plane : integer;
begin
   plane := 4;
   read_plane := 2;

   sour_seg := seg(BitMap);
   sour_off := ofs(BitMap) + 4;

   dest_seg := $A960 + (y * TILE_Y_SIZE) * 5;
   dest_off := x * (TILE_X_SIZE);

   asm
      push ds
      push es

      mov ax, sour_seg
      mov ds, ax
      mov ax, dest_seg
      mov es, ax
      mov dx, $3C4
      mov bx, CHARACTER_SIZE

@MAIN_LOOP:
      mov si, sour_off
      mov di, dest_off
      mov al, plane

@JUMP2:
      cmp al, 8
      je @JUMP3
      shl al, 1
      add si, SPRITE_X_SIZE
      jmp @JUMP2

@JUMP3:
      mov dx, $3C4
      mov al, $02
      mov ah, plane
      out dx, ax

      mov dx, $3CE
      mov al, $04
      mov ah, byte ptr read_plane
      out dx, ax

      mov cx, SPRITE_Y_SIZE

@JUMP4:

      mov ax,es:[di]

      mov bx, si
      mov dx, 3
      sub dx, word ptr read_plane
      shl dx, 1
      shl dx, 1
      sub bx, dx

      and ax, ds:[bx]
      or  ax, ds:[si]
      mov es:[di],ax
      inc si
      inc di
      inc si
      inc di

      mov ax,es:[di]

      mov bx, si
      mov dx, 3
      sub dx, word ptr read_plane
      shl dx, 1
      shl dx, 1
      sub bx, dx

      and ax, ds:[bx]
      or  ax, ds:[si]
      mov es:[di],ax
      inc si
      inc di
      inc si
      inc di

      add si, SPRITE_X_SIZE * 3
      add di, 80 - SPRITE_X_SIZE
      loop @JUMP4

      shr plane, 1
      dec read_plane
      cmp plane, 0
      jne @MAIN_LOOP

      mov dx, $3C4
      mov ax, $0F02
      out dx, ax

      pop es
      pop ds

   end;

end;

procedure flipPage;
var
   gap, count : word;
   index : word;
begin
   gap := (2 * SCROLL_X_WIDE + 2) * TILE_X_SIZE;
   count := (2 * SCROLL_Y_WIDE + 2) * TILE_Y_SIZE;
   index := SCROLL_Y_GAP * 80 + SCROLL_X_GAP;
   asm
         push ds
         push es

         mov bx, gap;
         mov dx, $3CE
         mov al, $05
         out dx, al
         inc dx
         in  al, dx
         and al, $FC
         or  al, $01
         out dx, al

         mov ax, $A960
         mov ds, ax
         mov si, 0
         mov ax, $A000
         mov es, ax
         mov di, index

         mov cx, count
@JUMP0:
         push cx

         mov cx, bx
         rep movsb

         add si, 80
         sub si, bx
         add di, 80
         sub di, bx

         pop cx

         loop @JUMP0

         mov dx, $3CE
         mov al, $05
         out dx, al
         inc dx
         in  al, dx
         and al, $FC
         out dx, al

         pop es
         pop ds

   end;
end;

procedure putPCX16(fn : string);
type
   head_T = record
      manufacture : byte;
      version : byte;
      encording : byte;
      bit_per_pixel : byte;
      x1,y1,x2,y2 : integer;
      h_dpi,v_dpi : integer;
      pal : palette_T;
      reserved : byte;
      planes : byte;
      bytes_per_line : integer;
      palette_info : integer;
      h_screensize : integer;
      v_screensize : integer;
      filler : array[0..53] of byte;
   end;
   buffer_T = array[0..9999] of byte;

const
   cirnum : array[0..15] of byte = (0,1,2,3,4,5,20,7,56,57,58,59,60,61,62,63);

var
   data,plane,len : byte;
   ch : byte;
   i,j,x,y,mx : integer;
   fp : file;
   head : head_T;
   size : longint;
   buffer : ^buffer_T;
   buffer_ptr : word;
   is_last_read : boolean;
   screen_buf : array[0..64000] of byte absolute $A000:$0000;

 procedure readBuffer(var ch : byte);
 begin
    ch := buffer^[buffer_ptr];
    inc(buffer_ptr);
    if buffer_ptr > 9999 then begin
       if size > 10000 then begin
          BlockRead(fp,buffer^,10000);
          size := size - 10000;
          buffer_ptr := 0;
       end else begin
          BlockRead(fp,buffer^,size);
          buffer_ptr := 0;
          is_last_read := TRUE;
       end;
    end;
 end;

begin
   is_last_read := FALSE;
   {$I-}
   assign(fp,fn);
   reset(fp,1);
   {$I+}
   if IOResult <> 0 then begin
      writeLn(^G);
      exit;
   end;
   size := FileSize(fp);
   blockread(fp,head,128);
   size := size - 128;

   port[$3c8] := 0;
   for i := 0 to 15 do begin
      setPalette(i);
      head.pal[i,1] := head.pal[i,1] shr 2;
      head.pal[i,2] := head.pal[i,2] shr 2;
      head.pal[i,3] := head.pal[i,3] shr 2;
      port[$3c9] := head.pal[i,1];
      port[$3c9] := head.pal[i,2];
      port[$3c9] := head.pal[i,3];
   end;

   x := 0; y := 0;
   plane := 1;
   mx := head.bytes_per_line;

   port[$03C4] := 2;
   port[$03C5] := plane;

   getMem(buffer,10000);
   buffer_ptr := 9999;
   readBuffer(ch);

   while (not is_last_read) or (buffer_ptr <= size) do begin
      readBuffer(ch);
      if ((ch and $C0) = $C0) then begin
         len := ch and $3F;
         readBuffer(data);
      end
      else begin
         len := 1;
         data := ch;
      end;
      while (len > 0) do begin
         dec(len);
         if x >= mx then begin
            plane := plane shl 1;
            if plane = $10 then begin
               inc(y);
               plane := 1;
            end;
            x := 0;
         end;
         port[$03C5] := plane;
         screen_buf[(y+40)*80+x] := data;
         inc(x);
      end;
   end;
   close(fp);

   freeMem(buffer,size);

end;

end.