#include <dos.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <iostream.h>

#define MAX_X 320
#define MAX_Y 200

typedef unsigned char BYTE;
typedef unsigned int  LONG;

#define pset(x,y,c)	active_page[ (((y)<<8)+((y)<<6)+(x)) ] = c;

BYTE *active_page;
BYTE *visual_page;

void initial_game_mode()
{   union REGS reg;
	reg.h.ah = 0;
	reg.h.al = 0x13;
	int386(0x10, &reg, &reg);
	active_page = (BYTE *)0xA0000;
	visual_page = (BYTE *)0xA0000;
}
void return_text_mode()
{  union REGS reg;
	reg.h.ah = 0;
	reg.h.al = 0x03;
	int386(0x10, &reg, &reg);
}
BYTE *make_page()
{  BYTE *new_page;
	new_page = (BYTE *)malloc(64000);
	active_page = new_page;
	memset(active_page,0,64000);
	return (new_page);
}
void page_flip(BYTE *vis, BYTE *act)
{	memcpy(vis,act,64000);
}
void setrgb(int num, BYTE r, BYTE g, BYTE b)
{       outp(0x3c8, num);       outp(0x3c9, r);
        outp(0x3c9, g);         outp(0x3c9, b);
}
void setpalette(BYTE *pal)
{   register int i;
        for (i=0; i<256; i++)
            setrgb(i,pal[i*3],pal[i*3+1],pal[i*3+2]);
}
/*
void main()
{   int i;
	initial_game_mode();
	active_page = make_page();
	for (i=0; i<200; i++)
	pset(i,i,i);
	getch();
	page_flip(visual_page,active_page);
	getch();
	return_text_mode();
}
*/
