#include <dos.h>
#include <math.h>
#include <stdio.h>
#include <alloc.h>
#include <mem.h>
#include <process.h>
#include <string.h>
#include <bios.h>
#include <stdlib.h>
#include <time.h>

#include <conio.h>

#include "vgalib.h"
#include "adlib.h"

typedef struct _POINT
{
	unsigned int x;
	unsigned int y;
} POINT;

const unsigned char table[3][32] =
{
{0,0,1,2,3,4,5,6,
 7,8,9,10,11,12,13,14,
 15,16,17,18,19,0,0,0,
 0,0,0,0,0,0,0,0},		// ʼ Ʈ տ ̺
{0,0,0,1,2,3,4,5,
 0,0,6,7,8,9,10,11,
 0,0,12,13,14,15,16,17,
 0,0,18,19,20,21,0,0},		// ߼ Ʈ տ ̺
{0,0,1,2,3,4,5,6,
 7,8,9,10,11,12,13,14,
 15,16,0,17,18,19,20,21,
 22,23,24,25,26,27,0,0}		//  Ʈ տ ̺
};

const unsigned char fsttable[2][20] =
{
{0,0,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,0,1,1,1},
{0,2,3,3,3,3,3,3,3,3,
 3,3,3,3,3,3,2,3,3,3}
};

const unsigned char midtable[3][22] =
{
{0,0,2,0,2,1,2,1,2,3,0,
 2,1,3,3,1,2,1,3,3,1,1},
{0,0,0,0,0,0,0,0,0,1,3,
 3,3,1,2,4,4,4,2,1,3,0},
{0,5,5,5,5,5,5,5,5,6,7,
 7,7,6,6,7,7,7,6,6,7,5}
};

unsigned char H_FONT1[8][20][32];	// ʼ
unsigned char H_FONT2[4][22][32];	// ߼
unsigned char H_FONT3[4][28][32];	// 

unsigned char E_FONT[256][16];		// 

unsigned char han_image[32];		// ѱ ¿ 迭
unsigned char eng_image[16];		//  ¿ 迭


unsigned char Speed=3;
char far *page1 = (char far*) 0xa0000000;
double XYratio = 0;
char far *page2,far *page3,far *page4;
int iii = 0;
unsigned char pal[768];
unsigned char RGB[768];
unsigned char AnmFlag;
char IceMan = 5;
unsigned int Point = 0;

unsigned char Image[11][10][10];
unsigned char MeltImage[8][10][10];
long oldtime;

unsigned int length = 4;

static POINT Map[720];
static POINT Fire[5];


struct _header
{
	char maker, version, code, bpp;
	UINT x1, y1, x2, y2, hres, vres;
	char palette[48];
	char vmode, nplanes;
	UINT bpl;
	UINT palinfo;
	UINT shres, svres;
	char unused[54];
} header;

int mouse_status;
int mouse_x;
int mouse_y;

int  mouse_reset(void);
void mouse_enable(void);
void mouse_disable(void);
void mouse_read_cursor(void);
void mouse_horizontal_range(int xmin, int xmax);
void mouse_vertical_range(int ymin, int ymax);

/*************************************************************************
*                                                                        *
*                           F U N C T I O N S                            *
*                                                                        *
*************************************************************************/

/*----------------------------------------------------------------------*/

int mouse_reset(void)
{
   _AX=0;
   geninterrupt(0x33);
   return(_AX);
}	/* mouse_reset */

/*----------------------------------------------------------------------*/

void mouse_enable(void)
{
   _AX=1;
   geninterrupt(0x33);
}	/* mouse_enable */


/*----------------------------------------------------------------------*/

void mouse_disable(void)
{
   _AX=2;
   geninterrupt(0x33);
}	/* mouse_disable */

/*----------------------------------------------------------------------*/

void mouse_read_cursor(void)
{
   _AX=3;
   geninterrupt(0x33);
   mouse_status=_BX;
   mouse_x=_CX;
   mouse_y=_DX;
}	/* mouse_read_cursor */

/*----------------------------------------------------------------------*/

void mouse_horizontal_range(int xmin, int xmax)
{
   _AX=7;
   _CX=xmin;
   _DX=xmax;
   geninterrupt(0x33);
}	/* mouse_vertical_range */

/*----------------------------------------------------------------------*/

void mouse_vertical_range(int ymin, int ymax)
{
   _AX=8;
   _CX=ymin;
   _DX=ymax;
   geninterrupt(0x33);
}	/* mouse_vertical_range */



//##################################################################
//#
//#
//# Keyboard Function!
//#
//##################################################################

void interrupt keyboard(__CPPARGS)
{
	unsigned char code, port;

	asm	cli;

	port = inportb(0x60);
	code = port & 127;

	if ( (port<128) && (scan[code]==0) )
	{
		scan[code] = 1;
		asci[code] = 1;
		press_key = code;
	} else if (port>127) scan[code] = 0;

	outportb(0x20, 0x20);

	asm	sti;
}

void setting_interupt()
{
	memset(scan, 0, 128);
	memset(asci, 0, 128);

	old_func = getvect(0x09);
	setvect(0x09, keyboard);
}

void restore_interupt()
{
	setvect(0x09, old_func);
}

//###############################################################
//#
//#    Vga Function
//###############################################################

//  ̺귯 Ŭ ʱȭ  Լ
//  : ȭ 带 320*200 ȯѴ.
// Է° :    ʱȭ ϸ
//	    ̸  320*200 (13h)尡 Ʈ̴.
// ϰ : .
void SetMode1(UINT mode)
{
	asm mov ax,mode;
	asm int 10h;
}

//  ̺귯 Ŭ  Ҹ Լ
//  :  ȭ 忡 Ϲ ؽƮ  ȯѴ.
// Է° : .
// ϰ : .
void Close(void)
{
	asm mov ax,0x03;
	asm int 10h;
}

//  :   3 .
// Է : .
// ϰ :  ߻ÿ 0 Ѵ.
int MakePage(void)
{
	page2 =(char far*) farmalloc(64000);
	page3 =(char far*) farmalloc(64000);
	if(!page2 || !page3) return 0;
//	memset((void *)page2,0, 64000);
//	memset((void *)page3,0, 64000);
//	memset((void *)page4,0, 64000);
	return 1;
}


//  :    .
void DestroyPage(void)
{
	farfree(page2);
	farfree(page3);
//	farfree(page4);
}

//  :  ޸  Լ
// ű ϴ ޸  Էϰ ϰ ϴ ũ⸦ ԷѴ.
void DataTrans(char far *sc, char far *dt, unsigned int size)
{
	asm push ds
	asm push es
	asm lds si,sc
	asm les di,dt
	asm mov cx, size
	asm shr cx,1
	asm jnc WORD_JMP

	asm movsb
	WORD_JMP:
	asm rep movsw

	asm pop es
	asm pop ds
}


//  : ȭ Ұ Լ
// Է : ȭҰŽ ȭ ä ÷. (DEFAULT = (0 ȷƮ))
//  : .
void ClearScr(char color)
{
	register unsigned long int temp;

	for(temp = 0; temp< (unsigned long)64000; temp++)
	{
		page1[temp] = color;
	}
}

//  : Էµ ǥ  ´.
// Է° : ǥ
void PutPixel(UINT x, UINT y, char color)
{
	page2[Offset(x,y)] = color;
}


//  : Էµ  ȭ鿡  ׸.
// Է° : ߽ Xǥ, ߽ Yǥ, , 
// ϰ : .
void Circle(int xc, int yc, int r,char color)
{
    int x,y,s;

    x = r;
    y = 0;
    s = r;
     while(x >= y)
     {
	PutPixel(xc+x,yc+y, color);
	PutPixel(xc+x,yc-y, color);
	PutPixel(xc-x,yc+y, color);
	PutPixel(xc-x,yc-y, color);
	PutPixel(xc+y,yc+x, color);
	PutPixel(xc+y,yc-x, color);
	PutPixel(xc-y,yc+x, color);
	PutPixel(xc-y,yc-x, color);

	s = s - y*2 -1;
	y = y + 1;

	if( s <0)
	{
	    s = s+(x-1)*2;
	    x = x -1;
	}
     }
}

void Ellipse(int x, int y, int rx, int ry, char color)
{
    int i;
    float a;

    UINT ox, oy;

    ox = x + rx;
    oy = y;     // mark!

    for(i =1; i<= 360; i++)
    {
	a = i* 3.14 /180;     // find radian or defree of A function
	DrawLine(ox,oy,(x+ rx*cos(a)), y + ry*sin(a), color);
	ox =(x+ rx*cos(a));
	oy =y + ry*sin(a);
    }
}


//  :  ׷ش.
// Է :   ׸  
void DrawLine(UINT sx, UINT sy, UINT ex, UINT ey, char color)
{
	register int t, distance;
	int xerr = 0, yerr=0, delta_x, delta_y;
	int incx, incy;

	delta_x = ex-sx;
	delta_y = ey-sy;

	if(delta_x > 0) 	incx = 1;
	else if(delta_x == 0)   incx = 0;
	else 			incx = -1;

	if(delta_y >0)		incy = 1;
	else if(delta_y == 0)   incy = 0;
	else 			incy = -1;

	delta_x = abs(delta_x);
	delta_y = abs(delta_y);
	if(delta_x > delta_y) distance = delta_x;
	else distance = delta_y;

	for(t=0; t<= distance+1; t++)
	{
		PutPixel(sx, sy, color);
		xerr += delta_x;
		yerr += delta_y;
		if(xerr > distance)
		{
			xerr -= distance;
			sx += incx;
		}
		if(yerr > distance)
		{
			yerr -= distance;
			sy += incy;
		}
	}
}

// 簢 ׸ Լ
// Է : 簢 ǥ ÷
void DrawBox(UINT sx, UINT sy, UINT ex, UINT ey, char color)
{
	register unsigned int temp;

	if(sx > ex) { temp = sx; sx = ex; ex = temp; }
	if(sy > ey) { temp = sy; sy = ey; ey = temp; }

	for(temp = sx; temp <= ex; temp++)
	{
		PutPixel(temp, sy, color);
		PutPixel(temp, ey, color);
	}
	for(temp = sy; temp < ey; temp++)
	{
		PutPixel(sx, temp, color);
		PutPixel(ex, temp, color);
	}
}

//  : ȭ  簢   ä.
// Է : .
//  : .
void BoxFill(UINT sx, UINT sy, UINT ex, UINT ey, char color)
{
	register i,j;

	if(sx > ex) { i = sx; sx = ex; ex = i; }
	if(sy > ey) { i = sy; sy = ey; ey = i; }

	for(i = sx; i< ex; i++)
		for(j = sy; j <ey; j++)
			page2[Offset(i,j)] = color;
}

//    ׸.
// Է :
//  :
void CircleFill(UINT x, UINT y, UINT rad, char color)
{
	register temp;

	for(temp = 0; temp < rad; temp++)
	{
		Circle(x,y,temp, color);
	}
}

// Էµ    Űش.
void SetVisualPage(char far *page)
{
	DataTrans(page, page1, 64000);
}

//  Լ
// source  destination  Ѵ.
void PageCopy(char far *scPage, char far *dtPage)
{
	DataTrans(scPage, dtPage, 64000);
}

// PCX о δ.
// Է : ̸, ׸ ϰ ϴ .
//  : ȭ µ ϸ 0 Ѵ.
UINT ReadPcx(char *filename, char far *page)
{
	UINT n = 0, i;
        char c;
	FILE *fp;

	if(!(fp = fopen(filename, "rb"))) return 0;

	fread(&header, sizeof(header), 1, fp);	// read header

	do{		// decoding
		c = fgetc(fp); //& 0xff;

		if((c&0xc0) == 0xc0)
		{
			i = c & 0x3f;
			c = fgetc(fp);
			while(i--)
			{
				//if(c !=0)
				*(page +n) = c; // Special Code
				n++;
			}
		} else
		{
			//if(c != 0)
			*(page +n) = c;
			n++;
		}
	} while ( n < 63999);

	fseek(fp, -768L, SEEK_END);
//	fgetc(fp);
	fread(pal,768, 1, fp);
	for(i = 0; i<768; i++) pal[i] = pal[i] >>2;
	fclose(fp);

	return 1;
}

//  :  Ʈ ȭ ȷƮ ٲ۴.
// Է : palnum<-ȷƮ ȣ, count<- ٲٰ ϴ ȷƮ 
// 	  *block<- Էϰϴ ȷƮ 
//  : .
void SetPal(UINT palnum, UINT count, char far *block)
{
	asm mov ah, 10h
	asm mov al, 12h
	asm mov bx, palnum
	asm mov cx, count
	asm les dx, block
	asm int 10h
}

//  : ̵ ȿ  ȷƮ    Ǵ  Ų.
void Effect(UINT ps)
{
	static	int i;

	for (i = 0; i<768; i++)	RGB[i] = (int) pal[i] * ps / 100;

	SetPal(0,256, RGB);
}

void effect(UINT p)
{
	int i;
//	memcpy(RGB, pal, 768);
	for(i = 0; i <768; i++) RGB[i] = (pal[i] *p) /100;
        SetPal(0,256, RGB);
//	set_pallette(RGB);
}

//  : 256Į󿡼 ̵ ȿ ش.
void FadeOut(void)
{
	int i;
	for(i = 100; i>0; i--)
	{
		effect(i);
		delay(50);
	}
}

//  : 256Į󿡼 ̵ ȿ ش.
void FadeIn(void)
{
	int j;
	for(j = 0; j < 100 ; j++)
	{
		effect(j);
		delay(50);
	}
}


void set_pallette(char *data)
{
	union REGS r;
	r.h.ah = 0x10;
	r.h.al = 0x12;
	r.x.bx = 0;
	r.x.cx = 0xff;
	_ES = FP_SEG(data);
	r.x.dx = FP_OFF(data);
	int86(0x10, &r, &r);
}

void initialize(void)
{
	SetMode1(0x13);
	MakePage();
}

void shutdown(void)
{
	Close();
	DestroyPage();
}

//#################################################################
// ѱ Ʈ о δ. ׿  ʱ⼳ Ѵ.
void InitHan()
{
	FILE *fp;

	fp = fopen("han.fnt","rb");
	fread(H_FONT1, 5120, 1, fp);
	fread(H_FONT2, 2816, 1, fp);
	fread(H_FONT3, 3584, 1, fp);
	fclose(fp);

	fp = fopen("eng.fnt","rb");
	fread(E_FONT, 4096, 1, fp);
	fclose(fp);
}

void or_img(unsigned char *src, unsigned char *dest, int size)
{
	int i;
	for(i = 0; i< size; i++) dest[i] |= src[i];
}

void put_font(int x, int y, unsigned char *fnt, int size, char color)
{
	int i,k,m = 0, n = 0, f= 1;
	unsigned char dat = 0x80;

	for( i = y; i<y+16; i++)
	{
		for( k = x; k<x+size; k++)
		{
			if((fnt[m] & (dat >> n)) == (dat >> n)) PutPixel(k,i, color);
			if((++n) == 8) {n = 0; m++;}
		}
		if(f==0) color ++;
	}
}

void HoutXY(int x, int y, char *s, int color)
{
	unsigned char data1, data2;
	unsigned char first, mid, last;
	int i, b1, b2, b3;

	for(i=0;i<strlen(s);i++)
	{
		data1 = *(s+i);
		memset(han_image, 0, 32);
		memset(eng_image, 0, 16);

		if(data1 > 127)	// ѱ ˻
		{
			data2 = *(s+(++i));

			first = (data1 &124) >>2;
			mid = (data1 &3)*8 +(data2 >>5);
			last = (data2&31);
			// ʼ ߼  Ʈ ȯѴ.

			first = table[0][first];
			mid   = table[1][mid];
			last  = table[2][last];

			b3 = midtable[0][mid];

			if(!last)	//    
			{
				b2 = fsttable[0][first];
				b1 = midtable[1][mid];
			}
			else		//  
			{
				b2 = fsttable[1][first];
				b1 = midtable[2][mid];
			}

			if (first)or_img(H_FONT1[b1][first], han_image, 32);
			if (mid)  or_img(H_FONT2[b2][mid], han_image, 32);
			if (last) or_img(H_FONT3[b3][last], han_image, 32);

			put_font( x, y, han_image, 16, color);

			x+=16;
		}
		else
		{
			memmove(&eng_image, &E_FONT[data1], 16);
			put_font(x, y, eng_image, 8, color);
			x+=8;
		}
	}
}




//##################################################################
//#
//#
//##################################################################

void m_Opening()
{
	int i;

	SetMode1(0x13);
	InitHan();
	playims2();
	if(!MakePage())
	{
		Close();
		printf("Error! Can't Allocate Memory!\n\a");
		exit(0);
	}
	setting_interupt();

	ReadPcx("st.pcx",page2);
	memset(RGB, 0, 768);
	set_pallette(RGB);
	SetVisualPage(page2);
//	FadeIn();

	set_pallette(pal);

	HoutXY(30,120,"aAaai ae bSa.",2);
	HoutXY(170,180,"ee : A  e",3);
	RGB[3] = 255;RGB[4] = 255;RGB[5] = 0;
	SetPal(2,2,RGB);
	SetVisualPage(page2);

	while(!(asci[_SPACE] || asci[_ESC]))
	{
		RGB[2] =0;RGB[0] = 100;RGB[1]=0;
		SetPal(2,1,RGB);
		delay(200);
		RGB[0] = 255;RGB[2] = 0;RGB[1]=0;
		SetPal(2,1,RGB);
		delay(100);
	}
	asci[_SPACE]=0;


	// Starting Game
	ReadPcx("bg.pcx",page2);
	memset(RGB, 0, 768);
	set_pallette(RGB);
	BoxFill(1,178,319,199,14);
	DrawBox(1,1,314,174,3);
	DrawBox(2,2,313,173,3);
	HoutXY(4,182,"W :",5);
	HoutXY(160,182," :",5);
	SetVisualPage(page2);
	SetPal(0,256,pal);
	//set_pallette(pal);
	PageCopy(page1,page3);
	stopims();
}

void m_Ending()
{
	DestroyPage();
	restore_interupt();
	Close();
}

void pause(void)
{
	PageCopy(page3, page2);
	HoutXY(120,90,"q !",10);
	asci[_P] = 0;
	SetVisualPage(page2);
	while(!asci[_P]);
	asci[_P] = 0;
	PageCopy(page3, page1);
}

void ReadSprite(void)
{
	FILE *file;
	int temp, temp1;

	file = fopen("iceup1.spr","rb");
	if(!file) return;

	for(temp = 0; temp <10; temp++)
		for(temp1=0; temp1 <10; temp1++)
		{
			Image[0][temp1][temp] = (char ) fgetc(file);
			Image[2][temp][temp1] = Image[0][temp1][temp];
			Image[4][9-temp][9-temp1]= Image[0][temp1][temp];
			Image[6][9-temp1][9-temp]= Image[0][temp1][temp];
		}
	fclose(file);

	file = fopen("iceup2.spr","rb");
	if(!file) return;

	for(temp = 0; temp <10; temp++)
		for(temp1=0; temp1 <10; temp1++)
		{
			Image[1][temp1][temp] = (char ) fgetc(file);
			Image[3][temp][temp1] = Image[1][temp1][temp];
			Image[5][9-temp][9-temp1]= Image[1][temp1][temp];
			Image[7][9-temp1][9-temp]= Image[1][temp1][temp];
		}

	fclose(file);

	file = fopen("dead.spr","rb");
	if(!file) return;
	for(temp = 0; temp <10; temp++)
		for(temp1=0; temp1 <10; temp1++)
		{
			Image[8][temp1][temp] = (char ) fgetc(file);
		}
	fclose(file);

	file = fopen("icemelt1.spr","rb");
	if(!file) return;

	for(temp = 0; temp <10; temp++)
		for(temp1=0; temp1 <10; temp1++)
		{
			MeltImage[0][temp1][temp] = (char ) fgetc(file);
			MeltImage[2][temp][temp1] = MeltImage[0][temp1][temp];
			MeltImage[4][9-temp][9-temp1]= MeltImage[0][temp1][temp];
			MeltImage[6][9-temp1][9-temp]= MeltImage[0][temp1][temp];
		}
	fclose(file);

	file = fopen("icemelt2.spr","rb");
	if(!file) return;
	for(temp = 0; temp<10; temp++)
		for(temp1 = 0; temp1 <10; temp1++)
		{
			MeltImage[1][temp1][temp] = (char) fgetc(file);
			MeltImage[3][temp][temp1] = MeltImage[1][temp1][temp];
			MeltImage[5][9-temp][9-temp1]= MeltImage[1][temp1][temp];
			MeltImage[7][9-temp1][9-temp]= MeltImage[1][temp1][temp];
		}
	fclose(file);

	file = fopen("fire1.spr","rb");
	if(!file) return;
	for(temp = 0; temp<10; temp++)
		for(temp1 = 0; temp1 <10; temp1++)
		{
			Image[9][temp1][temp] = (char) fgetc(file);
		}
	fclose(file);

	file = fopen("fire2.spr","rb");
	if(!file) return;
	for(temp = 0; temp<10; temp++)
		for(temp1 = 0; temp1 <10; temp1++)
		{
			Image[10][temp1][temp] = (char) fgetc(file);
		}
	fclose(file);
}

void DrawSprite(unsigned int x,unsigned int y, int spritenum)
{
	int temp, temp1;

	for(temp = 0; temp <10; temp++)
		for(temp1 =0; temp1 <10;temp1++)
		{
			if(Image[spritenum][temp][temp1])
				PutPixel((x+temp),(y+temp1),Image[spritenum][temp][temp1]);
		}
}


void DrawSprite2(unsigned int x,unsigned int y, int spritenum)
{
	int temp, temp1;

	for(temp = 0; temp <10; temp++)
		for(temp1 =0; temp1 <10;temp1++)
		{
			if(MeltImage[spritenum][temp][temp1])
				PutPixel((x+temp),(y+temp1),MeltImage[spritenum][temp][temp1]);
		}
}

void CharacterMove(unsigned char IceArrow,POINT *head, POINT *tail)
{
	unsigned int temp,x,y;

	// Position
	if(IceArrow == UP)
	{
		head->y -= Speed;
	}else
		if(IceArrow == DOWN) {head->y += Speed;}
	if(IceArrow == LEFT)
	{
		head->x -= Speed;
	}else
		if(IceArrow == RIGHT) {head->x +=Speed;}
	x = (head->x - 3)/10;
	x = x*10 +3;
	y = (head->y - 3)/10;
	y = y*10 +3;


	// Sprite
	if(IceArrow == UP)
	{
		if(AnmFlag%3)
		{
			DrawSprite(x, y, 0);
		}
		else
		{
			DrawSprite(x , y, 1);
		}

	}
	if(IceArrow == DOWN)
	{
		if(AnmFlag%3)
		{
			DrawSprite(x , y, 6);
		}
		else
		{
			DrawSprite(x , y, 7);
		}
	}
	if(IceArrow == LEFT)
	{
		if(AnmFlag%3)
		{
			DrawSprite(x , y, 2);
		}
		else
		{
			DrawSprite(x , y, 3);
		}
	}
	if(IceArrow == RIGHT)
	{
		if(AnmFlag%3)
		{
			DrawSprite(x , y, 4);
		}
		else
		{
			DrawSprite(x , y, 5);
		}
	}

	// Map Function
	if((Map[0].x == (int)(head->x - 3) / 10) && (Map[0].y == (int)(head->y - 3) / 10)) return;
	for(temp = length-1; temp >= 1; temp--)
	{
		Map[temp] = Map[temp-1];
	}
	Map[0].x = (unsigned )(head->x - 3) / 10;
	Map[0].y = (unsigned )(head->y - 3) / 10;
}

char CheckCrash(POINT *head)
{
	char temp;

	// Crash to the wall test code
	if(head->x < 3 || head->x > 310) return 0;
	if(head->y < 1 || head->y > 167) return 0;

	// Crash to the himself
	for(temp =1 ; temp < length; temp++)
	{
		if((Map[0].x == Map[temp].x) && (Map[0].y == Map[temp].y)) return 0;
	}

	// Meet the Food(Fire)
	for(temp = 0; temp <3; temp++)
	{
		if(((head->x-3)/10 == Fire[temp].x) && ((head->y-3)/10== Fire[temp].y))
		{
			length +=3;
			Point += 100;
			printf("\a");		//test
			Fire[temp].x = random(304)/10;
			Fire[temp].y = random(164)/10;
		}
	}
	return 1;
}

void SetSpeed(unsigned char speed)
{
// reported bug : if the timer turns to minus this game will into the loop of loop
	long m_time;

	m_time = biostime(0,0);

	while(m_time < (oldtime + speed/10))
	{
		m_time = biostime(0,0);
	}
	oldtime = m_time;
}


void Crash(POINT *head)
{
	int x1,y1;

	x1 = (head->x - 3)/10;
	x1 = x1*10 +3;
	y1 = (head->y - 3)/10;
	y1 = y1*10 +3;

	DrawSprite(x1, y1, 8);
	IceMan --;
	head->x = 160;
	head->y = 70;

	SetVisualPage(page2);
//	PlayVoc("ng.voc");
	SetSpeed(70);
	for( x1= 0; x1 < 720; x1++)
	{
	Map[x1].x = 0;
	Map[x1].y = 0;
	}
}

void main(void)
{
	unsigned char ExitFlag = 1,movespeed = 10;
	unsigned char IceArrow = UP,IceNumer;
	static POINT *head, *tail;
	unsigned int temp;

	unsigned char buf[10];		// test
	oldtime = biostime(0,0);

	head->x = 160;
	head->y = 100;
	tail->x = 180;
	tail->y = 120;

	m_Opening();
	ReadSprite();
	randomize();
//	PlayVoc("conga.voc");

	for(temp = 0; temp <3; temp++)
	{
		Fire[temp].x = random(304)/10;
		Fire[temp].y = random(164)/10;
	}
	playims();

	while(ExitFlag)	//   Flag ϶   ̴.
	{
		PageCopy(page3, page2);
		AnmFlag++;

		if(scan[_ESC]) ExitFlag = 0;	//
		if(asci[_P]) pause();
		if(scan[_UPKEY]) {IceArrow = UP;}
		else
			if(scan[_DNKEY]) {IceArrow = DOWN;}
			else
				if(scan[_LTKEY]) {IceArrow = LEFT;}
					else
					if(scan[_RTKEY]) {IceArrow = RIGHT;}
		CharacterMove(IceArrow,head, tail);

		for(temp = 0; temp <3; temp++)
		{
			if(AnmFlag %2)
			{
				DrawSprite(Fire[temp].x*10+3, Fire[temp].y*10+3, 9);
			}
			else
				DrawSprite(Fire[temp].x*10+3, Fire[temp].y*10+3, 10);
		}


		for(temp = 1; temp<length; temp++)
		{
			if( !((Map[temp].x == 0) && (Map[temp].y == 0) && temp !=0))
				DrawSprite2(Map[temp].x*10+3, Map[temp].y*10+3,0);
		}


		// Current Point and Character
		sprintf(buf, "%d", Point);
		HoutXY(228, 182, buf, 11);
		for(temp = 0; temp < IceMan; temp++)
		{
			DrawSprite((70+13*temp),185,0);
		}

		if(!CheckCrash(head)) {Crash(head); length = 4;}
		SetSpeed(movespeed);
		if(IceMan > 10) ExitFlag = 0;
		if(Point == 1000) {movespeed = 10;length = 3;IceMan ++; Point += 100;}
//		if(Point == 3000) {movespeed = 10;length = 3;IceMan ++; Point += 100;}
		SetVisualPage(page2);
	}
	m_Ending();
	stopims();

	printf("Thanks for Playing..\n\a");
	printf("Prog. Choi Jae Eun\n");
}