{****************************************************************************

                   Copyright (c) 1993,95 by Florian Klmpfl

 ****************************************************************************}

unit types;

  interface

    uses
       objects,cobjects,globals,asmgen,symtable,tree
{$ifdef i386}
       ,i386
{$else}
{$endif}
       ;


    { liefert true, wenn die bergebene Definition einen ordinalen Typ }
    { definiert                                                        }
    function is_ordinal(def : pdef) : boolean;

    { true, wenn der bergebene Typ vorzeichenbehaftet ist (nur ordinale Typen) }
    function is_signed(def : pdef) : boolean;

    { true, wenn beide Typen semantisch gleich sind }
    function is_equal(def1,def2 : pdef) : boolean;

    { gibt true zurueck, wenn zwei Parameterlisten gleich sind }
    function equal_paras(def1,def2 : pdefcoll) : boolean;

    { gibt den ordinalen Werten der Node zurueck oder falls sie }
    { keinen ordinalen Wert hat, wird ein Fehler erzeugt        }
    function get_ordinal_value(p : ptree) : longint;

    { prueft, ob l im gueltigen Bereich von def liegt }
    procedure testrange(def : pdef;l : longint);

    { gibt den Breich der Variablen zureck }
    procedure getrange(def : pdef;var l : longint;var h : longint);

    { erzeugt fr class die VMT }
    procedure genvmt(_class : pobjectdef);

    { true, falls p ein Zeiger auf eine konstanten Intknoten ist }
    function is_constintnode(p : ptree) : boolean;
    { entsprechend }
    function is_constboolnode(p : ptree) : boolean;
    function is_constrealnode(p : ptree) : boolean;
    function is_constcharnode(p : ptree) : boolean;

  implementation

    function is_constintnode(p : ptree) : boolean;

      begin
         is_constintnode:=((p^.treetype=ordconstn) and
           (p^.resulttype^.deftype=grunddef) and
           (pgrunddef(p^.resulttype)^.typ=s32bit));
         { !!!! what is with u32bit }
      end;

    function is_constcharnode(p : ptree) : boolean;

      begin
         is_constcharnode:=((p^.treetype=ordconstn) and
           (p^.resulttype^.deftype=grunddef) and
           (pgrunddef(p^.resulttype)^.typ=uchar));
      end;

    function is_constrealnode(p : ptree) : boolean;

      begin
         is_constrealnode:=(p^.treetype=realconstn);
      end;

    function is_constboolnode(p : ptree) : boolean;

      begin
         is_constboolnode:=((p^.treetype=ordconstn) and
           (p^.resulttype^.deftype=grunddef) and
           (pgrunddef(p^.resulttype)^.typ=bool8bit));
      end;

    function equal_paras(def1,def2 : pdefcoll) : boolean;

      begin
         while (assigned(def1)) and (assigned(def2)) do
           begin
              if not(is_equal(def1^.data,def2^.data)) or
                 (def1^.paratyp<>def2^.paratyp) then
                begin
                   equal_paras:=false;
                   exit;
                end;
              def1:=def1^.next;
              def2:=def2^.next;
           end;
         if (def1=nil) and (def2=nil) then
           equal_paras:=true
         else
           equal_paras:=false;
      end;

    function is_ordinal(def : pdef) : boolean;

      var
         dt : tgrundtyp;

      begin
         case def^.deftype of
            grunddef : begin
                          dt:=pgrunddef(def)^.typ;
                          is_ordinal:=(dt=s32bit) or (dt=u32bit) or (dt=uchar) or (dt=u8bit) or
                            (dt=s8bit) or (dt=s16bit) or (dt=bool8bit) or (dt=u16bit);
                       end;
            aufzaehldef : is_ordinal:=true;
            else is_ordinal:=false;
         end;
      end;

    function is_signed(def : pdef) : boolean;

      var
         dt : tgrundtyp;

      begin
         case def^.deftype of
            grunddef : begin
                          dt:=pgrunddef(def)^.typ;
                          is_signed:=(dt=s32bit) or (dt=s8bit) or (dt=s16bit);
                       end;
            aufzaehldef : is_signed:=false;
            else internalerror(1001);
         end;
      end;

    procedure testrange(def : pdef;l : longint);

      var
         lv,hv: longint;

      begin
         getrange(def,lv,hv);
         if (l<lv) or (l>hv) then
           warning(range_check_error);
      end;

    procedure getrange(def : pdef;var l : longint;var h : longint);

      begin
         if def^.deftype=grunddef then
           case pgrunddef(def)^.typ of
              s32bit,s16bit,u16bit,s8bit,u8bit :
                begin
                   l:=pgrunddef(def)^.von;
                   h:=pgrunddef(def)^.bis;
                end;
              bool8bit : begin
                            l:=0;
                            h:=1;
                         end;
              uchar : begin
                         l:=0;
                         h:=255;
                      end;
              u32bit : begin
                          {!!!!!!}
                       end;
           end
         else
           if def^.deftype=aufzaehldef then
             begin
                l:=0;
                h:=paufzaehldef(def)^.max;
             end;
      end;

    function get_ordinal_value(p : ptree) : longint;

      begin
         if p^.treetype=ordconstn then
           get_ordinal_value:=p^.value
         else error(ordinal_expect);
      end;

    function is_equal(def1,def2 : pdef) : boolean;

      var
         b : boolean;
         hd : pdef;
         hp1,hp2 : pdefcoll;

      begin
         { Wenn ein String dabei, dann def1 zum String machen }
         if def2^.deftype=stringdef then
           begin
              hd:=def1;
              def1:=def2;
              def2:=hd;
           end;
         b:=false;

         { wenn beide auf die gleiche Definition zeigen sind sie wohl gleich...}
         if def1=def2 then
           b:=true
         else
         { pointer with an equal definition are equal }
           if (def1^.deftype=pointerdef) and (def2^.deftype=pointerdef) then
             b:=is_equal(ppointerdef(def1)^.definition,ppointerdef(def2)^.definition)
         else
         { Grundtypen sind gleich, wenn sie den selben Grundtyp haben, }
         { und wenn noetig den selben Unterbereich haben }
           if (def1^.deftype=grunddef) and (def2^.deftype=grunddef) then
             begin
                case pgrunddef(def1)^.typ of
                   u8bit,s32bit,s8bit,u16bit,s16bit : begin
                                     if pgrunddef(def1)^.typ=pgrunddef(def2)^.typ then
                                       if (pgrunddef(def1)^.von=pgrunddef(def2)^.von) and
                                          (pgrunddef(def1)^.bis=pgrunddef(def2)^.bis) then
                                           b:=true;
                                  end;
                   u32bit,uvoid,s64real,bool8bit,uchar :
                     b:=pgrunddef(def1)^.typ=pgrunddef(def2)^.typ;
                end;
             end
         else

            { Strings mit gleicher Laenge sind auch equivalent }
            if (def1^.deftype=stringdef) and (def2^.deftype=stringdef) and
               (pstringdef(def1)^.len=pstringdef(def2)^.len) then
            b:=true
	{ STRING[N] ist equivalent zu ARRAY[0..N] OF CHAR (N<256) }
{
         else if ((def1^.deftype=stringdef) and (def2^.deftype=arraydef)) and
              (parraydef(def2)^.definition^.deftype=grunddef) and
              (pgrunddef(parraydef(def1)^.definition)^.typ=uchar) and
              (parraydef(def2)^.lowrange=0) and
              (parraydef(def2)^.highrange=pstringdef(def1)^.len) then
              b:=true }
          else
            if (def1^.deftype=formaldef) and (def2^.deftype=formaldef) then
            b:=true
          { Mengen mit gleichem Grundtyp sind gleich }
          else
            if (def1^.deftype=setdef) and (def2^.deftype=setdef) then
              begin
                 if assigned(psetdef(def1)^.setof) and
                    assigned(psetdef(def2)^.setof) then
                   b:=is_equal(psetdef(def1)^.setof,psetdef(def2)^.setof)
                 else b:=true;
              end
          else
            if (def1^.deftype=procvardef) and (def2^.deftype=procvardef) then
              begin
                 b:=(pprocvardef(def1)^.options=pprocvardef(def2)^.options) and
                   is_equal(pprocvardef(def1)^.retdef,pprocvardef(def2)^.retdef);
                 { falls b noch gesetzt, Parameter auswerten }
                 if b then
                   begin
                      hp1:=pprocvardef(def1)^.para1;
                      hp2:=pprocvardef(def1)^.para1;
                      while assigned(hp1) and assigned(hp2) do
                        begin
                           if not(is_equal(hp1^.data,hp2^.data)) or
                             not(hp1^.paratyp=hp2^.paratyp) then
                             begin
                                b:=false;
                                break;
                             end;
                           hp1:=hp1^.next;
                           hp2:=hp2^.next;
                        end;
                      b:=(hp1=nil) and (hp2=nil);
                   end;
              end;
         is_equal:=b;
      end;

    type
       pprocdefcoll = ^tprocdefcoll;

       tprocdefcoll = record
          next : pprocdefcoll;
          data : pprocdef;
       end;

       psymcoll = ^tsymcoll;

       tsymcoll = record
          next : psymcoll;
          name : pstring;
          data : pprocdefcoll;
       end;

    var
       wurzel : psymcoll;
       nextvirtnumber : longint;

    procedure eachsym(sym : psym);far;

      var
         procdefcoll : pprocdefcoll;
         hp : pprocdef;
         symcoll : psymcoll;
         _name : string;
         stored : boolean;

      begin
         { nur Unterprogrammsymbole werden in die VMT aufgenommen }
         if sym^.typ=procsym then
           begin
              _name:=sym^.name;
              symcoll:=wurzel;
              while assigned(symcoll) do
                begin
                   { wenn das Symbol in der Liste schon existiert }
                   if _name=symcoll^.name^ then
                     begin
                        { alle Definitionen des Symbols durchgehen }
                        hp:=pprocsym(sym)^.definition;
                        while assigned(hp) do
                          begin
                             { mit allen schon gespeicherten Definitionen }
                             { vergleichen                                }
                             procdefcoll:=symcoll^.data;
                             stored:=false;
                             while assigned(procdefcoll) do
                               begin
                                  { Parameter vergleichen }
                                  if equal_paras(procdefcoll^.data^.para1,hp^.para1) and
                                     (
                                       ((procdefcoll^.data^.options and povirtualmethod)<>0) or
                                       ((hp^.options and povirtualmethod)<>0)
                                     ) then
                                    begin
                                       { wenn sie gleich sind }
                                       { und eine davon virtual deklariert ist }
                                       { Fehler falls nur eine VIRTUAL }
                                       if (procdefcoll^.data^.options and povirtualmethod)<>
                                          (hp^.options and povirtualmethod) then
                                         error(overloaded_are_not_both_virtual);

                                       { Fehler falls Returntyp nicht gleich }
                                       if not(is_equal(procdefcoll^.data^.retdef,hp^.retdef)) then
                                         error(ol_meths_not_same_ret);

                                       { Fehler falls Excections nicht bereinstimmen }
                                       if (procdefcoll^.data^.options and poexceptions)<>
                                          (hp^.options and poexceptions) then
                                         error(overloaded_support_exceptions_false);

                                       { auch alle anderen Flags mssen bereinstimmen }
                                       { if it's not the abstract flag }
                                       if (procdefcoll^.data^.options and not(poabstractmethod))<>
                                         (hp^.options and not(poabstractmethod)) then
                                         error(header_dont_match);

                                       { nun Nummer setzten }
                                       hp^.extnumber:=procdefcoll^.data^.extnumber;
                                       { und Austauschen: }
                                       procdefcoll^.data:=hp;
                                       stored:=true;
                                    end;
                                  procdefcoll:=procdefcoll^.next;
                               end;
                             { falls nicht in der Liste gespeichtert, }
                             { dann neu Eintragen                     }
                             if not(stored) then
                               begin
                                  new(procdefcoll);
                                  procdefcoll^.data:=hp;
                                  procdefcoll^.next:=symcoll^.data;
                                  symcoll^.data:=procdefcoll;
                                  { numerieren, falls VIRTUAL }
                                  if (hp^.options and povirtualmethod)<>0 then
                                    begin
                                       { dann numerieren }
                                       hp^.extnumber:=nextvirtnumber;
                                       { und die Nummer erhhen }
                                       inc(nextvirtnumber);
                                    end;
                               end;
                             hp:=hp^.nextoverloaded;
                          end;
                        exit;
                     end;
                   symcoll:=symcoll^.next;
                end;
              { falls nicht, Symbolitem neu erzeugen }
              new(symcoll);
              symcoll^.name:=stringdup(sym^.name);
              symcoll^.next:=wurzel;
              symcoll^.data:=nil;
              wurzel:=symcoll;
              hp:=pprocsym(sym)^.definition;
              { und alle Definitionen einfgen }
              while assigned(hp) do
                begin
                   new(procdefcoll);
                   procdefcoll^.data:=hp;
                   procdefcoll^.next:=symcoll^.data;
                   symcoll^.data:=procdefcoll;
                   { sollte eine virtueller Methodenaufruf dabei sein }
                   if (hp^.options and povirtualmethod)<>0 then
                     begin
                        { dann numerieren }
                        hp^.extnumber:=nextvirtnumber;
                        { und die Nummer erhhen }
                        inc(nextvirtnumber);
                     end;
                   { nchstes Element }
                   hp:=hp^.nextoverloaded;
                end;
           end;
      end;

    procedure genvmt(_class : pobjectdef);

      procedure do_genvmt(p : pobjectdef);

        begin
           { bei der "ltesten Klasse anfangen }
           if assigned(p^.childof) then
             do_genvmt(p^.childof);
           { alle ffentlichen Symbole bearbeiten }
{$ifdef tp}
           p^.publicsyms^.foreach(eachsym);
{$else}
           p^.publicsyms^.foreach(@eachsym);
{$endif}
        end;

      var
         symcoll : psymcoll;
         procdefcoll : pprocdefcoll;
         i : longint;

      begin
         wurzel:=nil;
         nextvirtnumber:=0;
         { "Gestrpp" fr VMT erzeugen }
         do_genvmt(_class);
         { nun VMT mit brute force schreiben }
         { alle Nummern durchgehen }
         for i:=0 to nextvirtnumber-1 do
           begin
              symcoll:=wurzel;
              { alle Symbole durchgehen }
              while assigned(symcoll) do
                begin
                   { und alle berladenen Methoden durchgehen }
                   procdefcoll:=symcoll^.data;
                   while assigned(procdefcoll) do
                     begin
                        { Adresse in die VMT schreiben: }
                        { (natrliche nur die, die als VIRTUAL deklariert sind) }
                        if procdefcoll^.data^.extnumber=i then
                          begin
                             if (procdefcoll^.data^.options and povirtualmethod)<>0 then
                               vmtasmlist.concat(gennasmrec(A_LONG,S_NO,
                                 procdefcoll^.data^.mangledname));
                             { only virtual methods can be abstract }
                             if (procdefcoll^.data^.options and poabstractmethod)<>0 then
                               _class^.options:=_class^.options or oois_abstract;
                          end;
                        procdefcoll:=procdefcoll^.next;
                     end;
                   symcoll:=symcoll^.next;
                end;
           end;
         { nun noch das "Getrpp" entfernen }
         symcoll:=wurzel;
         while assigned(symcoll) do
           begin
              wurzel:=symcoll^.next;
              stringdispose(symcoll^.name);
              procdefcoll:=symcoll^.data;
              while assigned(procdefcoll) do
                begin
                   symcoll^.data:=procdefcoll^.next;
                   dispose(procdefcoll);
                   procdefcoll:=symcoll^.data;
                end;
              dispose(symcoll);
              symcoll:=wurzel;
           end;
      end;

end.
