// -------------------- graphic librury -----------------------

#include <dos.h>
#include <stdio.h>

void set_video_mode( int x )
{
	asm     mov     ax, x;
	asm     int     10h;
}

void box_fill( int x, int y, int h, int t, unsigned char color )
{
        int xh = (h - x) + 1, yt = (t - y) + 1;

        _ES = 0xA000;

        asm     cld;
        asm     mov     cx, yt;

next:   _DI = ( (y++) * 320) + x;

        asm     push    cx;
        asm     mov     cx, xh;
        asm     mov     al, color;
        asm     rep     stosb;
        asm     pop     cx;
        asm     loop    next;
}

void set_palette( unsigned char *data )
{
    int i;

    outportb( 0x3C8, 0 );

    for (i = 0; i < 768; i += 3 )
    {
	outportb( 0x3C9, data[i  ] );
	outportb( 0x3C9, data[i+1] );
	outportb( 0x3C9, data[i+2] );
    }
}

void put_pixel( int x, int y, char color )
{
	asm     push    es;
	asm     mov     ax, 0xa000;
	asm     mov     es, ax;

	_DI = ( y * 320 ) + x;

	asm     mov     al, color;
	asm     stosb;
	asm     pop     es;
}

void xor_put_pixel( int x, int y, char color )
{
	asm     push    es;
	asm     mov     ax, 0xa000;
	asm     mov     es, ax;

	_DI = ( y * 320 ) + x;

	asm     mov     al, color;
	asm     xor     al, es:[di];
	asm     stosb;
	asm     pop     es;
}

void draw_box( int x, int y, int h, int t, char color )
{
    int i, k;

    for ( i = x; i <= h; i++ )
    {
        put_pixel( i, y, color );
        put_pixel( i, t, color );
    }

    for ( k = y; k <= t; k++ )
    {
        put_pixel( x, k, color );
        put_pixel( h, k, color );
    }
}

void xor_draw_box( int x, int y, int h, int t, char color )
{
    int i, k;

    for ( i = x; i <= h; i++ )
    {
        xor_put_pixel( i, y, color );
        xor_put_pixel( i, t, color );
    }

    for ( k = y; k <= t; k++ )
    {
        xor_put_pixel( x, k, color );
        xor_put_pixel( h, k, color );
    }
}

void line_x( int x, int y, int h, char color )
{
    int i;
    for ( i = x; i <= h; i++ ) put_pixel( i, y, color );
}

void line_y( int x, int y, int t, char color )
{
    int i;
    for ( i = y; i <= t; i++ ) put_pixel( x, i, color );
}

void xor_line_x( int x, int y, int h, char color )
{
    int i;
    for ( i = x; i <= h; i++ ) xor_put_pixel( i, y, color );
}

void xor_line_y( int x, int y, int t, char color )
{
    int i;
    for ( i = y; i <= t; i++ ) xor_put_pixel( x, i, color );
}
