Unit MystMenu;
{$X+}
INTERFACE

Uses
   Crt, Dos, Graph, UHanX, MystSub;

 Procedure CureSpell;
 Procedure PhenominaSpell;
 Procedure ViewParty;
 Procedure ViewCharacter;
 Procedure Inventory;
 Procedure QuickView;
 Procedure CastSpell;
 Function ReturnPredict : integer;
 Procedure Extrasense;
 Procedure SetBackPack;
 Procedure Rest;
 Procedure Use_Item(select_num : byte);
 Procedure Use_Crystal;
 Procedure GameOption;
 Procedure SelectMode;


IMPLEMENTATION

Procedure SPnotEnough;
begin
   Print(7,'aa, a a a gsa.');
   PressAnyKey;
end;

Procedure HealOne(whom : byte);
begin
   with player[whom] do begin
      if (dead > 0) or (unconscious > 0) or (poison > 0) then begin
         if party.etc[6] = 0 then Print(7,name+'e áaI wȁa aa.');
         exit;
      end;
      if hp >= endurance * level * 10 then begin
         if party.etc[6] = 0 then Print(7,name+'e áai ϩaa sa.');
         exit;
      end;
   end;
   i := 2 * player[person].level;
   if player[person].sp < i then begin
      if party.etc[6] = 0 then SPnotEnough;
      exit;
   end;
   player[person].sp := player[person].sp - i;
   player[whom].hp := player[whom].hp + i * 10;
   with player[whom] do
   if hp > (level * endurance * 10) then hp := level * endurance * 10;
   Print(15,player[whom].name+'e áaA vsa.');
end;

Procedure CureOne(whom : byte);
begin
   with player[whom] do begin
      if (dead > 0) or (unconscious > 0) then begin
         if party.etc[6] = 0 then Print(7,name+'e  áaI wȁa aa.');
         exit;
      end;
      if poison = 0 then begin
         if party.etc[6] = 0 then Print(7,player[whom].name+'e A 韡 gvsa.');
         exit;
      end;
   end;
   if player[person].sp < 15 then begin
      if party.etc[6] = 0 then SPnotEnough;
      exit;
   end;
   player[person].sp := player[person].sp - 15;
   player[whom].poison := 0;
   Print(15,player[whom].name+' e A Asa.');
end;

Procedure ConsciousOne(whom : byte);
begin
   with player[whom] do begin
      if dead > 0 then begin
         if party.etc[6] = 0 then Print(7,name+'e  a wȁa aa.');
         exit;
      end;
      if unconscious = 0 then begin
         if party.etc[6] = 0 then Print(7,player[whom].name+'e w aa.');
         exit;
      end;
   end;
   i := 10 * player[whom].unconscious;
   if player[person].sp < i then begin
      if party.etc[6] = 0 then SPnotEnough;
      exit;
   end;
   player[person].sp := player[person].sp - i;
   player[whom].unconscious := 0;
   if player[whom].hp <= 0 then player[whom].hp := 1;
   Print(15,player[whom].name+'e i Axvsa.');
end;

Procedure RevitalizeOne(whom : byte);
begin
   if player[whom].dead = 0 then begin
      if party.etc[6] = 0 then Print(7,player[whom].name+'e a ia sa.');
      exit;
   end;
   i := 30 * player[whom].dead;
   if player[person].sp < i then begin
      if party.etc[6] = 0 then SPnotEnough;
      exit;
   end;
   player[person].sp := player[person].sp - i;
   with player[whom] do begin
      dead := 0;
      if unconscious > endurance * level then
         unconscious := endurance * level;
      if unconscious = 0 then unconscious := 1;
      Print(15,name+'e a wi sa.');
   end;
end;

Procedure HealAll;
var i : byte;
begin
   for i:= 1 to 6 do if player[i].name <> '' then HealOne(i);
end;

Procedure CureAll;
var i : byte;
begin
   for i:= 1 to 6 do if player[i].name <> '' then CureOne(i);
end;

Procedure ConsciousAll;
var i : byte;
begin
   for i:= 1 to 6 do if player[i].name <> '' then ConsciousOne(i);
end;

Procedure RevitalizeAll;
var i : byte;
begin
   for i:= 1 to 6 do if player[i].name <> '' then RevitalizeOne(i);
end;

Procedure CureSpell;
var
   i,j,whom : integer;
begin
   if player[person].classtype = magic then
      i := player[person].cure_magic div 10
   else
      i := player[person].axe_skill div 10;
   if i <= 0 then begin
      Print(7,'we áa ai awi wb sa.');
      PressAnyKey;
      exit;
   end;
   m[0] := 'AA';
   for i:= 1 to 6 do
   if player[i].name <> '' then
      m[i] := player[i].name
   else
      m[i] := 'sa';
   j := 6;
   if player[6].name <> '' then j := 7;
   m[j] := 'e aqiAA';
   if player[person].classtype = magic then
      i := player[person].cure_magic div 10
   else
      i := player[person].axe_skill div 10;
   if i < 6 then
      whom := Select(60,j-1,j-1,TRUE,TRUE)
   else
      whom := Select(60,j,j,TRUE,TRUE);
   if whom = 0 then exit;
   m[0] := 'Ȃ';
   if whom <> j then begin
      for i := 1 to 5 do m[i] := ReturnMagic(3,i);
      if player[person].classtype = magic then
         i := player[person].cure_magic div 10
      else
         i := player[person].axe_skill div 10;
      if i > 5 then i := 5;
      j := Select(60,i,5,FALSE,TRUE);
      if j = 0 then exit;
      case j of
         1 : HealOne(whom);
         2 : CureOne(whom);
         3 : ConsciousOne(whom);
         4 : RevitalizeOne(whom);
         5 : begin
                RevitalizeOne(whom);
                ConsciousOne(whom);
                CureOne(whom);
                HealOne(whom);
             end;
      end;
   end
   else begin
      for i := 6 to 10 do m[i-5] := ReturnMagic(3,i);
      if player[person].classtype = magic then
         i := player[person].cure_magic div 10 - 5
      else
         i := player[person].axe_skill div 10 - 5;
      if i < 1 then begin
         print(7,'we áa ae a aw sa.');
         PressAnyKey;
         exit;
      end;
      j := Select(60,i,5,TRUE,TRUE);
      case j of
         1 : HealAll;
         2 : CureAll;
         3 : ConsciousAll;
         4 : RevitalizeAll;
         5 : begin
                RevitalizeAll;
                ConsciousAll;
                CureAll;
                HealAll;
             end;
      end;
   end;
   Print(7,''); Print(7,'');
   SimpleDisCond;
   PressAnyKey;
end;

Procedure Wizard_Eye;
var
   x_init,y_init,x_end,y_end : integer;
begin
   if Map_Header.handicap then
   if (Map_Header.handicap_bit and BIT6) > 0 then begin
      Print(13,' w ១Ae a ww ᵡa gva.');
      exit;
   end;
   Clear_View_Screen;
   if (Map_Header.xmax <= 100) and (Map_Header.ymax <= 80) then begin
      x_init := 1; y_init := 1;
      x_end := Map_Header.xmax; y_end := Map_Header.ymax;
   end
   else begin
      x_init := x-50; y_init := y-40;
      x_end := x+50; y_end := y+40;
      if x_init < 1 then begin
         x_init := 1;
         if Map_Header.xmax > 100 then x_end := 100 else x_end := Map_Header.xmax;
      end;
      if y_init < 1 then begin
         y_init := 1;
         if Map_Header.ymax > 80 then y_end := 80 else y_end := Map_Header.ymax;
      end;
      if x_end > Map_Header.xmax then begin
         x_end := Map_Header.xmax;
         if Map_Header.xmax > 100 then x_init := Map_Header.xmax - 100 else x_init := 1;
      end;
      if y_end > Map_Header.ymax then begin
         y_end := Map_Header.ymax;
         if Map_Header.ymax > 80 then y_init := Map_Header.ymax - 80 else y_init := 1;
      end;
   end;
   for j := y_init to y_end do
   for i := x_init to x_end do begin
      case position of
         town : case Real_map(i,j) of
                   1..18,20,21 : k := White; { Wall }
                         22    : k := LightGreen;  { Enterance }
                         23    : k := LightCyan;   { Sign }
                         24    : k := LightBlue;   { Water }
                         25    : k := Cyan;        { Swamp }
                         26    : k := LightRed;    { Lava }
                   0,19,27..47 : k := Black  { Pass }
                            else k := LightMagenta;   { Person }
                end;
         ground:case Real_map(i,j) of
                   2..20 : k := White;
                   22    : k := LightCyan;
                   1,48    : k := LightBlue;
                   23,49 : k := Cyan;
                   50    : k := LightRed;
                   0     : k := Black;
                   24..47: k := Black
                         else k := LightGreen;
                end;
         den  : case Real_map(i,j) of
                   1..40,51 : k := White;
                      54    : k := LightGreen;
                      53    : k := LightCyan;
                      48    : k := LightBlue;
                      49    : k := Cyan;
                      50    : k := LightRed;
                      52    : k := Black;
                   0,41..47 : k := Black
                         else k := LightMagenta;
                end;
         keep : case Real_map(i,j) of
                   1..39,51 : k := White;
                      54    : k := LightGreen;
                      53    : k := LightCyan;
                      48    : k := LightBlue;
                      49    : k := Cyan;
                      50    : k := LightRed;
                0,52,40..47 : k := Black
                         else k := LightMagenta;
                end;
      end;
      PutPixel((i-x_init)*2+32,(j-y_init)*2+305,k);
   end;
   while keypressed do c := readkey;
   repeat
      if k = DarkGray then k := Yellow else k := DarkGray;
      PutPixel((x-x_init)*2+32,(y-y_init)*2+305,k);
   until keypressed and (k = DarkGray);
   while keypressed do c := readkey;
end;

Function Teleport : boolean;
begin
   if Map_Header.handicap then
   if (Map_Header.handicap_bit and BIT4) > 0 then begin
      Print(13,'i  e ӱ e i wЁ sa.');
      Teleport := FALSE;
      exit;
   end;
   Teleport := FALSE;
   x1 := 0; y1 := 0;
   case face mod 4 of
      0 : y1 := 1;
      1 : y1 := -1;
      2 : x1 := 1;
      3 : x1 := -1;
   end;
   Clear;
   Print(11,'w e bi ');
   setcolor(15);
   HGotoXY(266,70);
   HPrint('## ');
   setcolor(10);
   HPrint('5000');
   setcolor(15);
   HPrint(' e b');
   setcolor(10);
   k := 5;
   ok := FALSE;
   repeat
      j := 0;
      c := readkey;
      if c in [#13,#27] then ok := TRUE;
      if c = #0 then begin
         c := readkey;
         case c of
            #75,#80 : j := -1;
            #72,#77 : j := 1;
         end;
         if j <> 0 then begin
            k := k + j;
            if (k<1) or (k>9) then k := k - j
            else begin
               str(k,s);
               setfillstyle(1,8);
               bar(290,70,297,86);
               HPrintXY(290,70,s);
            end;
         end;
      end;
   until ok;
   if c = #27 then begin
      Clear;
      exit;
   end;
   x := x + k*x1; y := y + k*y1;
   if (x<5) or (x>=Map_Header.xmax-3) or (y<5) or (y>=Map_Header.ymax-3) then begin
      x := x - k*x1; y := y - k*y1;
      Message(7,'e  ɷa gsa.');
      exit;
   end;
   ok := FALSE;
   case position of
      town : if Real_map(x,y) in [27..47] then ok := TRUE;
      ground : if Real_map(x,y) in [24..47] then ok := TRUE;
      den : if Real_map(x,y) in [41..47] then ok := TRUE;
      keep : if Real_map(x,y) in [27..47] then ok := TRUE;
   end;
   if not ok then begin
      if (Real_map(x,y) = 0) or
         ((position in [den,keep]) and (Real_map(x,y) = 52)) then begin
         Message(13,'ie ӱ wi sa.');
         Teleport := TRUE;
      end
      else Message(7,'e  w s sa.');
      x := x - k*x1; y := y - k*y1;
      exit;
   end;
   x := x - k*x1; y := y - k*y1;
   for i := 1 to k-1 do begin
      x := x + x1; y := y + y1;
      Scroll(FALSE);
   end;
   x := x + x1; y := y + y1;
   Message(15,'e  a Жsa.');
   Scroll(TRUE);
   Teleport := TRUE;
end;

Procedure PhenominaSpell;

 Procedure SPnotEnough;
 begin
    Message(7,'a a a gsa.');
 end;

var
   x_init,y_init,x_end,y_end : integer;
   ok : boolean;
begin
   if player[person].classtype = sword then begin
      s := player[person].name+ReturnSJosa(player[person].name);
      Message(7,s+' e ai awae i aa.');
      exit;
   end;
   m[0] := 'Ȃ';
   for i := 1 to 10 do m[i] := ReturnMagic(2,i);
   j := player[person].pheno_magic div 10;
   if j > 10 then j := 10;
   k := Select(60,j,10,TRUE,TRUE);
   if k = 0 then exit;
   case k of
      1 : begin
             if player[person].sp < 1 then begin
                SPnotEnough;
                exit;
             end;
             if party.etc[1] + (player[person].pheno_magic div 10) < 256 then
                party.etc[1] := party.etc[1] + (player[person].pheno_magic div 10)
             else
                party.etc[1] := 255;
             Message(15,'Зe a i jvsa.');
             dec(player[person].sp);
             Scroll(TRUE);
          end;
      2 : begin
             if (not Map_Header.handicap) or
                ((Map_Header.handicap_bit and BIT6) = 0) then begin
                if player[person].sp < 5 then begin
                   SPnotEnough;
                   exit;
                end;
                player[person].sp := player[person].sp - 5;
             end;
             Wizard_Eye;
          end;
      3 : begin
             if player[person].sp < 5 then begin
                SPnotEnough;
                exit;
             end;
             Message(15,'Зe w a.');
             party.etc[4] := 255;
             player[person].sp := player[person].sp - 5;
          end;
      4 : begin
             if player[person].sp < 10 then begin
                SPnotEnough;
                exit;
             end;
             Message(15,'Зe i i sa.');
             party.etc[2] := 255;
             player[person].sp := player[person].sp - 10;
          end;
      5 : begin
             if player[person].sp < 20 then begin
                SPnotEnough;
                exit;
             end;
             Message(15,'Зe |i i sa.');
             party.etc[3] := 255;
             player[person].sp := player[person].sp - 20;
          end;
      6 : begin
             if Map_Header.handicap then
             if (Map_Header.handicap_bit and BIT3) > 0 then begin
                Print(13,'i  e ӱ  i wЁ sa.');
                exit;
             end;
             if player[person].sp < 25 then begin
                SPnotEnough;
                exit;
             end;
             x1 := 0; y1 := 0;
             case face mod 4 of
                0 : y1 := 1;
                1 : y1 := -1;
                2 : x1 := 1;
                3 : x1 := -1;
             end;
             x := x + 2*x1; y := y + 2*y1;
             if (x<5) or (x>=Map_Header.xmax-3) or (y<5) or (y>=Map_Header.ymax-3) then begin
                x := x - 2*x1; y := y - 2*y1;
                exit;
             end;
             ok := FALSE;
             case position of
                town : if Real_map(x,y) in [0,27..47] then ok := TRUE;
                ground : if Real_map(x,y) in[0,24..47] then ok := TRUE;
                den : if Real_map(x,y) in[0,41..47] then ok := TRUE;
                keep : if Real_map(x,y) in[0,40..47] then ok := TRUE;
             end;
             if not ok then begin
                x := x - 2*x1; y := y - 2*y1;
                Message(7,'  ɷa gsa.');
                exit;
             end;
             player[person].sp := player[person].sp - 25;
             if (Real_Map(x-x1,y-y1) = 0) or
             ((position in [den,keep]) and (Real_map(x+x1,y+y1) = 52)) then begin
                x := x - 2*x1; y := y - 2*y1;
                Message(13,'ie ӱ w ai sa.');
             end
             else begin
                x := x - x1; y := y - y1;
                Scroll(FALSE);
                x := x + x1; y := y + y1;
                Message(15,' i avsa.');
                Scroll(TRUE);
             end;
          end;
      7 : begin
             if Map_Header.handicap then
             if (Map_Header.handicap_bit and BIT1) > 0 then begin
                Print(13,' b b ӱ wei wЁ sa.');
                exit;
             end;
             if player[person].sp < 30 then begin
                SPnotEnough;
                exit;
             end;
             x1 := 0; y1 := 0;
             case face mod 4 of
                0 : y1 := 1;
                1 : y1 := -1;
                2 : x1 := 1;
                3 : x1 := -1;
             end;
             case position of
                town : k := 47;
                ground : k := 41;
                den : k := 43;
                keep : k := 43;
             end;
             player[person].sp := player[person].sp - 30;
             if (Real_map(x+x1,y+y1) = 0) or
             ((position in [den,keep]) and (Real_map(x+x1,y+y1) = 52)) then begin
                x1 := 0; y1 := 0;
                Message(13,'ie ӱ w ai sa.');
             end
             else if (position = keep) and (Real_Map(x+x1,y+y1) >= 42) then begin
                x1 := 0; y1 := 0;
             end
             else if (position = town) and (Real_Map(x+x1,y+y1) >= 48) then begin
                x1 := 0; y1 := 0;
             end
             else begin
                Putmap(x+x1,y+y1,k);
                Message(15,'weA Жsa.');
                Scroll(TRUE);
             end;
          end;
      8 : begin
             if (not Map_Header.handicap) or
                ((Map_Header.handicap_bit and BIT4) = 0) then begin
                if player[person].sp < 50 then begin
                   SPnotEnough;
                   exit;
                end;
             end;
             if Teleport then player[person].sp := player[person].sp - 50;
          end;
      9 : begin
             if player[person].sp < 30 then begin
                SPnotEnough;
                exit;
             end;
             j := 0;
             for i := 1 to 6 do if player[i].name <> '' then inc(j);
             if party.food + j > 255 then party.food := 255
             else party.food := party.food + j;
             player[person].sp := player[person].sp - 30;
             str(j,s);
             hany := 30;
             Print(15,'  A ae a ЗAsa');
             hany := hany + 20;
             str(j,s);
             Print(15,'            '+s+'   waQ');
             hany := hany + 30;
             str(party.food,s);
             Print(11,'      З e e '+s+'  a');
          end;
      10: begin
             if Map_Header.handicap then
             if (Map_Header.handicap_bit and BIT2) > 1 then begin
                Print(13,' b b ӱ wei wЁ sa.');
                exit;
             end;
             if player[person].sp < 60 then begin
                SPnotEnough;
                exit;
             end;
             x1 := 0; y1 := 0;
             case face mod 4 of
                0 : y1 := 1;
                1 : y1 := -1;
                2 : x1 := 1;
                3 : x1 := -1;
             end;
             case position of
                town : k := 47;
                ground : k := 41;
                den : k := 43;
                keep : k := 43;
             end;
             player[person].sp := player[person].sp - 60;
             j := 0;
             if x1 = 0 then h := 5 else h := 4;
             repeat
                inc(j);
                if (Real_map(x+x1*j,y+y1*j) = 0) or
                ((position in [den,keep]) and (Real_map(x+x1*j,y+y1*j) = 52)) then begin
                   x1 := 0; y1 := 0;
                   Message(13,'ie ӱ w ai sa.');
                   j := h+1;
                end
                else if (position = keep) and (Real_Map(x+x1,y+y1) >= 42) then begin
                   x1 := 0; y1 := 0;
                   j := h+1;
                end
                else if (position = town) and (Real_map(x+x1*j,y+y1*j) >= 48) then begin
                   x1 := 0; y1 := 0;
                   j := h+1;
                end
                else begin
                   Putmap(x+x1*j,y+y1*j,k);
                end;
             until j >= h;
             if j = h then Message(15,'weA Жsa.');
             Silent_Scroll;
          end;
   end;
   displaySP;
end;

Procedure Inventory;
var
   X_Pos, Y_Pos : integer;
begin
   SetColor(7);
   with party do begin
      Y_Pos := 30;
      X_Pos := 270;
      str(item[1],s);
      HPrintXY4Select(X_Pos,Y_Pos+0*15,'Ab A : '+s);
      str(item[2],s);
      HPrintXY4Select(X_Pos,Y_Pos+1*15,'a A : '+s);
      str(item[3],s);
      HPrintXY4Select(X_Pos,Y_Pos+2*15,'Ё  : '+s);
      str(item[4],s);
      HPrintXY4Select(X_Pos,Y_Pos+3*15,'  : '+s);
      str(item[5],s);
      HPrintXY4Select(X_Pos,Y_Pos+4*15,'ɷ  : '+s);
      X_Pos := 430;
      str(item[6],s);
      HPrintXY4Select(X_Pos,Y_Pos+0*15,'  : '+s);
      str(item[7],s);
      HPrintXY4Select(X_Pos,Y_Pos+1*15,'w  : '+s);
      str(item[8],s);
      HPrintXY4Select(X_Pos,Y_Pos+2*15,' i : '+s);
      str(item[9],s);
      HPrintXY4Select(X_Pos,Y_Pos+3*15,'З a : '+s);
      str(item[10],s);
      HPrintXY4Select(X_Pos,Y_Pos+4*15,' i : '+s);

      Y_Pos := 120;
      X_Pos := 270;
      str(crystal[1],s);
      HPrintXY4Select(X_Pos,Y_Pos+0*15,'qaai : '+s);
      str(crystal[2],s);
      HPrintXY4Select(X_Pos,Y_Pos+1*15,'eaaai : '+s);
      str(crystal[3],s);
      HPrintXY4Select(X_Pos,Y_Pos+2*15,'aa  aai : '+s);
      str(crystal[4],s);
      HPrintXY4Select(X_Pos,Y_Pos+3*15,'Aaai : '+s);
      str(crystal[5],s);
      HPrintXY4Select(X_Pos,Y_Pos+4*15,'wѥaai : '+s);
      X_Pos := 430;
      str(crystal[6],s);
      HPrintXY4Select(X_Pos,Y_Pos+0*15,'ŷaai : '+s);
      str(crystal[7],s);
      HPrintXY4Select(X_Pos,Y_Pos+1*15,'Aỡaai : '+s);
      str(crystal[8],s);
      HPrintXY4Select(X_Pos,Y_Pos+2*15,'aˢaai : '+s);
      str(crystal[9],s);
      HPrintXY4Select(X_Pos,Y_Pos+3*15,'a  a i  : '+s);

   end;
end;

Procedure ViewParty;

 Procedure ViewPartySub(i:integer);
 begin
    s := ' aw'; if party.etc[i] = 0 then s := ' a';
 end;

 Procedure AbilitySub(i:integer);
 begin
    s := ' aw'; if not getbit(i) then s := ' a';
 end;

var
   X_Pos, Y_Pos : integer;
   s1,s2,s3 : string[10];
begin
   setcolor(7);
   with party do begin
      X_Pos := 270;
      str(x,s); HPrintXY(X_Pos,45,'X  = '+s);
      str(y,s); HPrintXY(X_Pos,60,'Y  = '+s);
      str(food,s); HPrintXY(X_Pos,80,'qe  = '+s);
      str(gold,s); HPrintXY(X_Pos,95,'qe ׋q = '+s);
      str(arrow,s); HPrintXY(X_Pos,115,'qe i = '+s);
      X_Pos := 430;
      ViewPartySub(1);
      HPrintXY4Select(X_Pos,80,'a  :'+s);
      ViewPartySub(4);
      HPrintXY4Select(X_Pos,95,' w   :'+s);
      ViewPartySub(2);
      HPrintXY4Select(X_Pos,115,'i q :'+s);
      ViewPartySub(3);
      HPrintXY4Select(X_Pos,130,'|i q :'+s);
      Y_Pos := 160;
      X_Pos := 270;
      AbilitySub(8);
      HPrintXY4Select(X_Pos,Y_Pos+0*15,' a  i :'+s);
      AbilitySub(10);
      HPrintXY4Select(X_Pos,Y_Pos+1*15,'a   i :'+s);
      AbilitySub(12);
      HPrintXY4Select(X_Pos,Y_Pos+2*15,'ša i :'+s);
      AbilitySub(14);
      HPrintXY4Select(X_Pos,Y_Pos+3*15,'aať i :'+s);
      X_Pos := 430;
      AbilitySub(7);
      HPrintXY4Select(X_Pos,Y_Pos+0*15,' a  i :'+s);
      AbilitySub(9);
      HPrintXY4Select(X_Pos,Y_Pos+1*15,'a   i :'+s);
      AbilitySub(11);
      HPrintXY4Select(X_Pos,Y_Pos+2*15,'ša i :'+s);
      AbilitySub(13);
      HPrintXY4Select(X_Pos,Y_Pos+3*15,'aať i :'+s);
      X_Pos := 270;
      str(year,s1);
      str((day div 30)+1,s2);
      str((day mod 30)+1,s3);
      HPrintXY4Select(X_Pos,240,s1+' e '+s2+'  '+s3+' ');
      str(hour,s1);
      str(min,s2);
      HPrintXY4Select(X_Pos,255,s1+'  '+s2+' ');
   end;
end;

Procedure ViewCharacter;

 Function ChooseWhom(clean : boolean) : integer;
 var
    i,j,k : integer;
 begin
    m[0] := '';
    j := 0;
    for i := 1 to 6 do
    if player[i].name <> '' then begin
       inc(j);
       m[j] := player[i].name;
    end;
    SetColor(10);
    HPrintXY(265,70,'ewi a ---');
    k := Select(106,j,j,clean,TRUE);
    if k = 0 then begin
       ChooseWhom := 0;
       exit;
    end;
    j := 0;
    for i := 1 to 6 do
    if player[i].name <> '' then begin
       inc(j);
       if j = k then ChooseWhom := i;
    end;
 end;

const
   X_Pos = 260;
begin
   Clear;
   hany := 30;
   print(15,'wbi e i Ȃa');
   i := ChooseWhom(FALSE);
   Clear;
   if i = 0 then Exit;
   with player[i] do begin
      setcolor(11);
      HPrintXY4Select(X_Pos,30,'# q : '+name);
      HPrintXY4Select(X_Pos,46,'# i : '+ReturnSex(i));
      HPrintXY4Select(X_Pos,62,'# s : '+ReturnClass(i));
      setcolor(3);
      str(strength,s);
      HPrintXY4Select(X_Pos+4,88,'A  b : '+s);
      str(mentality,s);
      HPrintXY4Select(X_Pos+4,104,'b : '+s);
      str(concentration,s);
      HPrintXY4Select(X_Pos+4,120,'b : '+s);
      str(endurance,s);
      HPrintXY4Select(X_Pos+4,136,'b : '+s);
      str(resistance,s);
      HPrintXY4Select(X_Pos+4,152,'wb : '+s);
      str(agility,s);
      HPrintXY4Select(X_Pos+4,168,' : '+s);
      str(accuracy,s);
      HPrintXY4Select(X_Pos+4,184,'¬ : '+s);
      str(luck,s);
      HPrintXY4Select(X_Pos+4,200,'З   : '+s);
      SetColor(2);
      j := X_Pos+150;
      if classtype = sword then begin
         str(sword_skill,s);
         HPrintXY4Select(j,88,'Ae   á  : '+s);
         str(axe_skill,s);
         if class <> 7 then
            HPrintXY4Select(j,104,'e   á  : '+s)
         else
            HPrintXY4Select(j,104,'áa a  wbá  : '+s);
         str(spear_skill,s);
         HPrintXY4Select(j,120,'ae  á : '+s);
         str(bow_skill,s);
         HPrintXY4Select(j,136,'e   á  : '+s);
         str(shield_skill,s);
         HPrintXY4Select(j,152,'ẃ aw  á  : '+s);
         str(fist_skill,s);
         HPrintXY4Select(j,168,' aw  á  : '+s);
      end
      else if classtype = magic then begin
         str(attack_magic,s);
         HPrintXY4Select(j,88,'b a wbá : '+s);
         str(pheno_magic,s);
         HPrintXY4Select(j,104,'e a wbá : '+s);
         str(cure_magic,s);
         HPrintXY4Select(j,120,'áa a wbá : '+s);
         str(special_magic,s);
         HPrintXY4Select(j,136,'b a wbá : '+s);
         str(esp_magic,s);
         HPrintXY4Select(j,152,' aeb wbá : '+s);
         str(summon_magic,s);
         HPrintXY4Select(j,168,' a wbá : '+s);
      end;
      setcolor(3);
      str(experience,s);
      HPrintXY4Select(X_Pos+4,216,'## wá : '+s);
      str(level,s);
      HPrintXY4Select(X_Pos+220,216,'## AI : '+s);
      setcolor(2);
      HPrintXY4Select(X_Pos+4,240,'aw  - '+ReturnWeapon(player[i].weapon));
      if shield <> 0 then
         HPrintXY4Select(X_Pos+4,256,'ẃ - '+ReturnShield(shield));
      if armor <> 0 then
         HPrintXY4Select(X_Pos+190,256,'s - '+ReturnArmor(armor));
   end;
end;

Procedure QuickView;
const
   X_Pos = 270;
var
   color : integer;
begin
   color := GetColor;
   setcolor(15);
   HPrintXY(X_Pos+30,40,'q');
   setcolor(12);
   HPrintXY(X_Pos+150,40,'  w q');
   setcolor(7);
   for j:= 1 to 6 do
   with player[j] do
   if name <> '' then begin
      HPrintXY4Select(X_Pos,60+j*15,name);
      str(poison,s);
      HPrintXY4Select(X_Pos+174,60+j*15,s);
      str(unconscious : 3,s);
      HPrintXY4Select(X_Pos+214,60+j*15,s);
      str(dead : 5,s);
      HPrintXY4Select(X_Pos+250,60+j*15,s);
   end;
end;

Procedure CastSpell;
begin
   person := ChooseWhom(FALSE);
   if person = 0 then exit;
   if not exist(person) then begin
      ReturnSexData;
      Message(7,SexData+'e ai awie wȁa aa');
      exit;
   end;
   if (player[person].classtype = sword) and (player[person].class <> 7) then begin
      s := player[person].name+ReturnSJosa(player[person].name);
      Message(7,s+' ai awi  e ia.');
      exit;
   end;
   m[0] := 'awi a A ===>';
   m[1] := 'áa a';
   m[2] := 'e a';
   k := Select(80,2,2,TRUE,TRUE);
   case k of
      1 : CureSpell;
      2 : PhenominaSpell;
   end;
end;

Function ReturnPredict : integer;
var
   data : integer;
begin
   case party.etc[20] of
      0 : if not getbit(0) then data := 1 else data := 2;
   1..2 : data := 3;
      3 : case party.etc[21] of
             0 : if mapname <> 'Gaea' then data := 4 else data := 5;
             1 : data := 6;
             2 : data := 7;
             3 : if getbit(4) then data := 11
                 else if getbit(1) then data := 10
                 else if (mapname = 'Ground3') or (mapname = 'TrolTown') or
                         (mapname = 'Vesper') then data := 9
                 else data := 8;
          end;
   4..6 : if getbit(6) then data := 18
          else if mapname = 'Ground5' then data := 17
          else if getbit(5) then begin
             if mapname = 'Ground2' then data := 16 else data := 15;
          end else if mapname = 'Ground4' then data := 14
          else if mapname = 'Gaea' then data := 13
          else if (mapname = 'Ground2') or (mapname = 'Valiant') or
                  (mapname = 'OccTown') then data := 7
          else if party.etc[20] in [5] then data := 3
          else if party.etc[20] in [4] then data := 11
          else data := 12;
      7 : data := 19;
      8 : data := 20;
   end;
   if party.etc[25] = 1 then begin
      case party.etc[20] of
         9 : data := 19;
        10 : data := party.etc[26] + 21;
        11 : data := 11;
      end;
   end
   else if party.etc[25] = 2 then begin
      if party.year >= 795 then data := 30
      else if getbit(49) then data := 29
      else if getbit(48) then data := 28
      else if getbit(32) then data := 27
      else if mapname = 'UnderGrd' then data := 26
      else data := 25;
   end;
   ReturnPredict := data;
end;

Procedure Extrasense;

 Procedure ESPnotEnough;
 begin
    Message(7,'a a a gsa.');
 end;

const
   Max_Predict_Data = 30;
   Predict_Data : array [1..Max_Predict_Data] of string =
                  ('Aa ׬ei ai',
                   'aeAA ai',
                   'ae   i',
                   'aaAa i',
                   'aa Aa AA bi hi',
                   'a aii w i',
                   'aa Aa i a ei',
                   'aaA Aa i',
                   'B wA e Aai w i',
                   'Aa  a aii w i',
                   'aeAA ai',
                   'aa Aa a i',
                   'aa Aa A e Aai ɷЁ ᕡ Aa i',
                   'B BA e ša aii w i',
                   'aa Aa ai',
                   'a ϡia i ea aa Aa i',
                   'aašei w i',
                   'B ὢA e A aA Aea ii ei',
                   'a aei ei',
                   'a ϡia eei saa i',
                   'aa AaA e a ѥi  i',
                   'aaA AaA e a ѥi  i',
                   'ᕡ AaA e ša ѥi  i',
                   ' BA e aaše ѥi  i',
                   'aAa Aai ɷЁ aAa Aa i',
                   'ʁi ɷЁ  wi ie i',
                   'Aea i i he a  Ba ai',
                   'Av ai ei',
                   ' ai ii 鷩',
                   'A ae Aҁ ii 鷩');

var
   i,j,k : integer;
label
   Exit_For;
begin
   Clear;
   person := ChooseWhom(FALSE);
   if person = 0 then exit;
   ReturnSexData;
   if not exist(person) then begin
      Message(7,SexData+'e qbi awie wȁa aa');
      exit;
   end;
   if player[person].classtype = sword then begin
      Print(7,SexData+'AAe qb wb sa.');
      exit;
   end;
   m[0] := 'awi qb A ===>';
   for j := 1 to 5 do m[j] := ReturnMagic(5,j);
   k := Select(74,5,5,TRUE,TRUE);
   if k = 5 then begin
      Message(7,ReturnMagic(5,5)+'e ʁAe awSa.');
      exit;
   end;
   case k of
      1 : begin
             if Map_Header.handicap then
             if (Map_Header.handicap_bit and BIT5) > 0 then begin
                Print(13,' we aAA ʁi wЁ h a.');
                exit;
             end;
             if player[person].esp_magic < 70 then begin
                Print(7,SexData+'e ʁi Ё ve ae ba.');
                exit;
             end;
             if player[person].sp < 10 then begin
                ESPnotEnough;
                exit;
             end;
             move(font^[0],font^[55],296);
             for i := 5 to 296 do font^[0,i] := 0;
             if position in [den,keep] then begin
                move(font^[52],chara^[55],296);
                for i := 5 to 296 do font^[52,i] := 0;
             end;
             if position in [ground] then begin
                move(font^[20],chara^[55],296);
                for i := 5 to 296 do font^[20,i] := 0;
             end;
             Silent_Scroll;
             Print(15,'Зe i ʁa a.');
             PressAnyKey;
             move(font^[55],font^[0],296);
             if position in [den,keep] then move(chara^[55],font^[52],296);
             if position in [ground] then move(chara^[55],font^[20],296);
             Silent_Scroll;
             player[person].sp := player[person].sp - 10;
          end;
      2 : begin
             if player[person].esp_magic < 10 then begin
                Print(7,SexData+'e i Ё ve ae ba.');
                exit;
             end;
             if player[person].sp < 5 then begin
                ESPnotEnough;
                exit;
             end;
             Print(7,' we w i ea ...');
             Print(7,'');
             k := ReturnPredict;
             if k in [1..Max_Predict_Data] then
                s := 'we ' + Predict_Data[k] + ' a'
             else
                s := 'we  ӱA Ё i wЁ h a';
             cPrint(10,15,' # ',s,'');
             player[person].sp := player[person].sp - 5;
          end;
      3 : begin
             if player[person].esp_magic < 40 then begin
                Print(7,SexData+'e i Ё ve ae ba.');
                exit;
             end;
             if player[person].sp < 20 then begin
                ESPnotEnough;
                exit;
             end;
             Message(15,'we qe ae aq aqi i a.');
             party.etc[5] := 3;
          end;
      4 : begin
             if player[person].esp_magic < 55 then begin
                Print(7,SexData+'e 埡ei Ё ve ae ba.');
                exit;
             end;
             if player[person].sp < player[person].level * 5 then begin
                ESPnotEnough;
                exit;
             end;
             player[person].sp := player[person].sp - player[person].level * 5;
             x1 := 0; y1 := 0;
             case face mod 4 of
                0 : y1 := 1;
                1 : y1 := -1;
                2 : x1 := 1;
                3 : x1 := -1;
             end;
             Map_Header.startX := x; Map_Header.startY := y;
             Aux := SoundOn;
             SoundOn := FALSE;
             hany := 30;
             print(15,'埡e aw ...');
             setcolor(14);
             HPrintXY4Select(250,184,'aǡa a ...');
             for i := 1 to player[person].level do begin
                x := x + x1; y := y + y1;
                if (x<5) or (x>=Map_Header.xmax-3) or (y<5) or (y>=Map_Header.ymax-3) then begin
                   x := x - x1; y := y - y1;
                end
                else begin
                   Scroll(FALSE);
                   c := readkey;
                   if c = #0 then c := readkey;
                   if c = #27 then goto Exit_For;
                end;
             end;
Exit_For:
             Clear;
             x := Map_Header.startX; y := Map_Header.startY;
             SoundOn := Aux;
             Scroll(TRUE);
          end;
   end;
   DisplaySP;
end;

Procedure Rest;
var
   long : longint;
   ok : boolean;
begin
   Clear;
   Print(11,'З a  ei  a.');
   setcolor(15);
   HGotoXY(266,70);
   HPrint('## ');
   setcolor(10);
   str(Rest_Time : 2,s);
   HPrint(s);
   setcolor(15);
   HPrint(' e e');
   setcolor(10);
   ok := FALSE;
   repeat
      j := 0;
      c := readkey;
      if c in [#13,#27] then ok := TRUE;
      if c = #0 then begin
         c := readkey;
         case c of
            #75,#80 : j := -1;
            #72,#77 : j := 1;
         end;
         if j <> 0 then begin
            Rest_Time := Rest_Time + j;
            if (Rest_Time<1) or (Rest_Time>24) then Rest_Time := Rest_Time - j
            else begin
               str(Rest_Time : 2,s);
               setfillstyle(1,8);
               bar(290,70,305,86);
               HPrintXY(290,70,s);
            end;
         end;
      end;
   until ok;
   Clear;
   if c = #27 then exit;

   for person := 1 to 6 do
   with player[person] do
   if name <> '' then begin
      if sex = male then s := 'a' else s := 'aa';
      if party.food <= 0 then Print(4,'Зe  abva')
      else if dead > 0 then Print(7,name+ReturnSJosa(name)+' a')
      else if (unconscious>0) and (poison=0) then begin
         unconscious := unconscious - level*(Rest_Time div 2);
         if unconscious <= 0 then begin
            Print(15,name+ReturnSJosa(name)+'  AAa');
            unconscious := 0;
            if hp <= 0 then hp := 1;
            dec(party.food);
         end
         else Print(15,name+ReturnSJosa(name)+' aӡ  wa');
      end
      else if (unconscious>0) and (poison>0) then
         Print(7,'A, '+name+' '+s+' e AA gva')
      else if poison > 0 then
         Print(7,'A, '+name+' '+s+' we AA gva')
      else begin
         i := level * Rest_Time;
         if hp >= (endurance * level * 10) then if party.food < 255 then inc(party.food);
         hp := hp + i;
         if hp >= (endurance * level * 10) then begin
            hp := endurance * level * 10;
            Print(15,name+ReturnSJosa(name)+' e w AAa');
         end
         else Print(15,name+ReturnSJosa(name)+' áaAa');
         dec(party.food);
      end;
   end;
   if party.etc[1] > 0 then begin
      i := Rest_Time div 3 + 1;
      if party.etc[1] >= i then party.etc[1] := party.etc[1] - i
      else party.etc[1] := 0;
   end;
   for i := 2 to 4 do party.etc[i] := 0;
   for i := 1 to 6 do
   with player[i] do
   if exist(i) then begin
      if classtype = magic then sp := mentality * level * 10
      else if (classtype = sword) and (class = 7) then sp := mentality * level * 5
      else sp := 0;
   end;

   Print(7,'');
   for k := 1 to 6 do
   if exist(k) then begin
      long := player[k].potential_experience;
      j := 0;
      repeat
         inc(j);
      until (long < ReturnEXP(j)) or (j > 40);
      dec(j);
      if (player[k].level < j) or (j = 40) then begin
         if (j < 40) or (player[k].level <> 40) then begin
            str(j,s);
            Print(11,player[k].name+' AIe '+s+' a');
            player[k].level := j;
         end;
      end;
   end;

   SimpleDisCond;
   PlusTime(Rest_Time,0,0);

   if Time_Watch then begin
      with party do
      if ((year > watch_year) or
          ((year = watch_year) and (day > watch_day)) or
          ((year = watch_year) and (day = watch_day) and (hour > watch_hour)) or
          ((year = watch_year) and (day = watch_day) and (hour = watch_hour) and (min >= watch_min))) then begin
             year := watch_year;
             day := watch_day;
             hour := watch_hour;
             min := watch_min;
             sec := watch_sec;
      end;
   end;

end;

Procedure SetBackPack;
type
   position_type = (disarm,equip);
var
   data_ptr,absolute_ep,equip_ptr,disarm_ptr : byte;
   data : array[1..60,1..2] of byte;
   enable_disarm,enable_equip : boolean;
   select_position : position_type;
   i,j,k : integer;

 procedure pr(pos : position_type; line : byte; s_data : string);
 begin
    case pos of
       disarm : OutHPrintXY(288,(line-1)*32+96,s_data,FALSE);
       equip  : OutHPrintXY(424,(line-1)*16+80,s_data,FALSE);
    end;
 end;

 function init_data : boolean;
 var
    i,j : integer;
 begin
    data_ptr := 0;
    for j := 1 to 6 do
    for i := 1 to 10 do
    if party.BackPack[j,i] > 0 then begin
       inc(data_ptr);
       data[data_ptr,1] := j;
       data[data_ptr,2] := i;
    end;
    init_data := (data_ptr > 0);
 end;

 function ReturnEquipment(no : byte) : string;
 var
    i,j,k : byte;
    s : string[21];
 begin
    j := data[no,1];
    i := data[no,2];
    k := party.BackPack[j,i];
    if k > 0 then begin
       str(k : 3,s);
       s := ' '+s+' ';
       case j of
       1..4 : s := s + ReturnWeapon((j-1)*7+i);
          5 : s := s + ReturnShield(i);
          6 : s := s + ReturnArmor(i);
       end;
       ReturnEquipment := s;
    end else ReturnEquipment := '';
 end;

 procedure cursorsub(x,y,len,thick : word);
 var
    dest_off, gap : word;
 begin
    dest_off := 80 * (y-1) * 16 + x-1;
    thick := thick * 16;
    gap := 80 - len;
    asm
       push es
       mov ax, $A000
       mov es, ax
       mov di, dest_off
       mov dx, $3C4
       mov ax, $0702
       out dx, ax
       mov cx, thick
    @for_j:
       push cx
       mov cx, len
    @for_i:
       mov al, es:[di]
       xor al, $FF
       stosb
       loop @for_i
       add di,gap
       pop cx
       loop @for_j
       pop es
    end;
 end;

 procedure cursor;
 begin
    case select_position of
       disarm : cursorsub(36,(disarm_ptr-1) * 2 + 7, 16, 1);
       equip  : cursorsub(55,equip_ptr + 5, 18, 1);
    end;
 end;

 procedure display_disarm;
  procedure clearsub(line : byte);
  begin
     Bar(280,(line-1)*32 + 96,415,(line-1)*32+96+15);
  end;
 begin
    clearsub(1);
    pr(disarm,1,ReturnWeapon(player[person].weapon));
    clearsub(2);
    pr(disarm,2,ReturnShield(player[person].shield));
    clearsub(3);
    pr(disarm,3,ReturnArmor(player[person].armor));
    with player[person] do
       enable_disarm := (weapon > 0) or (shield > 0) or (armor > 0);
 end;

 procedure display_equip;
  procedure clearsub(line : byte);
  begin
     Bar(424,(line-1)*16+80,583,(line-1)*16+80+15);
  end;
 var
    i : byte;
 begin
{    while (data_ptr > 0) and (data_ptr > absolute_ep + equip_ptr) do begin
       if equip_ptr > 1 then dec(equip_ptr)
       else dec(absolute_ep);
    end;}
    if (data_ptr > 0) and (equip_ptr = 0) then equip_ptr := 1;
    if data_ptr = 0 then begin
       select_position := disarm;
       enable_equip := FALSE;
       Bar(424,80,583,271);
       exit;
    end;
    i := 0;
    repeat
       inc(i);
       clearsub(i);
       if (i + absolute_ep <= data_ptr) then begin
          pr(equip,i,ReturnEquipment(i+absolute_ep));
       end;
       if (select_position = equip) and (i = equip_ptr) then cursorsub(55,i+5,18,1);
    until (i = 12);
 end;

begin
   Clear;
   person := ChooseWhom(FALSE);
   if person = 0 then exit;
   with player[person] do enable_disarm := (weapon > 0) or (shield > 0) or (armor > 0);
   enable_equip := init_data;
   if (not enable_disarm) and (not enable_equip) then begin
      Print(7,player[person].name+ReturnSJosa(player[person].name)+' a  a  a.');
      exit;
   end;
   if enable_disarm then select_position := disarm else select_position := equip;
   SetColor(LightGreen);
   OutHPrintXY(272,32,chr(1)+' Ȃ : ',FALSE);
   SetColor(Green);
   OutHPrintXY(344,32,player[person].name,FALSE);
   SetColor(Yellow);
   OutHPrintXY(272,55,'<E>     <D>     <Enter>     <Esc>    ',FALSE);
   Setcolor(Brown);
   OutHPrintXY(272,55,'   wb    ЁA        Ȃ      a',FALSE);
   SetFillStyle(SolidFill,Black);
   SetColor(White);
   Bar(272,80,415,175);
   moveto(272,176); lineto(416,176); lineto(416,80);
   OutHPrintXY(272,80,'',FALSE);
   OutHPrintXY(272,112,'ẃ',FALSE);
   OutHPrintXY(272,144,'s',FALSE);
   Bar(424,80,583,271);
   moveto(424,272); lineto(584,272); lineto(584,80);
   SetColor(LightGray);
   absolute_ep := 0;
   equip_ptr := 1;
   disarm_ptr := 1;
   display_disarm;
   display_equip;
   if select_position = equip then cursor;
   repeat
      cursor;
      case select_position of
         disarm:
         repeat
            c := readkey;
            if c = #0 then c := readkey;
            case c of
               #72:
               begin
                  cursor;
                  if disarm_ptr > 1 then dec(disarm_ptr) else disarm_ptr := 3;
                  cursor;
               end;
               #80:
               begin
                  cursor;
                  if disarm_ptr < 3 then inc(disarm_ptr) else disarm_ptr := 1;
                  cursor;
               end;
               #13:
               begin
                  ok := FALSE;
                  case disarm_ptr of
                     1 :
                     if player[person].weapon > 0 then begin
                        ok := TRUE;
                        j := (player[person].weapon - 1) div 7 + 1;
                        i := player[person].weapon - (j-1) * 7;
                        if party.BackPack[j,i] < 255 then inc(Party.BackPack[j,i]);
                        player[person].weapon := 0;
                     end;
                     2 :
                     if player[person].shield > 0 then begin
                        ok := TRUE;
                        if party.BackPack[5,player[person].shield] < 255 then
                           inc(party.BackPack[5,player[person].shield]);
                        player[person].shield := 0;
                     end;
                     3 :
                     if player[person].armor > 0 then begin
                        ok := TRUE;
                        if party.BackPack[6,player[person].armor] < 255 then
                           inc(party.BackPack[6,player[person].armor]);
                        player[person].armor := 0;
                     end;
                  end;
                  if ok then begin
                     enable_equip := init_data;
                     display_disarm;
                     display_equip;
                     cursor;
                  end;
               end;
               'E','e':
               if enable_equip then begin
                  cursor;
                  select_position := equip;
               end else c := #255;
            end;
         until c in ['E','e',#27];
         equip:
         repeat
            c := readkey;
            if c = #0 then c := readkey;
            case c of
               #72:
               if absolute_ep + equip_ptr > 1 then begin
                  if equip_ptr <= 1 then begin
                     dec(absolute_ep);
                     display_equip;
                  end
                  else begin
                     cursor;
                     dec(equip_ptr);
                     cursor;
                  end;
               end;
               #80:
               if absolute_ep + equip_ptr < data_ptr then begin
                  if equip_ptr >= 12 then begin
                     inc(absolute_ep);
                     display_equip;
                  end
                  else begin
                     cursor;
                     inc(equip_ptr);
                     cursor;
                  end;
               end;
               #13:
               begin
                  j := data[absolute_ep + equip_ptr,1];
                  i := data[absolute_ep + equip_ptr,2];
                  ok := FALSE;
                  case j of
                     1..4:
                     if player[person].weapon = 0 then begin
                        if Verify_Weapon(person,(j-1) * 7 + i) then begin
                           ok := TRUE;
                           player[person].weapon := (j-1) * 7 + i;
                        end;
                     end;
                     5:
                     if player[person].shield = 0 then begin
                        if Verify_Shield(person,i) then begin
                           ok := TRUE;
                           player[person].shield := i;
                        end;
                     end;
                     6:
                     if player[person].armor = 0 then begin
                        if Verify_Armor(person,i) then begin
                           ok := TRUE;
                           player[person].armor := i;
                        end;
                     end;
                  end;
                  if ok then begin
                     dec(party.BackPack[j,i]);
                     if party.BackPack[j,i] = 0 then begin
                        enable_equip := init_data;
                        if absolute_ep + equip_ptr > data_ptr then begin
                           if absolute_ep + equip_ptr > 0 then dec(equip_ptr)
                        end else cursor;
                        display_equip;
                     end else begin
                        Bar(424,(equip_ptr-1)*16+80,583,(equip_ptr-1)*16+80+15);
                        pr(equip,equip_ptr,ReturnEquipment(absolute_ep+equip_ptr));
                        cursor;
                     end;
                     display_disarm;
                  end
                  else begin
                     sound(200);
                     delay(30);
                     nosound;
                  end;
                  if not enable_equip then begin
                     select_position := disarm;
                     c := 'D';
                  end;
               end;
               'D','d':
               if enable_disarm then begin
                  cursor;
                  select_position := disarm;
               end else c := #255;
            end;
         until c in ['D','d',#27];
      end;
   until c in [#27];
   SetFillStyle(SolidFill,DArkGray);
   Clear;
end;

Procedure Use_Item(select_num : byte);

 Procedure Use_1;
 begin
    with player[person] do begin
       hp := hp + 1000;
       if hp > endurance * level * 10 then begin
          Print(15,' '+name+ReturnSJosa(name)+' e w A Asa.');
          hp := endurance * level * 10;
       end
       else Print(15,' '+name+ReturnSJosa(name)+' w A Asa.');
    end;
    Display_Condition;
 end;

 Procedure Use_2;
 begin
    if (player[person].classtype <> magic) and (player[person].class <> 7) then begin
       Print(7,' '+player[person].name+ReturnSJosa(player[person].name)+' aa i aa.');
       exit;
    end;
    with player[person] do begin
       if classtype = magic then begin
          sp := sp + 1000;
          if sp > mentality * level * 10 then begin
             Print(15,' '+name+ReturnSJosa(name)+' e a a A Asa.');
             sp := mentality * level * 10;
          end
          else Print(15,' '+name+ReturnSJosa(name)+' a a A Asa.');
       end
       else begin
          sp := sp + 1000;
          if sp > mentality * level * 5 then begin
             Print(15,' '+name+ReturnSJosa(name)+' e a a A Asa.');
             sp := mentality * level * 5;
          end
          else Print(15,' '+name+ReturnSJosa(name)+' a a A Asa.');
       end;
    end;
    Display_Condition;
 end;

 Procedure Use_3;
 begin
    with player[person] do begin
       if poison = 0 then begin
          Print(7,' '+name+ReturnSJosa(name)+'  A gvsa.');
          exit;
       end;
       poison := 0;
       Print(15,' '+name+ReturnSJosa(name)+' Ё Asa.');
    end;
    Display_Condition;
 end;

 Procedure Use_4;
 begin
    k := ChooseWhom(FALSE);
    if k = 0 then exit;
    with player[k] do begin
       if unconscious = 0 then begin
          Print(7,' '+name+ReturnSJosa(name)+'  sa.');
          exit;
       end;
       unconscious := 0;
       if dead = 0 then begin
          Print(15,' '+name+ReturnSJosa(name)+' i avsa.');
          if hp <= 0 then hp := 1;
       end else
          Print(7,' '+name+ReturnSJosa(name)+'  e wȁ a.');
    end;
    Display_Condition;
 end;

 Procedure Use_5;
 begin
    k := ChooseWhom(FALSE);
    if k = 0 then exit;
    with player[k] do begin
       if dead = 0 then begin
          Print(7,' '+name+ReturnSJosa(name)+'  gvsa.');
          exit;
       end;
       if dead < 10000 then begin
          dead := 0;
          if unconscious >= endurance * level then unconscious := endurance * level - 1;
          Print(15,' '+name+ReturnSJosa(name)+' a iavsa.');
       end else begin
          Print(7,' '+name+' qe  e i sa.');
       end;
    end;
    Display_Condition;
 end;

 Procedure Use_6;

  function r(seed : byte) : integer;
  begin
     r := random(seed*2+1)-seed;
  end;

 var
    i,j,ability : word;
 begin
    ability := 0; j := 0;
    for i := 1 to 5 do begin
       if exist(i) then begin
          j := j + 1;
          ability := ability + player[i].level;
       end;
    end;
    ability := round(ability * 5 / j);
    with player[6] do begin
       case random(8) of
          0 : begin
                 name := 'aá';
                 endurance := 15+r(5);
                 resistance := 8+r(5);
                 accuracy := 12+r(5);
                 weapon := 33;
                 wea_power := ability * 3;
                 potential_ac := 3;
                 ac := 3;
              end;
          1 : begin
                 name := 'ā a';
                 endurance := 20+r(5);
                 resistance := 14+r(5);
                 accuracy := 13+r(5);
                 weapon := 34;
                 wea_power := ability * 1;
                 potential_ac := 3;
                 ac := 3;
              end;
          2 : begin
                 name := 'Eaa';
                 endurance := 17+r(5);
                 resistance := 12+r(5);
                 accuracy := 18+r(2);
                 weapon := 35;
                 wea_power := round(ability * 1.5);
                 potential_ac := 2;
                 ac := 2;
              end;
          3 : begin
                 name := 'Aa';
                 endurance := 18+r(5);
                 resistance := 5+r(5);
                 accuracy := 17+r(3);
                 weapon := 36;
                 wea_power := ability * 4;
                 potential_ac := 4;
                 ac := 4;
              end;
          4 : begin
                 name := 'Iae';
                 endurance := 10+r(5);
                 resistance := 20;
                 accuracy := 17;
                 weapon := 16;
                 wea_power := ability * 1;
                 potential_ac := 3;
                 ac := 3;
              end;
          5 : begin
                 name := 'A˥';
                 endurance := 10+r(5);
                 resistance := 10;
                 accuracy := 10+r(9);
                 weapon := 8;
                 wea_power := round(ability * 0.8);
                 potential_ac := 1;
                 ac := 1;
              end;
          6 : begin
                 name := 'Iaa';
                 endurance := 14+r(5);
                 resistance := 9+r(5);
                 accuracy := 11+r(5);
                 weapon := 33;
                 wea_power := ability * 3;
                 potential_ac := 2;
                 ac := 2;
              end;
          7 : begin
                 name := 'aa';
                 endurance := 13+r(5);
                 resistance := 11+r(5);
                 accuracy := 14+r(5);
                 weapon := 9;
                 wea_power := ability * 3;
                 potential_ac := 2;
                 ac := 2;
              end;
       end;
       sex := neutral;
       class := 0;
       classtype := unknown;
       strength := 10+r(5);
       level := ability div 5;
       strength := 10+r(5);
       mentality := 10+r(5);
       concentration := 10+r(5);
       agility := 0;
       luck := 10+r(5);
       poison := 0;
       unconscious := 0;
       dead := 0;
       hp := endurance * level * 10;
       sp := 0;
       experience := 0;
       potential_experience := 0;
       shield := 0;
       shi_power := 0;
       armor := 0;
       sword_skill := 0;
       axe_skill := 0;
       spear_skill := 0;
       bow_skill := 0;
       shield_skill := 0;
       fist_skill := 0;
       Display_Condition;
    end;
    Print(15,player[6].name+ReturnSJosa(player[6].name)+' ae aa   Avsa.');
 end;

 Procedure Use_7;
 begin
    if party.etc[1] + 10 > 255 then party.etc[1] := 255
    else party.etc[1] := party.etc[1] + 10;
    Print(15,' Зe w i vsa.');
    Silent_Scroll;
 end;

 Procedure Use_8;
 begin
    Wizard_Eye;
 end;

 Procedure Use_9;
 begin
    party.etc[2] := 255;
    party.etc[3] := 255;
    party.etc[4] := 255;
    Print(15,' Зe  З ai sa.');
 end;

 Procedure Use_10;
 begin
    Teleport;
 end;

var
   _select : integer;
   remember : string;
begin
   m[0] := 'awi Αi a.';
   m[1] := 'Ab A';
   m[2] := 'a A';
   m[3] := 'Ё ';
   m[4] := ' ';
   m[5] := 'ɷ ';
   m[6] := ' ';
   m[7] := 'w ';
   m[8] := ' i';
   m[9] := 'З a';
   m[10] := ' i';
   _select := Select(70,select_num,select_num,TRUE,TRUE);
   if _select = 0 then exit;
   remember := m[_select];
   if party.item[_select] = 0 then begin
      if _select in [1,2,7,8,10] then s := '' else s := 'a';
      Print(7,' ae '+remember+s+' sa.');
      PressAnyKey;
      exit;
   end;
   dec(party.item[_select]);
   case _select of
      1 : Use_1;
      2 : Use_2;
      3 : Use_3;
      4 : Use_4;
      5 : Use_5;
      6 : Use_6;
      7 : Use_7;
      8 : Use_8;
      9 : Use_9;
      10: Use_10;
   end;
   if _select <> 8 then begin
      str(party.item[_select],s);
      SetColor(3);
      HPrintXY4Select(hwinx1,256,' '+remember+ReturnSJosa(remember)+' A '+s+' qvsa.');
      if party.etc[6] = 1 then PressAnyKey;
   end;
end;

Procedure Use_Crystal;
var
   i,j : integer;
begin
   j := 0;
   for i := 6 to 9 do
   if party.crystal[i] > 0 then begin
      inc(j);
      m[j] := ReturnMagic(7,i);
   end;
   if j = 0 then exit;
   Clear;
   m[0] := '';
   Print(12,'aaii aw ----');
   Print(7,'');
   Print(11,'w awi aaii a.');
   k := Select(130,j,j,FALSE,TRUE);
   if k = 0 then exit;
   i := 5;
   j := 0;
   repeat
      inc(i);
      if party.crystal[i] > 0 then inc(j);
   until (j = k);
   case i of
      6 : with player[6] do begin
             case random(5) of
              0,1 : begin
                       name := 'aai a';
                       classtype := dragon;
                       strength := 25;
                       mentality := 20;
                       concentration := 20;
                       endurance := 30;
                       resistance := 20;
                       agility := 0;
                       accuracy := 20;
                       luck := 20;
                       weapon := 49;
                       wea_power := 255;
                       potential_ac := 4;
                    end;
              2,3 : begin
                       name := 'aai Q';
                       classtype := golem;
                       strength := 20;
                       mentality := 0;
                       concentration := 0;
                       endurance := 40;
                       resistance := 25;
                       agility := 0;
                       accuracy := 13;
                       luck := 0;
                       weapon := 0;
                       wea_power := 150;
                       potential_ac := 5;
                    end;
                4 : begin
                       name := 'aw';
                       classtype := magic;
                       strength := 20;
                       mentality := 20;
                       concentration := 20;
                       endurance := 30;
                       resistance := 19;
                       agility := 20;
                       accuracy := 20;
                       luck := 20;
                       weapon := 44;
                       wea_power := 200;
                       potential_ac := 5;
                    end;
             end;
             sex := neutral;
             class := 0;
             level := 30;
             poison := 0;
             unconscious := 0;
             dead := 0;
             hp := endurance * level * 10;
             sp := 0;
             ac := potential_ac;
             experience := 0;
             potential_experience := 0;
             shield := 0;
             shi_power := 0;
             armor := 0;
             sword_skill := 0;
             axe_skill := 0;
             spear_skill := 0;
             bow_skill := 0;
             shield_skill := 0;
             fist_skill := 0;
             Display_Condition;
             dec(party.crystal[6]);
          end;
      7 : begin
             for i := 1 to 6 do begin
                if player[i].name <> '' then begin
                   if player[i].dead = 0 then begin
                      player[i].unconscious := 0;
                      player[i].hp := player[i].endurance * player[i].level * 10;
                   end else begin
                      player[i].dead := 0;
                      player[i].unconscious := 0;
                      player[i].hp := 1;
                   end;
                end;
             end;
             Print(7,' Aỡ aaie we Aỡi   ');
             Print(7,'i a  wav  a Aỡi e');
             Print(7,'ie   i Axva.');
             Display_Condition;
             PressAnyKey;
             dec(party.crystal[7]);
          end;
      8 :
      begin
         if (mapname = 'UnderGrd') and (x = 46) and (y = 48) then begin
            Clear;
            Print(7,' sa w ὢA A e q i');
            Print(7,'a֔a.  a  e Aea i');
            Print(7,'a.');
            PressAnyKey;
            Print(9,' b  we Aa bЖ唁 i ҉Wa');
            Print(9,'a.  w xe ae aa A');
            Print(9,'a ϡia aqi Ae i ');
            Print(9,'a.  qee aa .  ᷁ qba');
            Print(9,'i Ё Vsa.');
            PressanyKey;
            mapname := 'Dome';
            Load;
            for j := 1 to Map_Header.ymax do
            for i := 1 to Map_Header.xmax do
            if random(10) = 0 then map^[i,j] := 45 else map^[i,j] := 47;
            x := 25;
            y := 50;
            Scroll(TRUE);
            with party do begin
               watch_year := year;
               watch_day := day;
               watch_hour := hour;
               watch_min := min;
               watch_sec := sec;
            end;
            Time_Watch := TRUE;
            Time_Event_No := 1;
            watch_min := watch_min + 20;
            if watch_min > 59 then begin
               watch_min := watch_min - 60;
               watch_hour := watch_hour + 1;
               if watch_hour > 23 then begin
                  watch_hour := watch_hour - 24;
                  watch_day := watch_day + 1;
                  if watch_day > 359 then begin
                     watch_day := watch_day - 360;
                     watch_year := watch_year + 1;
                  end;
               end;
            end;
         end else begin
            Clear;
            Print(7,' aaiAe a ew a.');
         end;
      end;
      9 :
      begin
         if Map_Header.Tile_Type <> ground then begin
            Print(7,' aai e a aAe bs');
            Print(7,'a.');
            exit;
         end;
         with party do begin
            watch_year := year;
            watch_day := day;
            watch_hour := hour;
            watch_min := min;
            watch_sec := sec;
         end;
         Time_Watch := TRUE;
         Time_Event_No := 5;
      end;
   end;
end;

Procedure GameOption;
var
   i : integer;
begin
   m[0] := 'A Ȃ w';
   m[1] := 'e ';
   m[2] := ' З  i';
   m[3] := 'ЗA AA Ǳ';
   m[4] := 'З wi ៱';
   m[5] := '巁 Ai ';
   m[6] := 'e Ai w';
   m[7] := 'Ai añ';
   k := Select(60,7,7,TRUE,TRUE);
   case k of
      1 : begin
             SetColor(12);
             HPrintXY(275,30,'eA eae i');
             HPrintXY(287,46,'Aái a');
             m[0] := '';
             for i:= 1 to 6 do begin
               str(i+2,s); m[i] := s+' w i';
             end;
             i := Select(90,6,6,FALSE,TRUE)+2;
             if i in [3..8] then maxenemy^ := i;

             m[0] := 'Зi q be sa ?';
             m[1] := ' ʁi ϡa a';
             m[2] := 'ᢁ xe ʁe a gea';
             m[3] := 'aå e ʁi aVa';
             m[4] := 'e ie  ʁaVa';
             m[5] := 'aie ϡA a a';
             i := Select(71,5,5,FALSE,TRUE);
             if i in [1..5] then encounter^ := 6-i;

             m[0] := ' w a b aVsa ?';
             m[1] := ' aa';
             m[2] := 'a ga';
             i := Select(90,2,2,FALSE,TRUE);
             if i > 0 then Cruel := (i = 1);
          end;
      2 : begin
             setcolor(12);
             HPrintXY(275,30,'e  ʁ i i a.');
             setcolor(11);
             HPrintXY(265,70,'i a ');
             m[0] := '';
             for i := 2 to 5 do
                if player[i].name <> '' then m[i-1] := player[i].name
                else m[i-1] := ' a';
             j := select(105,4,4,FALSE,FALSE) + 1;
             if j = 1 then begin
                clear; exit;
             end;
             setcolor(11);
             HPrintXY(445,70,'i a ');
             for i := 2 to 5 do m[i-1] := '                       '+m[i-1];
             k := select(105,4,4,FALSE,FALSE) + 1;
             if k = 1 then begin
                clear; exit;
             end;
             move(player[j],player[7],sizeof(player[7]));
             move(player[k],player[j],sizeof(player[7]));
             move(player[7],player[k],sizeof(player[7]));
             Display_Condition;
             clear;
          end;
      3 : begin
             setcolor(12);
             HPrintXY(275,35,'ЗA AA ǩ aqi a.');
             m[0] := '';
             for i := 2 to 6 do
                if player[i].name <> '' then m[i-1] := player[i].name
                else m[i-1] := 'a';
             k := select(75,5,5,FALSE,TRUE) + 1;
             if k = 1 then begin
                clear; exit;
             end;
             player[k].name := '';
             Display_Condition;
          end;
      4 : begin
             Clear;
             Print(12,'wi ៩ aqi a.');
             k := ChooseWhom(FALSE);
             if k = 0 then exit;
             Print(12,'៩ wi a.');
             m[0] := '';
             m[1] := ReturnWeapon(player[k].weapon);
             m[2] := ReturnShield(player[k].shield);
             m[3] := ReturnArmor(player[k].armor);
             j := Select(120,3,3,FALSE,TRUE);
             if j = 0 then exit;
             with player[k] do
             case j of
                1 : begin
                       weapon := 0;
                       Print(7,name+' e ЁA Asa.');
                    end;
                2 : begin
                       shield := 0;
                       Print(7,name+' ẃe ЁA Asa.');
                    end;
                3 : begin
                       armor := 0;
                       Print(7,name+' se ЁA Asa.');
                    end;
             end;
          end;
      5 : Restore_Game;
      6 : begin
             if Time_Watch then begin
                Clear;
                Print(12,' qe A wi i  sa.');
                Print(12,' qe  aa .');
                exit;
             end;
             m[0] := 'A w wi Ȃa.';
             m[1] := 'sa';
             m[2] := ' A Aa';
             m[3] := 'A Aa 1 ()';
             m[4] := 'A Aa 2 ()';
             m[5] := 'A Aa 3 ()';
             m[6] := 'A Aa 4 ()';
             m[7] := 'A Aa 5 ()';
             m[8] := 'A Aa 6 ()';
             m[9] := 'A Aa 7 ()';
             m[10] := 'A Aa 8 ()';
             k := select(65,10,10,FALSE,TRUE);
             if k < 2 then exit;
             LoadNo := chr(k+47);
             setcolor(12);
             HPrintXY(312,80,'e Ai wsa');
             Save;
             setcolor(7);
             HPrintXY(360,102,'Жsa');
             LoadNo := '1';
             PressAnyKey;
          end;
      7 : GameOver;
   end;
end;

Procedure SelectMode;
begin
   m[0] := 'w wwi a ===>';
   m[1] := 'З w׷i a       [P]';
   m[2] := ' w׷i a       [V]';
   m[3] := 'З a Αi ·  [I]';
   m[4] := 'З w wȁi a  [Q]';
   m[5] := 'ai awea          [C]';
   m[6] := 'wbi awea        [E]';
   m[7] := ' wb  ЁA        [W]';
   m[8] := 'a a              [R]';
   m[9] := 'Αi awea          [U]';
   m[10] := 'A Ȃ w           [G]';
   k := Select(60,10,10,TRUE,TRUE);
   case k of
      0 : exit;
      1 : ViewParty;
      2 : ViewCharacter;
      3 : Inventory;
      4 : QuickView;
      5 : CastSpell;
      6 : Extrasense;
      7 : SetBackPack;
      8 : Rest;
      9 :
      begin
          m[0] := '';
          m[1] := 'a i awea';
          m[2] := 'aaii awea';
          case Select(100,2,2,TRUE,TRUE) of
             0 : exit;
             1 :
             begin
                person := ChooseWhom(FALSE);
                if person > 0 then begin
                   if exist(person) then Use_Item(10)
                   else Print(7,' '+player[person].name+ReturnSJosa(player[person].name)+
                                ' Αi awi  e wȁa aa.');
                end;
             end;
             2 : Use_Crystal;
          end;
      end;
      10: GameOption;
   end;
end;

end.