Unit MystSub;

INTERFACE

Uses
   Crt, Dos, Graph, AdLib, UHanX;
Type
   FontType = array[0..55,1..294] of byte;
   MapType = array[1..150,1..120] of byte;
   BackPackType = array[1..6,1..10] of byte;
   ReturnDataType = array[1..6] of integer;
   ScrollTypes = (normal,snow,rain,autumn,wilderness,strongrain);
   PositionType = (town,ground,den,keep);
   Classes = (sword,magic,elemental,unknown,giant,golem,dragon);
   Map_Header_Type = record
      ID : string[10];
      xmax,ymax : byte;
      Tile_Type : PositionType;
      encounter, handicap : boolean;
      startX,startY : byte;
      exitmap : string[10];
      exitX,exitY : byte;
      entermap : string[10];
      enterX,enterY,default,handicap_bit : byte;
      unused : string[49];
   end;
   Lore = record
             name : string[17];
             sex : (male,female,neutral);
             class : byte;
             strength : byte;
             mentality : byte;
             concentration : byte;
             endurance : byte;
             resistance : byte;
             agility : byte;
             accuracy : byte;
             luck : byte;
             poison : byte;
             unconscious : integer;
             dead : integer;
             hp : integer;
             sp : integer;
             ac : byte;
             level : byte;
             experience : longint;
             potential_experience : longint;
             weapon : byte;
             shield : byte;
             armor : byte;
             potential_ac : byte;
             wea_power : byte;
             shi_power : byte;
             arm_power : byte;
             case classtype : classes of
                sword : (sword_skill,axe_skill,spear_skill,bow_skill,shield_skill,fist_skill : byte);
                magic : (attack_magic,pheno_magic,cure_magic,special_magic,esp_magic,summon_magic : byte);
          end;
   LorePlayer = record
                   year,day : integer;
                   hour,min,sec : byte;
                   food : byte;
                   gold : longint;
                   arrow : word;
                   checksum : array[1..2] of byte;
                   item, crystal : array[1..10] of byte;
                   BackPack : BackPackType;
                   etc : array[1..100] of byte;
                end;
   EnemyData1 = record
                  name : string[16];
                  strength : byte;
                  mentality : byte;
                  endurance : byte;
                  resistance : array[1..2] of byte;
                  agility : byte;
                  accuracy : array[1..2] of byte;
                  ac : byte;
                  special : byte;
                  castlevel : byte;
                  specialcastlevel : byte;
                  level : byte;
               end;
   EnemyData2 = record
                   E_number : byte;
                   name : string[16];
                   strength : byte;
                   mentality : byte;
                   endurance : byte;
                   resistance : array[1..2] of byte;
                   agility : byte;
                   accuracy : array[1..2] of byte;
                   ac : byte;
                   special : byte;
                   castlevel : byte;
                   specialcastlevel : byte;
                   level : byte;
                   hp : integer;
                   aux_hp : byte;
                   poison : boolean;
                   unconscious : boolean;
                   dead : boolean;
                end;
   EnemyDataType = array[1..74] of enemydata1;

const
   EnemyData : EnemyDataType = (
{ 1}(name:'waa'       ;strength: 12;mentality:  0;endurance: 10;resistance:(100,  0);
     agility: 10;accuracy:( 10,  0);ac:  2;special:  1;castlevel:  0;specialcastlevel:  0;level:  7),
{ 2}(name:'w'           ;strength:  0;mentality: 12;endurance: 10;resistance:( 50, 50);
     agility:  0;accuracy:( 10, 16);ac:  0;special:  0;castlevel:  4;specialcastlevel:  8;level:  8),
{ 3}(name:''           ;strength: 13;mentality:  0;endurance: 30;resistance:( 20, 20);
     agility: 10;accuracy:( 14,  0);ac:  4;special:  0;castlevel:  0;specialcastlevel:  0;level:  8),
{ 4}(name:'si'         ;strength: 12;mentality:  0;endurance: 10;resistance:( 30, 30);
     agility: 15;accuracy:( 15,  0);ac:  3;special:  2;castlevel:  0;specialcastlevel:  0;level:  7),
{ 5}(name:'aa '    ;strength:  0;mentality:  0;endurance:  4;resistance:(100,  0);
     agility:  0;accuracy:(  0,  0);ac:  0;special:  0;castlevel:  0;specialcastlevel: 64;level:  6),
{ 6}(name:' w'      ;strength: 20;mentality:  0;endurance: 10;resistance:(  0,  0);
     agility: 10;accuracy:( 15,  0);ac:  0;special:  0;castlevel:  0;specialcastlevel:  0;level: 10),
{ 7}(name:' w'      ;strength:  9;mentality:  0;endurance:  8;resistance:(100,  0);
     agility: 11;accuracy:( 13,  0);ac:  0;special:  0;castlevel:  0;specialcastlevel:  0;level: 10),
{ 8}(name:'aq w'    ;strength:  8;mentality:  0;endurance:  6;resistance:( 40, 40);
     agility: 15;accuracy:( 14,  0);ac:  0;special:  0;castlevel:  0;specialcastlevel:  0;level: 10),
{ 9}(name:'w w'      ;strength: 12;mentality:  0;endurance: 30;resistance:(  0,  0);
     agility: 10;accuracy:( 12,  0);ac:  0;special:  0;castlevel:  0;specialcastlevel:  0;level: 10),
{10}(name:'aa ө'      ;strength:  0;mentality:  0;endurance:  5;resistance:( 30, 30);
     agility: 14;accuracy:(  0,  0);ac:  0;special:  0;castlevel:  0;specialcastlevel: 64;level: 10),
{11}(name:'aaa'     ;strength: 30;mentality:  0;endurance: 30;resistance:( 10, 10);
     agility: 20;accuracy:( 20,  0);ac:  4;special:  0;castlevel:  0;specialcastlevel:  0;level: 13),
{12}(name:'IAa'       ;strength: 25;mentality: 15;endurance: 20;resistance:(  0,  0);
     agility: 10;accuracy:( 30,  0);ac:  6;special:  0;castlevel:  4;specialcastlevel:  0;level: 12),
{13}(name:'awEAa'   ;strength: 60;mentality:  0;endurance: 20;resistance:(  0,  0);
     agility: 10;accuracy:( 10,  0);ac:  5;special:  0;castlevel:  0;specialcastlevel:  0;level: 12),
{14}(name:'aaIa'       ;strength: 25;mentality: 20;endurance: 20;resistance:(  0, 50);
     agility: 17;accuracy:( 20, 20);ac:  5;special:  0;castlevel:  4;specialcastlevel:  0;level: 13),
{15}(name:'ʁwe'       ;strength: 18;mentality:  0;endurance: 15;resistance:(100,100);
     agility: 20;accuracy:( 15,  0);ac:  4;special:  0;castlevel:  0;specialcastlevel:  0;level:  8),
{16}(name:'w'           ;strength: 11;mentality:  0;endurance: 13;resistance:(  0,  0);
     agility: 13;accuracy:( 13,  0);ac:  3;special:  0;castlevel:  0;specialcastlevel:  0;level:  3),
{17}(name:'ͩa'         ;strength: 13;mentality: 10;endurance: 10;resistance:(  0,  0);
     agility: 10;accuracy:( 19, 18);ac:  3;special:  2;castlevel:  2;specialcastlevel:  0;level:  7),
{18}(name:'a'       ;strength:  8;mentality:  0;endurance:  8;resistance:(  0,  0);
     agility:  8;accuracy:(  8,  0);ac:  1;special:  0;castlevel:  0;specialcastlevel:  0;level:  1),
{19}(name:'awa'       ;strength: 10;mentality:  0;endurance: 12;resistance:(  5,  5);
     agility:  8;accuracy:(  9,  0);ac:  2;special:  0;castlevel:  0;specialcastlevel:  0;level:  3),
{20}(name:'aA'   ;strength:  7;mentality: 10;endurance:  9;resistance:(  0,  0);
     agility:  9;accuracy:(  9, 10);ac:  1;special:  0;castlevel:  2;specialcastlevel:  0;level:  4),
{21}(name:'aa'       ;strength: 12;mentality:  0;endurance: 13;resistance:( 25, 25);
     agility: 13;accuracy:( 10,  0);ac:  3;special:  0;castlevel:  0;specialcastlevel:  0;level:  5),
{22}(name:'aaǡA' ;strength:  0;mentality: 15;endurance: 10;resistance:( 40, 40);
     agility:  8;accuracy:(  0, 15);ac:  3;special:  4;castlevel:  4;specialcastlevel:  0;level:  8),
{23}(name:'aaǡa'   ;strength: 17;mentality:  0;endurance: 16;resistance:( 10, 10);
     agility: 15;accuracy:( 15,  0);ac:  5;special:  0;castlevel:  0;specialcastlevel:  0;level:  8),
{24}(name:'aǷ'         ;strength: 19;mentality:  0;endurance: 17;resistance:( 50, 50);
     agility: 11;accuracy:( 16,  0);ac:  5;special:  0;castlevel:  0;specialcastlevel:  0;level: 10),
{25}(name:'a'       ;strength:  9;mentality:  0;endurance:  6;resistance:(  0,  0);
     agility:  9;accuracy:(  9,  0);ac:  1;special:  0;castlevel:  0;specialcastlevel:  0;level:  2),
{26}(name:'awa'       ;strength: 11;mentality:  0;endurance:  6;resistance:(  0,  0);
     agility:  9;accuracy:( 12,  0);ac:  2;special:  0;castlevel:  0;specialcastlevel:  0;level:  3),
{27}(name:'awa'       ;strength: 13;mentality:  0;endurance: 12;resistance:(  0,  0);
     agility:  9;accuracy:( 13,  0);ac:  2;special:  0;castlevel:  0;specialcastlevel:  0;level:  4),
{28}(name:'aa'     ;strength: 16;mentality:  0;endurance: 14;resistance:(  0,  0);
     agility: 19;accuracy:( 20,  0);ac:  2;special:  2;castlevel:  0;specialcastlevel:  0;level:  6),
{29}(name:'awwa'   ;strength:  0;mentality: 10;endurance: 10;resistance:( 70, 70);
     agility:  5;accuracy:(  0, 10);ac:  1;special:  0;castlevel:  3;specialcastlevel:  4;level:  8),
{30}(name:'aqia'     ;strength: 12;mentality:  0;endurance: 13;resistance:( 50, 50);
     agility: 20;accuracy:( 20,  0);ac:  5;special:  3;castlevel:  0;specialcastlevel: 16;level: 11),
{31}(name:'aʁa'       ;strength: 13;mentality:  0;endurance: 12;resistance:(  0,  0);
     agility:  9;accuracy:( 15,  0);ac:  2;special:  0;castlevel:  0;specialcastlevel:  0;level:  5),
{32}(name:'aa'       ;strength: 15;mentality:  0;endurance: 18;resistance:(  0,  0);
     agility: 14;accuracy:( 14,  0);ac:  4;special:  0;castlevel:  0;specialcastlevel:  0;level:  7),
{33}(name:'aa'     ;strength:  0;mentality: 18;endurance: 17;resistance:( 20, 20);
     agility:  8;accuracy:(  0, 18);ac:  2;special:  0;castlevel:  5;specialcastlevel:  0;level:  9),
{34}(name:'a׸a'     ;strength: 19;mentality: 15;endurance: 19;resistance:( 40, 40);
     agility: 12;accuracy:( 19, 17);ac:  5;special:  0;castlevel:  3;specialcastlevel:  0;level: 12),
{35}(name:'šawa'     ;strength:  9;mentality:  0;endurance:  9;resistance:(  0,  0);
     agility:  9;accuracy:(  9,  0);ac:  2;special:  0;castlevel:  0;specialcastlevel:  0;level:  7),
{36}(name:'šaʁa'     ;strength:  9;mentality:  0;endurance:  9;resistance:( 10, 20);
     agility:  9;accuracy:( 12,  0);ac:  2;special:  0;castlevel:  0;specialcastlevel:  0;level:  8),
{37}(name:'šaA' ;strength:  0;mentality: 10;endurance:  9;resistance:(  0, 10);
     agility:  8;accuracy:(  0, 12);ac:  2;special:  1;castlevel:  3;specialcastlevel:  0;level:  8),
{38}(name:'ww'       ;strength: 12;mentality:  0;endurance: 12;resistance:( 40, 80);
     agility: 12;accuracy:( 20,  0);ac:  4;special:  3;castlevel:  0;specialcastlevel:  0;level:  9),
{39}(name:'eዡa'       ;strength: 12;mentality:  0;endurance: 25;resistance:( 20, 40);
     agility: 13;accuracy:( 17,  0);ac:  4;special:  2;castlevel:  0;specialcastlevel:  0;level: 10),
{40}(name:'šaa'   ;strength:  0;mentality: 20;endurance: 15;resistance:( 10, 50);
     agility: 15;accuracy:(  0, 20);ac:  3;special:  0;castlevel:  4;specialcastlevel:  0;level: 11),
{41}(name:'šaa'   ;strength: 17;mentality: 18;endurance: 28;resistance:( 20, 40);
     agility: 16;accuracy:( 20, 20);ac:  4;special:  2;castlevel:  2;specialcastlevel:  0;level: 12),
{42}(name:'źa'     ;strength:  0;mentality: 17;endurance: 10;resistance:( 60,100);
     agility:  8;accuracy:(  0, 17);ac:  2;special:  0;castlevel:  4;specialcastlevel:  4;level: 12),
{43}(name:'Aaw'       ;strength:  0;mentality: 20;endurance: 15;resistance:( 60,255);
     agility: 16;accuracy:(  0, 20);ac:  3;special:  0;castlevel:  5;specialcastlevel: 64;level: 13),
{44}(name:'eዡaw'     ;strength: 19;mentality: 19;endurance: 30;resistance:( 45, 80);
     agility: 15;accuracy:( 20, 20);ac:  5;special:  0;castlevel:  3;specialcastlevel:  0;level: 13),
{45}(name:'šaǷ'       ;strength:  0;mentality: 25;endurance: 25;resistance:( 50, 90);
     agility: 16;accuracy:(  0, 30);ac:  4;special:  0;castlevel:  6;specialcastlevel: 69;level: 15),
{46}(name:'a'         ;strength: 12;mentality:  0;endurance: 10;resistance:( 40, 40);
     agility: 20;accuracy:( 20,  0);ac:  2;special:  0;castlevel:  0;specialcastlevel:  0;level:  4),
{47}(name:'q IEi'  ;strength:  0;mentality:  0;endurance: 20;resistance:( 30, 30);
     agility:  0;accuracy:(  0,  0);ac:  0;special:  0;castlevel:  0;specialcastlevel: 64;level: 10),
{48}(name:'aaše'     ;strength: 30;mentality: 20;endurance: 30;resistance:( 40, 40);
     agility: 18;accuracy:( 18, 18);ac:  4;special:  2;castlevel:  3;specialcastlevel:  0;level: 12),
{49}(name:'w aať'    ;strength: 30;mentality: 20;endurance: 30;resistance:( 40, 40);
     agility: 18;accuracy:( 18, 18);ac:  4;special:  2;castlevel:  3;specialcastlevel:  0;level: 13),
{50}(name:'aa aať'    ;strength: 50;mentality:  0;endurance: 60;resistance:( 60, 70);
     agility: 20;accuracy:( 20,  0);ac:  5;special:  2;castlevel:  0;specialcastlevel:  0;level: 14),
{51}(name:'a aať'    ;strength: 30;mentality: 20;endurance: 30;resistance:( 40, 40);
     agility: 18;accuracy:( 18, 18);ac:  4;special:  2;castlevel:  3;specialcastlevel:  0;level: 15),
{52}(name:'Ŭa aať'  ;strength: 20;mentality: 20;endurance: 25;resistance:( 30, 30);
     agility: 20;accuracy:( 18, 18);ac:  3;special:  0;castlevel:  5;specialcastlevel:  4;level: 16),
{53}(name:'a aať'  ;strength:  0;mentality: 30;endurance: 30;resistance:( 50, 50);
     agility: 20;accuracy:(  0, 20);ac:  4;special:  0;castlevel:  6;specialcastlevel:  0;level: 17),
{54}(name:'לea aať'  ;strength: 50;mentality:  0;endurance: 60;resistance:( 60, 70);
     agility: 20;accuracy:( 20,  0);ac:  5;special:  2;castlevel:  0;specialcastlevel:  0;level: 18),
{55}(name:'aaa aať';strength: 30;mentality: 20;endurance: 30;resistance:(100, 90);
     agility: 18;accuracy:( 18, 18);ac:  4;special:  2;castlevel:  4;specialcastlevel:  0;level: 20),
{56}(name:'a aať'  ;strength: 45;mentality: 25;endurance: 30;resistance:( 50, 50);
     agility: 18;accuracy:( 20, 20);ac:  6;special:  3;castlevel:  5;specialcastlevel:  0;level: 24),
{57}(name:'aˢ aať';strength: 30;mentality: 20;endurance: 30;resistance:( 80, 80);
     agility: 18;accuracy:( 18, 18);ac:  4;special:  2;castlevel:  4;specialcastlevel:128;level: 26),
{58}(name:'aǡaaše' ;strength: 40;mentality: 30;endurance: 30;resistance:( 85, 85);
     agility: 20;accuracy:( 20, 20);ac:  7;special:  3;castlevel:  5;specialcastlevel:  7;level: 28),
{59}(name:'aašeǷ'   ;strength: 40;mentality: 30;endurance: 30;resistance:( 90, 90);
     agility: 30;accuracy:( 25, 25);ac:  8;special:  0;castlevel:  6;specialcastlevel:103;level: 30),
{60}(name:'a ѥ'    ;strength: 20;mentality:  0;endurance: 30;resistance:( 50, 50);
     agility: 25;accuracy:( 20,  0);ac:  4;special:  0;castlevel:  0;specialcastlevel:128;level: 25),
{61}(name:'a ѥ'    ;strength: 20;mentality:  0;endurance: 30;resistance:( 75, 75);
     agility: 25;accuracy:( 30,  0);ac:  5;special:  2;castlevel:  0;specialcastlevel:128;level: 25),
{62}(name:'ša ѥ'  ;strength:  0;mentality: 30;endurance: 30;resistance:( 50, 50);
     agility: 20;accuracy:(  0, 30);ac:  6;special:  0;castlevel:  6;specialcastlevel:128;level: 25),
{63}(name:'aať ѥ'  ;strength: 40;mentality: 30;endurance: 30;resistance:( 90, 90);
     agility: 30;accuracy:( 25, 25);ac:  8;special:  0;castlevel:  6;specialcastlevel:128;level: 25),
{64}(name:'a '  ;strength:  8;mentality:  0;endurance:  8;resistance:(  0,  0);
     agility:  8;accuracy:(  8,  0);ac:  1;special:  0;castlevel:  0;specialcastlevel:  0;level:  1),
{65}(name:'a a'  ;strength:  7;mentality:  0;endurance:  9;resistance:(  0,  0);
     agility:  9;accuracy:( 12,  0);ac:  2;special:  0;castlevel:  0;specialcastlevel:  0;level:  3),
{66}(name:'aa'       ;strength:  9;mentality:  0;endurance:  9;resistance:(  0,  0);
     agility:  9;accuracy:(  9,  0);ac:  2;special:  0;castlevel:  0;specialcastlevel:  0;level:  7),
{67}(name:' wa'    ;strength:  8;mentality:  0;endurance:  8;resistance:(  0,  0);
     agility:  8;accuracy:(  8,  0);ac:  1;special:  0;castlevel:  0;specialcastlevel:  0;level:  2),
{68}(name:' aa'    ;strength:  0;mentality: 16;endurance: 12;resistance:(  0,  0);
     agility: 12;accuracy:(  0, 12);ac:  2;special:  0;castlevel:  4;specialcastlevel:  0;level:  7),
{69}(name:' a'      ;strength:  9;mentality:  0;endurance:  9;resistance:(  0,  0);
     agility:  9;accuracy:(  9,  0);ac:  2;special:  0;castlevel:  0;specialcastlevel:  0;level:  7),
{70}(name:'ww'       ;strength: 40;mentality: 30;endurance: 30;resistance:( 85, 85);
     agility: 20;accuracy:( 20, 20);ac:  7;special:  3;castlevel:  5;specialcastlevel:  0;level: 15),
{71}(name:'wѡa'       ;strength: 30;mentality: 20;endurance: 30;resistance:( 40, 40);
     agility: 18;accuracy:( 18, 18);ac:  4;special:  2;castlevel:  3;specialcastlevel:  0;level: 10),
{72}(name:'wѡw'       ;strength: 40;mentality: 30;endurance: 30;resistance:( 85, 85);
     agility: 20;accuracy:( 20, 20);ac:  7;special:  3;castlevel:  5;specialcastlevel:  0;level: 22),
{73}(name:'ae'         ;strength:200;mentality:200;endurance:200;resistance:(200,200);
     agility: 20;accuracy:( 50, 50);ac: 20;special:  0;castlevel:  6;specialcastlevel:103;level: 60),
{74}(name:'ae'         ;strength: 60;mentality: 40;endurance: 60;resistance:(160,160);
     agility: 20;accuracy:( 40, 40);ac: 20;special:  0;castlevel:  6;specialcastlevel:103;level: 60));

   BIT1 =  1; BIT2 =  2; BIT3 =  4; BIT4 =  8;
   BIT5 = 16; BIT6 = 32; BIT7 = 64; BIT8 = 128;
   absolute_set_xy : boolean = FALSE;
   ebony : boolean = FALSE;
   Time_Watch : boolean = FALSE;
var
   i,j,k : integer;
   b : byte;
   h : word;
   long : longint;
   c,LoadNo : char;
   Josa,Mokjuk : string[2];
   sexdata : string[4];
   s : string;
   m : array[0..10] of string[50];
   x,y,x1,y1 : integer;
   ok,Allright,AutoBattle,aux,LoadFont,Loading_SaveGame,AdLibOn,SoundOn : boolean;
   Cruel : boolean;
   scrolltype : scrolltypes;
   position : positiontype;
   Map_Header : Map_Header_Type;
   encounter, maxenemy : ^byte;
   existfile : pathstr;
   _IMAGE_DIRECTION : (_DIRECT,_STORE);

   filename : file of byte;
   fontname : file of fonttype;
   f, playerfile : file;

   scrollform,scrollcolor,putstyle,yline,face,Rest_Time : byte;
   person : integer;
   font, chara : ^fonttype;
   map : ^maptype;
   mapname : string[9];
   battle : array[1..6,1..3] of byte;
   watch_year, watch_day : integer;
   watch_hour, watch_min, watch_sec, time_event_no : byte;

   party : loreplayer;
   player : array[1..7] of lore;
   enemynumber : byte;
   enemy : array[1..8] of enemydata2;

 Procedure RGB(Color, Red, Green, Blue : byte);
 Procedure Restore_Palette;
 Procedure Clear;
 Procedure PressAnyKey;
 Procedure Screen_Fade_Out_Sub(plane : byte);
 Procedure Screen_Fade_Out(_delay : integer);
 Procedure Screen_Fade_In_Sub(plane : byte);
 Procedure Screen_Fade_In(_delay : integer);
 Procedure OverLap(_delay : integer; character : boolean);
 Procedure Image(X, Y: Integer; var BitMap; Darkness : boolean);
 Function Real_Map(x,y : byte) : byte;
 Procedure PutMap(x,y,value : byte);
 Procedure PutSprite(x,y,number : integer);
 Procedure PutTile(x,y,number : integer);
 Procedure Scroll(character : boolean);
 Procedure Silent_Scroll;
 Procedure Store_Scroll(character : boolean);
 Procedure Delete_Scroll_Screen;
 Procedure Clear_View_Screen;
 Procedure setscrolltype(form : scrolltypes);
 Function exist(person : integer) : boolean;
 Procedure PlusTime(_hour, _min, _sec : integer);
 Procedure Print(color : integer; s1 : string);
 Procedure AuxPrint(color : integer; s1 : string; newline : boolean);
 Procedure cPrint(color1,color2 : integer; s1,s2,s3 : string);
 Procedure message(color : integer; s : string);
 Function SelectSub(yinit,select_init,maxsum,total : integer;clean,lastclean : boolean) : integer;
 Function Select(yinit,maxsum,total : integer;clean,lastclean : boolean) : integer;
 Function Restore_Game : boolean;
 Procedure GameOver;
 Procedure DetectGameOver;
 Function SelectEnemy : integer;
 Function ChooseWhomSub(yinit : integer; printing,clean : boolean) : integer;
 Function ChooseWhom(clean : boolean) : integer;
 Function ReturnSex(number : integer) : string;
 Function ReturnClass(number : integer) : string;
 Function ReturnClassEnable(number,classnumber : integer) : boolean;
 Function ReturnClassType(number : integer) : string;
 Function Verify_Weapon(player_no, weapon_no : byte) : boolean;
 Function Verify_Shield(player_no, shield_no : byte) : boolean;
 Function Verify_Armor(player_no, armor_no : byte) : boolean;
 Procedure Modify_Item(player_no : byte);
 Function ReturnWeapon(number : integer) : string;
 Function ReturnShield(number : integer) : string;
 Function ReturnArmor(number : integer) : string;
 Function ReturnCondition(number : integer) : string;
 Function ReturnMagic(class,magic : integer) : string;
 Function ReturnEXP(level : byte) : longint;
 Function ReturnSJosa(s : string) : string;
 Function ReturnBJosa(s : string) : string;
 Function ReturnOJosa(s : string) : string;
 Function ReturnMessage(who, how, what, whom : integer) : string;
 Procedure ReturnSexData;
 Procedure DisplayHP;
 Procedure DisplaySP;
 Procedure DisplayCondition;
 Procedure SimpleDisCond;
 Procedure Display_Condition;
 Function at(xx,yy : integer) : boolean;
 Function on(xx,yy : integer) : boolean;
 Procedure originposition;
 Function wantenter(name : string) : boolean;
 Function wantexit : boolean;
 Procedure DefaultEnter;
 Procedure DefaultExit;
 Procedure FindGold(money : longint);
 Procedure setbit(bit : integer);
 Function getbit(bit : integer) : boolean;
 Procedure asyouwish;
 Procedure notenoughmoney;
 Procedure thankyou;
 Procedure join(num,partynum : byte);
 Procedure joinenemy(num,j : byte);
 Procedure turn_mind(j,enemy_num : byte);
 Function ReturnJoinMember : byte;
 Procedure Grocery;
 Procedure Weapon_Shop;
 Procedure About_Class;
 Procedure Sell_EXP;
 Procedure Hospital;
 Procedure Medicine;
 Procedure Sell_Item;
 Procedure Load;
 Procedure Save;
 Procedure Set_All;
 Procedure UnSound;


IMPLEMENTATION

Procedure RGB(Color, Red, Green, Blue : byte); assembler;
asm
   mov dx,$3c8;
   mov al,Color;
   out dx,al;
   inc dx;
   mov al,Red;
   out dx,al;
   mov al,Green;
   out dx,al;
   mov al,Blue;
   out dx,al;
end;

Procedure Restore_Palette;
const
   RGB_data : array[0..15,1..3] of byte = (
                 ( 0, 0, 0),( 0, 0,42),( 0,42, 0),( 0,42,42),
                 (42,10,10),(42, 0,42),(42,21, 0),(42,42,42),
                 (21,21,21),(10,10,60),(10,60,10),(10,60,60),
                 (63,21,21),(60,10,60),(60,60,10),(60,60,60));
var
   i : byte;
begin
   for i := 0 to 15 do begin
      SetPalette(i,i);
      RGB(i,RGB_data[i,1],RGB_data[i,2],RGB_data[i,3]);
   end;
end;

Procedure Clear;
var
   i : integer;
begin
   Bar(245,21,242,22);
   Bar(245,21,610,288);
   yline := 30;
   hany := 32;
end;

Procedure PressAnyKey;
begin
   setcolor(14);
   HPrintXY4Select(260,272,'aǡa a ...');
   while keypressed do c := readkey;
   c := readkey;
   if c = #0 then c := readkey;
   Clear;
end;

Procedure Screen_Fade_Out_Sub(plane : byte); assembler;
const
   dest_seg : word = $A000;
   dest_off : word = 80 * 24 + 3;
asm
   push es

   mov ax, dest_seg
   mov es, ax
   mov di, dest_off
   mov dx, $3C4
   mov al, 2
   mov ah, plane
   out dx, ax
   mov ax, $000
   mov cx, 24 * 11

@JUMP1:
   push cx
   mov cx, 13
   rep stosw
   stosb
   add di, 80 - 27
   pop cx
   loop @JUMP1

   pop es
end;

Procedure Screen_Fade_Out(_delay : integer);
var
   i : byte;
begin
   for i := 3 downto 0 do begin
      Screen_Fade_Out_Sub(1 shl i);
      if i > 0 then delay(_delay);
   end;
end;

Procedure Screen_Fade_In_Sub(plane : byte); assembler;
asm
   push ds
   push es

   mov ax, $A9C4 + (24 * 5)
   mov ds, ax
   mov ax, $A000
   mov es, ax
   mov si, $0000 + 3
   mov di, 80 * 24 + 3

   mov dx, $3C4
   mov al, 2
   mov ah, plane
   out dx, ax
   mov cx, 24 * 11
   cld

@JUMP1:
   push cx

   mov cx,27
   rep movsb

   add si, 80 - 27
   add di, 80 - 27
   pop cx
   dec cx
   jz @JUMP2

   cmp cx, 24 * 6
   jne @JUMP1
   mov si, $0000 + 3 * 9 + 3
   jmp @JUMP1

@JUMP2:
   pop es
   pop ds
end;

Procedure Screen_Fade_In(_delay : integer);
const
   plane_data : array[0..3] of byte = (8,12,14,15);
var
   i : byte;
begin
   for i := 0 to 3 do begin
      Screen_Fade_in_Sub(plane_data[i]);
      if i < 3 then delay(_delay);
   end;
end;

Procedure OverLap(_delay : integer; character : boolean);
begin
   Store_Scroll(character);
   Screen_Fade_In(_delay);
   Scroll(character);
end;

Procedure Image(X, Y: Integer; var BitMap; Darkness : boolean);
const
   Font_X_Size = 3;  { 8 * 3 = 24 }
   Font_Y_Size = 24;
var
   sour_seg, sour_off, dest_seg, dest_off : word;
   plane : byte;
begin
   if Darkness then plane := 1 else plane := 8;
   sour_seg := seg(BitMap);
   sour_off := ofs(BitMap) + 4;
   case _IMAGE_DIRECTION of
      _DIRECT : dest_seg := $A000;
      _STORE  : begin
                   dest_seg := $A9C4;
                   if y > 5 then begin
                      y := y - 5;
                      x := x + 9;
                   end;
                end;
   end;
   dest_seg := dest_seg + y * Font_Y_Size * 5;
   dest_off := x * Font_X_Size;

   asm
      push ds
      push es
{
      mov dx, $3CE
      mov ax, $000
      out dx, ax
      mov ax, $001
      out dx, ax
}
      mov ax, sour_seg
      mov ds, ax
      mov ax, dest_seg
      mov es, ax
      mov dx, $3C4

      cmp plane, 1
      jne @MAIN_LOOP

      mov ax, $0E02
      out dx, ax
      mov cx, Font_Y_Size
      mov ax, $0000
      mov di, dest_off

@JUMP1:
      stosw
      stosb
      add di, 80 - Font_X_Size
      loop @JUMP1

@MAIN_LOOP:
      mov si, sour_off
      mov di, dest_off
      mov al, plane

@JUMP2:
      cmp al, 8
      je @JUMP3
      shl al, 1
      add si, 3
      jmp @JUMP2

@JUMP3:
      mov al, $02
      mov ah, plane
      out dx, ax
      mov cx, Font_Y_Size

@JUMP4:
      movsw
      movsb
      add si, 9
      add di, 80 - Font_X_Size
      loop @JUMP4

      shr plane, 1
      cmp plane, 0
      jne @MAIN_LOOP

      pop es
      pop ds
   end;
end;

procedure _Image(X, Y: Integer; var BitMap; Darkness : boolean);
const
   Font_X_Size = 3;    { 8 * 3 = 24 }
   Font_Y_Size = 24;
   Initial_Font_Gap = 0;
var
   bm_seg, bm_off : word;
   xx : word;
   segm : word;
   green, red, intensity : byte;
   i,j : integer;
begin
   if Darkness then begin
      green := 0; red := 0; intensity := 0;
   end else begin
      green := 2; red := 4; intensity := 8;
   end;
   bm_seg := seg(bitmap);
   bm_off := ofs(bitmap)+4;
   xx := x * Font_X_Size + Initial_Font_Gap;
   segm := y * Font_Y_Size * 5 + $a000;
   asm
      push ax
      push bx
      push cx
      push dx
      push si
      push di
{
      mov dx, $3ce
      mov ax, $000
      out dx, ax
      mov ax, $001
      out dx, ax
}
      mov cx, Font_Y_Size
      mov ax, segm
      mov es, ax
      mov di, xx
      mov ax, bm_seg
      mov si, bm_off
      push ds
      mov ds, ax
      mov dx, $3c4
      mov ax, $102
@Ad_Loop:
      cmp intensity, 8
      je  @No_Darkness
      mov ah, 0eh;
      out dx, ax
      mov byte ptr es:[di], 0
      inc di
      mov word ptr es:[di], 0
      dec di
@No_Darkness:
      mov ah, intensity;
      out dx, ax
      movsw
      movsb
      sub di, 3
      mov ah, red
      out dx, ax
      movsw
      movsb
      sub di, 3
      mov ah, green
      out dx, ax
      movsw
      movsb
      sub di, 3
      mov ah, 1
      out dx, ax
      movsw
      movsb

      add di, 77
      dec cx
      jne @Ad_Loop
      pop ds
      pop di
      pop si
      pop dx
      pop cx
      pop bx
      pop ax
   end;
end;

Function Real_Map(x,y : byte) : byte;
begin
   Real_Map := map^[x,y] and $7F;
end;

Procedure Putmap(x,y,value : byte);
begin
   map^[x,y] := (map^[x,y] and $80) or value;
end;

Procedure PutSprite(x,y,number : integer);
begin
   PutImage(x*24,y*24,Chara^[number+28],AndPut);
   PutImage(x*24,y*24,Chara^[number],OrPut);
end;

Procedure PutTile(x,y,number : integer);
begin
   PutImage(x*24,y*24,Font^[number],CopyPut);
end;

Procedure Scroll(character : boolean);
label
   _EBONY_LOOP;
const
   image_buf : array[1..4] of byte = (0,0,0,0);
var
   i, j : integer;
   AuxX, AuxY, x_wide, y_wide : shortint;
   Darkness, Dark, Moon_Light : boolean;
   buf : array [1..294] of byte;
begin
   while KeyPressed do c:= readkey;
   if position = den then Dark := TRUE else Dark := FALSE;
   if (party.day mod 30 + 1) in [10..20] then
      Moon_Light := TRUE else Moon_Light := FALSE;
   if position = den then Moon_Light := FALSE;
   if position = town then Moon_light := TRUE;
   with party do
   if not (hour in [7..17]) then begin
      Dark := TRUE;
      if hour = 18 then begin
         case min of
            0..19 : begin
                       x_wide := 4; y_wide := 4;
                    end;
            20..39: begin
                       x_wide := 3; y_wide := 3;
                    end;
            40..59: begin
                       x_wide := 2; y_wide := 2;
                    end;
         end;
      end
      else if hour = 6 then begin
         case min of
            0..19 : begin
                       x_wide := 2; y_wide := 2;
                    end;
            20..39: begin
                       x_wide := 3; y_wide := 3;
                    end;
            40..59: begin
                       x_wide := 4; y_wide := 4;
                    end;
         end;
      end
      else begin
         x_wide := 1; y_wide := 1;
      end;
   end;
   if position = den then begin
      x_wide := 1; y_wide := 1;
   end;
   if Dark and (party.etc[1] > 0) then begin
      case party.etc[1] of
         1,2 : if (x_wide < 2) and (y_wide < 2) then begin
                  x_wide := 2; y_wide := 2;
               end;
         3,4 : if (x_wide < 3) and (y_wide < 3) then begin
                  x_wide := 3; y_wide := 3;
               end;
      5..255 : if (x_wide < 4) and (y_wide < 4) then begin
                  x_wide := 3; y_wide := 3;
                  Moon_Light := TRUE;
               end;
      end;
   end;
   move(Font^[real_map(x,y)],buf,294);
   for i := 5 to 294 do
      buf[i] := (buf[i] and chara^[face+28][i]) or (chara^[face][i]);
   AuxX := x - 5; AuxY := y - 6;
   if scrolltype <> normal then begin
      SetFillStyle(scrollform,scrollcolor);
      bar(20,20,200,200);
   end;
   SetFillStyle(SolidFill,Black);
{   putimage(0,0,image_buf,copyput);}
_EBONY_LOOP:
   if ebony and (party.etc[1] = 0) then begin
      Moon_Light := FALSE;
      Dark := TRUE;
      character := FALSE;
      x_wide := 0; y_wide := 0;
   end;
   for j := 1 to 11 do for i := 1 to 9 do begin
      if (i in [5-x_wide..5+x_wide]) and (j in [6-y_wide..6+y_wide]) then Darkness := FALSE
      else Darkness := TRUE;
      if not Dark then Darkness := FALSE;
      if ebony and (party.etc[1] = 0) then Darkness := TRUE;
      if (i = 5) and (j = 6) and character then Image(5,6,buf,FALSE)
      else if (j+AuxY < 1) or (j+AuxY > Map_Header.ymax) then Image(i,j,font^[0],Darkness)
      else if map^[i+AuxX,j+AuxY] and $80 > 0 then Image(i,j,font^[real_map(i+AuxX,j+AuxY)],FALSE)
      else if Moon_Light or (not Darkness) then Image(i,j,font^[real_map(i+AuxX,j+AuxY)],Darkness)
      else Image(i,j,font^[55],Darkness);
   end;
   if ebony and (party.etc[1] > 0) then begin
      party.etc[1] := 0;
      delay(250);
      goto _EBONY_LOOP;
   end;
   if soundon then begin
      Sound(20); Delay(5);
   end;
   NoSound;
   setfillstyle(solidfill,DarkGray);
end;

Procedure Silent_Scroll;
begin
   aux := soundon;
   soundon  := FALSE;
   scroll(TRUE);
   soundon  := aux;
end;

Procedure Store_Scroll(character : boolean);
begin
   _IMAGE_DIRECTION := _STORE;
   aux := SoundOn;
   SoundOn := FALSE;
   Scroll(character);
   SoundOn := aux;
   _IMAGE_DIRECTION := _DIRECT;
end;

Procedure Delete_Scroll_Screen;
var
   i : integer;
begin
   SetColor(0);
   for i := 0 to 108 do begin
      line(i*2+24,24,i*2+24,23+24*11);
      line(239-i*2,24,239-i*2,23+24*11);
      delay(5);
   end;
end;

Procedure Clear_View_Screen;
begin
   SetFillStyle(SolidFill,8);
   Bar(30,305,31,306);
   Bar(30,305,240,479);
end;

Procedure setscrolltype(form : scrolltypes);
begin
   scrolltype := form;
   if form = normal then begin
      putstyle := copyput;
      party.etc[12] := 0;
   end
   else putstyle := orput;
   case form of
      snow : begin
                scrollform := SolidFill;
                scrollcolor := Blue;
                party.etc[12] := 1;
             end;
      rain : begin
                scrollform := LtSlashFill;
                scrollcolor := Blue;
                party.etc[12] := 2;
             end;
      autumn : begin
                  scrollform := SolidFill;
                  scrollcolor := Brown;
                  party.etc[12] := 3;
               end;
      wilderness : begin
                      scrollform := 9;
                      scrollcolor := Blue;
                      party.etc[12] := 4;
                   end;
      strongrain : begin
                      scrollform := 6;
                      scrollcolor := Blue;
                      party.etc[12] := 5;
                   end;
   end;
end;

Function exist(person : integer) : boolean;
begin
   exist := FALSE;
   if (player[person].name <> '') and (player[person].unconscious = 0) and
   (player[person].dead = 0) and (player[person].hp > 0) then exist := TRUE;
end;

Procedure PlusTime(_hour, _min, _sec : integer);
begin
   with party do begin
      hour := hour + _hour;
      min := min + _min;
      sec := sec + _sec;
      while sec > 59 do begin
         sec := sec - 60;
         min := min + 1;
      end;
      while min > 59 do begin
         min := min - 60;
         hour := hour + 1;
      end;
      while hour > 23 do begin
         hour := hour - 24;
         day := day + 1;
      end;
      while day > 359 do begin
         day := day - 360;
         year := year + 1;
      end;
   end;
end;

Procedure Print(color : integer; s1 : string);
begin
   SetColor(color);
   hany := hany + 16;
   HGotoXY(260,hany);
   HPrint(s1);
end;

Procedure AuxPrint(color : integer; s1 : string; newline : boolean);
begin
   SetColor(color);
   if newline then begin
      hany := hany + 16;
      HGotoXY(260,hany);
   end;
   HPrint(s1);
end;

Procedure cPrint(color1,color2 : integer; s1,s2,s3 : string);
begin
   AuxPrint(color1,s1,TRUE);
   AuxPrint(color2,s2,FALSE);
   AuxPrint(color1,s3,FALSE);
end;

Procedure message(color : integer; s : string);
var
   i : byte;
begin
   Clear;
   yline := 30; hany := 32;
   Print(color,s);
end;


Function SelectSub(yinit,select_init,maxsum,total : integer;clean,lastclean : boolean) : integer;
var
   i,j,k,y1 : integer;
   move, ok : boolean;
begin
   if clean then Clear;
   SetColor(12);
   HPrintXY4Select(275,30,m[0]);
   if maxsum < 1 then select_init := 0;
   SetColor(7);
   for i := 1 to total do begin
      SetColor(7);
      if i = select_init then SetColor(15);
      if i > maxsum then SetColor(0);
      HPrintXY4Select(290,yinit+(i-1)*16,m[i]);
   end;
   if maxsum <= 0 then begin
      repeat
         c := readkey;
      until c in [#13,#27];
      if lastclean then Clear;
      SelectSub := 0;
      exit;
   end;
   SetColor(7);
   k := select_init; y1 := 0;
   ok := FALSE;
   repeat begin
      c := ReadKey;
      if c = #0 then begin
         c := ReadKey;
         move := TRUE;
         case c of
            #72 : y1 := -1;
            #80 : y1 := 1
            else move := FALSE;
         end;
      end;
      if move then begin
         HPrintXY4Select(290,yinit+(k-1)*16,m[k]);
         k := k + y1;
         if k<1 then k := maxsum;
         if k>maxsum then k := 1;
         SetColor(15);
         HPrintXY4Select(290,yinit+(k-1)*16,m[k]);
         SetColor(7);
      end;
      if ((c=#13) or (c=#32)) then ok := TRUE;
      if c = #27 then begin
         ok := TRUE;
         k := 0;
      end;
      y1 := 0;
   end;
   until ok;
   if lastclean then Clear;
   SetColor(15);
   SelectSub := k;
end;

Function Select(yinit,maxsum,total : integer;clean,lastclean : boolean) : integer;
{  y t, Ȃ awe a , aI e a , q Clear a, ab Clear a
  i , i m A a Aai  З ǡe e we 啡A Ȃ e aaea }
begin
   Select := SelectSub(yinit,1,maxsum,total,clean,lastclean);
end;

Function Restore_Game : boolean;
begin
   m[0] := '  e Ai Ȃa.';
   m[1] := 'sa';
   m[2] := ' A Aa';
   m[3] := 'A Aa 1 ()';
   m[4] := 'A Aa 2 ()';
   m[5] := 'A Aa 3 ()';
   m[6] := 'A Aa 4 ()';
   m[7] := 'A Aa 5 ()';
   m[8] := 'A Aa 6 ()';
   m[9] := 'A Aa 7 ()';
   m[10] := 'A Aa 8 ()';
   k := select(65,10,10,TRUE,TRUE);
   if k > 1 then begin
      LoadNo := chr(k+47);
      aux := FALSE;
      ExistFile := FSearch('Player'+LoadNo+'.dat','');
      if ExistFile = '' then aux := TRUE;
      if aux then begin
         setcolor(12);
         HPrintXY(300,80,'wE Aaa sa !');
         PressAnyKey;
         Restore_Game := FALSE;
         exit;
      end;
      setcolor(11);
      HPrintXY(280,80,'wЖ Ai a ᵳa');
      LoadFont := FALSE; Load; Scroll(TRUE); Display_Condition;
      LoadNo := '1';
      party.etc[6] := 254;
      Clear;
      Time_Watch := FALSE;
      Restore_Game := TRUE;
   end
   else Restore_Game := FALSE;
end;

Procedure All_Fade_Out(plane : byte); assembler;
const
   dest_seg : word = $A000;
   dest_off : word = 0;
asm
   push es

   mov ax, dest_seg
   mov es, ax
   mov di, dest_off
   mov dx, $3C4
   mov al, 2
   mov ah, plane
   out dx, ax
   mov ax, $000
   mov cx, 40 * 480
   rep stosw

   pop es
end;

Procedure GameOver;
Label
   Must_End;
begin
   if party.etc[6] = 255 then begin
      clear;
      while KeyPressed do c := readkey;
      setcolor(13);
      HPrintXY(280,50,'Зe 񺗵A  i a.');
      PressAnyKey;
      if Restore_Game then exit
      else goto Must_End;
   end;
   if party.etc[6] <> 1 then begin
      setcolor(10);
      HPrintXY(300,50,'i {Vsa ?');
      m[0] := '';
      m[1] := '       << a >>';
      m[2] := '       <<      >>';
      k := select(110,2,2,FALSE,TRUE);
      if k < 2 then exit;
   end
   else begin
      while KeyPressed do c := readkey;
      clear;
      setcolor(13);
      HPrintXY(280,50,'Зe  ʁA ́Жa !!');
      setcolor(10);
      HPrintXY(280,70,'    A aVsa ?');
      m[0] := '';
      m[1] := '   巁 Ai ea';
      m[2] := '       Ai {a';
      k := select(120,2,2,FALSE,TRUE);
      if k <> 1 then goto Must_End;
      if Restore_Game then exit;
   end;
Must_End:
   if AdLibOn then PlayOff;
   UnSound;
   for i := 0 to 3 do begin
      All_Fade_Out(1 shl i);
      delay(100);
   end;
   asm
      mov ah,0
      mov al,3
      int $10
      mov ah,1
      mov ch,$20
      int $10
   end;
   dispose(font); dispose(chara);
   dispose(map);
   TextColor(7);
   TextBackGround(0);
   ClrScr;
   TextColor(7);
   Writeln(#13);
   RGB(7,0,0,0);
   Writeln('Feel your RPG imagination !!');
   for i := 1 to 63 do begin
      RGB(7,i,i,i);
      delay(15);
   end;
   delay(500);
   for i := 62 downto 42 do begin
      RGB(7,i,i,i);
      delay(15);
   end;
   asm
      mov ah,1
      mov ch,$13
      mov cl,$14
      int $10
   end;
   Halt;
end;

Procedure DetectGameOver;
var
   i,j : integer;
begin
   j := 0;
   for i := 1 to 6 do if exist(i) then inc(j);
   if j = 0 then begin
      party.etc[6] := 255; { Poisoned to death }
      gameover;
   end;
end;

Function SelectEnemy : integer;
var
   number,color,y1 : integer;
   move : boolean;
begin
   ok := FALSE;
   number := 1;
   repeat
   with enemy[number] do begin
      case hp of
         0 : color := 8;
         1..199 : color := 12;
         200..499 : color := 4;
         500..999 : color := 6;
         1000..1999 : color := 14;
         2000..3999 : color := 2
         else color := 10;
      end;
      if (E_Number = 0) or ((SpecialCastLevel and $80) > 0) then color := 10;
      if unconscious then color := 8;
      if dead then color := 0;
      SetFillStyle(1,7);
      Bar(60,20*number+48,198,20*number+64);
      SetColor(color);
      if color = 0 then setcolor(7);
      HPrintXY4Select(70,20*number+50,name);
      y1 := 0; move := FALSE; c := ReadKey;
      if c = #0 then begin
         c := ReadKey;
         move := TRUE;
         case c of
            #72 : y1 := -1;
            #80 : y1 := 1
            else move := FALSE;
         end;
      end;
      if c = #13 then ok := TRUE;
      if move or ok then begin
         SetFillstyle(1,0);
         Bar(60,20*number+48,198,20*number+64);
         SetColor(color);
         HPrintXY4Select(70,20*number+50,name);
         number := number + y1;
         if number<1 then number := enemynumber;
         if number>enemynumber then number := 1;
      end;
   end;
   until ok;
   SetFillStyle(1,8);
   SelectEnemy := number;
end;

Function ChooseWhomSub(yinit : integer; printing,clean : boolean) : integer;
var
   i,j,k : integer;
begin
   m[0] := '';
   j := 0;
   for i := 1 to 5 do
   if player[i].name <> '' then begin
      inc(j);
      m[j] := player[i].name;
   end;
   if j = 1 then begin
      k := 1;
   end
   else begin
      if printing then begin
         SetColor(10);
         HPrintXY(265,70,'ewi a ---');
      end;
      k := Select(yinit,j,j,clean,TRUE);
      if k = 0 then begin
        ChooseWhomSub := 0;
        exit;
      end;
   end;
   j := 0;
   for i := 1 to 5 do
   if player[i].name <> '' then begin
      inc(j);
      if j = k then ChooseWhomSub := i;
   end;
end;

Function ChooseWhom(clean : boolean) : integer;
begin
   ChooseWhom := ChooseWhomSub(106,TRUE,clean);
end;

Function ReturnSex(number : integer) : string;
begin
   case player[number].sex of
      male   : ReturnSex := 'q';
      female : ReturnSex := 'a';
      neutral: ReturnSex := '';
   end;
end;

Function ReturnClass(number : integer) : string;
const
   MaxData = 7;
   Class : array[sword..magic,1..MaxData] of string[10] = (
           ('ʁ  a','  a','  a','a','ʁw','qia','  a'),
           ('A','a','a','a','wwa','aa','a'));
begin
   if player[number].class in [1..MaxData] then
      ReturnClass := Class[player[number].classtype,player[number].class]
   else
      ReturnClass := '¯q';
end;

Function ReturnClassEnable(number,classnumber : integer) : boolean;
var
   enable : boolean;
begin
   enable := FALSE;
   if (number in [1..6]) and (classnumber in [1..7]) then begin
      with player[number] do
      if classtype = sword then begin
         case classnumber of
            1 : if (sword_skill>=10) and (axe_skill>=10) and (spear_skill>=10)
                and (bow_skill>=10) and (shield_skill>=10) then enable := TRUE;
            2 : if (sword_skill>=10) and (axe_skill>=10) and (spear_skill>=5)
                and (shield_skill>=20) then enable := TRUE;
            3 : if (sword_skill>=40) then enable := TRUE;
            4 : if (axe_skill>=5) and (spear_skill>=5) and (bow_skill>=40) then enable := TRUE;
            5 : if (fist_skill>=40) then enable := TRUE;
            6 : if (sword_skill>=10) and (bow_skill>=10) and (fist_skill>=20) then enable := TRUE;
            7 : if (sword_skill>=25) and (spear_skill>=5)
                and (shield_skill>=20) and (fist_skill>=10) then enable := TRUE;
         end;
      end else begin
         case classnumber of
            1 : if (attack_magic>=10) and (pheno_magic>=10) and (cure_magic>=10) then enable := TRUE;
            2 : if (summon_magic>=10) and (pheno_magic>=10) and (cure_magic>=10) then enable := TRUE;
            3 : if (summon_magic>=10) and (cure_magic>=10) then enable := TRUE;
            4 : if (attack_magic>=40) and (pheno_magic>=25) and (cure_magic>=25) then enable := TRUE;
            5 : if (attack_magic>=20) and (pheno_magic>=20) and (cure_magic>=40)
                and (summon_magic>=40) then enable := TRUE;
            6 : if (attack_magic>=10) and (pheno_magic>=40) and (cure_magic>=30)
                and (summon_magic>=20) then enable := TRUE;
            7 : if (attack_magic>=40) and (pheno_magic>=40) and (cure_magic>=40)
                and (special_magic>=20) and (esp_magic>=20) and (summon_magic>=20) then enable := TRUE;
         end;
      end;
      ReturnClassEnable := enable;
   end;
end;

Function ReturnClassType(number : integer) : string;
begin
   case player[number].classtype of
      sword : ReturnClassType := 'ʁa';
      magic : ReturnClassType := 'aa';
      elemental : ReturnClassType := 'w';
      giant : ReturnClassType := 'ᷥ';
      golem : ReturnClassType := 'Q';
      dragon : ReturnClassType := 'a'
      else ReturnClassType := '¯q';
   end;
end;

Function Verify_Weapon(player_no, weapon_no : byte) : boolean;
begin
   Verify_Weapon := FALSE;
   if player[player_no].ClassType = magic then exit;
   with player[player_no] do begin
      case weapon_no of
         1..7  : if class in [1,2,3,6,7] then Verify_Weapon := TRUE;
         8..14 : if class in [1,2,4] then Verify_Weapon := TRUE;
         15..21: if class in [1,2,4,6,7] then Verify_Weapon := TRUE;
         22..28: if class in [1,4,6,7] then Verify_Weapon := TRUE;
      end;
   end;
end;

Function Verify_Shield(player_no, shield_no : byte) : boolean;
var
   sort, order : integer;
begin
   Verify_Shield := FALSE;
   if player[player_no].ClassType <> sword then exit;
   if player[player_no].class in [1,2,3,7] then Verify_Shield := TRUE;
end;

Function Verify_Armor(player_no, armor_no : byte) : boolean;
begin
   Verify_Armor := FALSE;
   with player[player_no] do begin
      if (ClassType = magic) and (armor_no = 1) then
         Verify_Armor := TRUE;
      if (ClassType = sword) and (armor_no in [1..10,255]) then
         Verify_Armor := TRUE;
   end;
end;

Procedure Modify_Item(player_no : byte);
const
   weapon_data : array[1..4,1..7,1..7] of byte = (
          ((15,15,15,15,15,25,15),
           (30,30,25,25,25,25,30),
           (35,40,35,35,35,35,40),
           (45,48,50,40,40,40,40),
           (50,55,60,50,50,50,55),
           (60,70,70,60,60,60,65),
           (70,70,80,70,70,70,70)),
          ((15,15,15,15,15,15,15),
           (35,30,30,37,30,30,30),
           (35,40,35,35,35,35,35),
           (52,45,45,45,45,45,45),
           (60,60,55,55,55,55,55),
           (75,70,70,70,70,70,70),
           (80,85,80,80,80,80,80)),
          ((10,10,10,25,10,20,10),
           (35,40,35,35,35,35,40),
           (35,30,30,35,30,30,30),
           (40,40,40,45,40,40,40),
           (60,60,60,60,60,60,60),
           (80,80,80,80,80,80,80),
           (90,90,90,90,90,90,90)),
          ((10,10,10,15,10,15,10),
           (10,10,10,10,10,20,10),
           (20,20,20,27,20,20,20),
           (35,35,35,40,35,38,35),
           (45,45,45,55,45,45,45),
           (55,55,55,65,55,55,55),
           (70,70,70,85,70,70,70)));
var
   sort, order : integer;
begin
   with player[player_no] do begin
      if Verify_Weapon(player_no,weapon) then begin
         if weapon > 0 then begin
            sort := (weapon-1) div 7 + 1;
            order := weapon - (sort-1) * 7;
            wea_power := weapon_data[sort,order,class];
         end else wea_power := 5;
      end
      else wea_power := 5;
      if Verify_Shield(player_no,shield) then begin
         shi_power := shield;
      end
      else shi_power := 0;
      if Verify_Armor(player_no,armor) then begin
         arm_power := armor;
         if armor = 255 then arm_power := 20;
      end
      else arm_power := 0;
      ac := potential_ac + arm_power;
   end;
end;

Function ReturnWeapon(number : integer) : string;
const
   maxdata = 49;
   data : array[-1..maxdata] of string[15] = ('¯e ','',
          'e','aaa','I','','','w','aQa',
          '','w ','aA','ʁw wá','A','i ʁ ','Љa',
          'e','ww','ew','Aϡ','qw','','w',
          'i aa','aw','ʁ⋡','ʁw','','⊗','aaiAaa',
          'q','Ё','͢Η','','i','','w',
          'iɳ','a','q',' a','刁 a',
          'ɡ','w ','e aa','','aa',
          '','q aa','e',' aa');
begin
   if number in [0..maxdata] then ReturnWeapon := data[number]
   else ReturnWeapon := data[-1];
   if number in [3,10,26,30,33] then begin
      Josa := '';
      Mokjuk := 'i';
   end
   else if number in [0,1,6,8,16,17,19,21,23,25,27,29,31,32,35,36,38,40,42,44,46] then begin
      Josa := 'a';
      Mokjuk := 'i';
   end
   else begin
      Josa := '';
      Mokjuk := 'i';
   end;
end;

Function ReturnShield(number : integer) : string;
const
   maxdata = 5;
   data : array[-1..maxdata] of string[15] = ('¯q','q',
          'a ẃ','w w ẃ','w w ẃ','aˢ ẃ',
          'iˡ ẃ');
begin
   if number in [0..maxdata] then ReturnShield := data[number]
   else ReturnShield := data[-1];
   if number in [0] then begin
      Josa := 'a';
      Mokjuk := 'i';
   end
   else begin
      Josa := '';
      Mokjuk := 'i';
   end;
end;

Function ReturnArmor(number : integer) : string;
const
   maxdata = 10;
   data : array[-1..maxdata] of string[15] = ('¯q','q',
          'a s',' A','A A','i s','ae',
          'A','aIa','e s','aˢ s','iˡ s');
begin
   if number in [0..maxdata] then ReturnArmor := data[number]
   else ReturnArmor := data[-1];
   if number in [0..4,6,8..10] then begin
      Josa := 'a';
      Mokjuk := 'i';
   end
   else begin
      Josa := '';
      Mokjuk := 'i';
   end;
end;

Function ReturnCondition(number : integer) : string;
begin
   with player[number] do begin
      if (hp <= 0) and (unconscious = 0) then unconscious := 1;
      if (unconscious > endurance * level) and (dead = 0) then dead := 1;
      if dead > 0 then begin
         ReturnCondition := 'e wȁ';
         exit;
      end;
      if unconscious > 0 then begin
         ReturnCondition := ' w';
         exit;
      end;
      if poison > 0 then begin
         ReturnCondition := '   ';
         exit;
      end;
      ReturnCondition := '   q';
   end;
end;

Function ReturnMagic(class,magic : integer) : string;
const
   maxclass = 7;
   maxmagic = 10;
   data : array [0..maxclass,1..maxmagic] of string[20] = (
          ('a i','a ','a ew',' ai','a i',
           ' ׬','e ',' ׬','b A','ϩi '),
          (' ͢Η','i a','qa','A aa','',
           'q ','aaa','Aỡ wb',' ','a i'),
          ('a ','a ',' w','i q','|i q',
           ' ','w e','e ',' A','w e'),
          ('ew áa','ew  A','ew  ','ew ','ew s áa',
           ' áa','  A','  ',' ',' s áa'),
          ('ew  b','ew w b','ew wb a','ew a w','ew i ',
           '  b',' w b',' wb a',' a w',' i '),
          ('ʁ','','','埡e','qb',
           ' ЂWs','͡ ','Ŭw ',' a ','AA i'),
          (' w ',' w ',' w ','w w ','e a ',
           'ae a  ','ᷥi q','Qi q','wi q','aeaa '),
          ('q aai','ea aai','aa aai','A aai','wѥ aai',
           'ŷ aai','Aỡ aai','aˢ aai','aai ',''));
var
   code : byte;
begin
   if (class in [0..maxclass]) and (magic in [1..maxmagic]) then begin
      ReturnMagic := data[class,magic];
      code := 1;
      case class of
         0 : if magic in [2,5] then code := 0;
         1 : if magic in [3..7] then code := 0;
         2 : if magic in [7,9,10] then code := 0;
         3 : if magic in [1,2,5..7,10] then code := 0;
         4 : if magic in [1..10] then code := 0;
         5 : if magic in [1] then code := 0;
      end;
   end
   else begin
      ReturnMagic := 'i e a';
      code := 1;
   end;
   if code = 0 then begin
      Josa := '';
      Mokjuk := 'i';
   end
   else begin
      Josa := 'a';
      Mokjuk := 'i';
   end;
end;

Function ReturnEXP(level : byte) : longint;
const
   data : array[1..40] of longint = (
          0,1500,6000,20000,50000,150000,250000,500000,800000,1050000,
          1320000,1620000,1950000,2320000,2700000,3120000,3570000,4050000,4560000,5100000,
          6000000,7000000,8000000,9000000,10000000,12000000,14000000,16000000,18000000,20000000,
          25000000,30000000,35000000,40000000,45000000,50000000,55000000,60000000,65000000,70000000);

begin
   if level in [1..50] then ReturnEXP := data[level]
   else ReturnEXP := 0;
end;

Function ReturnSJosa(s : string) : string;
var
   temp : byte;
begin
   temp := ord(s[length(s)]);
   temp := temp and $1F;
   if temp = 1 then ReturnSJosa := 'e'
   else ReturnSJosa := 'e';
end;

Function ReturnBJosa(s : string) : string;
var
   temp : byte;
begin
   temp := ord(s[length(s)]);
   temp := temp and $1F;
   if temp = 1 then ReturnBJosa := 'a'
   else ReturnBJosa := '';
end;

Function ReturnOJosa(s : string) : string;
var
   temp : byte;
begin
   temp := ord(s[length(s)]);
   temp := temp and $1F;
   if temp = 1 then ReturnOJosa := 'i'
   else ReturnOJosa := 'i';
end;

Function ReturnMessage(who, how, what, whom : integer) : string;
var
   temp : byte;
begin
   s := player[who].name;
   s := s + ReturnSJosa(s) + ' ';
   case how of
      1 : begin
             if player[who].weapon-1 >= 0 then j := (player[who].weapon-1) div 7
             else j := 0;
             case j of
                1 : s := s+ReturnWeapon(player[who].weapon)+Josa+' '
                          +enemy[whom].name+ReturnOJosa(enemy[whom].name)+' ava';
                2 : s := s+ReturnWeapon(player[who].weapon)+Josa+' '
                          +enemy[whom].name+ReturnOJosa(enemy[whom].name)+' a';
                3 : begin
                       if party.arrow > 0 then begin
                          s := s+ReturnWeapon(player[who].weapon)+Josa+' '
                          +enemy[whom].name+ReturnOJosa(enemy[whom].name)+' va';
                       end else begin
                          s := 'i a a bi  a';
                       end;
                    end
                else s := s+ReturnWeapon(player[who].weapon)+Josa+' '
                          +enemy[whom].name+ReturnOJosa(enemy[whom].name)+' bЖa';
             end;
          end;
      2 : s := s+''''+ReturnMagic(0,what)+''''+Josa+' '+enemy[whom].name+'AA bЖa';
      3 : s := s+''''+ReturnMagic(1,what)+''''+Josa+' '+enemy[whom].name+'AA bЖa';
      4 : s := s+enemy[whom].name+'AA '+ReturnMagic(4,what)+Josa+' b bi Жa';
      5 : s := s+player[whom].name+'AA '''+ReturnMagic(3,what)+''''+Mokjuk+' awЖa';
      6 : if whom = 0 then s := s+'e AA '+ReturnMagic(5,what)+Mokjuk+' awЖa'
          else s := s+enemy[whom].name+'AA '+ReturnMagic(5,what)+Mokjuk+' awЖa';
      7 : s := s+ReturnMagic(6,what)+Mokjuk+'  Жa';
      9 : s := 'Зe wi Жa'
      else s := s+' q Жa';
   end;
   ReturnMessage := s;
end;

Procedure ReturnSexData;
begin
   if player[person].sex = female then SexData := 'aa'
   else SexData := 'a';
end;

Procedure DisplayHP;
begin
   setcolor(15);
   Bar(400,20+330,401,20+331);
   for j:=1 to 6 do
   with player[j] do
   if name <> '' then begin
      str(hp:5,s);
      Bar(400,j*20+330,440,j*20+346); { HP }
      OutHPrintXY(400,330+20*j,s,FALSE);
   end;
end;

Procedure DisplaySP;
begin
   setcolor(15);
   Bar(479,20+330,480,20+331);
   for j:=1 to 6 do
   with player[j] do
   if name <> '' then begin
      str(sp:5,s);
      Bar(463,j*20+330,503,j*20+346); { SP }
      OutHPrintXY(463,330+20*j,s,FALSE);
   end;
end;

Procedure DisplayCondition;
begin
   Bar(540,20+330,541,20+331);
   for j:=1 to 6 do begin
      Bar(540,j*20+330,610,j*20+346); { Condition }
      if player[j].name <> '' then begin
         s := ReturnCondition(j);
         if s = '   q' then Setcolor(15) else Setcolor(12);
         OutHPrintXY(540,330+20*j,s,FALSE);
      end;
   end;
   setcolor(15);
end;

Procedure SimpleDisCond;
var
   i,j : integer;
begin
   setcolor(15);
   Bar(400,20+330,401,20+331);
   for j:=1 to 6 do
   with player[j] do begin
      str(hp:5,s);
      Bar(400,j*20+330,440,j*20+346); { HP }
      if name <> '' then OutHPrintXY(400,330+20*j,s,FALSE);
      str(sp:5,s);
      Bar(463,j*20+330,503,j*20+346); { SP }
      if name <> '' then OutHPrintXY(463,330+20*j,s,FALSE);
   end;
   DisplayCondition;
end;

Procedure Display_Condition;
var
   i,j : integer;
begin
   SimpleDisCond;
   SetColor(15);
   for j := 1 to 6 do
   with player[j] do begin
      bar(260,j*20+330,388,j*20+346); { Name }
      if name <> '' then OutHPrintXY(260,330+20*j,name,FALSE);
   end;
end;

Function at(xx,yy : integer) : boolean;
begin
   if (x+x1=xx) and (y+y1=yy) then at := TRUE else at := FALSE;
end;

Function on(xx,yy : integer) : boolean;
begin
   if (x=xx) and (y=yy) then on := TRUE else on := FALSE;
end;

Procedure originposition;
begin
   x := x - x1;
   y := y - y1;
   Silent_Scroll;
end;

Function wantenter(name : string) : boolean;
var
   k : integer;
begin
   Clear;
   Print(11,name+' A iai sa ?');
   m[0] := '';
   m[1] := ', asa.';
   m[2] := 'a, a gsa.';
   k := Select(100,2,2,FALSE,TRUE);
   if k = 1 then wantenter := TRUE else wantenter := FALSE;
end;

Function wantexit : boolean;
var
   k : integer;
begin
   Clear;
   Print(11,'a aai sa ?');
   m[0] := '';
   m[1] := ', asa.';
   m[2] := 'a, a gsa.';
   k := Select(100,2,2,FALSE,TRUE);
   if k = 1 then wantexit := TRUE else wantexit := FALSE;
end;

Procedure DefaultEnter;
begin
   absolute_set_xy := TRUE;
   with Map_Header do begin
      x := EnterX; y := EnterY;
      mapname := EnterMap;
   end;
   Load;
   Scroll(TRUE);
   absolute_set_xy := FALSE;
   x1 := 0; y1 := 0;
end;

Procedure DefaultExit;
begin
   absolute_set_xy := TRUE;
   with Map_Header do begin
      x := ExitX; y := ExitY;
      mapname := ExitMap;
   end;
   Load;
   Scroll(TRUE);
   absolute_set_xy := FALSE;
   x1 := 0; y1 := 0;
end;

Procedure FindGold(money : longint);
var
   account : string[9];
begin
   Clear;
   str(money,account);
   Print(7,'we q '+account+'i ieЖa.');
   party.gold := party.gold + money;
end;

Procedure setbit(bit : integer);
var
   _byte,_bit : integer;
begin
   _byte := (bit div 8) + 50;
   _bit := bit mod 8;
   party.etc[_byte] := party.etc[_byte] or (1 shl _bit);
end;

Function getbit(bit : integer) : boolean;
var
   _byte,_bit : integer;
begin
   _byte := (bit div 8) + 50;
   _bit := bit mod 8;
   getbit := (party.etc[_byte] and (1 shl _bit)) > 0;
end;

Procedure asyouwish;
begin
   message(7,'w aeae ...');
end;

Procedure notenoughmoney;
begin
   message(7,'we e  sa.');
end;

Procedure thankyou;
begin
   message(7,' ssa.');
end;

Procedure join(num,partynum : byte);
begin
   with player[partynum] do begin
      name := EnemyData[num].name;
      sex := neutral;
      class := 0;
      strength := EnemyData[num].strength;
      mentality := EnemyData[num].mentality;
      concentration := 0;;
      endurance := EnemyData[num].endurance;
      resistance := EnemyData[num].resistance[1] div 2;
      agility := EnemyData[num].agility;
      accuracy := EnemyData[num].accuracy[1];
      luck := 10;
      poison := 0;
      unconscious := 0;
      dead := 0;
      level := EnemyData[num].level;
      hp := endurance * level * 10;
      sp := mentality * level * 10;
      ac := EnemyData[num].ac;
      weapon := 50;
      shield := 6;
      armor := 11;
      wea_power := level * 2 + 10;
      shi_power := 0;
      arm_power := ac;
      experience := 0;
   end;
end;

Procedure joinenemy(num,j : byte);
begin
   with enemy[num] do begin
      E_number := j;
      name := EnemyData[j].name;
      strength := EnemyData[j].strength;
      mentality := EnemyData[j].mentality;
      endurance := EnemyData[j].endurance;
      resistance[1] := EnemyData[j].resistance[1];
      resistance[2] := EnemyData[j].resistance[2];
      agility := EnemyData[j].agility;
      accuracy[1] := EnemyData[j].accuracy[1];
      accuracy[2] := EnemyData[j].accuracy[2];
      ac := EnemyData[j].ac;
      special := EnemyData[j].special;
      castlevel := EnemyData[j].castlevel;
      specialcastlevel := EnemyData[j].specialcastlevel;
      level := EnemyData[j].level;
      aux_hp := 0;
      k := endurance * level;
      while (k > 3000) do begin
         inc(aux_hp);
         k := k - 100;
      end;
      hp := k * 10;
      poison := FALSE; unconscious := FALSE; dead := FALSE;
   end;
end;

Procedure turn_mind(j,enemy_num : byte);
begin
   with enemy[enemy_num] do begin
      E_number := 1;
      name := player[j].name;
      strength := player[j].strength;
      mentality := player[j].mentality;
      endurance := player[j].endurance;
      resistance[1] := player[j].resistance * 5;
      resistance[2] := player[j].resistance * 5;
      if resistance[1] > 99 then resistance[1] := 99;
      if resistance[2] > 99 then resistance[2] := 99;
      agility := player[j].agility;
      accuracy[1] := player[j].accuracy;
      accuracy[2] := player[j].accuracy;
      ac := player[j].ac;
      if player[j].class = 7 then special := 2 else special := 0;
      castlevel := player[j].level div 4;
      specialcastlevel := 0;
      level := player[j].level;
      hp := endurance * level * 10;
      poison := FALSE; unconscious := FALSE; dead := FALSE;
   end;
end;

Function ReturnJoinMember : byte;
var
   i : byte;
begin
   Clear;
   m[0] := 'aA ǩ e a ?';
   for i := 2 to 6 do m[i-1] := player[i].name;
   if m[5] = '' then m[5] := ' a ';
   ReturnJoinMember := select(80,5,5,FALSE,TRUE) + 1;
end;

Procedure Grocery;
begin
   Print(15,'ae aΑ a.');
   Print(15,'yi aa ?');
   m[1] := 'ϩa sa';
   for i := 1 to 5 do begin
      str(i*10,s);
      str(i*100,m[0]);
      m[i+1] := s+'  : q '+m[0]+' ';
   end;
   m[0] := '';
   k := select(95,6,6,FALSE,TRUE);
   if k < 2 then begin
      asyouwish;
      exit;
   end;
   dec(k);
   if party.gold < k * 100 then begin
      notenoughmoney;
      exit;
   end;
   party.gold := party.gold - k * 100;
   k := k * 10;
   if party.food+k > 255 then party.food := 255
   else party.food := party.food + k;
   thankyou;
end;

Procedure Weapon_Shop;
const
   weapon_price : array[1..4,1..7] of longint = (
          (500,3000,5000,7000,12000,40000,70000),
          (500,3000,5000,10000,30000,60000,100000),
          (100,1000,1500,4000,8000,35000,50000),
          (200,300,800,2000,5000,10000,30000));
   shield_price : array[1..5] of longint = (
           3000,15000,45000,80000,150000);
   armor_price : array[1..10] of longint = (
           2000,5000,22000,45000,75000,100000,140000,200000,350000,500000);
var
   i,j,k,h : integer;
label
   first, second, third, fourth;
begin
first:
   Print(15,'ae w񷳓a.');
   Print(15,'ie , ẃ, si isa.');
   Print(15,' Ai aa ?');
   m[0] := '';
   m[1] := 'Ae A';
   m[2] := 'e A';
   m[3] := 'ae A';
   m[4] := 'e A';
   m[5] := 'ẃA';
   m[6] := 'sA';
   h := select(120,6,6,FALSE,TRUE);
   case h of
      0 : begin
             Display_Condition;
             Clear;
             exit;
          end;
      1,2,3,4 : begin
second:
             hany := 15;
             Print(15,' i aa ?');
             for i := 1 to 7 do m[i] := ReturnWeapon((h-1)*7+i);
             for i := 1 to 7 do begin
                str(weapon_price[h,i],s);
                HPrintXY4Select(420,70+(i-1)*16,'q '+s+' ');
             end;
             k := select(70,7,7,FALSE,TRUE);
             if k = 0 then goto first;
             long := weapon_price[h,k];
             if party.gold < long then begin
                notenoughmoney;
                PressAnyKey;
                Clear;
                goto second;
             end;
             if party.BackPack[h,k] < 255 then inc(party.BackPack[h,k]);
             party.gold := party.gold - long;
             Clear;
             goto second;
          end;
      5 : begin
third:
             Print(15,' ẃi aa ?');
             for i := 1 to 5 do begin
                m[i] := ReturnShield(i);
                str(shield_price[i] : 6,s);
                HPrintXY4Select(420,90+(i-1)*16,'q '+s+' ');
             end;
             k := select(90,5,5,FALSE,TRUE);
               if k = 0 then goto first;
               long := shield_price[k];
               if party.gold < long then begin
                  notenoughmoney;
                  PressAnyKey;
                  Clear;
                  goto third;
               end;
               if party.BackPack[h,k] < 255 then inc(party.BackPack[h,k]);
               party.gold := party.gold - long;
               Clear;
               goto third;
            end;
      6 : begin
fourth:
             Print(15,' si aa ?');
             for i := 1 to 10 do begin
                m[i] := ReturnArmor(i);
                str(armor_price[i] : 6,s);
                HPrintXY4Select(420,80+(i-1)*16,'q '+s+' ');
             end;
             k := select(80,10,10,FALSE,TRUE);
               if k = 0 then goto first;
               long := armor_price[k];
               if party.gold < long then begin
                  notenoughmoney;
                  PressAnyKey;
                  Clear;
                  goto fourth;
               end;
               if party.BackPack[h,k] < 255 then inc(party.BackPack[h,k]);
               party.gold := party.gold - long;
               Clear;
               goto fourth;
            end;
   end;
end;

Procedure Train_Center;
const
   enable_class : array[1..7,1..6] of byte = (
               (50,50,50,50,50,50),
               (60,60,50,0,60,50),
               (100,0,0,0,30,30),
               (0,50,50,100,0,60),
               (0,0,0,0,0,100),
               (80,0,60,80,0,70),
               (60,50,50,30,70,50));

 Procedure Display_Skill;
 const
    j = 280;
 begin
    Clear;
    with player[person] do begin
       SetColor(15);
       HPrintXY4Select(j-20,30,name+' e wbá');
       if enable_class[class,1] > 0 then SetColor(11) else SetColor(0);
       str(sword_skill,s);
       HPrintXY4Select(j,50,'Ae   á  : '+s);
       if enable_class[class,2] > 0 then SetColor(11) else SetColor(0);
       str(axe_skill,s);
       if class <> 7 then
          HPrintXY4Select(j,66,'e   á  : '+s)
       else
          HPrintXY4Select(j,66,'áa a  wbá  : '+s);
       if enable_class[class,3] > 0 then SetColor(11) else SetColor(0);
       str(spear_skill,s);
       HPrintXY4Select(j,82,'ae  á : '+s);
       if enable_class[class,4] > 0 then SetColor(11) else SetColor(0);
       str(bow_skill,s);
       HPrintXY4Select(j,98,'e   á  : '+s);
       if enable_class[class,5] > 0 then SetColor(11) else SetColor(0);
       str(shield_skill,s);
       HPrintXY4Select(j,114,'ẃ aw  á  : '+s);
       if enable_class[class,6] > 0 then SetColor(11) else SetColor(0);
       str(fist_skill,s);
       HPrintXY4Select(j,130,' aw  á  : '+s);
       SetColor(10);
       str(experience,s);
       HPrintXY4Select(j-10,150,'a wá : '+s);
    end;
 end;

 Procedure Clear_Part;
 begin
    SetFillStyle(SolidFill,8);
    Bar(260,190,261,191);
    Bar(260,190,610,288);
 end;

var
   i,k : integer;
   j : longint;
label
   continue, _return, break;
begin
   Print(15,' ae a ҅e a.');
   Print(15,' e w e ʁ wi }vae, we ᶂ waA i aa.');
   PressAnyKey;
continue:
   Clear;
   setcolor(15);
   Print(15,'a ҅ei hVsa ?');
   person := ChooseWhom(FALSE);
   Clear;
   if person = 0 then begin
      Display_Condition;
      exit;
   end;
   if player[person].classtype <> sword then begin
      Print(7,' we ʁa i aa.');
      exit;
   end;
   with player[person] do begin
      ok := TRUE;
      for k := 1 to 6 do begin
         case k of
            1 : j := sword_skill;
            2 : j := axe_skill;
            3 : j := spear_skill;
            4 : j := bow_skill;
            5 : j := shield_skill;
            6 : j := fist_skill;
         end;
         if enable_class[class,k] > 0 then begin
            if j < enable_class[class,k] then ok := FALSE;
         end;
      end;
   end;
   if ok then begin
      Clear;
      Print(7,' we e i aЖaa e w');
      Print(7,'ái AI aVsa.');
      with player[person] do begin
         potential_experience := potential_experience + experience;
         experience := 0;
      end;
      exit;
   end;
   m[0] := '';
   m[1] := 'Ae    á';
   m[2] := 'e    á';
   m[3] := 'ae  á';
   m[4] := 'e    á';
   m[5] := 'ẃ  aw  wbá';
   m[6] := '  aw  á';
   if player[person].class = 7 then m[2] := 'áa  a  wbá';
   k := 1;
   with player[person] do
   repeat
      Display_Skill;
_return:
      Clear_Part;
      SetColor(12);
      HPrintXY4Select(260,170,'w e a e i a.');
      k := SelectSub(190,k,6,6,FALSE,FALSE);
      if k = 0 then begin
         ok := TRUE;
         goto break;
      end;
      Clear_Part;
      if enable_class[class,k] = 0 then begin
         Setcolor(7);
         HPrintXY4Select(260,190,'w s x gsa');
         c := readkey;
         if c = #0 then c := readkey;
         goto _return;
      end
      else begin
         case k of
            1 : j := sword_skill;
            2 : j := axe_skill;
            3 : j := spear_skill;
            4 : j := bow_skill;
            5 : j := shield_skill;
            6 : j := fist_skill;
         end;
         if j >= enable_class[class,k] then begin
            Setcolor(7);
            HPrintXY4Select(260,190,' e    sa');
            c := readkey;
            if c = #0 then c := readkey;
            goto _return;
         end;
         long := 15 * j * j;
         if long > experience then begin
            Setcolor(7);
            HPrintXY4Select(260,190,'a wáa asa');
            c := readkey;
            if c = #0 then c := readkey;
            goto _return;
         end;
         experience := experience - long;
         potential_experience := potential_experience + long;
         case k of
            1 : inc(sword_skill);
            2 : inc(axe_skill);
            3 : inc(spear_skill);
            4 : inc(bow_skill);
            5 : inc(shield_skill);
            6 : inc(fist_skill);
         end;
      end;
      ok := FALSE;
break:
   until ok;
   j := 0;
   for i := 1 to 5 do
   if exist(i) then inc(j);
   if j > 1 then goto continue;
   Clear;
end;

Procedure Magic_School;
const
   enable_class : array[1..7,1..6] of byte = (
               (50,30,30,0,50,0),
               (20,50,30,10,50,30),
               (20,20,50,10,50,50),
               (100,60,60,50,100,0),
               (60,70,100,100,100,100),
               (60,100,70,100,100,50),
               (70,100,70,50,100,100));

 Procedure Display_Skill;
 const
    j = 280;
 begin
    Clear;
    with player[person] do begin
       SetColor(15);
       HPrintXY4Select(j-20,30,name+' e wbá');
       if enable_class[class,1] > 0 then SetColor(11) else SetColor(0);
       str(sword_skill,s);
       HPrintXY4Select(j,50,'b a wbá : '+s);
       if enable_class[class,2] > 0 then SetColor(11) else SetColor(0);
       str(axe_skill,s);
       HPrintXY4Select(j,66,'e a wbá : '+s);
       if enable_class[class,3] > 0 then SetColor(11) else SetColor(0);
       str(spear_skill,s);
       HPrintXY4Select(j,82,'áa a wbá : '+s);
       if enable_class[class,4] > 0 then SetColor(11) else SetColor(0);
       str(bow_skill,s);
       HPrintXY4Select(j,98,'b a wbá : '+s);
       if enable_class[class,5] > 0 then SetColor(11) else SetColor(0);
       str(shield_skill,s);
       HPrintXY4Select(j,114,' aeb wbá : '+s);
       if enable_class[class,6] > 0 then SetColor(11) else SetColor(0);
       str(fist_skill,s);
       HPrintXY4Select(j,130,' a wbá : '+s);
       SetColor(10);
       str(experience,s);
       HPrintXY4Select(j-10,150,'a wá : '+s);
    end;
 end;

 Procedure Clear_Part;
 begin
    SetFillStyle(SolidFill,8);
    Bar(260,190,261,191);
    Bar(260,190,610,288);
 end;

var
   i,k : integer;
   j : longint;
label
   continue, _return, break;
begin
   Print(15,' ae a ba a.');
   Print(15,' e w e  wi }vae, we ᶂ waA ai aa.');
   PressAnyKey;
continue:
   Clear;
   setcolor(15);
   Print(15,'a aañi hVsa ?');
   person := ChooseWhom(FALSE);
   Clear;
   if person = 0 then begin
      Display_Condition;
      exit;
   end;
   if player[person].classtype <> magic then begin
      Print(7,' we aa i aa.');
      exit;
   end;
   with player[person] do begin
      ok := TRUE;
      for k := 1 to 6 do begin
         case k of
            1 : j := attack_magic;
            2 : j := pheno_magic;
            3 : j := cure_magic;
            4 : j := special_magic;
            5 : j := esp_magic;
            6 : j := summon_magic;
         end;
         if enable_class[class,k] > 0 then begin
            if j < enable_class[class,k] then ok := FALSE;
         end;
      end;
   end;
   if ok then begin
      Clear;
      Print(7,' we e i aЖaa e w');
      Print(7,'ái AI aVsa.');
      with player[person] do begin
         potential_experience := potential_experience + experience;
         experience := 0;
      end;
      exit;
   end;
   m[0] := '';
   m[1] := 'b a wbá';
   m[2] := 'e a wbá';
   m[3] := 'áa a wbá';
   m[4] := 'b a wbá';
   m[5] := ' aeb wbá';
   m[6] := ' a wbá';
   k := 1;
   with player[person] do
   repeat
      Display_Skill;
_return:
      Clear_Part;
      SetColor(12);
      HPrintXY4Select(260,170,'w  e i a.');
      k := SelectSub(190,k,6,6,FALSE,FALSE);
      if k = 0 then begin
         ok := TRUE;
         goto break;
      end;
      Clear_Part;
      if enable_class[class,k] = 0 then begin
         Setcolor(7);
         HPrintXY4Select(260,190,'w s x gsa');
         c := readkey;
         if c = #0 then c := readkey;
         goto _return;
      end
      else begin
         case k of
            1 : j := attack_magic;
            2 : j := pheno_magic;
            3 : j := cure_magic;
            4 : j := special_magic;
            5 : j := esp_magic;
            6 : j := summon_magic;
         end;
         if j >= enable_class[class,k] then begin
            Setcolor(7);
            HPrintXY4Select(260,190,' e    sa');
            c := readkey;
            if c = #0 then c := readkey;
            goto _return;
         end;
         long := 10 * j * j;
         if long > experience then begin
            Setcolor(7);
            HPrintXY4Select(260,190,'a wáa asa');
            c := readkey;
            if c = #0 then c := readkey;
            goto _return;
         end;
         experience := experience - long;
         potential_experience := potential_experience + long;
         case k of
            1 : inc(attack_magic);
            2 : inc(pheno_magic);
            3 : inc(cure_magic);
            4 : inc(special_magic);
            5 : inc(esp_magic);
            6 : inc(summon_magic);
         end;
      end;
      ok := FALSE;
break:
   until ok;
   j := 0;
   for i := 1 to 5 do
   if exist(i) then inc(j);
   if j > 1 then goto continue;
   Clear;
end;

Procedure Change_Job_for_Sword;
const
   classdata : array[1..7] of string[10] = (
                  'ʁa','a','a','a',
                  'ʁw','qia','a');
   enable_class : array[1..7,1..6] of byte = (
               (10,10,10,10,10,0),
               (10,10,5,0,20,0),
               (40,0,0,0,0,0),
               (0,5,5,40,0,0),
               (0,0,0,0,0,40),
               (10,0,0,10,0,20),
               (25,0,5,0,20,10));
var
   i,j,k : integer;
   enable : array[1..7] of boolean;
begin
   Print(15,' ae a ҅e a.');
   Print(15,' e w eae  sa a a sa.');
   PressAnyKey;
   Clear;
   if party.gold < 10000 then begin
      Print(7,' aa ЗAAe  i a ae w');
      Print(7,' q 10000 a sa.');
      PressAnyKey;
      exit;
   end;
   setcolor(15);
   Print(15,'a ʁa i i aVsa ?');
   person := ChooseWhom(FALSE);
   Clear;
   if person = 0 then begin
      Display_Condition;
      exit;
   end;
   if player[person].classtype <> sword then begin
      Print(7,' we ʁa i aa.');
      exit;
   end;
   Clear;
   with player[person] do begin
      SetColor(15);
      HPrintXY4Select(260,30,name+' awe s');
      j := 80;
      for i := 1 to 7 do begin
         ok := TRUE;
         if enable_class[i,1] > sword_skill then ok := FALSE;
         if enable_class[i,2] > axe_skill then ok := FALSE;
         if enable_class[i,3] > spear_skill then ok := FALSE;
         if enable_class[i,4] > bow_skill then ok := FALSE;
         if enable_class[i,5] > shield_skill then ok := FALSE;
         if enable_class[i,6] > fist_skill then ok := FALSE;
         if ok then begin
            SetColor(11);
            enable[i] := TRUE;
         end
         else begin
            SetColor(0);
            enable[i] := FALSE;
         end;
         HPrintXY4Select(280,j,classdata[i]);
         j := j + 16;
      end;
      m[0] := '';
      for i := 1 to 7 do m[i] := '                 '+classdata[i];
      SetColor(12);
      HPrintXY4Select(260,220,'w aቡ e si a.');
      SetColor(15);
      HPrintXY4Select(260,236,'w : q 10000 ');
      k := SelectSub(80,class,7,7,FALSE,TRUE);
      if k > 0 then begin
         if enable[k] then begin
            if class <> k then begin
               class := k;
               Print(10,name+ReturnSJosa(name)+' A '+classdata[k]+' s Aa.');
               if class < 7 then sp := 0;
               Modify_Item(person);
               party.gold := party.gold - 10000;
               DisplaySP;
            end;
         end
         else
            Print(7,' se a aw sa.');
      end;
   end;
end;

Procedure Change_Job_for_Magic;
const
   classdata : array[1..7] of string[10] = (
                  'A','a','a','a',
                  'wwa','aa','a');
   enable_class : array[1..7,1..6] of byte = (
               (10,10,10,0,0,0),
               (0,10,10,0,0,10),
               (0,0,10,0,0,10),
               (40,25,25,0,0,0),
               (20,20,40,0,0,40),
               (10,40,30,0,0,20),
               (40,40,40,20,20,20));
var
   i,j,k : integer;
   enable : array[1..7] of boolean;
begin
   Print(15,' ae a ba a.');
   Print(15,' e w eae  sa a a sa.');
   PressAnyKey;
   Clear;
   if party.gold < 10000 then begin
      Print(7,' aa ЗAAe  i a ae w');
      Print(7,' q 10000 a sa.');
      PressAnyKey;
      exit;
   end;
   setcolor(15);
   Print(15,'a aa i i aVsa ?');
   person := ChooseWhom(FALSE);
   Clear;
   if person = 0 then begin
      Display_Condition;
      exit;
   end;
   if player[person].classtype <> magic then begin
      Print(7,' we aa i aa.');
      exit;
   end;
   Clear;
   with player[person] do begin
      SetColor(15);
      HPrintXY4Select(260,30,name+' awe s');
      j := 80;
      for i := 1 to 7 do begin
         ok := TRUE;
         if enable_class[i,1] > attack_magic then ok := FALSE;
         if enable_class[i,2] > pheno_magic then ok := FALSE;
         if enable_class[i,3] > cure_magic then ok := FALSE;
         if enable_class[i,4] > special_magic then ok := FALSE;
         if enable_class[i,5] > esp_magic then ok := FALSE;
         if enable_class[i,6] > summon_magic then ok := FALSE;
         if ok then begin
            SetColor(11);
            enable[i] := TRUE;
         end
         else begin
            SetColor(0);
            enable[i] := FALSE;
         end;
         HPrintXY4Select(280,j,classdata[i]);
         j := j + 16;
      end;
      m[0] := '';
      for i := 1 to 7 do m[i] := '                 '+classdata[i];
      SetColor(12);
      HPrintXY4Select(260,220,'w aቡ e si a.');
      SetColor(15);
      HPrintXY4Select(260,236,'w : q 10000 ');
      k := SelectSub(80,class,7,7,FALSE,TRUE);
      if k > 0 then begin
         if enable[k] then begin
            if class <> k then begin
               class := k;
               Print(10,name+ReturnSJosa(name)+' A '+classdata[k]+' s Aa.');
               Modify_Item(person);
               party.gold := party.gold - 10000;
            end;
         end
         else
            Print(7,' se a aw sa.');
      end;
   end;
end;

Procedure About_Class;
begin
   m[0] := ' i aa ?';
   m[1] := 'ʁa i i sb';
   m[2] := 'aa i wbi sb';
   m[3] := 'ʁa i si a';
   m[4] := 'aa i si a';
   k := Select(80,4,4,TRUE,TRUE);
   case k of
      1 : Train_Center;
      2 : Magic_School;
      3 : Change_Job_for_Sword;
      4 : Change_Job_for_Magic;
   end;
end;

Procedure Sell_EXP;
var
   i,k : longint;
label
   continue;
begin
   m[0] := '';
   for i := 1 to 10 do begin
      str(i*10000 : 6,s);
      m[i] := 'q '+s+' ; ae : ';
      str(i : 2,s);
      m[i] := m[i] + s + ' e';
   end;
continue:
   Clear;
   Print(15,' aAe ׋q eq  ҅ei a w');
   Print(15,'ái a e a.');
   Print(11,' ae qi a.');
   k := Select(120,10,10,FALSE,TRUE);
   if k = 0 then exit;
   if party.gold < k*10000 then begin
      Print(7,' Зe e q a.');
      PressAnyKey;
      goto continue;
   end;
   str(k : 2,s);
   Print(15,' Зe '+s+' ee ҅ei hA Aa.');
   party.gold := party.gold - k*10000;
   for i := 1 to 5 do
   if exist(i) then player[i].experience := player[i].experience + k*10000;
   party.min := 0;
   ok := TRUE;
   with party do
   repeat
      min := min + 20;
      if min > 59 then begin
         hour := hour + 1;
         k := k - 1;
         min := 0;
      end;
      if hour > 23 then begin
         day := day + 1;
         hour := 0;
      end;
      if day > 359 then begin
         year := year + 1;
         day := 0;
      end;
      if KeyPressed then ok := FALSE;
      if ok then begin
         delay(500);
         if KeyPressed then ok := FALSE;
         Scroll(TRUE);
      end;
   until k <= 0;
   Scroll(TRUE);
   Print(7,'');
   Print(7,' Зe ҅ei { ava.');
   while KeyPressed do c := readkey;
end;

Procedure Hospital;
var
   i,j,k : integer;
label
   first,second;
begin
   Print(15,'ae wa.');
   PressAnyKey;
first:
   Print(15,'a áai hVsa ?');
   k := choosewhom(FALSE);
   if k = 0 then begin
      Display_Condition;
      Clear;
      exit;
   end;
second:
   m[0] := ' áaa ?';
   m[1] := 'wi áa';
   m[2] := 'i A';
   m[3] := ' A';
   m[4] := '';
   j := select(70,4,4,FALSE,TRUE);
   if j = 0 then begin
      Clear;
      j := 0;
      for i := 1 to 5 do
      if player[i].name <> '' then inc(j);
      if j > 1 then goto first;
      exit;
   end;
   case j of
      1 : with player[k] do begin
             if dead > 0 then
                Print(7,name+ReturnSJosa(name)+'  e wȁa')
             else if unconscious > 0 then
                Print(7,name+ReturnSJosa(name)+'  wa')
             else if poison > 0 then
                Print(7,name+ReturnSJosa(name)+'  ụ wȁa')
             else if hp >= endurance*level*10 then
                Print(15,name+ReturnSJosa(name)+' áai ϩaa sa');
             if (dead>0) or (unconscious>0) or (poison>0) or
                (hp>=endurance*level*10) then begin
                PressAnyKey;
                goto second;
             end;
             i := endurance * level * 10 - hp;
             i := round(i * (level / 10)) + 1;
             if party.gold < i then begin
                notenoughmoney;
                PressAnyKey;
                goto second;
             end;
             party.gold := party.gold - i;
             hp := endurance * level * 10;
             if sex = male then s := ' a' else s := ' aa';
             Print(15,name+ReturnSJosa(name)+s+' e w AAa');
             displayHP;
             PressAnyKey;
             j := 0;
             for i := 1 to 5 do
             if player[i].name <> '' then inc(j);
             if j > 1 then goto first;
          end;
      2 : with player[k] do begin
             if dead > 0 then
                Print(7,name+ReturnSJosa(name)+'  e wȁa')
             else if unconscious > 0 then
                Print(7,name+ReturnSJosa(name)+'  wa')
             else if poison = 0 then
                Print(15,name+ReturnSJosa(name)+' A 韡 gvsa');
             if (dead>0) or (unconscious>0) or (poison=0) then begin
                PressAnyKey;
                goto second;
             end;
             i := level * 10;
             if party.gold < i then begin
                notenoughmoney;
                PressAnyKey;
                goto second;
             end;
             party.gold := party.gold - i;
             poison := 0;
             Print(15,name+ReturnSJosa(name)+'  A Asa');
             displaycondition;
             PressAnyKey;
             j := 0;
             for i := 1 to 5 do
             if player[i].name <> '' then inc(j);
             if j > 1 then goto first;
          end;
      3 : with player[k] do begin
             if dead > 0 then Print(7,name+ReturnSJosa(name)+'  e wȁa')
             else if unconscious = 0 then Print(15,name+ReturnSJosa(name)+' w aa');
             if (dead>0) or (unconscious=0) then begin
                PressAnyKey;
                goto second;
             end;
             i := unconscious * 2;
             if party.gold < i then begin
                notenoughmoney;
                PressAnyKey;
                goto second;
             end;
             party.gold := party.gold - i;
             unconscious := 0;
             hp := 1;
             Print(15,name+ReturnSJosa(name)+' i avsa');
             displaycondition;
             displayHP;
             PressAnyKey;
             j := 0;
             for i := 1 to 5 do
             if player[i].name <> '' then inc(j);
             if j > 1 then goto first;
          end;
      4 : with player[k] do begin
             if dead = 0 then begin
                Print(15,name+ReturnSJosa(name)+'  gvsa');
                PressAnyKey;
                goto second;
             end;
             i := dead * 100 + 400;
             if party.gold < i then begin
                notenoughmoney;
                PressAnyKey;
                goto second;
             end;
             party.gold := party.gold - i;
             dead := 0;
             if unconscious > endurance * level then
                unconscious := endurance * level;
             Print(15,name+ReturnSJosa(name)+' a iavsa');
             displaycondition;
             PressAnyKey;
             j := 0;
             for i := 1 to 5 do
             if player[i].name <> '' then inc(j);
             if j > 1 then goto first;
          end;
   end;
end;

Procedure Medicine;
const
   data : array[1..5] of string[12] = (
          'Ab A','a A','Ё ',
          ' ','ɷ ');
   pricedata : array[1..5] of longint = (
               2000,3000,1000,5000,10000);
var
   i,j,k : integer;
label
   continue;
begin
   Clear;
continue:
   Print(15,' ae i ae a.');
   Print(7,'');
   Print(15,' w a e a i a.');
   m[0] := '';
   for i := 1 to 5 do m[i] := data[i];
   k := select(116,5,5,FALSE,TRUE);
   if k = 0 then exit;
   Print(15,' i  a.');
   for i := 1 to 10 do begin
      str(i : 2,s);
      m[i] := data[k] + '  '+s+' : ';
      str(pricedata[k]*i,s);
      m[i] := m[i]+'q '+s+' ';
   end;
   j := select(100,10,10,FALSE,TRUE);
   if j = 0 then goto continue;
   long := pricedata[k] * j;
   if party.gold < long then begin
      Print(7,' wAAe  i i  sa.');
      PressAnyKey;
      goto continue;
   end;
   party.gold := party.gold - long;
   if party.item[k] + j < 256 then party.item[k] := party.item[k] + j
   else party.item[k] := 255;
   goto continue;
end;

Procedure Sell_Item;
const
   data : array[1..6] of string[10] = (
          'i',' ','w ',
          ' i','З a',' i');
   pricedata : array[1..6] of longint = (
               500,4000,300,500,1000,5000);
var
   i,j,k : integer;
label
   continue;
begin
   Clear;
continue:
   Print(15,' ae aa Αi ae a.');
   Print(7,'');
   Print(15,' w a e i a.');
   m[0] := '';
   for i := 1 to 6 do m[i] := data[i];
   k := select(116,6,6,FALSE,TRUE);
   if k = 0 then exit;
   Print(15,' i  a.');
   for i := 1 to 10 do begin
      if k = 1 then
         str(i*10 : 2,s)
      else
         str(i : 2,s);
      m[i] := data[k] + '  '+s+' : ';
      str(pricedata[k]*i,s);
      m[i] := m[i]+'q '+s+' ';
   end;
   j := select(100,10,10,FALSE,TRUE);
   if j = 0 then goto continue;
   long := pricedata[k] * j;
   if party.gold < long then begin
      Print(7,' wAAe  i i  sa.');
      PressAnyKey;
      goto continue;
   end;
   party.gold := party.gold - long;
   if k = 1 then begin
      if party.arrow + j*10 > 0 then party.arrow := party.arrow + j*10
      else party.arrow := 32767;
   end
   else begin
      if party.item[k+4] + j < 256 then party.item[k+4] := party.item[k+4] + j
      else party.item[k+4] := 255;
   end;
   goto continue;
end;

Procedure Load;

 Procedure ErrorMessage(s : string; need : boolean);
 begin
    asm
       mov ah,0
       mov al,3
       int $10
    end;
    TextAttr := $07;
    ClrScr;
    TextColor(12);
    Writeln('"'+s+'" not found.');
    TextColor(7);
    if need then Writeln('You need to CREATE CHARACTER.');
    Halt;
 end;

 Procedure Edit_Error;
 begin
    if AdLibOn then PlayOff;
    UnSound;
    asm
       mov ah,0
       mov al,3
       int $10
    end;
    TextAttr := $07;
    ClrScr;
    TextColor(12);
    Writeln('Editing is not all wed !!');
    Halt;
 end;

 Procedure Load_Font(font_name : string);
 begin
    Assign(fontname,font_name+'.fnt');
    Reset(fontname);
    read(fontname,chara^);
    Close(fontname);
    if IOResult <> 0 then ErrorMessage(font_name+'.fnt',false);
 end;

 Procedure Verify_LoadGame;
 begin
 end;

var
   i,j,k : integer;
   r,g,b : byte;
begin
   if not LoadFont then begin
      {$I-}
      if Loading_SaveGame then begin
         Assign(playerfile,'player'+LoadNo+'.dat');
         Reset(playerfile,1);
         blockread(playerfile,party,sizeof(party));
         blockread(playerfile,player,sizeof(player));
         Close(playerfile);
         if IOResult <> 0 then ErrorMessage('player'+LoadNo+'.dat',true);
{         Verify_LoadGame;}
      end;
      Load_Font('chara');
      {$I+}
   end;
   existfile := fsearch('save'+LoadNo+'.m','');
   if (existfile = '') or (LoadFont) or (not Loading_SaveGame) then begin
      s := mapname;
      {$I-}
      Assign(f,s+'.m');
      Reset(f,1);
      BlockRead(f,Map_Header,sizeof(Map_Header));
      for j:=1 to Map_Header.ymax do
      for i:=1 to Map_Header.xmax do BlockRead(f,map^[i,j],1);
      Close(f);
      if IOResult <> 0 then ErrorMessage(s+'.m',FALSE);
      {$I+}
      if not absolute_set_xy then
      with Map_Header do
      if ((startX <> 255) or (startY <> 255)) and (Map_Header.Tile_Type <> ground) then begin
         x := startX; y := startY;
      end;
   end
   else begin
      Assign(f,'save'+LoadNo+'.m');
      Reset(f,1);
      BlockRead(f,Map_Header,sizeof(Map_Header));
      BlockRead(f,map^,sizeof(map^));
      Close(f);
      with Map_Header do begin
         x := startX; y := startY; mapname := ID;
      end;
   end;
   Loading_SaveGame := TRUE;
   position := Map_Header.Tile_Type;
   QuitPlay := TRUE;
   case position of
      town : begin
                s := 'town';
                ExistFile := 'Music2.Bgm';
             end;
      ground : begin
                  s := 'ground';
                  ExistFile := 'Music3.Bgm';
               end;
      den : begin
               s := 'den';
               ExistFile := 'Music4.Bgm';
            end;
      keep : begin
                s := 'keep';
                ExistFile := 'Music5.Bgm';
             end;
   end;
   {$I-}
   Assign(fontname,s+'.fnt');
   Reset(fontname);
   read(fontname,font^);
   Close(fontname);
   if IOResult <> 0 then ErrorMessage(s+'.fnt',false);
   for i := 5 to 294 do font^[55,i] := 0;

   { Special Font Loading }
   if mapname = 'OrcTown' then begin
      Load_Font('decorate');
      for i := 5 to 294 do begin
         Font^[53,i] := (Font^[43,i] and chara^[9,i]) or chara^[8,i];
         Font^[54,i] := (Font^[43,i] and chara^[11,i]) or chara^[10,i];
         Font^[34,i] := (Font^[43,i] and chara^[13,i]) or chara^[12,i];
      end;
      Load_Font('chara');
   end;
   if mapname = 'Ground3' then begin
      move(Font^[13],Font^[21],sizeof(Font^[12]));
   end;
   if mapname = 'Vesper' then begin
      Load_Font('decorate');
      for i := 5 to 294 do begin
         Font^[53,i] := (Font^[43,i] and chara^[15,i]) or chara^[14,i];
         Font^[54,i] := (Font^[44,i] and chara^[13,i]) or chara^[12,i];
      end;
      Load_Font('chara');
   end;
   if mapname = 'TrolTown' then begin
      Load_Font('decorate');
      for i := 5 to 294 do begin
         Font^[53,i] := (Font^[44,i] and chara^[17,i]) or chara^[16,i];
         Font^[54,i] := (Font^[44,i] and chara^[15,i]) or chara^[14,i];
      end;
      Load_Font('chara');
   end;
   if mapname = 'Ground4' then begin
      move(Font^[14],Font^[52],sizeof(Font^[14]));
      move(Font^[15],Font^[54],sizeof(Font^[15]));
   end;
   if mapname = 'Kobold' then begin
      Load_Font('ground');
      move(chara^[18],Font^[35],sizeof(Font^[22]));
      move(Font^[48],Font^[52],sizeof(Font^[48]));
      Load_Font('chara');
   end;
   if mapname = 'Ancient' then begin
      Load_Font('decorate');
      for i := 5 to 294 do begin
         Font^[53,i] := (Font^[44,i] and chara^[21,i]) or chara^[20,i];
      end;
      Load_Font('ground');
      move(chara^[13],Font^[22],sizeof(Font^[22]));
      move(chara^[16],Font^[ 3],sizeof(Font^[ 3]));
      move(chara^[17],Font^[ 4],sizeof(Font^[ 4]));
      Load_Font('chara');
   end;
   if mapname = 'Hut' then begin
      Load_Font('decorate');
      for i := 5 to 294 do begin
         Font^[53,i] := (Font^[44,i] and chara^[17,i]) or chara^[16,i];
      end;
      Load_Font('chara');
   end;
   if mapname = 'DracTown' then begin
      Load_Font('decorate');
      for i := 5 to 294 do begin
         Font^[53,i] := (Font^[44,i] and chara^[19,i]) or chara^[18,i];
         Font^[52,i] := (Font^[44,i] and chara^[23,i]) or chara^[22,i];
         Font^[49,i] := (Font^[44,i] and chara^[21,i]) or chara^[20,i];
      end;
      Load_Font('ground');
      move(chara^[16],Font^[ 8],sizeof(Font^[ 8]));
      move(chara^[17],Font^[ 9],sizeof(Font^[ 9]));
      move(chara^[19],Font^[14],sizeof(Font^[14]));
      Load_Font('chara');
      move(Font^[24],Font^[19],sizeof(Font^[14]));
   end;
   if mapname = 'Tomb' then begin
      Load_Font('ground');
      move(chara^[16],Font^[37],sizeof(Font^[37]));
      move(chara^[17],Font^[38],sizeof(Font^[38]));
      move(chara^[14],Font^[54],sizeof(Font^[54]));
      Load_Font('town');
      move(chara^[48],Font^[53],sizeof(Font^[53]));
      Load_Font('chara');
   end;
   if mapname = 'Light' then begin
      Load_Font('decorate');
      for i := 5 to 294 do begin
         Font^[53,i] := (Font^[42,i] and chara^[25,i]) or chara^[24,i];
      end;
      Load_Font('chara');
   end;
   if mapname = 'Dome' then begin
      Load_Font('decorate');
      for i := 5 to 294 do begin
         Font^[54,i] := (Font^[35,i] and chara^[25,i]) or chara^[24,i];
      end;
      Load_Font('chara');
   end;



   Assign(filename,s+'.pal');
   Reset(filename);
   for i := 0 to 15 do begin
      read(filename,r);
      read(filename,g);
      read(filename,b);
      setpalette(i,i);
      RGB(i,r,g,b);
   end;
   Close(filename);
   if IOResult <> 0 then ErrorMessage(s+'.pal',false);
   {$I+}

   LoadFont := TRUE;
   move(font^[Map_Header.default],font^[0],294);
   if Map_Header.ymax div 2 > y then face := 4 else face := 5;

   if player[1].classtype = magic then begin
      inc(face,4);
   end;
   if player[1].classtype = sword then begin
      if position = town then dec(face,4);
      if mapname = 'Menace' then dec(face,4); { Special Case }
   end;
   if not (encounter^ in [1..3]) then encounter^ := 2;
   if not (maxenemy^ in [3..7]) then maxenemy^ := 5;
   case party.etc[12] of
      1 : setscrolltype(snow);
      2 : setscrolltype(rain);
      3 : setscrolltype(autumn);
      4 : setscrolltype(wilderness);
      5 : setscrolltype(strongrain)
      else setscrolltype(normal);
   end;
   Clear_View_Screen;
end;

Procedure Save;

 Procedure Modify_SaveGame;
 begin
 end;

begin
   Map_Header.startX := x;
   Map_Header.startY := y;
   Modify_SaveGame;
   Assign(playerfile,'player'+LoadNo+'.dat');
   Rewrite(playerfile,1);
   blockwrite(playerfile,party,sizeof(party));
   blockwrite(playerfile,player,sizeof(player));
   Close(playerfile);
   Assign(f,'save'+LoadNo+'.m');
   Rewrite(f,1);
   blockwrite(f,Map_Header,sizeof(Map_Header));
   blockwrite(f,map^,sizeof(map^));
   Close(f);
end;

Procedure Set_All;
begin
   Randomize;
   encounter := @party.etc[7];
   maxenemy := @party.etc[8];
   soundon := TRUE;
   Cruel := TRUE;
   LoadFont := FALSE;
   _IMAGE_DIRECTION := _DIRECT;
   LoadNo := '1';
   Rest_Time := 6;

   SetFillStyle(SolidFill,DarkGray);
   Bar(0,0,620,479);

   {$I-}

   Assign(fontname,'Decorate.fnt');
   Reset(fontname);
   read(fontname,font^);
   Close(fontname);
   if IOResult = 0 then begin
      Image(0,0,Font^[3],FALSE);
      for i := 1 to 24 do Image(i,0,Font^[5],FALSE);
      Image(25,0,Font^[4],FALSE);
      for i := 1 to 19 do begin
         Image( 0,i,Font^[6],FALSE);
         Image(25,i,Font^[7],FALSE);
      end;
   end;

   {$I+}

   Load;

   { Initial Condition }

   with party do
   if (year = 673) and (day = 326) and (hour = 16) and (min = 0) then begin
      x := 27; y := 29;
      PutMap(24,34,43); PutMap(35,41,43); PutMap(15,36,43); PutMap(27,26,43);
      PutMap(27,32,21);
      Clear;
      Print(7,' ae  B Aa q.');
      Print(7,' e 673e 11 27 ҁva.');
      party.etc[1] := 4;
   end;

   Scroll(TRUE);
   SetLineStyle(SolidLn,0,ThickWidth);
   SetColor(White);
   Line(24*10+1,24*1-1,24*10+1,24*12+1);
   SetColor(LightGray);
   Line(24*1-1,24*12+1,24*10+1,24*12+1);
   SetLineStyle(SolidLn,0,NormWidth);
   SetColor(11);
   bHPrint(260,313,'  q           wb   ab       w ȁ');
   Display_Condition;
   SetScrollType(normal);
   SetTextStyle(0,0,1);
end;

Procedure UnSound;
begin
   ExistFile := FSearch('End.cmd','');
   if ExistFile <> '' then begin
      Assign(FileName,'End.cmd');
      Rename(FileName,'End.com');
      exec(getenv('COMSPEC'),'/cEnd.com');
      Rename(FileName,'End.cmd');
   end;
end;

end.