#include <stdio.h>
#include <math.h>
#include <sys\timeb.h>
#include <string.h>
/*--------------------------------------------------*/
#define word unsigned
#define byte unsigned char
#define Sin(th) s[th+2000]
#define Cos(th) s[th+6000]
#define         DAC_READ_INDEX  0x03c7
#define         DAC_WRITE_INDEX 0x03c8
#define         DAC_DATA                0x03c9


#define BYTE    unsigned char

#define BOOL    int
#define TRUE    1
#define FALSE   0


#define PCX_IMAGE_WIDTH         320
#define PCX_IMAGE_HEIGHT        128
#define PCX_BYTES_PER_LINE      128

float s[8000*4];
int winl, winr, winu, winb;
byte vp[64000];

struct face{
	long X,Y,Z; 			 // Coordinate of Center of the Obj
	int DX,DY;
	float Direction[3][3];
	byte *im;
	};

int screen=200;

void initTRI(void)
{
	int i;

	for (i=0;i<4000;i++)
	{
		s[i] = sin(3.1415926535*(i-2000)/18000);
	}
	for (i=4000;i<8000;i++)
	{
		s[i] = cos(3.1415926535*(i-6000)/18000);
	}
}

BOOL LoadPCX_Pallete(char *filename, BYTE *pallete)
{

	FILE *fp;
	int  i;

	if ((fp=fopen(filename, "rb"))==NULL)  return(FALSE);

	if (fseek(fp, -768L, SEEK_END))  {
		fclose(fp);
		return(FALSE);
	}

	fread(pallete, 768, sizeof(BYTE), fp);
	for(i=0; i<768; i++)  pallete[i]>>=2;

	fclose(fp);
	return(TRUE);
}

/*
	pcx  A Datai ea
*/
void DecompressPCX_Image(FILE *fp, BYTE *image)
{
	BYTE c;
	register int  n, i;

	n=0;

	while(n<PCX_BYTES_PER_LINE)  {
		fread(&c, 1, sizeof(BYTE), fp);
		if ((c & 0xc0)==0xc0)  {
			i=c & 0x3f;
			fread(&c, 1, sizeof(BYTE), fp);
			while(i--)  image[n++]=c;
		}
		else  image[n++]=c;
	}
}
BOOL LoadPCX_Image(char *filename, BYTE *image)
{
	FILE *fp;
	int x, y;

	if ((fp=fopen(filename, "rb"))==NULL)  return(FALSE);

	fseek(fp, 128L, SEEK_SET);

	for(y=0; y<PCX_IMAGE_HEIGHT; y++)  {

		DecompressPCX_Image(fp, &image[y*PCX_BYTES_PER_LINE]);
	}
	fclose(fp);
	return(TRUE);
}


/*
	pcx s(RLE method)i ЁAea
*/




/*
	RGB ti ea
*/

void SetRGB(BYTE *rgb)
{
	int  i;

	outp(DAC_WRITE_INDEX, 0);

	for(i=0; i<768; i++)  outp(DAC_DATA, rgb[i]);
}


/*
	PCX i   A  ea
*/

/*
	pcx s(RLE method)i ЁAea
*/

void yow(struct face *obj,int al)
{
	float b[3][3];
	int i;

	b[0][0] = (Cos(al) * (*obj).Direction[0][0] +
		  Sin(al) * (*obj).Direction[0][2]);
	b[0][2] = (Cos(al) * (*obj).Direction[0][2] -
		  Sin(al) * (*obj).Direction[0][0]);
	b[1][0] = (Cos(al) * (*obj).Direction[1][0] +
		  Sin(al) * (*obj).Direction[1][2]);
	b[1][2] = (Cos(al) * (*obj).Direction[1][2] -
		  Sin(al) * (*obj).Direction[1][0]);
	b[2][0] = (Cos(al) * (*obj).Direction[2][0] +
		  Sin(al) * (*obj).Direction[2][2]);
	b[2][2] = (Cos(al) * (*obj).Direction[2][2] -
		  Sin(al) * (*obj).Direction[2][0]);
	for (i=0;i<3;i++)
	{
		(*obj).Direction[i][0] = b[i][0];
		(*obj).Direction[i][2] = b[i][2];
	}
}
void pitch(struct face *obj, int al)
{
	float b[3][3];
	int i;

	b[0][1] = (Cos(al) * (*obj).Direction[0][1] -
		  Sin(al) * (*obj).Direction[0][2]);
	b[0][2] = (Cos(al) * (*obj).Direction[0][2] +
		  Sin(al) * (*obj).Direction[0][1]);
	b[1][1] = (Cos(al) * (*obj).Direction[1][1] -
		  Sin(al) * (*obj).Direction[1][2]);
	b[1][2] = (Cos(al) * (*obj).Direction[1][2] +
		  Sin(al) * (*obj).Direction[1][1]);
	b[2][1] = (Cos(al) * (*obj).Direction[2][1] -
		  Sin(al) * (*obj).Direction[2][2]);
	b[2][2] = (Cos(al) * (*obj).Direction[2][2] +
		  Sin(al) * (*obj).Direction[2][1]);
	for (i=0;i<3;i++)
	{
		(*obj).Direction[i][1] = b[i][1];
		(*obj).Direction[i][2] = b[i][2];
	}
}
void roll(struct face *obj, int al)
{
	float b[3][3];
	int i;

	b[0][0] = (Cos(al) * (*obj).Direction[0][0] -
		  Sin(al) * (*obj).Direction[0][1]);
	b[0][1] = (Cos(al) * (*obj).Direction[0][1] +
		  Sin(al) * (*obj).Direction[0][0]);
	b[1][0] = (Cos(al) * (*obj).Direction[1][0] -
		  Sin(al) * (*obj).Direction[1][1]);
	b[1][1] = (Cos(al) * (*obj).Direction[1][1] +
		  Sin(al) * (*obj).Direction[1][0]);
	b[2][0] = (Cos(al) * (*obj).Direction[2][0] -
		  Sin(al) * (*obj).Direction[2][1]);
	b[2][1] = (Cos(al) * (*obj).Direction[2][1] +
		  Sin(al) * (*obj).Direction[2][0]);
	for (i=0;i<3;i++)
	{
		(*obj).Direction[i][0] = b[i][0];
		(*obj).Direction[i][1] = b[i][1];
	}
}
void inverse(float a[][3], float b[][3])
{
	b[0][0] = (a[1][1] * a[2][2] - a[2][1] * a[1][2]);
	b[0][1] = (a[2][1] * a[0][2] - a[0][1] * a[2][2]);
	b[0][2] = (a[0][1] * a[1][2] - a[1][1] * a[0][2]);
	b[1][0] = (a[2][0] * a[1][2] - a[1][0] * a[2][2]);
	b[1][1] = (a[0][0] * a[2][2] - a[2][0] * a[0][2]);
	b[1][2] = (a[1][0] * a[0][2] - a[0][0] * a[1][2]);
	b[2][0] = (a[1][0] * a[2][1] - a[2][0] * a[1][1]);
	b[2][1] = (a[2][0] * a[0][1] - a[0][0] * a[2][1]);
	b[2][2] = (a[0][0] * a[1][1] - a[1][0] * a[0][1]);
}
void inverse1(float a[][3], float b[][3])
{
	float d;

	d = a[0][1]*a[1][2] - a[0][2]*a[1][1] +
	    a[0][2]*a[1][0] - a[0][0]*a[1][2] +
	    a[0][0]*a[1][1] - a[0][1]*a[1][0];
	b[0][0] = (a[1][1] * a[2][2] - a[2][1] * a[1][2])/d;
	b[0][1] = (a[2][1] * a[0][2] - a[0][1] * a[2][2])/d;
	b[0][2] = (a[0][1] * a[1][2] - a[1][1] * a[0][2])/d;
	b[1][0] = (a[2][0] * a[1][2] - a[1][0] * a[2][2])/d;
	b[1][1] = (a[0][0] * a[2][2] - a[2][0] * a[0][2])/d;
	b[1][2] = (a[1][0] * a[0][2] - a[0][0] * a[1][2])/d;
	b[2][0] = (a[1][0] * a[2][1] - a[2][0] * a[1][1])/d;
	b[2][1] = (a[2][0] * a[0][1] - a[0][0] * a[2][1])/d;
	b[2][2] = (a[0][0] * a[1][1] - a[1][0] * a[0][1])/d;
}



float obsv[3][3]={1,0,0,
		 0,1,0,
		 0,0,1};
/*void tx_mapping(struct face *obj)
{
	int dx,dy,sx,sy;
	long sdx,sdy;
	int i=0,n=1,j;
	long B=0,K1,K2,K3=0,K4,K5,K6,K7;
	long DX,DY,DZ,X,Y,Z;
	long a1,a2,a3;
	char far *ipt;

	a1 = (obsv[0][0]*(obj->Direction)[0][0] + obsv[0][1]*(obj->Direction)[1][0] + obsv[0][2]*(obj->Direction)[2][0]) >>7;
	a2 = (obsv[1][0]*(obj->Direction)[0][0] + obsv[1][1]*(obj->Direction)[1][0] + obsv[1][2]*(obj->Direction)[2][0]) >>7;
	a3 = (obsv[2][0]*(obj->Direction)[0][0] + obsv[2][1]*(obj->Direction)[1][0] + obsv[2][2]*(obj->Direction)[2][0]) >>7;
	DX = (obsv[0][0]*(obj->Direction)[0][1] + obsv[0][1]*(obj->Direction)[1][1] + obsv[0][2]*(obj->Direction)[2][1]) >>7;
	DY = (obsv[1][0]*(obj->Direction)[0][1] + obsv[1][1]*(obj->Direction)[1][1] + obsv[1][2]*(obj->Direction)[2][1]) >>7;
	DZ = (obsv[2][0]*(obj->Direction)[0][1] + obsv[2][1]*(obj->Direction)[1][1] + obsv[2][2]*(obj->Direction)[2][1]) >>7;
	X = (obsv[0][0] + obsv[0][1] + obsv[0][2]) * (obj->X);
	Y = (obsv[1][0] + obsv[1][1] + obsv[1][2]) * (obj->Y);
	Z = (obsv[2][0] + obsv[2][1] + obsv[2][2]) * (obj->Z);

	sdx = Z * DX - X * DZ;
	sdy = Z * DY - Y * DZ;
	if (sdx>0) dx=1;
	else if (sdx<0) {dx=-1;sdx=-sdx;}
	else dx=0;
	if (sdy>0) dy=1;
	else if (sdy<0) {dy=-1;sdy=-sdy;}
	else dy=0;
	ipt = obj->im;
	if (sdx>=sdy)
	{
		if (dx==1)
		{
			K1 = K3 = ((Z>>7)*DX - (X>>7)*DZ)*screen ;
			K2 = (DZ+Z)*(Z>>7) ;
			K4 = DZ*(Z>>7) ;
			while (i< obj->DY)
			{
				if ( K1 > K2)
				{
					K1 -= K2;
					K3 = ((Z>>7)*DX - (X>>7)*DZ)*screen ;
					K2 = (DZ+Z)*(Z>>7) ;
					K4 = DZ*(Z>>7);
					tx_lineX(ipt,obj->DX,X,Y,Z,a1,a2,a3);
				}
				K1+= K3;
				K2+= K4;
				X += DX;
				Y += DY;
				Z += DZ;
				B += screen;
				if (B > mag)
				{
					i++;
					ipt += obj->DX;
					B -= mag;
				}
			}
		}
		else
		{
			K1 = K3 = ((X>>7)*DZ - (Z>>7)*DX)*screen ;
			K2 = (DZ+Z)*(Z>>7) ;
			K4 = DZ*(Z>>7) ;
			while (i< obj->DY)
			{
				if ( K1 > K2)
				{
					K1 -= K2;
					K3 = ((X>>7)*DZ - (Z>>7)*DX)*screen ;
					K2 = (DZ+Z)*(Z>>7) ;
					K4 = DZ*(Z>>7);
					tx_lineX(ipt,obj->DX,X,Y,Z,a1,a2,a3);
				}
				K1+= K3;
				K2+= K4;
				X += DX;
				Y += DY;
				Z += DZ;
				B += screen;
				if (B > mag)
				{
					i++;
					ipt += obj->DX;
					B -= mag;
				}
			}
		}
	}
	else
	{
		if (dy==1)
		{
			K1 = K3 = ((Z>>7)*DY - (Y>>7)*DZ)*screen ;
			K2 = (DZ+Z)*(Z>>7);
			K4 = DZ*(Z>>7);
			while (i< obj->DY)
			{
				if ( K1 > K2)
				{
					K1 -= K2;
					K3 = ((Z>>7)*DY - (Y>>7)*DZ)*screen ;
					K2 = (DZ+Z)*(Z>>7) ;
					K4 = DZ*(Z>>7);
					tx_lineX(ipt,obj->DX,X,Y,Z,a1,a2,a3);
				}
				K1+= K3;
				K2+= K4;
				X += DX;
				Y += DY;
				Z += DZ;
				B += screen;
				if (B > mag)
				{
					i++;
					ipt += obj->DX;
					B -= mag;
				}
			}
		}
		else
		{
			K1 = K3 = ((Y>>7)*DZ - (Z>>7)*DY)*screen;
			K2 = (DZ+Z)*(Z>>7);
			K4 = DZ*(Z>>7) ;
			while (i< obj->DY)
			{
				if ( K1 > K2)
				{
					K1 -= K2;
					K3 = ((Y>>7)*DZ - (Z>>7)*DY)*screen ;
					K2 = (DZ+Z)*(Z>>7) ;
					K4 = DZ*(Z>>7);
					tx_lineX(ipt,obj->DX,X,Y,Z,a1,a2,a3);
				}
				K1+= K3;
				K2+= K4;
				X += DX;
				Y += DY;
				Z += DZ;
				B += screen;
				if (B > mag)
				{
					i++;
					ipt += obj->DX;
					B -= mag;
				}
			}
		}
	}
}

  */
long scx[9],scy[9];
byte nsc;
long minx[200], maxx[200];
long miny, maxy;

int projection(long *x, long *y, long *z,byte pn)
{
   register int i,j,k=0,l;


   if (z[0] <= screen)
   {
	for (i=1;i<pn;i++)
		if (z[i] > screen) break;
	if (i==pn) return 0;
	scx[k] =(long)(-((x[i] - x[i-1]) * (screen-z[i-1]) / (z[i] - z[i-1])
		  + x[i-1])+160);
	scy[k] =(long)( 100+ -((y[i] - y[i-1]) * (screen - z[i-1]) / (z[i] - z[i-1])
		  + y[i-1]));
	k++;
	for (j=i;j<=pn;j++)
	{
		if (z[j] <= screen) break;
		   else
		   {
			scx[k] = (long)(-x[j] * screen / z[j]+160) ;
			scy[k] = (long)(100 - y[j] * screen / z[j]);
			k++;
		   }
	 }
	scx[k] = (long)(-((x[j] - x[j-1]) * (z[j-1] - screen) / (z[j-1] - z[j])
		 + x[j-1])+160);
	scy[k] = (long)(100 - ((y[j] - y[j-1]) * (z[j-1] - screen) / (z[j-1] - z[j])
		 + y[j-1]));
	k++;
	scx[k] = scx[0]; scy[k] = scy[0];
	//if (clip_line(scx[k-1],scy[k-1],scx[0],scy[0])) return 0;
	nsc = k;
   }
      else
      {
	for (i = 0; i < pn; i++)
	{
		if (z[i] <= screen) break;
		   else
		   {
			scx[k] = (long)(- x[i] * screen / z[i]+160);
			scy[k] = (long)(100 - y[i] * screen / z[i]);
			k++;
		   }
	}
	if (i < pn)
	{
		scx[k] = (long)(-((x[i] - x[i-1]) * (z[i-1] - screen) / (z[i-1] - z[i])
			 + x[i-1])+160);
		scy[k] = (long)(100 -((y[i] - y[i-1]) * (z[i-1] - screen) / (z[i-1] - z[i])
			 + y[i-1]));
		k++;
		for (j = i+1; j <= pn; j++)
			if (z[j] > screen) break;
		scx[k] = (long)(-((x[j-1] - x[j]) * (z[j] - screen) / (z[j] - z[j-1])
			 + x[j])+160);
		scy[k] = (long)(100 -((y[j-1] - y[j]) * (z[j] - screen) / (z[j] - z[j-1])
			 + y[j]));
		//if (clip_line(scx[k-1],scy[k-1],scx[k],scy[k])) return 0;
		k++;
		for (l = j; l < pn; l++)
		{
			scx[k] = (long)(- x[l] * screen / z[l]+160);
			scy[k] = (long)(100 -  y[l] * screen / z[l]);
			k++;
		}
	}
	scx[k] = scx[0]; scy[k] = scy[0];
	nsc = k ;
      }
      return 1;
}

/*void txline(int x1,int x2, int y1, struct face *obj)
{
	long a1,a2,a3,b1,b2,b3,c1,c2,c3;
	long x,y;
	int i;
	a1 = (obsv[0][0]*(obj->Direction)[0][0] + obsv[0][1]*(obj->Direction)[1][0] + obsv[0][2]*(obj->Direction)[2][0]) >>7;
	a2 = (obsv[1][0]*(obj->Direction)[0][0] + obsv[1][1]*(obj->Direction)[1][0] + obsv[1][2]*(obj->Direction)[2][0]) >>7;
	a3 = (obsv[2][0]*(obj->Direction)[0][0] + obsv[2][1]*(obj->Direction)[1][0] + obsv[2][2]*(obj->Direction)[2][0]) >>7;
	b1 = (obsv[0][0]*(obj->Direction)[0][1] + obsv[0][1]*(obj->Direction)[1][1] + obsv[0][2]*(obj->Direction)[2][1]) >>7;
	b2 = (obsv[1][0]*(obj->Direction)[0][1] + obsv[1][1]*(obj->Direction)[1][1] + obsv[1][2]*(obj->Direction)[2][1]) >>7;
	b3 = (obsv[2][0]*(obj->Direction)[0][1] + obsv[2][1]*(obj->Direction)[1][1] + obsv[2][2]*(obj->Direction)[2][1]) >>7;
	c1 = (obsv[0][0] + obsv[0][1] + obsv[0][2]) * (obj->X);
	c2 = (obsv[1][0] + obsv[1][1] + obsv[1][2]) * (obj->Y);
	c3 = (obsv[2][0] + obsv[2][1] + obsv[2][2]) * (obj->Z);
	for (i=x1;i<=x2;i++)
	{
		x=(((b3*c2>>7) - (b2*c3>>7))*(160-i) + ((b1*c3>>7) - (b3*c1>>7))*(100-y1) + ((b2*c1>>7) - (b1*c2>>7))*screen) /
		  (((a3*b2>>7) - (a2*b3>>7))*(160-i) + ((a1*b3>>7) - (a3*b1>>7))*(100-y1) + ((a2*b1>>7) - (a1*b2>>7))*screen);
		y=-(((a3*c2>>7) - (a2*c3>>7))*(160-i) + ((a1*c3>>7) - (a3*c1>>7))*(100-y1) + ((a2*c1>>7) - (a1*c2>>7))*screen) /
		  (((a3*b2>>7) - (a2*b3>>7))*(160-i) + ((a1*b3>>7) - (a3*b1>>7))*(100-y1) + ((a2*b1>>7) - (a1*b2>>7))*screen);
		color = obj->im[x*screen/mag + (y*screen/mag)*obj->DX ];
		putpixel(i,y1);
	}
}
*/
int mag=36;
void fillpoly(long x[], long y[], byte pn,struct face *obj,float B[][3],float C[][3])
{


	register int i, j;
	long  k,x1,y1,x2,y2, a, b, dx, dy;
	long temp1,temp2;
	long t1,t2,t3,t4,t5,t6,t7,t8,t9,t10,t11,t12,t13,t14;
	float a1,a2,a3,b1,b2,b3,c1,c2,c3;
	long A1,A2,A3,B1,B2,B3,C1,C2,C3;
	byte far *vptr;
	int imx,imy;

	for (i=1,temp1=x[0],temp2=x[0];i<pn;i++)
	{
		if (x[i]<temp1) temp1=x[i];
		if (x[i]>temp2) temp2=x[i];
	}
	if ((temp1>winr)||(temp2<winl)) return;
	for (i=1,temp1=y[0],temp2=y[0];i<pn;i++)
	{
		if (y[i]<temp1) temp1=y[i];
		if (y[i]>temp2) temp2=y[i];
	}
	if ((temp1>winb)||(temp2<winu)) return;

	for (i=0;i<pn;i++)
		if ((x[i]!=x[i+1])||(y[i]!=y[i+1])) break;
	if (i==pn)
	{
		if ((x[0]<winl)||(x[0]>winr)||(y[0]<winu)||(y[0]>winb)) return;
		return;
	}
	miny = maxy = y[0];
	for (i=0;i<pn;i++)
	{
		a = b = 0;
		dx = x[i+1] - x[i];
		dy = y[i+1] - y[i];
		x1= x[i];y1=y[i];
		if (dx > 0)
		{
			if (dy>0)
			{
				if (maxy < y[i+1]) maxy = y[i+1];
				if ((y1>=0) && (y1<200)) minx[y1] = x1;
				if (dx>dy)
				{
					b += dx>>1;
					for (k=0;k<dx;k++)
					{
						x1 ++;
						b += dy;
						if (b>dx)
						{
							y1 ++;
							b -= dx;
							if ((y1>=0) && (y1<200)) minx[y1] = x1;
						}
					}
				}
				else
				{
					a += dy>>1;
					for (k=0;k<dy;k++)
					{
						a += dx;
						if (a>dy)
						{
							x1 ++;
							a -= dy;
						}
						y1 ++;
						if ((y1>=0) && (y1<200)) minx[y1] = x1;
					}
				}
			}
			else
			{
				if (miny > y[i+1]) miny = y[i+1];
				if (dx> - dy)
				{
					b += dx>>1;
					for (k=0;k<dx;k++)
					{
						x1 ++;
						b -= dy;
						if (b>dx)
						{
							if ((y1>=0) && (y1<200)) maxx[y1] = x1;
							y1 --;
							b -= dx;
						}
					}
					if ((y1>=0) && (y1<200)) maxx[y1] = x1;
				}
				else
				{
					if ((y1>=0) && (y1<200)) maxx[y1] = x1;
					a -= dy>>1;
					for (k=0;k<-dy;k++)
					{
						a += dx;
						if (a>-dy)
						{
							x1 ++;
							a += dy;
						}
						y1 --;
						if ((y1>=0) && (y1<200)) maxx[y1] = x1;
					 }
				}
			}
		}
		else if (dx==0)
		{
			if (dy>0)
			{
				if (maxy < y[i+1]) maxy = y[i+1];
				for (j=y[i];j<=y[i+1];j++) if ((j>=0) && (j<200)) minx[j]=x[i];
			}
			else if (dy<0)
			{
				if (miny > y[i+1]) miny = y[i+1];
				for (j=y[i+1];j<=y[i];j++) if ((j>=0) && (j<200)) maxx[j]=x[i];
			}
		}
		else
		{
			if (dy>=0)
			{
				if (maxy < y[i+1]) maxy = y[i+1];
				if (-dx>dy)
				{
					b -= dx>>1;
					for (k=0;k<-dx;k++)
					{
						x1 --;
						b += dy;
						if (b>-dx)
						{
							if ((y1>=0) && (y1<200)) minx[y1] = x1;
							y1 ++;
							b += dx;
						}
					}
					if ((y1>=0) && (y1<200)) minx[y1] = x1;
				}
				else
				{
					if ((y1>=0) && (y1<200)) minx[y1] = x1;
					a += dy>>1;
					for (k=0;k<dy;k++)
					{
						a -= dx;
						if (a>dy)
						{
							x1 --;
							a -= dy;
						}
						y1 ++;
						if ((y1>=0) && (y1<200)) minx[y1] = x1;
					}
				}
			}
			else
			{
				if (miny > y[i+1]) miny = y[i+1];
				if ((y1>=0) && (y1<200)) maxx[y1] = x1;
				if (-dx> - dy)
				{
					b -= dx>>1;
					for (k=0;k<-dx;k++)
					{
						x1 --;
						b -= dy;
						if (b>-dx)
						{
							y1 --;
							b += dx;
							if ((y1>=0) && (y1<200)) maxx[y1] = x1;
						}
					}
				}
				else
				{
					a -= dy>>1;
					for (k=0;k<-dy;k++)
					{
						a -= dx;
						if (a>-dy)
						{
							x1 --;
							a += dy;
						}
						y1 --;
						if ((y1>=0) && (y1<200)) maxx[y1] = x1;
					}
				}
			}
		}
	}
	if ((miny>winb)||(maxy<winu)) return;
	if (miny<winu) miny = winu;
	if (maxy>winb) maxy = winb;

	a1 = (C[0][0]*B[0][0] + C[0][1]*B[1][0] + C[0][2]*B[2][0]);
	a2 = (C[1][0]*B[0][0] + C[1][1]*B[1][0] + C[1][2]*B[2][0]);
	a3 = (C[2][0]*B[0][0] + C[2][1]*B[1][0] + C[2][2]*B[2][0]);
	b1 = (C[0][0]*B[0][1] + C[0][1]*B[1][1] + C[0][2]*B[2][1]);
	b2 = (C[1][0]*B[0][1] + C[1][1]*B[1][1] + C[1][2]*B[2][1]);
	b3 = (C[2][0]*B[0][1] + C[2][1]*B[1][1] + C[2][2]*B[2][1]);
	c1 = (C[0][0]*B[0][2] + C[0][1]*B[1][2] + C[0][2]*B[2][2]);
	c2 = (C[1][0]*B[0][2] + C[1][1]*B[1][2] + C[1][2]*B[2][2]);
	c3 = (C[2][0]*B[0][2] + C[2][1]*B[1][2] + C[2][2]*B[2][2]);

	A1 = (b2*c3 - b3*c2)*256;
	B1 = (b3*c1 - b1*c3)*256;
	C1 = (b1*c2 - b2*c1)*screen*256;
	A2 = (a3*c2 - a2*c3)*256;
	B2 = (a1*c3 - a3*c1)*256;
	C2 = (a2*c1 - a1*c2)*screen*256;
	A3 = ((a2*b3) - (a3*b2))*256;
	B3 = ((a3*b1) - (a1*b3))*256;
	C3 = ((a1*b2) - (a2*b1))*screen*256;

	i = miny;
	t4 = (A3>>4)*(B1>>8) - (A1>>8)*(B3>>4);
	t6 = (A3>>4)*(B2>>8) - (A2>>8)*(B3>>4);
	t5 = t4*(100-i) + (A3>>4)*(C1>>8) - (A1>>8)*(C3>>4);
	t7 = t6*(100-i) + (A3>>4)*(C2>>8) - (A2>>8)*(C3>>4);
	t12 = B1*(100-i) + C1 - (B1>>1);//- (A1>>1) - (B1>>1);
	t13 = B2*(100-i) + C2 - (B2>>1);//- (A2>>1) - (B2>>1);
	t14 = B3*(100-i) + C3 - (B3>>1);//- (A3>>1) - (B3>>1);
	for (i = miny;i<=maxy;i++,t5-=t4,t7-=t6,t12-=B1,t13-=B2,t14-=B3)
	{
		if ((minx[i]>winr) || (maxx[i] <winl)) continue;
		if (minx[i] <winl) minx[i] = winl;
		if (maxx[i] >winr) maxx[i] = winr;
		j = minx[i];
		vptr = vp + (i<<8) + (i<<6) + j;
		t1 = A1*(160-j) + t12;
		t2 = A2*(160-j) + t13;
		t3 = A3*(160-j) + t14;
		if (!t3) continue;
		imx = t1/t3;
		if (imx<0) imx=0;
		else if (imx>=obj->DX) imx=obj->DX-1;
		imy = t2/t3;
		if (imy<0) imy=0;
		else if (imy>=obj->DY) imy=obj->DY-1;
		t10 = A3*imx;
		t11 = A3*imy;
		*vptr = *(obj->im + (imy<<7) + imx);
		t8 = t3*imx;
		t9 = t3*imy;
		if (t3>0)
		{
			if (t5>0)
			{
				if (t7>0)
				{
					t8 += t3;t10+=A3;
					t9 += t3;t11+=A3;
					for (j=minx[i];j<maxx[i];j++)
					{
						t1-=A1;t2-=A2;t3-=A3;
						t8-=t10;t9-=t11;
						vptr++;
						if (t3<=0) {*vptr = *(obj->im + (imy<<7) + imx);break;}
						while (t8 < t1)
						{
							t8 += t3;t10+=A3;
							imx++;
							if (imx>=obj->DX) imx=obj->DX-1;
						}
						while (t9 < t2)
						{
							t9 += t3;t11+=A3;
							imy++;
							if (imy>=obj->DY) imy=obj->DY-1;
						}
						*vptr = *(obj->im + (imy<<7) + imx);
					}
				}
				else
				{
					t8 += t3;t10+=A3;
					for (j=minx[i];j<maxx[i];j++)
					{
						t1-=A1;t2-=A2;t3-=A3;
						t8-=t10;t9-=t11;
						vptr++;
						if (t3<=0) {*vptr = *(obj->im + (imy<<7) + imx);break;}
						if (t2<=0) {*vptr = *(obj->im + (imy<<7) + imx);break;}
						while (t8 < t1)
						{
							t8 += t3;t10+=A3;
							imx++;
							if (imx>=obj->DX) imx=obj->DX-1;
						}
						while (t9 > t2)
						{
							t9 -= t3;t11-=A3;
							imy--;
							if (imy<0) imy=0;
						}
						*vptr = *(obj->im + (imy<<7) + imx);
					}
				}
			}
			else
			{
				if (t7>0)
				{
					t9 += t3;t11+=A3;
					for (j=minx[i];j<maxx[i];j++)
					{
						t1-=A1;t2-=A2;t3-=A3;
						t8-=t10;t9-=t11;
						vptr++;
						if (t3<=0) {*vptr = *(obj->im + (imy<<7) + imx);break;}
						if (t1<=0) {*vptr = *(obj->im + (imy<<7) + imx);break;}
						while (t8 > t1)
						{
							t8 -= t3;t10-=A3;
							imx--;
							if (imx<0) imx=0;
						}
						while (t9 < t2)
						{
							t9 += t3;t11+=A3;
							imy++;
							if (imy>=obj->DY) imy=obj->DY-1;
						}
						*vptr = *(obj->im + (imy<<7) + imx);
					}
				}
				else
				{
					for (j=minx[i];j<maxx[i];j++)
					{
						t1-=A1;t2-=A2;t3-=A3;
						t8-=t10;t9-=t11;
						vptr++;
						if (t3<=0) {*vptr = *(obj->im + (imy<<7) + imx);break;}
						if (t1<=0) {*vptr = *(obj->im + (imy<<7) + imx);break;}
						if (t2<=0) {*vptr = *(obj->im + (imy<<7) + imx);break;}
						while (t8 > t1)
						{
							t8 -= t3;t10-=A3;
							imx--;
							if (imx<0) imx=0;
						}
						while (t9 > t2)
						{
							t9 -= t3;t11-=A3;
							imy--;
							if (imy<0) imy=0;
						}
						*vptr = *(obj->im + (imy<<7) + imx);
					}
				}
			}
		}
		else
		{
			if (t5>0)
			{
				if (t7>0)
				{
					t8 += t3;t10+=A3;
					t9 += t3;t11+=A3;
					for (j=minx[i];j<maxx[i];j++)
					{
						t1-=A1;t2-=A2;t3-=A3;
						t8-=t10;t9-=t11;
						vptr++;
						if (t3>=0) {*vptr = *(obj->im + (imy<<7) + imx);break;}
						while (t8 > t1)
						{
							t8 += t3;t10+=A3;
							imx++;
							if (imx>=obj->DX) imx=obj->DX-1;
						}
						while (t9 > t2)
						{
							t9 += t3;t11+=A3;
							imy++;
							if (imy>=obj->DY) imy=obj->DY-1;
						}
						*vptr = *(obj->im + (imy<<7) + imx);
					}
				}
				else
				{
					t8 += t3;t10+=A3;
					for (j=minx[i];j<maxx[i];j++)
					{
						t1-=A1;t2-=A2;t3-=A3;
						t8-=t10;t9-=t11;
						vptr++;
						if (t3>=0) {*vptr = *(obj->im + (imy<<7) + imx);break;}
						if (t2>=0) {*vptr = *(obj->im + (imy<<7) + imx);break;}
						while (t8 > t1)
						{
							t8 += t3;t10+=A3;
							imx++;
							if (imx>=obj->DX) imx=obj->DX-1;
						}
						while (t9 < t2)
						{
							t9 -= t3;t11-=A3;
							imy--;
							if (imy<0) imy=0;
						}
						*vptr = *(obj->im + (imy<<7) + imx);
					}
				}
			}
			else
			{
				if (t7>0)
				{
					t9 += t3;t11+=A3;
					for (j=minx[i];j<maxx[i];j++)
					{
						t1-=A1;t2-=A2;t3-=A3;
						t8-=t10;t9-=t11;
						vptr++;
						if (t3>=0) {*vptr = *(obj->im + (imy<<7) + imx);break;}
						if (t1>=0) {*vptr = *(obj->im + (imy<<7) + imx);break;}
						while (t8 < t1)
						{
							t8 -= t3;t10-=A3;
							imx--;
							if (imx<0) imx=0;
						}
						while (t9 > t2)
						{
							t9 += t3;t11+=A3;
							imy++;
							if (imy>=obj->DY) imy=obj->DY-1;
						}
						*vptr = *(obj->im + (imy<<7) + imx);
					}
				}
				else
				{
					for (j=minx[i];j<maxx[i];j++)
					{
						t1-=A1;t2-=A2;t3-=A3;
						t8-=t10;t9-=t11;
						vptr++;
						if (t3>=0) {*vptr = *(obj->im + (imy<<7) + imx);break;}
						if (t1>=0) {*vptr = *(obj->im + (imy<<7) + imx);break;}
						if (t2>=0) {*vptr = *(obj->im + (imy<<7) + imx);break;}
						while (t8 < t1)
						{
							t8 -= t3;t10-=A3;
							imx--;
							if (imx<0) imx=0;
						}
						while (t9 < t2)
						{
							t9 -= t3;t11-=A3;
							imy--;
							if (imy<0) imy=0;
						}
						*vptr = *(obj->im + (imy<<7) + imx);;
					}
				}
			}
		}
	}

}

void setmode( char );

#pragma aux setmode =           \
	"mov ah, 0",            \
	"int 10h"               \
	parm   [ al ]           \
	modify [ ah ];

void main(void)
{
	byte im[22500];
	int i,j,l,m,n,dl,dm,dn;
	long x[5],x1[5]={0,0,280,280,0};
	long y[5],y1[5]={0,280,280,0,0};
	long z[5];
	long x2[5],y2[5],z2[5];
	float A[3][3] = {{128,128,0},{128,0,0},{1,1,1}};
	float A1[3][3] = {{128,0,0},{128,128,0},{1,1,1}};
	float B[3][3],C[3][3];
	struct face obj = {0,0,400, 128, 128,
			   1,0,0,
			   0,1,0,
			   0,0,1};
	struct face obj1 = {0,0,400, 128, 128,
			   1,0,0,
			   0,1,0,
			   0,0,1};
	char fn[]="s_gloria.pcx";
	BYTE pal[768];
	float a1,a2,a3,b1,b2,b3,c1,c2,c3;
	struct timeb T;

	winl = 0;
	winr = 319;
	winu = 0;
	winb = 199;
	obj.im = im;

	initTRI();
	ftime(&T);
	srand(T.millitm);
	setmode(0x13);
	LoadPCX_Pallete(fn, pal);
	SetRGB(pal);
	LoadPCX_Image(fn,im);
	l=m=n=0;
	dl=rand()%2+3;
	dm=rand()%2+2;
	dn=rand()%2+2;
	while (!kbhit())
	{
	memset(vp,0,64000);
	for (i=0;i<l;i++)
		pitch(&obj,100);
	for (i=0;i<m;i++)
		yow(&obj,100);
	for (i=0;i<n;i++)
		roll(&obj,100);
	for (i=0;i<5;i++)
	{
		x2[4-i] = x[i] = obj.Direction[0][0]*(x1[i]-140) +
				 obj.Direction[0][1]*(y1[i]-140) +
				 obj.Direction[0][2]*70;
		y2[4-i] = y[i] = obj.Direction[1][0]*(x1[i]-140) +
				 obj.Direction[1][1]*(y1[i]-140) +
				 obj.Direction[1][2]*70;
		z2[4-i] = z[i] = obj.Direction[2][0]*(x1[i]-140) +
				 obj.Direction[2][1]*(y1[i]-140) +
				 obj.Direction[2][2]*70 + 420;
	}
	inverse1(A,B);
	for (i=0;i<3;i++)
	{
		C[0][i] = x[i];
		C[1][i] = y[i];
		C[2][i] = z[i];
	}

	projection(x,y,z,4);
	fillpoly(scx,scy,nsc,&obj,B,C);
	inverse1(A1,B);
	for (i=0;i<3;i++)
	{
		C[0][i] = x2[i];
		C[1][i] = y2[i];
		C[2][i] = z2[i];
	}
	projection(x2,y2,z2,4);
	fillpoly(scx,scy,nsc,&obj,B,C);
	memcpy((void*)0xa0000,vp,64000);
	for (i=0;i<3;i++)
		for (j=0;j<3;j++)
			obj.Direction[i][j] = obj1.Direction[i][j];
	l += dl; if (l>360) {l-=360;dl=rand()%2+3;}
	m += dm; if (m>360) {m-=360;dm=rand()%2+2;}
	n += dn; if (n>360) {n-=360;dn=rand()%2+2;}
	}
	setmode(0x03);

}