(*-------------------------------------------------------------*)
(*                a ŝe A                             *)
(*                                                             *)
(*  q : ADLIB.C                                           *)
(*                                                             *)
(*  ee : Marc Savary                                       *)
(*                                                             *)
(*  a : ADLIB.PAS                                         *)
(*                                                             *)
(*  a : w҅ (  wba 1 be )                   *)
(*                  ( HiTEL, 埡e : komh )                   *)
(*                                                             *)
(*  ai : 1995 e 01  14                                *)
(*-------------------------------------------------------------*)

{$F+,O+}
unit AdLib;

interface

const
  nbLocParam    = 14;

  prmKsl        = 0;
  prmMulti      = 1;
  prmFeedBack   = 2;
  prmAttack     = 3;
  prmSustain    = 4;
  prmStaining   = 5;
  prmDecay      = 6;
  prmRelease    = 7;
  prmLevel      = 8;
  prmAm         = 9;
  prmVib        = 10;
  prmKsr        = 11;
  prmFm         = 12;
  prmWaveSel    = 13;

  prmAmDepth    = 14;
  prmVibDepth   = 15;
  prmNoteSel    = 16;
  prmPercussion = 17;

  vMelo0        = 0;
  vMelo1        = 1;
  vMelo2        = 2;
  vMelo3        = 3;
  vMelo4        = 4;
  vMelo5        = 5;
  vMelo6        = 6;
  vMelo7        = 7;
  vMelo8        = 8;

  Bd            = 6;
  Sd            = 7;
  Tom           = 8;
  Cymb          = 9;
  HiHat         = 10;

  MaxVolume     = $7F;
  Log2Volume    = 7;
  MaxPitch      = $3FFF;
  MidPitch      = $2000;

  MidC          = 60;
  ChipMidC	= 48;
  NrNotes       = 96;

  procedure SetMode(Mode : Integer);
  procedure SetGParam (AmD, VibD, NSel : Integer);
  procedure SetPitchRange(pR : Word);
  procedure SetWaveSel(State : Integer);
  procedure SoundWarmInit;
  function  SoundColdInit(Port : Word) : Boolean;
  procedure SetVoiceTimbre (Voice : Word; ParamArray : Pointer);
  procedure SetVoiceVolume(Voice, Volume : Word);
  procedure SetVoicePitch(Voice, PitchBend : Word);
  procedure NoteOn(Voice : Word; Pitch : Integer);
  procedure NoteOff(Voice : Word);

implementation

uses
  BaseUnit;

const
  TomPitch = 24;
  TomToSd  = 7;
  SdPitch  = TomPitch + TomToSd;

  PercMasks : array [0..4] of Byte = (
    $10, $08, $04, $02, $01
  );

  PianoParamsOp0 : array [0..nbLocParam - 1] of Byte = (
    1, 1, 3, 15, 5, 0, 1, 3, 15, 0, 0, 0, 1, 0
  );

  PianoParamsOp1 : array [0..nbLocParam - 1] of Byte = (
    0, 1, 1, 15, 7, 0, 2, 4, 0, 0, 0, 1, 0, 0
  );

  BdOpr0 : array [0..13] of Byte = (
    0, 0, 0, 10, 4, 0, 8, 12, 11, 0, 0, 0, 1, 0
  );
  BdOpr1 : array [0..13] of Byte = (
    0, 0, 0, 13, 4, 0, 6, 15, 0, 0, 0, 0, 1, 0
  );
  SdOpr : array [0..13] of Byte = (
    0, 12, 0, 15, 11, 0, 8, 5, 0, 0, 0, 0, 0, 0
   );
  TomOpr : array [0..13] of Byte = (
    0, 4, 0, 15, 11, 0, 7, 5, 0, 0, 0, 0, 0, 0
  );
  CymbOpr : array [0..13] of Byte = (
    0, 1, 0, 15, 11, 0, 5, 5, 0, 0, 0, 0, 0, 0
  );
  HhOpr : array [0..13] of Byte = (
    0, 1, 0, 15, 11, 0, 7, 5, 0, 0, 0, 0, 0, 0
  );

  SlotMVoice : array [0..8, 0..1] of Byte = (
    (0, 3),
    (1, 4),
    (2, 5),
    (6, 9),
    (7, 10),
    (8, 11),
    (12, 15),
    (13, 16),
    (14, 17)
  );

  SlotPVoice : array [0..10, 0..1] of Byte = (
    (0, 3),
    (1, 4),
    (2, 5),
    (6, 9),
    (7, 10),
    (8, 11),
    (12, 15),
    (16, 255),
    (14, 255),
    (17, 255),
    (13, 255)
  );

  OffsetSlot : array [0..17] of Byte = (
     0,  1,  2,  3,  4,  5,
     8,  9, 10, 11, 12, 13,
    16, 17, 18, 19, 20, 21
  );

  CarrierSlot : array [0..17] of Byte = (
    0, 0, 0,
    1, 1, 1,
    0, 0, 0,
    1, 1, 1,
    0, 0, 0,
    1, 1, 1
  );

  VoiceMSlot : array [0..17] of Byte = (
    0, 1, 2,
    0, 1, 2,
    3, 4, 5,
    3, 4, 5,
    6, 7, 8,
    6, 7, 8
  );

  VoicePSlot : array [0..17] of Byte = (
    0, 1, 2,
    0, 1, 2,
    3, 4, 5,
    3, 4, 5,
    BD, HIHAT, TOM,
    BD, SD, CYMB
  );

var
  GenAddr       : Word;
  PitchRange    : Integer;
  ModeWaveSel   : Integer;
  PercBits      : Byte;
  VoiceNote     : array [0..8] of Byte;
  VoiceKeyOn    : array [0..8] of Byte;
  VPitchBend    : array [0..8] of Word;
  BxRegister    : array [0..8] of Byte;
  LVoiceVolume  : array [0..10] of Byte;
  ModeVoices    : Word;

  ParamSlot     : array [0..17, 0..nbLocParam - 1] of Byte;
  AmDepth       : Byte;
  VibDepth      : Byte;
  NoteSel       : Byte;
  Percussion    : Boolean;

function GetLocPrm(Slot, Prm : Word) : Word;
begin
  GetLocPrm := ParamSlot[Slot, Prm];
end;

procedure SndOutPut(Addr, DataVal : Integer); assembler;
asm
        MOV     DX, GenAddr
	MOV     AX, Addr
	OUT     DX, AL

	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX

        INC	DX
	MOV     AX, DataVal
	OUT     DX, AL
	DEC     DX

	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX

	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX

	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX

	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
	IN	AL, DX
end;

const
  Clock           = 3579545;
  FIntern         = CLOCK div 72;
  NbNotes         = 96;
  Octave          = 12;
  NbTableDemiTon  = Octave;
  NbStepPitch     = 16;
  LogNbStepPitch  = 4;
  TableSize       = NbStepPitch * NbTableDemiTon;
  LogPitch        = 8;
  FreqDo          = 261.6256;

  FNumTbl : array [0..TableSize - 1] of Word = (
    $02B2, $02B4, $02B7, $02B9, $02BC, $02BE, $02C1, $02C3, $02C6, $02C9,
    $02CB, $02CE, $02D0, $02D3, $02D6, $02D8, $02DB, $02DD, $02E0, $02E3,
    $02E5, $02E8, $02EB, $02ED, $02F0, $02F3, $02F6, $02F8, $02FB, $02FE,
    $0301, $0303, $0306, $0309, $030C, $030F, $0311, $0314, $0317, $031A,
    $031D, $0320, $0323, $0326, $0329, $032B, $032E, $0331, $0334, $0337,
    $033A, $033D, $0340, $0343, $0346, $0349, $034C, $034F, $0352, $0356,
    $0359, $035C, $035F, $0362, $0365, $0368, $036B, $036F, $0372, $0375,
    $0378, $037B, $037F, $0382, $0385, $0388, $038C, $038F, $0392, $0395,
    $0399, $039C, $039F, $03A3, $03A6, $03A9, $03AD, $03B0, $03B4, $03B7,
    $03BB, $03BE, $03C1, $03C5, $03C8, $03CC, $03CF, $03D3, $03D7, $03DA,
    $03DE, $03E1, $03E5, $03E8, $03EC, $03F0, $03F3, $03F7, $03FB, $03FE,
    $0FE01, $0FE03, $0FE05, $0FE07, $0FE08, $0FE0A, $0FE0C, $0FE0E, $0FE10, $0FE12,
    $0FE14, $0FE16, $0FE18, $0FE1A, $0FE1C, $0FE1E, $0FE20, $0FE21, $0FE23, $0FE25,
    $0FE27, $0FE29, $0FE2B, $0FE2D, $0FE2F, $0FE31, $0FE34, $0FE36, $0FE38, $0FE3A,
    $0FE3C, $0FE3E, $0FE40, $0FE42, $0FE44, $0FE46, $0FE48, $0FE4A, $0FE4C, $0FE4F,
    $0FE51, $0FE53, $0FE55, $0FE57, $0FE59, $0FE5C, $0FE5E, $0FE60, $0FE62, $0FE64,
    $0FE67, $0FE69, $0FE6B, $0FE6D, $0FE6F, $0FE72, $0FE74, $0FE76, $0FE79, $0FE7B,
    $0FE7D, $0FE7F, $0FE82, $0FE84, $0FE86, $0FE89, $0FE8B, $0FE8D, $0FE90, $0FE92,
    $0FE95, $0FE97, $0FE99, $0FE9C, $0FE9E, $0FEA1, $0FEA3, $0FEA5, $0FEA8, $0FEAA,
    $0FEAD, $0FEAF
  );

  NoteDiv12 : array [0..95] of Byte = (
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1,  1,
    1,  1,  1,  1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    2,  2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  4,  4,  4,
    4,  4,  4,  4,  4,  4,  4,  4,  4,  5,  5,  5,  5,  5,  5,  5,  5,
    5,  5,  5,  5,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  7,
    7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7
  );

  NoteMod12 : array [0..95] of Byte = (
    0,   1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11,  0,  1,  2,  3,  4,
    5,   6,  7,  8,  9, 10, 11,  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,
    10, 11,  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11,  0,  1,  2,
    3,   4,  5,  6,  7,  8,  9, 10, 11,  0,  1,  2,  3,  4,  5,  6,  7,
    8,   9, 10, 11,  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11,  0,
    1,   2,  3,  4,  5,  6,  7,  8,  9, 10, 11
  );

  KeyOnBlockFNum  = $B0;
  FNumLow         = $A0;

function SetFreq(Voice : Integer; Note : Word; Pitch,
  KeyOn : Integer) : Integer; assembler;
asm
        MOV	AX, Pitch
	SUB	AX, 2000h
	JE	@@AfterMul

	SAR	AX, 1
	SAR	AX, 1
	SAR	AX, 1
	SAR	AX, 1
	SAR	AX, 1

        IMUL    PitchRange

@@AfterMul:
	ADD	AH, BYTE PTR Note

	ADD     AX, (1 SHL (LogPitch - LogNbStepPitch - 1))

	SAR	AX, 1
	SAR	AX, 1
	SAR	AX, 1
	SAR	AX, 1

	JGE	@@L3

	XOR	AX, AX
	JMP	@@L4

@@L3:	CMP	AX, (NbNotes SHL LogNbStepPitch) - 1
	JL	@@L4

	MOV	AX, (NbNotes SHL LogNbStepPitch) - 1

@@L4:
	MOV	DI, AX
	SHR	DI, 1
	SHR	DI, 1
	SHR	DI, 1
	SHR	DI, 1
	MOV	DX, DI

        MOV     BL, BYTE PTR NoteMod12[DI]
	XOR	BH, BH
	MOV	DI, BX

	SHL	DI, 1
	SHL	DI, 1
	SHL	DI, 1
	SHL	DI, 1
	SHL	DI, 1

	SHL	AX, 1
	AND	AX, (NbStepPitch * 2 - 1)
	ADD	DI, AX

	MOV     AX, WORD PTR FNumTbl[DI]

	MOV	DI, DX
	MOV     BL, BYTE PTR NoteDiv12[DI]
	DEC	BL

	OR	AX, AX
	JGE	@@L5
	INC	BL

@@L5:
	OR	BL, BL
	JGE	@@L6

	INC	BL

	SAR	AX, 1
@@L6:

        PUSH    DX
	PUSH	BX
	PUSH	AX
	XOR	AH, AH
        MOV     DX, AX
	MOV	AL, FNumLow
	ADD	AL, BYTE PTR Voice
	PUSH	AX
        MOV     AX, DX
	PUSH	AX
	CALL	SndOutput
	POP	AX
	POP	BX
        POP     DX

	MOV	AL, AH
	AND	AL, 3
	SHL	BL, 1
	SHL	BL, 1
	ADD	AL, BL
	ADD	AL, BYTE PTR KeyOn
	XOR	AH, AH
        PUSH    DX
	PUSH	AX
        MOV     DX, AX
	MOV	AX, KeyOnBlockFNum
	ADD	AX, Voice
	PUSH	AX
        MOV     AX, DX
	PUSH	AX
	CALL	SndOutput
	POP     AX
        POP     DX
end;

procedure SndSAmVibRhythm;
var
  T1 : Word;

begin
  T1 := 0;

  if amDepth <> 0 then
    T1 := $80;

  if vibDepth <> 0 then
    T1 := T1 or $40;

  if Percussion then
    T1 := T1 or $20;

  T1 := T1 or PercBits;

  SndOutput($BD, T1);
end;

procedure SndSNoteSel;
begin
  if NoteSel <> 0 then
    SndOutput($08, 64)
  else
    SndOutput($08, 0);
end;

procedure SndSKslLevel(Slot : Integer);
var
  T1, VC        : Word;
  SingleSlot    : Boolean;

begin
  if Percussion then
    VC := VoicePSlot[Slot]
  else
    VC := VoiceMSlot[Slot];

  T1 := 63 - (GetLocPrm(Slot, PrmLevel) and 63);
  SingleSlot := Percussion and (VC > Bd);

  if (CarrierSlot[Slot] <> 0) or (GetLocPrm(Slot, PrmFm) = 0) or
     SingleSlot then
    T1 := (T1 * LVoiceVolume[VC] + ((MaxVolume + 1) div 2)) shr Log2Volume;

  T1 := 63 - T1;
  T1 := T1 or (GetLocPrm(Slot, PrmKsl) shl 6);
  SndOutput($40 + Integer(OffsetSlot[Slot]), T1);
end;

procedure SndSFeedFm(Slot : Integer);
var
  T1 : Word;

begin
  if CarrierSlot[Slot] <> 0 then
    Exit;

  T1 := GetLocPrm(Slot, prmFeedBack) shl 1;

  if GetLocPrm(Slot, prmFm) = 0 then
    T1 := T1 or 1;

  SndOutput($C0 + Integer(VoiceMSlot[Slot]), T1);
end;

procedure SndSAttDecay(Slot : Integer);
var
  T1 : Word;

begin
  T1 := GetLocPrm(Slot, prmAttack) shl 4;
  T1 := T1 or (GetLocPrm(Slot, prmDecay) and $F);

  SndOutput($60 + Integer(OffsetSlot[Slot]), T1);
end;

procedure SndSSusRelease(Slot : Integer);
var
  T1 : Word;

begin
  T1 := GetLocPrm(Slot, prmSustain) shl 4;
  T1 := T1 or (GetLocPrm(Slot, prmRelease) and $F);

  SndOutput($80 + Integer(OffsetSlot[Slot]), T1);
end;

procedure SndSAVEK(Slot : Integer);
var
  T1 : Word;

begin
  T1 := 0;

  if GetLocPrm(Slot, prmAm) <> 0 then
    T1 := $80;

  if GetLocPrm(Slot, prmVib) <> 0 then
    Inc(T1, $40);

  if GetLocPrm(Slot, prmStaining) <> 0 then
    Inc(T1, $20);

  if GetLocPrm(Slot, prmKsr) <> 0 then
    Inc(T1, $10);

  Inc(T1, GetLocPrm(Slot, prmMulti) and $F);

  SndOutput($20 + Integer(OffsetSlot[Slot]), T1);
end;

procedure SndWaveSelect(Slot : Integer);
var
  Wave : Word;

begin
  if ModeWaveSel <> 0 then
    Wave := GetLocPrm(Slot, PrmWaveSel) and $03
  else
    Wave := 0;

  SndOutput($E0 + OffsetSlot[Slot], Wave);
end;

procedure SndSetAllPrm (Slot : Integer);
begin
  SndSAmVibRhythm;
  SndSNoteSel;
  SndSKslLevel(Slot);
  SndSFeedFm(Slot);
  SndSAttDecay(Slot);
  SndSSusRelease(Slot);
  SndSAVEK(Slot);
  SndWaveSelect(Slot);
end;

procedure SetSlotParam (Slot : Word; Param : Pointer; WaveSel : Word);
var
  _Param        : PWordArray absolute Param;
  I, K          : Integer;
  Ptr           : PByteArray;

begin
  Ptr := @ParamSlot[Slot, 0];

  for I := 0 to nbLocParam - 2 do
    Ptr^[I] := _Param^[I];

  WaveSel := WaveSel and $3;
  Ptr^[nbLocParam - 1] := WaveSel;
  SndSetAllPrm(Slot);
end;

procedure SetCharSlotParam(Slot : Word; CParam : Pointer; WaveSel : Word);
var
  _CParam       : PByteArray absolute CParam;
  Param         : array [0..nbLocParam - 1] of Word;
  I             : Integer;

begin
  for I := 0 to nbLocParam - 2 do
    Param[I] := _CParam^[I];

  SetSlotParam (Slot, @Param, WaveSel);
end;

procedure InitSlotParams;
var
  I : Integer;

begin
  for I := 0 to 17 do
  begin
    if CarrierSlot[I] <> 0 then
      SetCharSlotParam(I, @PianoParamsOp1, 0)
    else
      SetCharSlotParam(I, @PianoParamsOp0, 0);
  end;

  if Percussion then
  begin
    SetCharSlotParam(12, @BdOpr0, 0);
    SetCharSlotParam(15, @BdOpr1, 0);
    SetCharSlotParam(16, @SdOpr, 0);
    SetCharSlotParam(14, @TomOpr, 0);
    SetCharSlotParam(17, @CymbOpr, 0);
    SetCharSlotParam(13, @HhOpr, 0);
  end;
end;

procedure SndSetPrm(Slot, Prm : Integer);
begin
  case Prm of
    prmPercussion,
    prmAmDepth,
    prmVibDepth         : SndSAmVibRhythm;

    prmNoteSel          : SndSNoteSel;

    prmKsl,
    prmLevel            : SndSKslLevel(Slot);

    prmFm,
    prmFeedBack         : SndSFeedFm(Slot);

    prmAttack,
    prmDecay            : SndSAttDecay(Slot);

    prmRelease,
    prmSustain          : SndSSusRelease(Slot);

    prmMulti,
    prmVib,
    prmStaining,
    prmKsr,
    prmAm               : SndSAVEK(Slot);

    prmWaveSel          : SndWaveSelect (slot);
  end;
end;

procedure SetASlotParam(Slot, Param, Val : Integer);
begin
  ParamSlot[Slot, Param] := Val;
  SndSetPrm(Slot, Param);
end;

procedure UpdateFNums(Voice : Integer);
begin
  BxRegister[Voice] := SetFreq(Voice, VoiceNote[Voice],
    vPitchBend[Voice], VoiceKeyOn[Voice]);
end;

function BoardInstalled : Boolean;
var
  T1, T2, I : Word;

begin
  SndOutput(4, $60);
  SndOutput(4, $80);
  T1 := Port[GenAddr];
  SndOutput(2, $FF);
  SndOutput(4, $21);

  for I := 0 to 199 do
    T2 := Port[GenAddr];

  T2 := Port[GenAddr];
  SndOutput(4, $60);
  SndOutput(4, $80);

  BoardInstalled := ((T1 and $E0) = 0) and ((T2 and $E0) = $C0);
end;

procedure SetMode(Mode : Integer);
begin
  if Mode <> 0 then
  begin
    VoiceNote[Tom] := TomPitch;
    vPitchBend[Tom] := MidPitch;
    UpdateFNums(Tom);

    VoiceNote[Sd] := SdPitch;
    vPitchBend[Sd] := MidPitch;
    UpdateFNums(Sd);
  end;

  Percussion := Mode <> 0;

  if Mode <> 0 then
    ModeVoices := 11
  else
    ModeVoices := 9;

  PercBits := 0;

  InitSlotParams;
  SndSAmVibRhythm;
end;

procedure SetGParam (AmD, VibD, NSel : Integer);
begin
  AmDepth := AmD;
  VibDepth := VibD;
  NoteSel := NSel;

  SndSAmVibRhythm;
  SndSNoteSel;
end;

procedure SetPitchRange(pR : Word);
begin
  if pR > 12 then
    pR := 12;

  if pR < 1 then
    pR := 1;

  PitchRange := pR;
end;

procedure SetWaveSel(State : Integer);
var
  I : Integer;

begin
  if State <> 0 then
    ModeWaveSel := $20
  else
    ModeWaveSel := 0;

  for I := 0 to 17 do
    SndOutput($E0 + OffsetSlot[I], 0);

  SndOutput(1, ModeWaveSel);
end;

procedure SoundWarmInit;
var
  I : Integer;

begin
  for I := 1 to $F5 do
    SndOutput(I, 0);

  SndOutput(4, 6);

  for I := 0 to 8 do
  begin
    vPitchBend[I] := MidPitch;
    VoiceKeyOn[I] := 0;
    VoiceNote[I] := 0;
  end;

  for I := 0 to 10 do
    LVoiceVolume[I] := MaxVolume;

  SetMode(0);
  SetGParam(0, 0, 0);
  SetPitchRange(1);
  SetWaveSel(1);
end;

function SoundColdInit(Port : Word) : Boolean;
var
  Hardware : Boolean;

begin
  GenAddr := Port;
  Hardware := BoardInstalled;
  SoundWarmInit;

  SoundColdInit := HardWare;
end;

procedure SetVoiceTimbre (Voice : Word; ParamArray : Pointer);
var
  Wave0, Wave1          : Word;
  Prm1                  : Pointer;
  _ParamArray           : PWordArray absolute ParamArray;
  Slots                 : Word;

begin
  if Voice >= ModeVoices then
    Exit;

  Wave0 := _ParamArray^[2 * (nbLocParam - 1)];
  Wave1 := _ParamArray^[2 * (nbLocParam - 1) + 1];
  Prm1 := @_ParamArray^[nbLocParam - 1];

  if Percussion then
    Slots := Word(SlotPVoice[Voice])
  else
    Slots := Word(SlotMVoice[Voice]);

  SetSlotParam(Lo(Slots), _ParamArray, Wave0);

  if Hi(Slots) <> 255 then
    SetSlotParam(Hi(Slots), Prm1, Wave1);
end;

procedure SetVoiceVolume(Voice, Volume : Word);
var
  Slots : Word;

begin
  if Voice >= ModeVoices then
    Exit;

  if Volume > MaxVolume then
    Volume := MaxVolume;

  LVoiceVolume[Voice] := Volume;

  if Percussion then
    Slots := Word(SlotPVoice[Voice])
  else
    Slots := Word(SlotMVoice[Voice]);

  SndSKslLevel(Lo(Slots));

  if Hi(Slots) <> 255 then
    SndSKslLevel(Hi(Slots));
end;

procedure SetVoicePitch(Voice, PitchBend : Word);
begin
  if ((not Percussion) and (Voice < 9)) or (Voice <= Bd) then
  begin
    if PitchBend > MaxPitch then
      PitchBend := MaxPitch;

    vPitchBend[Voice] := PitchBend;
    UpdateFNums(Voice);
  end;
end;

procedure NoteOn(Voice : Word; Pitch : Integer);
begin
  Dec(Pitch, MidC - ChipMidC);
  if Pitch < 0 then
    Pitch := 0;

  if ((not Percussion) and (Voice < 9)) or (Voice < Bd) then
  begin
    VoiceNote[Voice] := Pitch;
    VoiceKeyOn[Voice] := $20;
    UpdateFNums(Voice);
  end
  else
    if Percussion and (voice <= Hihat) then
    begin
      if Voice = Bd then
      begin
        VoiceNote[Bd] := Pitch;
        UpdateFNums(Voice);
      end
      else
        if Voice = Tom then
        begin
          if VoiceNote[Tom] <> Pitch then
          begin
            VoiceNote[Tom] := Pitch;
	    VoiceNote[Sd] := Pitch + TomToSd;
            UpdateFNums(Tom);
            UpdateFNums(Sd);
          end;
        end;

      PercBits := PercBits or (PercMasks[Voice - Bd]);
      SndSAmVibRhythm;
    end;
end;

procedure NoteOff(Voice : Word);
begin
  if ((not percussion) and (Voice < 9)) or (voice < Bd) then
  begin
    VoiceKeyOn[Voice] := 0;
    BxRegister[Voice] := BxRegister[Voice] and (not $20);
    SndOutput($B0 + Voice, BxRegister[Voice]);
  end
  else
    if Percussion and (Voice <= Hihat) then
    begin
      PercBits := PercBits and (not PercMasks[Voice - Bd]);
      SndSAmVibRhythm;
    end;
end;

end.
