(*-------------------------------------------------------------*)
(*                 IMS ŝe A                               *)
(*                                                             *)
(*  q : IMPDEMO.C                                         *)
(*                                                             *)
(*  ee : w                                            *)
(*                                                             *)
(*  a : IMSUNIT.PAS                                       *)
(*                                                             *)
(*  a : w҅ (  wba 2 be )                   *)
(*                  ( HiTEL, 埡e : komh )                   *)
(*                                                             *)
(*  ai : 1995 e 01  15                                *)
(*           qe                                            *)
(*                                                             *)
(*  ai : 1995 e 07  01                                *)
(*           a  iq                            *)
(*-------------------------------------------------------------*)

{$F+,O+,X+}
unit ImsUnit;

interface

  procedure LoadBnk(BnkName : string);
  procedure LoadIms(Name : string);
  procedure PlayIms;
  procedure EndIms;

implementation

uses
  AdLib, Timer, BaseUnit, FileUnit;

var
  ByteSize,
  CurByte       : Longint;
  InsName       : PCharArray;
  ImsData       : array [0..5] of PByteArray;
  InsData       : PIntArray;
  DMode         : Integer;
  BasicTempo    : Integer;
  InsNum        : Integer;
  ChNum         : Integer;
  CurIns        : PIntArray;
  CurVol        : array [0..10] of Integer;
  PageNum       : Word;
  PageEtc       : Word;

procedure LoadBnk(BnkName : string);
var
  I, J, InsCount   : Integer;
  InsMaxNum        : Word;
  InsCurNum        : Word;
  Num              : Word;
  InsListOff       : Longint;
  InsDataOff       : Longint;
  CurFP            : Longint;
  T1               : PCharArray;
  Name             : array [0..8] of Char;
  T2               : PIntArray;
  FP               : File;

begin
  if BnkName <> '' then
    Assign(FP, BnkName)
  else
    Assign(FP, 'STANDARD.BNK');

  {$I-}
  Reset(FP, 1);
  {$I+}
  if IOResult <> 0 then
    Halt(0);

  FSeek(FP, 8, SeekSet);
  BlockRead(FP, InsMaxNum, 2);

  FSeek(FP, 2, SeekCur);
  BlockRead(FP, InsListOff, 4);
  BlockRead(FP, InsDataOff, 4);

  FSeek(FP, InsListOff, SeekSet);

  InsCurNum := 0;
  InsCount := 0;
  while (InsCurNum < InsMaxNum) and (InsCount < InsNum) do
  begin
    BlockRead(FP, Num, 2);

    FSeek(FP, 1, SeekCur);
    BlockRead(FP, Name, 9);

    I := 0; J := 0;
    while (I < InsNum) and (J < 8) do
    begin
      T1 := @InsName^[I * 9];
      T2 := @InsData^[I * 28];

      J := 0;
      while (UpCase(T1^[J]) = UpCase(Name[J])) and (J < 8) do
        Inc(J);

      Inc(I);
    end;

    if J = 8 then
    begin
      CurFP := FilePos(FP);
      FSeek(FP, InsDataOff + Longint(Num) * 30 + 2, SeekSet);

      for J := 0 to 27 do
        T2^[J] :=  FGetC(FP);

      FSeek(FP, CurFP, SeekSet);

      Inc(InsCount);
    end;

    Inc(InsCurNum);
  end;

  Close(FP);
end;

procedure LoadIms(Name : string);
var
  I, J, TS : Integer;
  CPBLen   : Longint;
  T1       : PCharArray;
  ImsName  : array [0..29] of Char;
  FP       : File;

begin
  Assign(FP, Name);
  {$I-}
  Reset(FP, 1);
  {$I+}
  if IOResult <> 0 then
    Halt(0);

  FSeek(FP, 6, SeekSet);
  BlockRead(FP, ImsName, 30);

  FSeek(FP, 58, SeekSet);
  DMode := FGetC(FP);
  ChNum := 9 + DMode * 2;

  FSeek(FP, 42, SeekSet);
  BlockRead(FP, ByteSize, 4);

  FSeek(FP, 60, SeekSet);
  BlockRead(FP, BasicTempo, 2);

  FSeek(FP, 71, SeekSet);
  PageNum := ByteSize div 32768;

  for I := 0 to PageNum - 1 do
  begin
    GetMem(ImsData[I], 32768);
    BlockRead(FP, ImsData[I]^, 32768);
  end;

  PageEtc := ByteSize mod 32768;
  if PageEtc <> 0 then
  begin
    GetMem(ImsData[PageNum], PageEtc);
    BlockRead(FP, ImsData[PageNum]^, PageEtc);
  end;

  FSeek(FP, 1, SeekCur);
  BlockRead(FP, InsNum, 2);

  GetMem(InsName, InsNum * 9);
  GetMem(InsData, InsNum * 56);
  BlockRead(FP, InsName^, InsNum * 9);

  Close(FP);
end;

procedure PlayIms;
var
  I : Integer;

begin
  SoundColdInit($388);
  SetMode(DMode);

  for I := 0 to ChNum - 1 do
  begin
    CurVol[I] := 0;
    NoteOff(I);
    SetVoiceVolume(I, 0);
  end;

  CurByte := 0;
  StartTimeOut(10);
end;

procedure EndIms;
var
  I : Integer;

begin
  FreeMem(InsData, InsNum * 56);
  FreeMem(InsName, InsNum * 9);

  for I := 0 to PageNum - 1 do
    FreeMem(ImsData[I], 32768);

  if PageEtc <> 0 then
    FreeMem(ImsData[PageNum], PageEtc);

  for I := 0 to ChNum - 1 do
  begin
    NoteOff(I);
    SetVoiceVolume(I, 0);
  end;

  SetClkRate(0);
end;

function ReadMem(Cub : Longint) : Byte;
var
  Pg, Rm    : Word;

begin
  Pg := Cub div 32768;
  Rm := Cub mod 32768;

  ReadMem := ImsData[Pg]^[Rm];
end;

(*-----------------------------------*)
(*    Play Routine                   *)
(*-----------------------------------*)
procedure InsRt(Ch : Integer);
var
  Tibre : Pointer;

begin
  Tibre := @InsData^[ReadMem(CurByte) * 28];
  Inc(CurByte);

  SetVoiceTimbre(Ch, Tibre);
end;

procedure VolRt(Ch : Integer);
begin
  CurVol[Ch] := ReadMem(CurByte);
  Inc(CurByte);

  SetVoiceVolume(Ch, CurVol[Ch]);
end;

procedure PitRt(Ch : Integer);
var
  Data1 : Word;

begin
  Data1 := ReadMem(CurByte + 1) shl 8;
  Inc(Data1, ReadMem(CurByte));
  Data1 := Data1 shr 1;

  SetVoicePitch(Ch, Data1);
  Inc(CurByte, 2);
end;

procedure TemRt;
var
  Data1, Data2 : Integer;
  Rate         : Word;
  TTem         : Longint;

begin
  Inc(CurByte, 2);

  Data1 := ReadMem(CurByte);
  Inc(CurByte);

  Data2 := ReadMem(CurByte);
  Inc(CurByte);

  TTem := BasicTempo;
  TTem := ((TTem * Data2) div 128) + BasicTempo * Data1;
  Rate := 298295 div TTem;

  SetClkRate(Rate);
  Inc(CurByte);
end;

procedure Note1Rt(Ch : Integer);
var
  Data1 : Integer;

begin
  Data1 := ReadMem(CurByte + 1);
  NoteOff(Ch);

  If CurVol[Ch] <> Data1 then
  begin
    CurVol[Ch] := Data1;
    SetVoiceVolume(Ch, Data1);
  end;

  NoteOn(Ch, ReadMem(CurByte));
  Inc(CurByte, 2);
end;

procedure Note2Rt(Ch : Integer);
var
  Data1 : Integer;

begin
  Data1 := ReadMem(CurByte + 1);
  NoteOff(Ch);

  if Data1 <> 0 then
  begin
    if CurVol[Ch] <> Data1 then
    begin
      CurVol[Ch] := Data1;
      SetVoiceVolume(Ch, Data1);
    end;

    NoteOn(Ch, ReadMem(CurByte));
  end;

  Inc(CurByte, 2);
end;

function TimeOut : Integer;
const
  IdCodeSt : Integer = 0;

var
  Ch, IdCode, TDelay : Integer;

begin
  IdCode := ReadMem(CurByte);

  if IdCode < $80 then
    IdCode := IdCodeSt
  else
  begin
    Inc(CurByte);
    IdCodeSt := IdCode;
  end;

  Ch := IdCode and $0F;
  case (IdCode and $F0) of
    $C0 : InsRt(Ch);
    $A0 : VolRt(Ch);
    $E0 : PitRt(Ch);
    $F0 : TemRt;
    $80 : Note1Rt(Ch);
    $90 : Note2Rt(Ch);
  end;

  TDelay := 0;

  repeat
    Ch := ReadMem(CurByte);
    Inc(CurByte);

    if ReadMem(CurByte) = $FC then
      CurByte := 0;

    Inc(TDelay, 240);
  until Ch <> $F8;

  Dec(TDelay, 240);

  if Ch <> 0 then
    Inc(TDelay, Ch);

  TimeOut := TDelay;
end;

begin
  Timer.TimeOut := TimeOut;
end.
