(*-------------------------------------------------------------*)
(*                Timer ŝe A                              *)
(*                                                             *)
(*  ee : w҅ (  wba 1 be )                   *)
(*                  ( HiTEL, 埡e : komh )                   *)
(*                                                             *)
(*  ee : 1995 e 01  14                                *)
(*-------------------------------------------------------------*)

unit Timer;

interface

var
  TimeOut : function : Integer;

  procedure SetInt(State : Integer);
  procedure SetClkRate(Count : Word);
  procedure ClkInstall;
  procedure ClkUninstall;
  procedure StartTimeOut(Delay : Integer);

implementation

uses
  Dos;

const
  TimerIntr     = $08;

var
  ClkDivH       : Word;
  ClkDivL       : Word;
  ClkMod        : Word;
  OldInt08      : procedure;
  SoundDelay    : Word;
  UserRoutineOn : Boolean;

procedure ClkRate; assembler;
asm
	PUSH    AX
	MOV     AL, 00110110b
	OUT     43h, AL
	POP     AX
	OUT     40h, AL
	XCHG	AH, AL
	OUT     40h, AL
	XCHG	AH, AL
end;

procedure ClkInt; interrupt; assembler;
asm
	MOV     AX, ClkDivL
	ADD     ClkMod, AX
	MOV     AX, ClkDivH
	ADC     AX, 0
	JNZ     @@ClkInt8

	MOV     AL, 00100000b
	OUT     20h, AL
	JMP     @@ClkInt7

@@ClkInt8:
	PUSHF
	CALL	OldInt08

@@ClkInt7:
	DEC     SoundDelay
	JNZ     @@ClkIntEnd

	CMP     UserRoutineOn, False
	JNZ     @@ClkIntEnd

@@GoUser:
	INC     UserRoutineOn

        STI
	CALL    TimeOut
        CLI

	DEC     UserRoutineOn

	MOV     BX, SoundDelay
	NEG     BX
	CMP     BX, AX
	JB      @@ClkDelayOk

	MOV     SoundDelay, 0
	JMP     @@GoUser

@@ClkDelayOk:
	ADD     SoundDelay, AX

	STI

@@ClkIntEnd:
end;

procedure SetInt(State : Integer); assembler;
asm
	CMP     State, 0
	JNE     @@SOn

	CLI
	JMP     @@SEnd

@@SOn:
	STI

@@SEnd:
	POP     BP
end;

procedure SetClkRate(Count : Word); assembler;
asm
	MOV     AX, Count
	PUSHF
	CLI
	MOV     ClkDivL, AX
	CMP     AX, 1
	MOV     ClkDivH, 0
	ADC     ClkDivH, 0
	CALL	ClkRate
	POPF
end;

procedure ClkInstall;
begin
  asm
	XOR     AX, AX
	CALL	ClkRate

	MOV     ClkDivH, 1
	MOV     ClkDivL, AX
	MOV     ClkMod, AX
        MOV     UserRoutineOn, False
  end;

  GetIntVec(TimerIntr, @OldInt08);
  SetIntVec(TimerIntr, @ClkInt);
end;

procedure ClkUninstall;
begin
  asm
	XOR     AX, AX
	CALL    ClkRate
  end;

  SetIntVec(TimerIntr, @OldInt08);
end;

procedure StartTimeOut(Delay : Integer); assembler;
asm
	PUSHF
	CLI
	MOV     AX, Delay
	MOV     SoundDelay, AX
	POPF
end;

end.
