/*

	XRAINBOW

	BMP.C

*/

#include <stdio.h>
#include <stdlib.h>

#include "bc.h"
#include "xga.h"
#include "pal.h"
#include "bmp.h"

BOOL  GetBmpInfo(char *name,BITMAPINFOHEADER *Bi)
{
	FILE *fp;
	BITMAPFILEHEADER bf;
	fp = fopen(name,"rb");
	if(fp==NULL) return FALSE;

	fread(&bf,1,sizeof(BITMAPFILEHEADER),fp);
	fread(Bi,1,sizeof(BITMAPINFOHEADER),fp);
	fclose(fp);
	return TRUE;
}

BOOL  GetBmpSprite(_SPRITE *S,char *name,short opt)
{
	int i;
	BOOL ret=TRUE;
	FILE *fp;
	char *buffer;

	PALETTEENTRY *ape;
	BITMAPFILEHEADER bf;
	BITMAPINFOHEADER bi;

	fp = fopen(name,"rb");
	if(fp==NULL) return FALSE;

	fread(&bf,1,sizeof(BITMAPFILEHEADER),fp);
	fread(&bi,1,sizeof(BITMAPINFOHEADER),fp);

	if(bf.bfType!=0x4D42) ret=FALSE;
	else if(bi.biSize!=sizeof(BITMAPINFOHEADER)) ret=FALSE;
	else if(bi.biBitCount>8) ret=FALSE;
	else if(bi.biCompression) ret=FALSE;
	else if(bi.biClrUsed==0) bi.biClrUsed=256;

	if(ret==TRUE) {
		ape=(PALETTEENTRY*)malloc(sizeof(PALETTEENTRY)*bi.biClrUsed);
		fread(ape,sizeof(PALETTEENTRY),bi.biClrUsed,fp);
		if(opt) {
			for(i=0;i<256;i++) {
				R[i] = ape[i].peBlue>>2;
				G[i] = ape[i].peGreen>>2;
				B[i] = ape[i].peRed>>2;
			}
			if(opt==1) SetRgb(0,MAX_COLOR,1);
		}
		free(ape);
		S->data = (char *) malloc(bi.biWidth*bi.biHeight);
		if(S->data==NULL) ret = FALSE;
		else {
			buffer = S->data+bi.biWidth*bi.biHeight;
			buffer -= bi.biWidth;
			for(i=0;i<bi.biHeight;i++) {
				fread(buffer,bi.biWidth,1,fp);
				buffer-=bi.biWidth;
			}
			S->xs = bi.biWidth;
			S->ys = bi.biHeight;
		}
	}
	fclose(fp);
	return ret;
}

BOOL  ViewBmp(short x,short y,char *name,short opt)
{
	_SPRITE S;
	BOOL ret;
	ret = GetBmpSprite(&S,name,opt);
	if(ret==TRUE) {
		if(x==MAXX) { x=(MAXX-S.xs)/2;}
		if(y==MAXY) { y=(MAXY-S.ys)/2;}
		PutImage(x,y,&S,COPY_PUT|FREE_PUT);
	}
	return (BOOL)ret;
}

BOOL  WriteBmp(_SPRITE *S ,char *name)
{
    	int i;
	char *buffer;
	FILE *fp;
	PALETTEENTRY ape[256];
	BITMAPFILEHEADER bf;
	BITMAPINFOHEADER bi;
	if(!S->xs || !S->ys) return FALSE;

	bi.biSize = sizeof(BITMAPINFOHEADER);
	bi.biWidth = S->xs;
	bi.biHeight = S->ys;
	bi.biPlanes = 1;
	bi.biBitCount = 8;
	bi.biCompression = 0;
	bi.biSizeImage = (long)S->xs * (long)S->ys;
	bi.biXPelsPerMeter = 0;
	bi.biYPelsPerMeter = 0;
	bi.biClrUsed = 0 ;
	bi.biClrImportant = 0;

	bf.bfType = 0x4D42;//
	bf.bfSize = sizeof(BITMAPINFOHEADER) + sizeof(BITMAPFILEHEADER) +
			bi.biSizeImage + sizeof(ape);
	bf.bfReserved1 = 0;
	bf.bfReserved2 = 0;
	bf.bfoffBits = 1078;// offset

	for(i=0;i<256;i++) {
		ape[i].peBlue = R[i]<<2;
		ape[i].peGreen = G[i]<<2;
		ape[i].peRed = B[i]<<2;
	}

	fp = fopen(name,"wb");
	if(fp==NULL) return FALSE;

	fwrite(&bf,1,sizeof(BITMAPFILEHEADER),fp);
	fwrite(&bi,1,sizeof(BITMAPINFOHEADER),fp);
	fwrite(ape,sizeof(ape),1,fp);

	buffer = S->data+bi.biWidth*bi.biHeight;
	buffer -= bi.biWidth;
	for(i=0;i<bi.biHeight;i++) {
		fwrite(buffer,bi.biWidth,1,fp);
		buffer-=bi.biWidth;
	}

	fclose(fp);
	return TRUE;
}

/*
void main(int argc,char *argv[])
{
	InitXrainbow(R640x480,AUTODETECT);
	InitHan("han1.fnt","eng1.fnt");
	if(argv[1]!=NULL) ViewBmp(MAXX,MAXY,argv[1],1);
	KeyWait();
	CloseXrainbow();
}
*/


