#ifndef __BMP_H
#define __BMP_H

typedef struct tagPALETTEENTRY
{
    BYTE    peRed;
    BYTE    peGreen;
    BYTE    peBlue;
    BYTE    peFlags;
} PALETTEENTRY;

typedef struct tagRGBQUAD
{
    BYTE    rgbBlue;
    BYTE    rgbGreen;
    BYTE    rgbRed;
    BYTE    rgbReserved;
} RGBQUAD;
typedef RGBQUAD* LPRGBQUAD;

typedef struct tagBITMAPINFOHEADER
{
	DWORD   biSize;            // Size of the structure
	LONG    biWidth;           // Width in Pixels
	LONG    biHeight;          // Height in Pixels
	WORD    biPlanes;          // Set to 1
	WORD    biBitCount;        // Color bits per pixel
	DWORD   biCompression;     // Compression scheme
	DWORD   biSizeImage;       // Number of Bitmap bytes
	LONG    biXPelsPerMeter;   // Horizontal resolution
	LONG    biYPelsPerMeter;   // Vertical resolution
	DWORD   biClrUsed;         // Number of colors Used
	DWORD   biClrImportant;    // Important colors
} BITMAPINFOHEADER;

typedef BITMAPINFOHEADER*      PBITMAPINFOHEADER;

typedef struct tagBITMAPINFO
{
    BITMAPINFOHEADER bmiHeader;
    RGBQUAD          bmiColors[1];
} BITMAPINFO;
typedef BITMAPINFO* PBITMAPINFO;

typedef struct tagBITMAPFILEHEADER
{
    WORD   bfType;         // "BM" or 0x4D42
    DWORD  bfSize;         // Size of the file in bytes
    WORD   bfReserved1;    // Set to 0
    WORD   bfReserved2;    // Set to 0
    DWORD  bfoffBits;      // Offset in file where
} BITMAPFILEHEADER;

typedef BITMAPFILEHEADER*      PBITMAPFILEHEADER;


BOOL  GetBmpInfo(char *name,BITMAPINFOHEADER *Bi);

BOOL  GetBmpSprite(_SPRITE *S,char *name,short opt);

BOOL  ViewBmp(short x,short y,char *name,short opt);

BOOL  WriteBmp(_SPRITE *S , char *name);

#endif

