/*

	Animator Pro fli & flc player

        A 12a A baw

*/

#include <fcntl.h>
#include <dos.h>
#include <io.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "bc.h"
#include "xga.h"
#include "pal.h"
#include "flic.h"

static void  _Screen_Repeat_Two(short x,short y,Pixel2 p2,short count);
static void  _Screen_Repeat_One(short x,short y,BYTE data,short count);
static void  _Write_Dac(short start,short count,BYTE *dac);
static void  _Decode_Color_256(BYTE *data);
static void  _Decode_Color_64(BYTE *data);
static void  _Decode_Byte_Run(BYTE *data,_FLIC *flic);
static void  _Decode_Delta_Fli(BYTE *data,_FLIC *flic);
static void  _Decode_Delta_Flc(BYTE *data,_FLIC *flic);
static void  _Decode_Black(_FLIC *flic);
static void  _Decode_Literal(BYTE *data,_FLIC *f);
static short _Flic_Open(_FLIC *f,char *name);
static short _Decode_Frame(_FLIC *flic,FrameHead *fr);

void RepeatFlic(_FLIC *P)
{
	if(P->frame_state==-1) return;
	P->frame_state=0;
	lseek(P->handle,P->head.oframe2,SEEK_SET);
}

short  FlicNextFrame(_FLIC *P)
{
	FrameHead head;
	long fpos;

	if(P->frame_state<0) return P->frame_state;
	fpos=tell(P->handle);
	if(read(P->handle,&head,sizeof(head))==-1) return -1;
	_Decode_Frame(P,&head);
	lseek(P->handle,fpos+head.size,SEEK_SET);
	P->frame_state++;
	if(P->frame_state>=P->head.frames) return 1;
	return 0;
}

short FlicPlay(short x,short y,_FLIC *P,char *fname,BYTE opt)
{
	long max_buffsize;
	P->yoff=P->xoff=P->frame_state=0;
	if(_Flic_Open(P,fname)==-1) {
		P->frame_state=-1;
		return -1;
	}
	P->opt=opt;
	P->tick=P->head.speed*=18L/1000L;
	max_buffsize=(long)P->head.width*P->head.height + 7102L;
	P->FrameBuff=(char *)malloc(max_buffsize);

	if(P->FrameBuff==NULL) {
		close(P->handle);
		P->frame_state=-2;
		return -2;
	}

	if(x==MAXX) { P->xoff=(MAXX-P->head.width)/2;}
	else P->xoff=x;
	if(y==MAXY) { P->yoff=(MAXY-P->head.height)/2;}
	else P->yoff=y;

	if(P->head.type==FLI_TYPE) P->head.oframe2=tell(P->handle);
	return 1;
}

void CloseFlic(_FLIC *P)
{
	if(P->frame_state==-1) return;
	if(P->frame_state!=-2) free(P->FrameBuff);
	close(P->handle);
	if(P->opt==1) GetRgb();
}

///////////////////////////// static function ///////////////////////////////

static void _Screen_Repeat_Two(short x,short y,Pixel2 p2,short count)
{
	short  i,j=0;
	BYTE   buffer[1030];
	for(i=0;i<count;i++) {
		*(buffer+j++)=p2.pixels[0];
		*(buffer+j++)=p2.pixels[1];
	}
	Psets(x,y,buffer,count*2);
}

static void _Screen_Repeat_One(short x,short y,BYTE data,short count) /* o.k */
{
	LineH(x,count+x-1,y,data);
}

static void _Write_Dac(short start,short count,BYTE *dac) /* o.k */
{
	short i,max = count *3;
	outp(0x03c8,start);
	for(i=0;i<max;i++) outp(0x03c9,*dac++);
}

static void _Decode_Color_256(BYTE *data) /* o.k */
{
	signed short start = 0,i;
	BYTE *cbuf = (BYTE *)data;
	signed short *wp = (short *)cbuf;
	signed short ops;
	signed short count;

	ops = *wp;
	cbuf += sizeof(*wp);

	while(--ops >=0) {
		start += *cbuf++;
		if((count = *cbuf++) == 0) count = 256;
		for( i=0 ; i< (3*count) ; i++) 	*(cbuf+i) = *(cbuf+i) >>2;
		_Write_Dac(start,count,cbuf);
		cbuf += (3*count);
		start += count;
	}
}

static void _Decode_Color_64(BYTE *data) /* o.k */
{
	signed short start = 0;
	BYTE *cbuf = (BYTE *)data;
	signed short *wp = (short *)cbuf;
	signed short ops;
	signed short count;

	ops = *wp;
	cbuf +=sizeof(*wp);

	while (--ops >=0) {
		start += *(cbuf++);
		if( (count = *cbuf++) == 0) count = 256;
		_Write_Dac(start,count,cbuf);
		cbuf += 3*count;
		start += count;
	}
}

static void _Decode_Byte_Run(BYTE *data,_FLIC *flic) /* o.k */
{
	short  x,y;
	short  width  = flic ->head.width;
	short  height = flic ->head.height;
	signed char   psize;
	BYTE   *cpt = data;
	short  end;

	y=flic->yoff;
	end=flic->xoff+width;

	while( --height >=0) {
		x=flic ->xoff;
		cpt +=1;
		psize = 0;

		while((x+=psize) <end) {
			psize = *cpt++;
			if(psize >0) {
				_Screen_Repeat_One(x,y,*cpt++,psize);
			}
			else {
				psize = -psize;
				Psets(x,y,cpt,psize);
				cpt += psize;
			}
		}
		y++;
	}
}

static void _Decode_Delta_Fli(BYTE *data,_FLIC *flic)
{
	short *wpt = (short *)data;
	BYTE  *cpt = (BYTE *)(wpt+2);
	short xorg= flic ->xoff;
	short yorg= flic ->yoff;
	short x,y;
	short lines;
	BYTE  opcount;
	signed char  psize;

	y = yorg + *wpt++;
	lines = *wpt;

	while (--lines >=0) {
		x=xorg;
		opcount = *cpt++;
		while (opcount >0) {
			x+= *cpt++;
			psize = *cpt++;
			if(psize <0) {
				psize = -psize;
				_Screen_Repeat_One(x,y,*cpt++,psize);
				x += psize;
				opcount -=1;
			}else {
				Psets(x,y,(char *)cpt,psize);
				cpt+=psize;
				x += psize;
				opcount -=1;
			}
		}
		y++;
	}
}

static void _Decode_Delta_Flc(BYTE *data,_FLIC *flic)
{
	short xorg= flic ->xoff;
	short yorg= flic ->yoff;
	short width = flic ->head.width;
	short x,y;
	short lp_count;
	short opcount;
	short psize;
	union {
		short *w;
		BYTE  *ub;
		signed char  *b;
		Pixel2 *p2;
	}wpt;
	short lastx=xorg + width -1;

	wpt.ub = data;
	lp_count = *wpt.w++;
	y = yorg;

	goto LPACK;

	SKIPLINES :
		y-=opcount;
	LPACK:
		opcount = *wpt.w++;
		if(opcount>=0) { goto DO_SS2OPS; }
		if( ((unsigned short)opcount) & 0x4000) { goto SKIPLINES; }
		PutPixel(lastx,y,opcount);
		if((opcount = *wpt.w++) ==0) {
			++y;
			if(--lp_count >0) { goto LPACK; }
			return;
		}
	DO_SS2OPS:
		x= xorg;
	PPACK:
		x += *wpt.ub++;
		psize = *wpt.b++;
		if((psize += psize) >=0 ) {
			Psets(x,y,wpt.ub,psize);
			x+=psize;
			wpt.ub+=psize;
			if( --opcount != 0) { goto PPACK; }
			++y;
			if( --lp_count >0) { goto LPACK; }
		} else {
			psize = -psize;
			_Screen_Repeat_Two(x,y,*wpt.p2++,psize>>1);
			x+=psize;
			if(--opcount !=0) { goto PPACK; }
			++y;
			if(--lp_count>0) { goto LPACK; }
		}
}

static void _Decode_Black(_FLIC *flic)
{
	short i;
	for(i=flic->yoff ; i<flic->head.height ; i++)
		_Screen_Repeat_One(flic->xoff,flic->yoff,0,flic->head.width);
}

static void _Decode_Literal(BYTE *data,_FLIC *f)
{
	short i;
	short heigth = f->head.height;
	short width = f->head.width;
	short x = f->xoff;
	short y = f->yoff;

	for (i=0;i<heigth;++i) {
		Psets(x,y+i,data,width);
		data += width;
	}
}

static short _Flic_Open(_FLIC *f,char *name)
{
	if( (f->handle=open(name,O_RDONLY | O_BINARY))==-1) return -1;
	if( read(f->handle,&f->head,sizeof(f->head))==-1) {
		close(f->handle);
		return -1;
	}
	f->name=name;
	if(f->head.type==FLC_TYPE) {
		lseek(f->handle,f->head.oframel,SEEK_SET);
		return 0;
	}

	if(f->head.type==FLI_TYPE) {
		f->head.oframel=sizeof(f->head);
		f->head.speed=f->head.speed*1000L/70L;
		return 0;
	}

	close(f->handle);
	return -1;
}

static short _Decode_Frame(_FLIC *flic,FrameHead *fr)
{
	short i;
	long fpos;
	ChunkHead chunk;

	for(i=0;i<fr->chunks;i++) {
		fpos=tell(flic->handle);
		if(read(flic->handle,&chunk,sizeof(chunk))==-1) return -1;
		if(read(flic->handle,flic->FrameBuff,
			(UINT)(chunk.size-sizeof(chunk)))==-1) return -1;

		switch(chunk.type) {
			case COLOR_256:
				if(flic->opt==1) _Decode_Color_256(flic->FrameBuff);
				break;
			case DELTA_FLC:	_Decode_Delta_Flc(flic->FrameBuff,flic);
					break;
			case COLOR_64:
				if(flic->opt==1) _Decode_Color_64(flic->FrameBuff);
				break;
			case DELTA_FLI:	_Decode_Delta_Fli(flic->FrameBuff,flic);
				      break;
			case BLACK_CLS:	_Decode_Black(flic);
				      break;
			case BYTE_RUN:_Decode_Byte_Run(flic->FrameBuff,flic);
				      break;
			case LITERAL: _Decode_Literal(flic->FrameBuff,flic);
				      break;
			default: break;
		}
		lseek(flic->handle,fpos+chunk.size,SEEK_SET);
	}
	return 0;
}

/*
one time play

void main()
{
	short ret;
	_FLIC FFF;

	InitXrainbow(R640x480,AUTODETECT);
        FlicPlay(MAXX,MAXY,&FFF,"test1.flc",1); //e wA b

	while(1) {
		if(FlicNextFrame(&FFF)==1) break;
		if(_KBHIT)break;
	}

	FlicEnd(&FFF);

	CloseXrainbow();
}
*/

/*
repeat play

void main()
{
	short ret;
	_FLIC FFF;

	InitXrainbow(R640x480,AUTODETECT);
        FlicPlay(MAXX,MAXY,&FFF,"test1.flc",1); // e wA b
	FlicNextFrame(&FFF);
	RepeatFlic(&FFF);

	while(1) {
		if(FlicNextFrame(&FFF)==1) {
			RepeatFlic(&FFF);
		}
		if(_KBHIT)break;
	}
	FlicEnd(&FFF);

	CloseXrainbow();
*/

