/*


	Animator Pro fli & flc player



*/

#ifndef __FLIC_H
#define	__FLIC_H

#define	FLC_TYPE		0xaf12
#define	FLI_TYPE		0xaf11

#define FRAME_TYPE		0XF1FA
#define COLOR_256		4
#define	DELTA_FLC		7
#define COLOR_64		11
#define	DELTA_FLI		12
#define BLACK_CLS		13
#define BYTE_RUN		15
#define LITERAL			16
#define PSTAMP			18

typedef struct {
	long  size;
	WORD  type;
	short frames;
	short width,height;
	short depth;
	short flags;
	long  speed;
	char  reservedl[18];
	short aspectx,aspecty;
	char  reserved2[38];
	long  oframel,oframe2;
	char  reserved3[40];
}FlicHead;

typedef struct {
	FlicHead head;
	short handle;
	short frame;
	char  *name;
	short xoff,yoff;
	short frame_state;
	char  *FrameBuff;
	BYTE  opt;
	WORD  tick;
}_FLIC;

typedef struct {
	long size;
	WORD type;
	short chunks;
	char reserved[8];
}FrameHead;

typedef struct {
	long size;
	WORD type;
}ChunkHead;

typedef struct {
	char pixels[2];
}Pixel2;

void  RepeatFlic(_FLIC *P);
short FlicNextFrame(_FLIC *P);
short FlicPlay(short x,short y,_FLIC *P,char *fname,BYTE opt);
void  CloseFlic(_FLIC *P);

#endif

