/*

	XRAINBOW

	GIF.C

*/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <process.h>
#include <fcntl.h>
#include <string.h>

#include "bc.h"
#include "xga.h"
#include "pal.h"
#include "gif.h"

#define MAX_CODES     4096

static short curr_size;
static short clear;
static short ending;
static short newcodes;
static short top_slot;
static short slot;
static short navail_bytes = 0;
static short nbits_left = 0;
static BYTE  b1;
static BYTE  byte_buff[257];
static BYTE *pbytes;
static BYTE *stack;
static BYTE *suffix;
static WORD *prefix;

static DWORD code_mask[13] =
{
   0L,
   0x0001L, 0x0003L,
   0x0007L, 0x000FL,
   0x001FL, 0x003FL,
   0x007FL, 0x00FFL,
   0x01FFL, 0x03FFL,
   0x07FFL, 0x0FFFL
};

static short _get_next_code(FILE *fp)
{
	short i;
	static DWORD ret;

	if (!nbits_left)  {
		if (navail_bytes <= 0) {
			pbytes = byte_buff;
			navail_bytes = getc(fp);
			if (navail_bytes)  {
				for (i = 0; i < navail_bytes; ++i )
					*(byte_buff + i) = getc( fp );
			}
		}
		b1 = *pbytes++;
		nbits_left = 8;
		--navail_bytes;
	}

	ret = b1 >> (8 - nbits_left);
	while (curr_size > nbits_left)   {
		if (navail_bytes <= 0) {
			pbytes = byte_buff;
			navail_bytes = getc(fp);
			if (navail_bytes) {
				for( i = 0; i < navail_bytes; ++i )
				  *(byte_buff + i) = getc( fp );
			}
		}
		b1 = *pbytes++;
		ret |= b1 << nbits_left;
		nbits_left += 8;
		--navail_bytes;
	}

	nbits_left -= curr_size;
	return((short)(ret & *(code_mask + curr_size)));
}

BOOL  GetGifPal(char *name)
{
	FILE *fp;
	BYTE   buf[1028];
	short  i;
	fp = fopen(name,"rb");
	if(fp==NULL) return FALSE;
	fread(buf,1,6,fp);
	if( strncmp( buf, "GIF", 3 ) ) {
		fclose(fp);
		return FALSE;
	}
	fread(buf,1,7,fp);

	for (i = 0; i < MAX_COLOR; i++)  {
		R[i] = getc(fp) >>2;
		G[i] = getc(fp) >>2;
		B[i] = getc(fp) >>2;
	}

	fclose(fp);
	return TRUE;
}

BOOL  GetGifInfo(char *name,_GIFINFO *G)
{
	BYTE   buf[1028];
	FILE *fp;
	fp = fopen(name,"rb");
	if(fp==NULL) return FALSE;
	fread(buf,1,6,fp);
	if( strncmp( buf, "GIF", 3 ) ) {
		fclose(fp);
		return FALSE;
	}
	fseek(fp,6+7+768+5,SEEK_SET);
	fread(buf,1,2,fp);
	G->width = (*(short *)buf);
	fread(buf,1,2,fp);
	G->height = (*(short *)buf);
	fclose(fp);
	return TRUE;
}

BOOL ViewGif(short x,short y,char *name,short opt)
{
	_SPRITE S;
	short ret;
	ret = GetGifSprite(&S,name,opt);
	if(ret==1) {
		if(x==MAXX) { x=(MAXX-S.xs)/2;}
		if(y==MAXY) { y=(MAXY-S.ys)/2;}
		PutImage(x,y,&S,COPY_PUT|FREE_PUT);
	}
	return (BOOL)ret;
}

BOOL GetGifSprite(_SPRITE *S,char *name,short opt)
{
	FILE *fp;
	BYTE *sp,*OrgBuffer;
	short code, fc, oc,i,c;
	BYTE  size;
	WORD  wt,ht;
	long  bSize;
	BYTE  buf[1028];

	fp = fopen(name,"rb");
	if(fp==NULL) return FALSE;

	fread(buf,1,6,fp);
	if( strncmp( buf, "GIF", 3 ) ) {
		fclose(fp);
		return FALSE;
	}

	fread(buf,1,7,fp);

	if(opt) {
		for (i = 0; i < MAX_COLOR; i++)  {
			R[i] = getc(fp) >>2;
			G[i] = getc(fp) >>2;
			B[i] = getc(fp)  >>2;
		}
		if(opt==1) SetRgb(0,MAX_COLOR,1);
	}else fseek(fp,768,SEEK_CUR);

	fread(buf,1,5,fp);
	fread(buf,1,2,fp);
	wt = (*(short *)buf);
	fread(buf,1,2,fp);
	ht = (*(short *)buf);
	bSize = (ht * wt) + (sizeof(short) * 2);
	S->data = (BYTE *)malloc(bSize);
	if (S->data == NULL) {
		fclose(fp);
		return FALSE;
	}

	OrgBuffer = S->data;

	S->xs = wt;
	S->ys = ht;

	fread(buf,1,1,fp);
	size = getc(fp);

	if (size < 2 || 9 < size) {
		fclose(fp);
		FreeSprite(S);
		return FALSE;
	}

	stack = (BYTE *) malloc(MAX_CODES + 1);
	suffix = (BYTE *) malloc(MAX_CODES + 1);
	prefix = (unsigned short *) malloc(sizeof(short) * (MAX_CODES + 1));

	if (stack == NULL || suffix == NULL || prefix == NULL)  {
		fclose(fp);
		FreeSprite(S);
		return FALSE;
	}

	curr_size = size + 1;
	top_slot = 1 << curr_size;
	clear = 1 << size;
	ending = clear + 1;
	slot = newcodes = ending + 1;
	navail_bytes = nbits_left = 0;
	oc = fc = 0;
	sp = stack;

	while ( (c = _get_next_code(fp)) != ending )	{
		if (c == clear)	{
			curr_size = size + 1;
			slot = newcodes;
			top_slot = 1 << curr_size;
			while ( (c = _get_next_code(fp)) == clear );
			if( c == ending ) break;
			if( c >= slot )	c = 0;
			oc = fc = c;
			*OrgBuffer++ = c;
		} else {
			code = c;
			if (code >= slot) {
				code = oc;
				*sp++ = fc;
			}

			while (code >= newcodes)  {
				*sp++ = *(suffix + code);
				code = *(prefix + code);
			}

			*sp++ = code;
			if (slot < top_slot) {
				*(suffix + slot) = fc = code;
				*(prefix + slot++) = oc;
				oc = c;
			}

			if (slot >= top_slot && curr_size < 12)  {
				top_slot <<= 1;
				++curr_size;
			}

			while (sp > stack) {
				--sp;
				*OrgBuffer++ = *sp;
			}
		}
	}

	free(stack);
	free(suffix);
	free(prefix);

	fclose(fp);
	return TRUE;
}

