/*

	RAINBOW

	PIC.C (pcx & raw)

*/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>

#include "bc.h"
#include "xga.h"
#include "pal.h"
#include "pic.h"

BOOL GetPcxInfo(char *name,_PCXHEAD *P)
{
	FILE   *fp;
	fp=fopen(name,"rb");
	if(fp==NULL) return FALSE;
	fread(P,sizeof(_PCXHEAD),1,fp);
	fclose(fp);
	return TRUE;
}

BOOL GetPcxPal(char *name)
{
	FILE  *fp;
	char  pal[768];
	short c;
	fp=fopen(name,"rb");
	if(fp==NULL) return FALSE;
	fseek(fp,-768L,SEEK_END);
	fread(pal,768,1,fp);
	for(c=0;c<768;c++) *(pal+c) >>= 2;
	SetPalette(pal);
	GetRgb();
	fclose(fp);
	return TRUE;
}

BOOL  ViewPcx(short x,short y,char *name,short opt)
{
	_SPRITE S;
	short ret;
	ret = GetPcxSprite(&S,name,opt);
	if(ret==1) {
		if(x==MAXX) { x=(MAXX-S.xs)/2;}
		if(y==MAXY) { y=(MAXY-S.ys)/2;}
		PutImage(x,y,&S,COPY_PUT|FREE_PUT);
	}
	return (BOOL)ret;
}

BOOL GetPcxSprite(_SPRITE *S,char *name,short opt)
{
	_PCXHEAD PCX;
	_PCXHEAD *P=&PCX;
	FILE *fp;
	BYTE count;
	WORD c;
	char *data;
	DWORD    size,count_size=0;
	fp = fopen(name,"rb");
	if(fp==NULL) return FALSE;

	fread(P,sizeof(_PCXHEAD),1,fp);

	if(P->Version != 5) {
		fclose(fp); return FALSE;
	}

	if(opt) {
		if(opt==1) GetPcxPal(name);
		else {
			fseek(fp,-768L,SEEK_END);
			for(c=0;c<256;c++) {
				R[c]=getc(fp)>>2;
				G[c]=getc(fp)>>2;
				B[c]=getc(fp)>>2;
			}
		}
	}

	S->xs = P->Xmax - P->Xmin+1;
	S->ys = P->Ymax - P->Ymin+1;
	size=(long)S->xs*(long)S->ys;
	S->data = (char *) malloc(size);

	if(S->data==NULL) { fclose(fp); return FALSE; }
	data = S->data;

	fseek(fp,sizeof(_PCXHEAD),SEEK_SET);
	do {
		count=getc(fp);
		if(0xc0==(0xc0&count)){
			count=0x3f&count;
			c=getc(fp);
		}else{
			c=count;
			count=1;
		}
		count_size+=count;
		if(count_size>size) break;
		while(count--) { *data++ = c;}
	}while(1);

	fclose(fp);
	return TRUE;
}

BOOL GetRawSprite(_SPRITE *S,char *name)
{
	_POINT size;
	FILE *fp;
	fp = fopen(name,"rb");
	if(fp==NULL) return FALSE;

	fread(&size,1,sizeof(_POINT),fp);
	S->data = (char *)malloc((long)size.x * (long)size.y);
	if(S->data==NULL) {
		fclose(fp);
		return FALSE;
	}
	fread(S->data,(long)size.x*(long)size.y,1,fp);
	S->xs = size.x; S->ys = size.y;

	fclose(fp);
	return TRUE;
}

BOOL WriteRaw(_SPRITE *S,char *name)
{
	FILE *fp;
	fp = fopen(name,"wb");
	if(fp==NULL) return FALSE;

	fwrite(S,1,sizeof(_POINT),fp);
	fwrite(S->data,(long)S->xs*(long)S->ys,1,fp);

	fclose(fp);
	return TRUE;
}

