#ifndef __PIC_H
#define __PIC_H

typedef struct {
	char  Manufacturer;
	char  Version;
	char  Encode;
	char  BitPerPixel;
	short Xmin;
	short Ymin;
	short Xmax;
	short Ymax;
	short Hres;
	short Vres;
	char  RGB_Palette[48];
	char  Reserved;
	char  ColorPlanes;
	short BytePerLine;
	short PaletteType;
	char  Filler[58];
}_PCXHEAD;

BOOL GetPcxInfo(char *name,_PCXHEAD *P);
BOOL GetPcxPal(char *name);
BOOL ViewPcx(short x,short y,char *name,short opt);
BOOL GetPcxSprite(_SPRITE *S,char *name,short opt);

BOOL GetRawSprite(_SPRITE *S,char *name);

BOOL WritePcx(_SPRITE *S , char *name);
BOOL WriteRaw(_SPRITE *S,char *name);

#endif
