/*

	BMP test

	Program by GGUMTL

*/

#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <string.h>

#include "Xrainbow.h"

class _VIEW {
private:
	int resolution;
	BITMAPINFOHEADER bi;
public:
	_VIEW(char *file);
	~_VIEW();
	int GetResolution(int width,int height);
};

_VIEW::_VIEW(char *file)
{
	resolution = 0;
	if(GetBmpInfo(file,&bi)) {
		resolution = GetResolution(bi.biWidth,bi.biHeight);
		InitXrainbow((WORD)resolution,AUTODETECT);
                ViewBmp(MAXX,MAXY,file,1); // e wA b
		KeyWait();
	}else resolution =-1;
}

_VIEW::~_VIEW()
{
    	if(resolution) CloseXrainbow();
	exit(1);
}

int _VIEW::GetResolution(int width,int height)
{
	int w=0,h=0;

	if(width<=320) w = R320x200;
	else if(width<=640) w = R640x480;
	else if(width<=800) w = R800x600;
	else if(width<=1024) w = R1024x768;

	if(height<=200) h = R320x200;
	else if(height<=400) h = R640x400;
	else if(height<=480) h = R640x480;
	else if(height<=600) h = R800x600;
	else if(height<=768) h = R1024x768;

	if(w==h) return w;
	if(w==R320x200) w = -1;
	if(h==R320x200) h = -1;
	return (h>w) ? h:w;
}

void main(int argc,char *argv[])
{
	if(argc<2) {
		cout <<"VIEW filename\n";
		return;
	}
	_VIEW t(argv[1]);
}

