/*

	Xrainbow Library 1.2


	Source Code : Watcom C++ 10.0 , TASM 3.1


	Compiler option :

		c    : WCL386 -3r -mf -ox -w4
		c++  : WCL386 -3r -mf -ox -w4 -cc++

	Program by LEE WON HEE (GGUMTL)

*/

#ifndef __XRAINBOW_H
#define __XRAINBOW_H

#if !defined(__FLAT__) && !defined(__WATCOMC__)
	#error "This program is run in WATCOM C FLAT memory mode."
#endif

#ifndef _DOS_H_INCLUDE
	#include <dos.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*********

	define

**********/

#define RP_SEG(A)		((unsigned)A>>4)// Real mode get segment
#define RP_OFF(A)		((unsigned)A&15)// Real mode get offest

#define FALSE			0
#define TRUE			1

#define MAX_COLOR		256
#define MAXLIGHT		32

// InitXrainbow(R640x480,AUTODETECT);
// ChangeResolution(R320x200);
#define R640x400		0
#define R640x480		1
#define R800x600		2
#define R1024x768		3
#define R320x200		4

// void PutImage(short x,short y,_SPRITE *S,WORD opt);
// WORD opt  = FREE_PUT | SHADOW_PUT
#define COPY_PUT		0x0001
#define IMAGE_PUT		0x0001
#define SPRITE_PUT		0x0010
#define FREE_PUT		0x0100
#define SHADOW_PUT		0x1000

#define	M_EXEC			1000
#define	M_ENTER			2000
#define	M_ESC			3000
#define M_SCROLL_UP		4000
#define M_SCROLL_DOWN		5000
#define M_SCROLL_LEFT		6000
#define M_SCROLL_RIGHT		7000

#define _ESC			1
#define _1			2
#define _2			3
#define _3			4
#define _4			5
#define _5	 	        6
#define _6 			7
#define _7 			8
#define _8 			9
#define _9 			10
#define _0 			11
#define _MINUS 		    	12
#define _EQUAL   		13
#define _BACKSP 		14
#define _Q 			16
#define _W 			17
#define _E 			18
#define _R 			19
#define _T 			20
#define _Y 			21
#define _U 			22
#define _I 			23
#define _O 			24
#define _P 			25
#define _LPAREN 		26
#define _RPAREN 		27      /* ] */
#define _A 	 		30
#define _S 			31
#define _D 			32
#define _F 			33
#define _G 			34
#define _H 			35
#define _J 			36
#define _K 			37
#define _L 			38
#define _SEMI 			39       /*  ; */
#define _QUATO 			40       /*  ' */
#define _BSLASH 		43       /*  \ */
#define _Z 			44
#define _X 			45
#define _C 			46
#define _V 			47
#define _B 			48
#define _N 			49
#define _M			50
#define _COMMA			51       /*  , */
#define _DOT			52       /*  . */
#define _SLASH	 		53       /*  / */
#define _SPACEBAR		57
#define _F1  			59
#define _F2  			60
#define _F3  			61
#define _F4  			62
#define _F5  			63
#define _F6  			64
#define _F7  			65
#define _F8  			66
#define _F9  			67
#define _F10 			68
#define _RET 			28
#define _TAB 			15
#define _LSHIFT 		42
#define _RSHIFT 		54
#define _LCTRL 			29
#define _RCTRL 			29
#define _LALT 			56
#define _RALT 			56
#define _HOME 			71
#define _PGUP 			73
#define _END  			79
#define _PGDN 			81
#define _INS  			82
#define _DEL  			83
#define _NUMLOCK 		69
#define _CAPLOCK 		58
#define _SCRLOCK 		70
#define _UP    			72
#define _DOWN  			80
#define _LEFT  			75
#define _RIGHT 			77
#define _5_    			76
#define _PLUS  			78

//void SetSystemDelay(WORD rate);
#define TIMER_120HZ		0x26D7
#define TIMER_100HZ		0x2E9B
#define TIMER_60HZ		0x4DAE
#define TIMER_50HZ		0x5D37
#define TIMER_40HZ		0x7486
#define TIMER_30HZ		0x965C
#define TIMER_20HZ		0xE90B
#define TIMER_18HZ		0xFFFF

#ifndef inportb
	#define inportb(A) 	inp(A)
#endif

#ifndef outportb
	#define outportb(A,B)   outp(A,B)
#endif

#ifndef Swap
	#define Swap(A,B) {A^=B; B^=A; A^=B; }
#endif

/*********

	enum

**********/

// SetFontStyle(NORMAL);
enum {	
	NORMAL=0,
	REVERS,
	SHADOW,
	OUTLINE,
	BOLD,
};

// InitXrainbow(R640x480,AUTODETECT);
enum {
	 AUTODETECT=-1,
	 VESA=0,      		//ax=0x4f02 bx=mode;   //10
	 TRIDENT,
	 ATI,
	 ET4000,
	 WDC,
	 VIDEO7,    		//ax=0x6f05 bx=mode;
	 CHIPS_TECH,
	 OAK,
	 AHEADA,
	 AHEADB,
	 EVEREX,    		//ax=0x70   bx=mode;
	 GENOA,
	 CIRRUS,
	 ET3000,
	 ET4000W32,  		// Extended
	 VTEXT//
};

/*********

	typedef

**********/

typedef int		BOOL;
typedef unsigned char  	BYTE;
typedef unsigned short 	WORD;
typedef unsigned int    UINT;
typedef signed long 	LONG;
typedef unsigned long 	DWORD;

typedef struct {
    long    edi, esi, ebp, reserved, ebx, edx, ecx, eax;
    short   flags, es, ds, fs, gs, ip, cs, sp, ss;
}_REGSs;

typedef struct {
	short x,y,xx,yy;
}_RECT;

typedef struct {
	short x,y;
}_POINT;

typedef struct {
	long x,y;
}_POINTL;

typedef struct {
	char  Manufacturer;
	char  Version;
	char  Encode;
	char  BitPerPixel;
	short Xmin;
	short Ymin;
	short Xmax;
	short Ymax;
	short Hres;
	short Vres;
	char  RGB_Palette[48];
	char  Reserved;
	char  ColorPlanes;
	short BytePerLine;
	short PaletteType;
	char  Filler[58];
}_PCXHEAD;

/* windows type */
typedef struct tagBITMAPINFOHEADER
{
	DWORD   biSize;            // Size of the structure
	LONG    biWidth;           // Width in Pixels
	LONG    biHeight;          // Height in Pixels
	WORD    biPlanes;          // Set to 1
	WORD    biBitCount;        // Color bits per pixel
	DWORD   biCompression;     // Compression scheme
	DWORD   biSizeImage;       // Number of Bitmap bytes
	LONG    biXPelsPerMeter;   // Horizontal resolution
	LONG    biYPelsPerMeter;   // Vertical resolution
	DWORD   biClrUsed;         // Number of colors Used
	DWORD   biClrImportant;    // Important colors
} BITMAPINFOHEADER;

typedef struct {
	short	width,height;
}_GIFINFO;

typedef struct {
	short  xs,ys;
	char *data;
}_SPRITE;

typedef struct {
	long  size;
	WORD  type;
	short frames;
	short width,height;
	short depth;
	short flags;
	long  speed;
	char  reservedl[18];
	short aspectx,aspecty;
	char  reserved2[38];
	long  oframel,oframe2;
	char  reserved3[40];
}FlicHead;

typedef struct {
	FlicHead head;
	short handle;
	short frame;
	char  *name;
	short xoff,yoff;
	short frame_state;
	char  *FrameBuff;
	BYTE  opt;
	WORD  tick;
}_FLIC;

/*********

	extern variable

**********/

/* xga */
extern char *SVGA_ADDR;
extern char *OVER_FLOW;
extern char *ACT_PAGE;
extern char *CHBANK_LINE;

extern WORD  MAXX,MAXY;			            // Max resolution size
extern long  MEM_SIZE;				    // MAXX * MAXY
extern short VGA_CHIP;
extern WORD  CLIP_X,CLIP_Y,CLIP_XX,CLIP_YY;	    // Sprite Clipping...
extern WORD  CLIP_XS,CLIP_YS;			    // Sprite Clipping Size

extern WORD  SCREEN_X,SCREEN_Y,SCREEN_XX,SCREEN_YY; // Screen Clipping...
extern WORD  SCREEN_XS,SCREEN_YS;		    // Screen Clipping Size
extern WORD  CENTER_X,CENTER_Y;		    	    // Screen Center point..
extern BYTE  R[256], G[256], B[256];
extern DWORD ADDRESS[768];
extern BYTE  SHADOW_LEVEL;
extern BYTE  LIGHT_TABLE[MAXLIGHT+1][MAX_COLOR];    // light table

/* han */
extern short HAN_FNT_SIZE;
extern short ENG_FNT_SIZE;

/* mouse */
extern short MOUSE_RIGHT,MOUSE_LEFT;
extern short MOUSE_CURSOR_X,MOUSE_CURSOR_Y;
extern short MOUSE_INSTALL;

/* key & vect */
extern BYTE _KEY[128];
extern BYTE _KBHIT;
extern WORD FRAME_RATE;

/*^^^^^^^^

	Function

^^^^^^^^*/

#if defined(__WATCOMC__)
	int   random(int num);
	void  randomize();
#endif

short GetRandom(short _min,short _max);
BOOL  Crash(short sx1,short sx2,short sy1,short sy2,short dx1,short dx2,
		short dy1,short dy2);
void  PassXY(short x1,short y1,short x2,short y2,short *xadd,
		short *yadd, short speed);

/* Real mode */
void *AllocDosmem(int size);
void FreeDosmem(void *mem);
void int386emul(int num, union REGS *in, union REGS *out);
void int386xemul(int num, union REGS *in, union REGS *out, struct SREGS *ad);

/*^^^^^^^

	Hangul

^^^^^^^^*/

short PutsHan(short x, short y, BYTE color,char *str);
short CputsHan(short x, short y,short xx,BYTE color,char *str);
short PrintfHan(short x,short y,BYTE color,char *fmt, ...);
short CprintfHan(short x,short y,short xx,BYTE color,char *fmt, ...);
void  SetTextStyle(BYTE i);
BYTE  GetTextStyle();
BOOL  ReadHanFont(char *_han);
BOOL  ReadEngFont(char *_eng);
void  SetFontSize(short han,short eng,short hany);
void  SetFontDirectory(char *dir);
void  InitHan(char *_han,char *_eng);
short GetsEng(short x,short y,short c,short bc,short num,char *st);

/*^^^^^^^

	Palette

^^^^^^^^*/

void  MakeLightTable(short redtarget,short greentarget,short bluetarget);
BYTE  SearchNearPal(BYTE r,BYTE g, BYTE b,short level);
void  SetPalette(char *palette);
void  GetRgb();
void  SetRgb(short start,short end,short MODE );
void  Fade(short x,short y,short Ct1);
BOOL  ReadPal(char *pal);
BOOL  WritePal(char *pal);
BOOL  WriteLightTable(char *name);
BOOL  ReadLightTable(char *name);
void  FadeIn();
void  FadeOut();
void  RotatePalette(short Start,short End,short Direct);

/*^^^^^^^

	Pcx , Flc , Fli , Gif , Bmp , Raw

^^^^^^^^*/

/* gif */
BOOL  GetGifPal(char *name);
BOOL  GetGifInfo(char *name,_GIFINFO *G);
BOOL  ViewGif(short x,short y,char *name,short opt);
BOOL  GetGifSprite(_SPRITE *S,char *name,short opt);

/* pcx */
BOOL  GetPcxInfo(char *name,_PCXHEAD *P);
BOOL  GetPcxPal(char *name);
BOOL  ViewPcx(short x,short y,char *name,short opt);
BOOL  GetPcxSprite(_SPRITE *S,char *name,short opt);

/* flc, fli */
void  RepeatFlic(_FLIC *P);
short FlicNextFrame(_FLIC *P);
short FlicPlay(short x,short y,_FLIC *P,char *fname,BYTE opt);
void  CloseFlic(_FLIC *P);

/* bmp */
BOOL  GetBmpInfo(char *name,BITMAPINFOHEADER *Bi);
BOOL  GetBmpSprite(_SPRITE *S,char *name,short opt);
BOOL  ViewBmp(short x,short y,char *name,short opt);
BOOL  WriteBmp(_SPRITE *S , char *name);

/* raw */
BOOL  GetRawSprite(_SPRITE *S,char *name);
BOOL  WriteRaw(_SPRITE *S,char *name);

/*^^^^^^^

	Mouse

^^^^^^^^*/

void  SetMouseSpriteCursorXy(short x,short y,short xx,short yy,_SPRITE *S);
void  SetMouseSpriteCursor(_SPRITE *S);
void  FreeMouseSpriteCursor(_SPRITE *S);
void  MouseInfo();
void  MouseMoveCursor(short x,short y);
void  MouseXyRange(short left,short right,short top,short bottom);
void  MouseReleased();
BOOL  MouseCrash(short x1,short y1,short x2,short y2);
void  ShowMouseSpriteCursorClip();
void  ShowMouseSpriteCursor();
short MouseInt(short i);
BOOL  InitMouse();

/*^^^^^^^

	Key & Timer

^^^^^^^^*/

WORD  GetClockTick();
void  SystemDelay();
void  SetVect();
void  CloseVect();
short KeyWait();
short GetKey();
void  SetSystemDelay(WORD rate);
void  DelayTime(WORD tick);

/*^^^^^^^

	Bank

^^^^^^^^*/

void  SetBank(short bank);
void  IncSetBank();
short WhatsVga();
short SetVgaBank(short opt);

/*^^^^^^^

	Graphic

^^^^^^^^*/

void  InitXrainbow(short mode,short vga);
void  CloseXrainbow();
BOOL  ChangeResolution(short mode);
void  SetScreenSize(WORD x,WORD y,WORD xx,WORD yy);
void  ClearScreenSize();
void  SetViewPort(WORD x,WORD y,WORD xx,WORD yy);
void  ClearViewPort();
void  WaitVsync2();
void  WaitVsync();
void  SetActPage(char *page);
char  *GetActPage();
void  FullViewPage(char *page);
void  ViewPage(char *page);
void  WindowViewPage
	(short x,short y,long dx,long dy, short dxs,short dys,char *page);
void  WindowCopyPage
	(long x,short y,long xx,short yy,char *des,char *page);
void  WindowCopyPageXy
	(short x,short y,long dx,long dy, short dxs,short dys,char *des,char *page);
char  *GetFarAddr(long x,long y);
void  SetVideoMode(WORD  mode,WORD mode2);
void  PutPixel(long x,long y,BYTE color);
BYTE  GetPixel(long x,long y);
void  CircleFill(long x1,long y1,short r,BYTE color);
void  Circle(long x1,long y1,long r,BYTE color);
void  Triangle(short x1,short y1,short x2,short y2,short x3,short y3,BYTE color);
void  LineV (short x1,short y1,short y2,BYTE color);
void  LineH (short x1,short x2,short y1,BYTE color);
void  Line(short x1,short y1,short x2,short y2,BYTE color);
void  PolyLine(_POINT P[],short n,BYTE color);
void  BoxFill(short x1,short y1,short x2,short y2,BYTE color);
void  ShadowBoxFill(short x1,short y1,short x2,short y2,BYTE level);
void  Box(short x1,short y1,short x2,short y2,BYTE color);
void  Clrscr(BYTE color);
void  Psets(long x,long y,char *data,WORD nbyte); // image sets
void  Psets2(long x,long y,char *data,WORD nbyte);// sprite sets
void  Psets3(long x,long y,char *data,WORD nbyte);// shadow sets
void  Pgets(short x,short y,char *img,short xs);  // image gets
BOOL  GetImage(short x,short y,short xx, short yy,_SPRITE *S);
void  PutImage(short x,short y,_SPRITE *S,WORD opt);
void  FreeSprite(_SPRITE *S);

void  ScaleImage(long x,long y,long x_s, long y_s,_SPRITE *s,WORD opt);
void  PutImageClip(long x, long y,_SPRITE *S);
void  PutSpriteClip(long x, long y,_SPRITE *S);
void  PutShadowSpriteClip(long x, long y,short level,_SPRITE *S);
void  PutShadowObjectSpriteClip(long x, long y,_SPRITE *S);

/* sprite.asm */
extern void PutTile(long x, long y,_SPRITE *S);
extern void PutTile4(long x, long y,_SPRITE *S);

/*
	Inline assembler
*/

extern void _Memcpy(char *des,char *sur,long size);
#pragma aux _Memcpy  = "XOR   EDX,EDX"\
			   "MOV   DL,CL"\
			   "AND   DL,3"\
			   "SHR   ECX,2"\
			   "REP   MOVSD"\
			   "MOV   ECX,EDX"\
			   "REP   MOVSB"\
			   parm  [EDI] [ESI] [ECX] modify [EDX];

extern void _Memcpy4(char *des,char *sur,long size);
#pragma aux _Memcpy4  ="SHR   ECX,2"\
			"REP   MOVSD"\
			parm  [EDI] [ESI] [ECX];

extern void _Memset(char *des,DWORD set,long size);
#pragma aux _Memset  = "MOV   AH,AL"\
			"PUSH  AX"\
			"SHL   EAX,16"\
			"POP   AX"\
			"XOR   EDX,EDX"\
			"MOV   DL,CL"\
			"AND   DL,3"\
			"SHR   ECX,2"\
			"REP   STOSD"\
			"MOV   ECX,EDX"\
			"REP   STOSB"\
			parm  [EDI] [EAX] [ECX] modify [EDX];

extern void _Memset4(DWORD *des,DWORD set,long size);
#pragma aux _Memset4= "REP   STOSD"\
			parm  [EDI] [EAX] [ECX];

extern void _Memset4Ex(char *des,DWORD set,long size);
#pragma aux _Memset4Ex=	"SHR	ECX,2"\
			"REP    STOSD"\
			parm  [EDI] [EAX] [ECX];

#ifdef __cplusplus
}
#endif

#endif

