/*

	Xmodem Protocol

         wⷥ Xmodem aɡi aa.
        e e ..

*/

#include <stdio.h>
#include <stdlib.h>
#include <direct.h>
#include <dos.h>
#include <io.h>
#include <string.h>
#include <conio.h>

#include "bc.h"
#include "xlink.h"
#include "protocol.h"

#define REPAIR_TIME	5
#define MAX_RETRY_NAK	3

static BYTE Xbuffer[128];

short WaitReceive(_PORT *P)
{
	struct dostime_t t;
	short    old_sec,retry;
	BYTE i;
	retry = 0;
	_dos_gettime(&t);
	old_sec=t.second;
	while(1) {
		if(DataReady(P)) {
			i = (BYTE)ReadCom(P);
			return i;
		}
		_dos_gettime(&t);
		if(old_sec!=t.second) {
			retry++;
			old_sec=t.second;
			if(retry>REPAIR_TIME) return -1;
		}
		if(kbhit()) return 0;
	}
}

BOOL CheckReceive(_PORT *P,BYTE msg) // ok
{
	BOOL ret;
	ret = WaitReceive(P);
	if(ret == msg) return TRUE;
	return FALSE;
}

void SendPack(_PORT *P,BYTE *data,BYTE length)
{
	short i;
	BYTE chksum=0;
	WriteCom(P,SOH);
	for(i=0;i<length;i++) {
		chksum += data[i];
		WriteCom(P,data[i]);
	}
	WriteCom(P,chksum);
}

BOOL ReceivePack(_PORT *P,BYTE *data,BYTE length)
{
	BYTE chksum;
	char temp;
	short i,ret;
	chksum = 0;
	ret = WaitReceive(P);
	if(ret!=SOH) return FALSE;
	for(i=0;i<length;i++) {
		ret = WaitReceive(P);
		if(ret < 0) return FALSE;
		data[i] = ret;
		chksum += data[i];
	}
	temp = WaitReceive(P);
	if( chksum != temp) return FALSE;
	return TRUE;
}

BOOL SendFile(_PORT *P,char *file)
{
	FILE *fp;
	short ret;
	int  ack_level = 0;
	long file_length;
	char buffer[23];

	fp = fopen(file,"rb");
	if(fp==NULL) {
		printf("%s file not found.\n",file);
		return FALSE;
	}
	file_length = filelength(fileno(fp));

	WriteCom(P,0x1b);//file transport
	sprintf(buffer,"%13s%10ld",file,file_length);
	puts(buffer);
	SendPack(P,buffer,23);
	while(1) {
		ret = WaitReceive(P);
		if(ret==-1) {
			fclose(fp);
			printf("Cancel..\n");
			return FALSE;
		}
		switch(ret) {
			case ACK:
				if(ack_level == 0) {
					fread(Xbuffer,1,128,fp);
					SendPack(P,Xbuffer,128);
					file_length-=128L;
					if(file_length < 0) ack_level=1;
				} else if(ack_level == 1) {
					WriteCom(P,EOT);
					ack_level =2;
				} else if(ack_level == 2) {
					printf("Send %s file OK.\n",file);
					goto _SKIP;
				}
				break;
			case NAK:
				SendPack(P,Xbuffer,128);
				break;
		}
	}
_SKIP:
	fclose(fp);
	return TRUE;
}

BOOL ReceiveFile(_PORT *P)
{
	FILE *fp;
	short ret;
	BYTE retry = 0;
	long file_length,file_length2;
	char file[13];
	char buffer[23];

	if(ReceivePack(P,buffer,23)) {
		sscanf(buffer,"%13s%10ld",file,&file_length);
		printf("%s file receive. (%ld)\n",file,file_length);
	} else {
		printf("Receive Pack error..\n");
		return FALSE;
	}

	fp = fopen(file,"wb");
	if(fp==NULL) {
		printf("%s file create error.\n",file);
		return FALSE;
	}
	WriteCom(P,ACK);// next pack
	file_length2 = file_length;
	while(1) {
		if(file_length<0) {
			ret = WaitReceive(P);
			if(ret==EOT) WriteCom(P,ACK);
			break;
		}
		if(ReceivePack(P,Xbuffer,128)) {
			if(file_length>128L) fwrite(Xbuffer,128,1,fp);
			else fwrite(Xbuffer,(int)file_length,1,fp);
			file_length-=128;
			WriteCom(P,ACK);
			retry = 0;
		} else {
			retry ++;
			WriteCom(P,NAK);
			if(retry>MAX_RETRY_NAK) {
				fclose(fp);
				printf("Receive error.\n");
			}
			printf("Retry %d\n",retry);
		}
	}

	fclose(fp);

	if(ret!=EOT) {
		unlink(file);
		printf("%s file receive error.\n",file);
	}else {
		fp = fopen(file,"rb");
		file_length=filelength(fileno(fp));
		fclose(fp);
		if(file_length2!=file_length) {
			printf("%l file size error.\n",file_length2);
			unlink(file);
		}
		else printf("%s file receive OK.\n",file);
	}
	return TRUE;
}

