/*

	Uart program..

	Program By LEE WON HEE (GGUMTL)

*/

#include <dos.h>
#include <bios.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>

#include "bc.h"
#include "xlink.h"

#define __MAKE_INTERRUPT

static _PORT_BUFF Portb[2];
static _PORT_BUFF *Pi;
static void (_interrupt _far *OldUart1)();
static void (_interrupt _far *OldUart2)();

static void _interrupt _far Serial_Isr1(void)
{
	Pi = &Portb[0];
	Pi->ser_buffer[Pi->ser_end] = inportb(COM_1);
	Pi->char_ready++;
	Pi->ser_end++;
	if(Pi->ser_end==SERIAL_BUFF_SIZE) Pi->ser_end = 0;
	outportb(PIC_ICR,0x20);
}

static void _interrupt _far Serial_Isr2(void)
{
	Pi = &Portb[1];
	Pi->ser_buffer[Pi->ser_end] = inportb(COM_2);
	Pi->char_ready++;
	Pi->ser_end++;
	if(Pi->ser_end==SERIAL_BUFF_SIZE) Pi->ser_end = 0;
	outportb(PIC_ICR,0x20);
}

static void _interrupt _far Serial_Isr3(void)
{
	Pi = &Portb[0];
	Pi->ser_buffer[Pi->ser_end] = inportb(COM_3);
	Pi->char_ready++;
	Pi->ser_end++;
	if(Pi->ser_end==SERIAL_BUFF_SIZE) Pi->ser_end = 0;
	outportb(PIC_ICR,0x20);
}

static void _interrupt _far Serial_Isr4(void)
{
	Pi = &Portb[1];
	Pi->ser_buffer[Pi->ser_end] = inportb(COM_4);
	Pi->char_ready++;
	Pi->ser_end++;
	if(Pi->ser_end==SERIAL_BUFF_SIZE) Pi->ser_end = 0;
	outportb(PIC_ICR,0x20);
}

short DataReady(_PORT *P)
{
	return Portb[P->port_num].char_ready;
}

short ReadCom(_PORT *P)
{
	BYTE data;
	Pi = &Portb[P->port_num];
	if (Pi->ser_end == Pi->ser_start) return 0;
	data = Pi->ser_buffer[Pi->ser_start];
	Pi->ser_start++;
	if(Pi->ser_start == SERIAL_BUFF_SIZE) Pi->ser_start = 0;
	if(Pi->char_ready>0) Pi->char_ready--;
	return data;
}

void WriteCom(_PORT *P,BYTE ch)
{
	while(!(inportb(P->port+SER_LSR) & 0x20)){}
	outportb(P->port, ch);
}

void WritesCom(_PORT *P,BYTE *msg)
{
	while (*msg) { WriteCom (P,(BYTE)*msg++); }
}

BOOL ChkConnected(_PORT *P)
{
	if((inp(P->port+SER_MSR)&0xb0)==0xb0) return TRUE;
	return FALSE;
}

void InitXrainbowUart(_PORT *P,short port_base, short baud, short configuration)
{
	BYTE temp;
	memset(P,0,sizeof(_PORT));// clear

	P->port = port_base;
	P->bit_flag = configuration;
	P->baud = baud;
	P->install = 1;
	P->uart_mode = RS232;

	outportb(port_base + SER_LCR, SER_DIV_LATCH_ON);
	outportb(port_base + SER_DLL, baud);
	outportb(port_base + SER_DLH, 0);
	outportb(port_base + SER_LCR, configuration);
	outportb(port_base + SER_MCR, MCR_GP02|MCR_DTR|MCR_RTS);

	temp = inportb(port_base + SER_IER);
	outportb(port_base + SER_IER,temp|0x01);

#ifdef __MAKE_INTERRUPT
	switch(port_base) {
		case COM_1: P->port_num = 0;
			OldUart1 = _dos_getvect(INT_SER_PORT_1);
			_dos_setvect(INT_SER_PORT_1,Serial_Isr1);
			break;
		case COM_2: P->port_num = 1;
			OldUart2 = _dos_getvect(INT_SER_PORT_2);
			_dos_setvect(INT_SER_PORT_2,Serial_Isr2);
			break;
		case COM_3: P->port_num = 0;
			OldUart1 = _dos_getvect(INT_SER_PORT_1);
			_dos_setvect(INT_SER_PORT_1,Serial_Isr3);
			break;
		case COM_4: P->port_num = 1;
			OldUart2 = _dos_getvect(INT_SER_PORT_2);
			_dos_setvect(INT_SER_PORT_2,Serial_Isr4);
			break;
	}
#endif
	P->old_mask = inportb(PIC_IMR);
	outportb(PIC_IMR, (port_base==COM_1||port_base==COM_3) ?
			(P->old_mask & 0xEF) : (P->old_mask & 0xF7));
}

void CloseXrainbowUart(_PORT *P)
{
	if(!P->install) return;
	outportb(P->port+SER_MCR,0);
	outportb(P->port+SER_IER,0);
	outportb(PIC_IMR,P->old_mask);
#ifdef __MAKE_INTERRUPT
	switch(P->port) {
		case COM_1: case COM_3:
			_dos_setvect(INT_SER_PORT_1,OldUart1);break;
		case COM_2: case COM_4:
			_dos_setvect(INT_SER_PORT_2,OldUart2);break;
	}
#endif
	memset(P,0,sizeof(_PORT));
}

