/*


	Xrainbow Xlink Library 1.0


	Source Code : Watcom C++ 10.0


	Compiler option : WCL386 -3r -mf -ox


	Program by LEE WON HEE (GGUMTL)


*/

#ifndef __XLINK_H
#define __XLINK_H


#ifdef __cplusplus
extern "C" {
#endif

#define SER_RBF		0 // the read buffer
#define SER_THR		0 // the write buffer

#define SER_IER		1 // the int. enable register
#define SER_IIR		2 // the int. identification register
#define SER_LCR		3 // control data config. and divisor latch
#define SER_MCR		4 // modem control reg.
#define SER_LSR		5 // line status reg.
#define SER_MSR		6 // modem status of cts, ring etc.
#define SER_DLL		0 // the low byte of baud rate divisor
#define SER_DLH		1 // the hi byte of divisor latch

#define MCR_DTR		0x01
#define MCR_RTS		0x02
#define MCR_GP02	8 // enable interrupt

#define SER_DIV_LATCH_ON	128  // used to turn reg 0,1 into divisor latch
#define PIC_IMR			0x21 // pic's interrupt mask reg.
#define PIC_ICR			0x20 // pic's interupt control reg.

#define INT_SER_PORT_1		0x0C  // port 0 interrupt com 1 & 3
#define INT_SER_PORT_2		0x0B  // port 0 interrupt com 2 & 4

#define BAUD_1200		96
#define BAUD_2400		48
#define BAUD_9600		12
#define BAUD_19200		6

#define COM_1			0x3F8 // base port address of port 0
#define COM_2			0x2F8 // base port address of port 1
#define COM_3			0x3E8 // base port address of port 2
#define COM_4			0x2E8 // base port address of port 3

#define SER_STOP_1		0     // 1 stop bit per character
#define SER_STOP_2		4     // 2 stop bits per character

#define SER_BITS_5		0     // send 5 bit characters
#define SER_BITS_6		1     // send 6 bit characters
#define SER_BITS_7		2     // send 7 bit characters
#define SER_BITS_8		3     // send 8 bit characters

#define SER_PARITY_NONE		0     // no parity
#define SER_PARITY_ODD		8     // odd parity
#define SER_PARITY_EVEN		24    // even parity

#define SERIAL_BUFF_SIZE	1024  // current size of circulating receive buffer

enum {
	RS232=0,
	RS422,
	DIAL_MODEM,
	SMART_MODEM
};

typedef struct {
	BYTE  ser_buffer[SERIAL_BUFF_SIZE];
	short ser_end,ser_start;
	short char_ready;
	short old_int_mask;
}_PORT_BUFF;

typedef struct {
	short port;		// port addr
	short port_num;		// port number
	BYTE bit_flag;		// bit flag
	WORD baud;              // baud rate
	WORD old_mask;		// old interrupt mask
	BYTE install;		// install port
	WORD uart_mode;		// rs232 or dial modem
	short time;		// chkeck time
}_PORT;

short DataReady(_PORT *P);
short ReadCom(_PORT *P);
void  WriteCom(_PORT *P,BYTE ch);
void  WritesCom(_PORT *P,BYTE *msg);
BOOL  ChkConnected(_PORT *P);
void  InitXrainbowUart(_PORT *P,short port_base, short baud,
				short configuration);
void  CloseXrainbowUart(_PORT *P);


#ifdef __cplusplus
}
#endif

#endif

