// 8253 Timer Controller Multi Control 4 WATCOM C/C++ (C) Kim Youngsik WoodPark

#include <dos.h>
#include <conio.h>
#include <malloc.h>
#include <i86.h>
#include "TIMER.H"

#define MAXTIMER        20

void __interrupt __far (*OldTimerInt8)(void);

struct MULTITIMER{
    int           Empty;
    int           Freq;
    int           Active;
    unsigned long Divisor;
    unsigned long AddDiv;
    void          (*TimerPtr)(void);
} UserTimerInfo[MAXTIMER];

unsigned long CurrentDivisor  = 0;
unsigned long CurrentAddDiv   = 0;

void AdjustTimerFreq(void)
{
    int MaxFreq, i;
    unsigned DivFreq;

    MaxFreq = 182;
    for (i = 0; i < MAXTIMER; i++)
        if (MaxFreq < UserTimerInfo[i].Freq && !UserTimerInfo[i].Empty)
            MaxFreq = UserTimerInfo[i].Freq;
    for (i = 0; i < MAXTIMER; i++)
        if (!UserTimerInfo[i].Empty)
            UserTimerInfo[i].Divisor = 65536l * UserTimerInfo[i].Freq / MaxFreq;
    CurrentDivisor = DivFreq = 11931800 / MaxFreq;

    outp(0x43, 0x34);
    outp(0x40, DivFreq & 0xFF);
    outp(0x40, DivFreq >> 8);
}

void SetTimerFreq(int handle, double freq)
{
    if (freq < 18.2) freq = 0;

    UserTimerInfo[handle].Freq = (int)(freq * 10);
    UserTimerInfo[handle].AddDiv = 0;

    AdjustTimerFreq();
}

int OpenTimer(int handle, void (*UserTimerPtr)(void))
{
    if (UserTimerInfo[handle].Empty == 0) return(0);

    UserTimerInfo[handle].Empty = 0;
    UserTimerInfo[handle].TimerPtr = UserTimerPtr;
    UserTimerInfo[handle].Active = 0;
    SetTimerFreq(handle, 18.2);

    return(1);
}

void CloseTimer(int handle)
{
    if (UserTimerInfo[handle].Empty) return;

    UserTimerInfo[handle].Empty = 1;
    AdjustTimerFreq();
}

void StartTimer(int handle)
{
    UserTimerInfo[handle].Active = 1;
}

void StopTimer(int handle)
{
    UserTimerInfo[handle].Active = 0;
}

void __interrupt __far TimerInt(void)
{
    _disable();

    for (int i = 0; i < MAXTIMER; i++) {
        if (!UserTimerInfo[i].Active || UserTimerInfo[i].Empty) continue;
        if (UserTimerInfo[i].AddDiv >= 65536L) {
            UserTimerInfo[i].TimerPtr();
            UserTimerInfo[i].AddDiv -= 65536L;
        }
        UserTimerInfo[i].AddDiv += UserTimerInfo[i].Divisor;
    }
    if (CurrentAddDiv >= 65536L) {
        OldTimerInt8();
        CurrentAddDiv -= 65536L;
    }
    CurrentAddDiv += CurrentDivisor;

    outp(0x20, 0x20);

    _enable();
}

void MultiTimerInstall(void)
{
    CurrentDivisor  = 65536L;
    CurrentAddDiv   = 0;

    for (int i = 0; i < MAXTIMER; i++) UserTimerInfo[i].Empty = 1;

    OldTimerInt8 = _dos_getvect(0x08);
    _dos_setvect(0x08, TimerInt);
}

void MultiTimerUninstall(void)
{
    _dos_setvect(0x08, OldTimerInt8);

    outp(0x43, 0x34);
    outp(0x40, 0xFF);
    outp(0x40, 0xFF);
}
