// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

// Fade in and out an image (timer and interrupt controlled fading).
// While the images fades, the animation procedure (text moves) goes on.

#include "device/keyboard.h"
#include "device/vesadrv.h"
#include "gfx/bitmap.h"
#include "gfx/imageio.h"
#include "gfx/fade.h"
#include "gfx/font.h"
#include "gfx/blit.h"

const int TimeForMove=8192;

main()
  {
  if (Video.SetMode(VideoDriver::VGA320x200x256)!=0) ErrorHandler.Abort("main()  Can't set VGA mode 13h.");
  SystemTimer.TimeVal(20); // that means that we want 1000/20=50 timer ticks per second
  // Load an image and check if the its compatible with the video mode.
  // If it were not compatible to the video we could easily convert it 
  // using CopyRectConverted(), but here we simply exit the program.
  ErrorHandler.EnterCriticalSection("loading images");
  Bitmap Image1;
  if (LoadPCX(Image1,"flower.pcx")!=0) ErrorHandler.Abort("main()  Can't load picture flower.pcx.");
  if (Image1.ClassID()!=Bitmap::ClassPackedPixel8) ErrorHandler.Abort("flower.pcx is not a 256 color image.");
  if (Image1.Width()!=Video.Width() || Image1.Height()!=Video.Height()) ErrorHandler.Abort("flower.pcx has not the same size as the screen.");
  ErrorHandler.LeaveCriticalSection();
  // load our font
  Font Font8x8;
  Font8x8.Load("c:\\bc_kjell\\fonts\\font8x8.pcx");
  // precompute palette indices for our desiBlack colors
  // (we must do this before we set Fader.Brightness(0), cause this func
  // sets all palette entries to black )
  ColorRef Black=Image1.Palette().GetPaletteIndex(RGB8(0,0,0));
  ColorRef White=Image1.Palette().GetPaletteIndex(RGB8(255,255,255));
  // fade in Image1
  PaletteFader Fader(Image1.Palette()); // this fader is now compatible to Image1 palette, and will fade in 1 second (=1000ms) from black <-> color
  Fader.Brightness(0);                       // set all colors in image1.palette to black
  Video.UsePalette(Image1.Palette());        // the screen will be black now (because Image1.Palette() is all black right now)
  Video.BlitToScreen(0,0,Image1,Rect(0,0,319,199)); // copy the (black) image onto the screen
  Fader.FadeIn(2000);                              // start fading
 // Now the fader is running in background. We can run another
 // thread in the foreground.
  // create our text line and get its dimension in pixels
  char MyText[] = "I am running ...";
  const int MyTextLen=strlen(MyText);
  const int MyTextHeight=Font8x8.StringHeight(MyText);
  const int MyTextWidth= Font8x8.StringWidth (MyText);
  // create a buffer for our dirty rectangle
  Bitmap Backup(MyTextWidth+1,MyTextHeight+1,Video.ClassID()); // a bitmap (class ID) compatible to the screen
  Backup.UsePalette(Image1.Palette());  // color compatibility
  // start the loop
  int FadingOut=0; // flag
  do
    {
    // print the text in the off screen buffer bitmap
    const int deltat=(SystemTimer.Time()/8)%300;
    const int x=95,y=20+(deltat<150?deltat:300-deltat);
    // we will print the text in our image, but first we must backup
    // the changed part in a buffer bitmap.
    CopyRect(Backup,0,0,Image1,Rect(x,y,x+MyTextWidth,y+MyTextHeight));
    // modify off screen buffer (print text)
    TextOut(Image1,x  ,y  ,Font8x8,Black,MyText,MyTextLen);
    TextOut(Image1,x+1,y+1,Font8x8,White,MyText,MyTextLen);
    // update the screen. 
    Video.BlitToScreen(0,0,Image1,Rect(0,0,319,199));
    // restore the original content of our image
    CopyRect(Image1,x,y,Backup,Rect(0,0,MyTextWidth,MyTextHeight));
    if (Keyboard.GetKey()) 
      {
      // start fading out
      FadingOut=1;
      Fader.FadeOut(2000);
      }
    }
  while (!(FadingOut && !Fader.IsRunning())); // stop if fading out has finished
  return(0);
  }

