// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

// Scroll an image
#include <iostream.h>
#include "device/keyboard.h"
#include "device/vesadrv.h"
#include "device/timer.h"
#include "gfx/bitmap.h"
#include "gfx/imageio.h"
#include "gfx/blit.h"

const int TileSize=16;
const int ScrollPixelsPerSecond=100;

extern void _interrupt _far keyboardint();

main()
  {
  // print start msg.
  {cout << "Press the cursor keys to scroll arround, <Escape> quits.\nPress a key to start.";
  const int StartTime=SystemTimer.Time();
  while (SystemTimer.Time()-StartTime<6000 && !Keyboard.GetKey());} // wait 6 secs
  // init video/timer
  SystemTimer.TimeVal(10); // 10ms is the maximum frame rate (100fps)
  if (Video.SetMode(VideoDriver::VGA320x200x256)!=0) ErrorHandler.Abort("main()  Can't set VGA mode 13h.");
  // load image
  Bitmap Image1;
  if (LoadPCX(Image1,"flower.pcx")!=0) ErrorHandler.Abort("main()  Can't load picture flower.pcx.");
  if (Image1.ClassID()!=Bitmap::ClassPackedPixel8) ErrorHandler.Abort("flower.pcx is not a 256 color image.");
  if (Image1.Width()!=Video.Width() || Image1.Height()!=Video.Height()) ErrorHandler.Abort("flower.pcx has not the same size as the screen.");
  Video.UsePalette(Image1.Palette());
  // create a chess board bitmap with nxn tiles
  int xTiles=Video.Width() /TileSize+3;
  int yTiles=Video.Height()/TileSize+3;
  Bitmap Chess(xTiles*TileSize,yTiles*TileSize,Image1.ClassID());
  Chess.UsePalette(Image1.Palette());
  ColorRef White=Image1.Palette().GetPaletteIndex(RGB8(255,255,255));
  const Rect TileRect(0,0,TileSize-1,TileSize-1);
  for (int y=0;y<yTiles;y++)
    for (int x=0;x<xTiles;x++)
      if ((x+y)&1)
        CopyRect(Chess,x*TileSize,y*TileSize,Image1,TileRect);
      else
        FillRect(Chess,Rect(x*TileSize,y*TileSize,x*TileSize+(TileSize-1),y*TileSize+(TileSize-1)),White);
  // scroll loop
  int x=0;
  y=0;
  int Scrolling=0,LastScrollTime=SystemTimer.Time(),ScrollTimeDiff=0;
  do
    {
    int ScrollDistance;
    if (Scrolling) 
      {
      int Time=SystemTimer.Time();
      ScrollTimeDiff+=Time-LastScrollTime;
      LastScrollTime=Time;
      }
    ScrollDistance=(ScrollTimeDiff*ScrollPixelsPerSecond)/1000;
    ScrollTimeDiff=((ScrollTimeDiff*ScrollPixelsPerSecond)%1000)/ScrollPixelsPerSecond;
    if (Keyboard.IsPressed(KeyboardDriver::CursorBlockRight)) { if (Scrolling) x+=ScrollDistance; Scrolling=1; }
    if (Keyboard.IsPressed(KeyboardDriver::CursorBlockLeft))  { if (Scrolling) x-=ScrollDistance; Scrolling=1; }
    if (Keyboard.IsPressed(KeyboardDriver::CursorBlockUp))    { if (Scrolling) y-=ScrollDistance; Scrolling=1; }
    if (Keyboard.IsPressed(KeyboardDriver::CursorBlockDown))  { if (Scrolling) y+=ScrollDistance; Scrolling=1; }
    if (!Scrolling)
      { 
      Scrolling=0;
      LastScrollTime=SystemTimer.Time(); 
      }
    int sx=x&31;
    int sy=y&31;
    Video.BlitToScreen(0,0,Chess,Rect(sx,sy,sx+319,sy+199));
    }
  while (!Keyboard.WasPressed(KeyboardDriver::Escape));
  return(0);
  }
