// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

#ifndef KEYBOARD_H
#define KEYBOARD_H

#include <conio.h>
#include <dos.h>
#include <i86.h>
#include "misc/error.h"

class KeyboardDriver
  {
  private:
  static int installeddrivers;
  int flags;
    enum {
    FlagInstalled=1,
    FlagNumLock=2, };
  void (__interrupt __far *oldint)();
  volatile int ispressed[128];          // set by the kb interrupt
  volatile int waspressed[128];         //  "
  int pressedkeys;
  friend void _interrupt _far keyboardint();
  friend void RemoveKeyboardDriverOnError();
  public:
  // functions are self explaining
  KeyboardDriver();
  ~KeyboardDriver();
  int IsInstalled() { return(flags&FlagInstalled); };
  int IsNumLock() { return(flags&FlagNumLock); };
  int GetKey();             // get key code from ring buffer
  int IsPressed(int Code);  // key code or scancode
  int WasPressed(int Code); // "
  enum ScanCode
    {
    ScanCodeFlag=0x200,
    CursorBlockLeft=75|ScanCodeFlag,
    CursorBlockRight=77|ScanCodeFlag,
    CursorBlockUp=72|ScanCodeFlag,
    CursorBlockDown=80|ScanCodeFlag,
    NumBlockNumLock=69|ScanCodeFlag,
    NumBlock7=71|ScanCodeFlag,
    NumBlock8=72|ScanCodeFlag,
    NumBlock9=73|ScanCodeFlag,
    NumBlockMinus=74|ScanCodeFlag,
    NumBlock4=75|ScanCodeFlag,
    NumBlock5=76|ScanCodeFlag,
    NumBlock6=77|ScanCodeFlag,
    NumBlockPlus=78|ScanCodeFlag,
    NumBlock1=79|ScanCodeFlag,
    NumBlock2=80|ScanCodeFlag,
    NumBlock3=81|ScanCodeFlag,
    LeftShift=42|ScanCodeFlag,
    RightShift=54|ScanCodeFlag,
    Control=29|ScanCodeFlag,
    Alt=56|ScanCodeFlag,
    CapsLock=58|ScanCodeFlag,
    NumLock=69|ScanCodeFlag,
    };
  enum KeyCode // the values passed by GetKey() (former getkey()) + ASCIIs
    {
    ExtendedKeyFlag=0x100, // for non-ASCII keys: F1-F12, Ins, Del
    F1=59|ExtendedKeyFlag,
    F2=60|ExtendedKeyFlag,
    F3=61|ExtendedKeyFlag,
    F4=62|ExtendedKeyFlag,
    F5=63|ExtendedKeyFlag,
    F6=64|ExtendedKeyFlag,
    F7=65|ExtendedKeyFlag,
    F8=66|ExtendedKeyFlag,
    F9=67|ExtendedKeyFlag,
    F10=68|ExtendedKeyFlag,
    F11=87|ExtendedKeyFlag,
    F12=88|ExtendedKeyFlag,
    ShiftF1=84|ExtendedKeyFlag,
    ShiftF2=85|ExtendedKeyFlag,
    ShiftF3=86|ExtendedKeyFlag,
    ShiftF4=87|ExtendedKeyFlag,
    ShiftF5=88|ExtendedKeyFlag,
    ShiftF6=89|ExtendedKeyFlag,
    ShiftF7=90|ExtendedKeyFlag,
    ShiftF8=91|ExtendedKeyFlag,
    ShiftF9=92|ExtendedKeyFlag,
    ShiftF10=93|ExtendedKeyFlag,
    ShiftF11=135|ExtendedKeyFlag,
    ShiftF12=136|ExtendedKeyFlag,
    Delete=83|ExtendedKeyFlag,
    Insert=83|ExtendedKeyFlag,
    Home=71|ExtendedKeyFlag,
    End=79|ExtendedKeyFlag,
    PageUp=73|ExtendedKeyFlag,
    PageDown=81|ExtendedKeyFlag,
    Esc=27,
    Escape=27,
    Tab=9,
    Space=32,
    Backspace=8,
    };
  };

extern KeyboardDriver Keyboard; // the only instance, it's global

#endif
