// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

#ifndef DEVICE_TIMER_H
#define DEVICE_TIMER_H

class TimerDriver
  {
  private:
  static int installeddrivers;
  void interrupt far (*oldint)();
  int DOS_timer;                                      // DOS timer was read, when my int has been set
  volatile long time;
  long timeval; // time between 2 calls in milliseconds
  friend void interrupt timerhandler();
  public:
  TimerDriver();
  ~TimerDriver();
  int TimeVal(long MilliSecsBetweenTwoInterrupts); // return(Error);
  int TimeVal() const { return(timeval); }            // millisecs between 2 interrupts
  long Time() const { return(time); };                // in millisecs since program start
  };

extern TimerDriver SystemTimer; // the only instance of this class

class AlarmTimer // virtual base class
  {
  private:
  AlarmTimer *prev,*next;
  int alarmtime,timeval;
  volatile int flags;
  enum { HandlerIsWorking=1,FlagIsRunning=2, };
  virtual void TimerHandler(int MissedCalls) = 0;  
  friend void interrupt timerhandler();
  public:
  AlarmTimer() { prev=0;timeval=1000;flags=0; };
  virtual ~AlarmTimer() { Stop(); };
  void Start(int SystemTimeIndex);
  void Start() { Start(SystemTimer.Time()+timeval); };
  void Stop();
  // Don't expand IsRunning() inline, the problem is,
  // that Watcom optimizes "while (!Timer.IsRunning())" too much, so that
  // it becomes "and flag,mask Label: jne Label", although flags have been declared volatile!
  int IsRunning() const;
  void TimeVal(int MilliSecs);   // millisecs between two calls
  int  TimeVal() const { return timeval; };
  };
inline void AlarmTimer::TimeVal(int TimeVal)
  {
  if (TimeVal<=0) TimeVal=1;
  timeval=TimeVal;
  alarmtime=SystemTimer.Time()+TimeVal;
  }

#endif
