// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

#include "gfx/bitmap.h"
#include "gfx/blit.h"
#include "gfx/fastmem.h"
#include "misc/error.h"

void (*CopyRectStretchedFunc[Bitmap::Classes])(Bitmap& Dst,Rect &DstRect,Bitmap& Src,Rect &SrcRect);

void CopyRectStretchedInvalid(Bitmap& Dst,Rect&,Bitmap &Src,Rect &SrcRect);
void CopyRectStretchedGeneral(Bitmap& Dst,Rect&,Bitmap &Src,Rect &SrcRect);
void CopyRectStrechedPackedPixel8(Bitmap& Dst,Rect&,Bitmap& Src,Rect &SrcRect);
static class AutoInitCopyRectStretchedFunc
  {
  public:
  AutoInitCopyRectStretchedFunc()
    {
    for (int i=0;i<Bitmap::Classes;i++) CopyRectStretchedFunc[i]=CopyRectStretchedGeneral;
    CopyRectStretchedFunc[Bitmap::ClassInvalid]=CopyRectStretchedInvalid;
/* not yet implemented
    #if defined(ACCEL_CopyRectStretched_PP8) || defined(ACCEL_PP8)
    CopyRectStretchedFunc[(Bitmap::ClassPackedPixel8]=CopyRectStretched_PP8;
    #endif
*/
    };
  } InitCopyRectStretchedFunc;

void CopyRectStretchedInvalid(Bitmap&,Rect&,Bitmap&,Rect&)
  {
  ErrorExit("CopyRectStretched()  Invalid bitmap.");
  }
void CopyRectStretchedGeneral(Bitmap& Dst,Rect &DstRect,Bitmap &Src,Rect &SrcRect)
  {
  #ifdef DEBUG
  if (Dst.Class()!=Src.Class() || (Dst.Palette.Class()==Palette::ClassColorArray && (ClassDst.Palette()!=Src.Palette())) ErrorExit("CopyRectStretched()  Incompatible bitmaps.");
  int RectWidth=SrcRect.Right-SrcRect.Left+1;
  int RectHeight=SrcRect.Bottom-SrcRect.Top+1;
  if (SrcRect.Left<0 || SrcRect.Top<0 || SrcRect.Right>=Src.Width() || SrcRect.Bottom>=Src.Height()) ErrorExit("CopyRectStretched()  SrcRect exceeds bitmap.");
  if (DstRect.Left<0 || DstRect.Top<0 || DstRect.Right>=Dst.Width() || SrcRect.Bottom>=Dst.Height()) ErrorExit("CopyRectStretched()  DstRect exceeds bitmap.");
  #endif
  // generate the increment needed for the stretching
  const int WORDBITS=16;
  int sxInc=(SrcRect.Width()<<WORDBITS)/DstRect.Width();
  int syInc=(SrcRect.Height()<<WORDBITS)/DstRect.Height();
  int sxStart=SrcRect.Left<<WORDBITS;
  // copy the pixels
  int dy=DstRect.Top;
  int sy=SrcRect.Top<<WORDBITS;
  while (dy<=DstRect.Bottom)
    {
    int dx=DstRect.Left;
    int sx=sxStart;
    while (dx<=DstRect.Right)
      {
      Dst.SetPixel(dx,dy,Src.GetPixel(sx>>WORDBITS,sy>>WORDBITS));
      sx+=sxInc;
      dx++;
      }
    sy+=syInc;
    dy++;
    }
  }
