// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

// The fading function are designed for use with video modes that
// use color arrays, they won't work with HiColor/TrueColor modes.

#include "device/timer.h"
#include "gfx/palette.h"
#include "gfx/fade.h"
#include "compiler/types.h"

PaletteFader::PaletteFader(Palette &Pal)
  {
  #ifdef DEBUG
  if (Pal.ClassID()!=Palette::ClassColorArray) ErrorHandler.Abort("PaletteFader::PaletteFader()  can only fade video modes that use color arrays.");
  #endif
  pal=&Pal;
  // backup palette infos
  colors=Pal.Colors();
  startcolor=new ColorRef[colors];
  for (int i=0;i<colors;i++) startcolor[i]=Pal.GetColor(i);
  mode=ModeFadeOut;
  brightness=256; 
  }
void PaletteFader::TimerHandler(int MissedCalls)
  {
  int Change=1+MissedCalls;
  if (mode==ModeFadeOut) Change=-Change;
  int NewBrightness=brightness+Change;
  if (NewBrightness<0 || NewBrightness>256) Stop();
  Brightness(NewBrightness);
  }
void PaletteFader::Brightness(int Level)
  {
  if (Level<0) Level=0;
  if (Level>256) Level=256;
  brightness=Level;
  for (int ColorNr=0;ColorNr<colors;ColorNr++)
    {
    ColorRef FadedColor=RGB8(
     (UBYTE)(RGB8Red  (startcolor[ColorNr])*brightness>>8),
     (UBYTE)(RGB8Green(startcolor[ColorNr])*brightness>>8),
     (UBYTE)(RGB8Blue (startcolor[ColorNr])*brightness>>8));
    pal->SetColor(ColorNr,FadedColor);
    }
  };
void PaletteFader::FadeIn(int MilliSecs) 
  { 
  TimeVal(Max(MilliSecs>>8,1));
  mode=ModeFadeIn;
  Start(); 
  };
void PaletteFader::FadeOut(int MilliSecs) 
  { 
  TimeVal(Max(MilliSecs>>8,1));
  mode=ModeFadeOut;
  Start(); 
  };

