// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

#include <iostream.h>
#include <stdlib.h>
#include "misc/error.h"

GlobalErrorHandler ErrorHandler;

void GlobalErrorHandler::Abort(char *MessageString)
  {
  for (int i=cleanup_proc.Entries()-1;i>=0;i--) (*cleanup_proc[i])();
  while (!debugstring.IsEmpty()) { cerr << debugstring.Top() << "\n";debugstring.Pop(); }
  cerr << MessageString;
  exit(3);
  }
void GlobalErrorHandler::AddCleanUpProc(Proc Process)
  {
  int Index=cleanup_proc.Entries();
  cleanup_proc.Insert(Index);
  cleanup_proc[Index]=Process;
  }
void GlobalErrorHandler::RemoveCleanUpProc(Proc Process)
  {
  for (int i=cleanup_proc.Entries()-1;i>=0;i--)
    if (cleanup_proc[i]==Process) cleanup_proc.Delete(i);
  }

