// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de
// A global error handler.

#ifndef MISC_ERROR_H
#define MISC_ERROR_H

#include <misc/dynarray.h>
#include <misc/stack.h>

class GlobalErrorHandler
  {
  private:
  typedef void (*Proc)();
  Stack<char *> debugstring;
  DynArray<Proc> cleanup_proc;
  public:
  void Abort(char *MessageString);       // call this if a non-recoverable error emerges
  void AddCleanUpProc(Proc);       // add a procedure that should be called before the the program exits after calling Abort(). (for instance reset video to text mode)
  void RemoveCleanUpProc(Proc);    // remove the proc if it is no longer needed
  void EnterCriticalSection(char *DebugInfo); // additional info may help you if a program crashes. 
  void LeaveCriticalSection();
  };
inline void GlobalErrorHandler::EnterCriticalSection(char *DebugInfo) { debugstring.Push(DebugInfo); }
inline void GlobalErrorHandler::LeaveCriticalSection() { debugstring.Pop(); }

extern GlobalErrorHandler ErrorHandler;           // this should be the only instance

#endif
