// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

#ifndef MISC_MEM_H
#define MISC_MEM_H

#include <stdlib.h>
#include <mem.h>
#include "misc/error.h"

#ifdef HEAPCHECK
void HeapCheck();
void *operator new(size_t size);
void operator delete(void *ptr);
#else
inline void *operator new(size_t size)
  {
  void *ptr=malloc(size);
  if (ptr==0) ErrorHandler.Abort("new(): out of memory.");
  return(ptr);
  };
inline void operator delete(void *ptr)
  {
  free(ptr);
  }
#endif


#endif
