// AdLib Soung ToolKit For WATCOM C/C++   Modified by Kim Youngsik .WOODPARK.
//                                        (C) AdLib Inc.,
// Support : YM3812/YMF-262M FM Chip
//           Melody mode 9 channel/Percussion mode 11 channel
//           Melody mode 18 channel/Percussion mode 20 channel
//           Stereo sound
// Thanks to Park jeenhong(pkchn) and Music club members (go mul 7 12)

#ifndef __ADLIB_WATCOM__
#define __ADLIB_WATCOM__

#define nbLocParam      14

#define prmKsl          0
#define prmMulti        1
#define prmFeedBack     2           /* use for opr. 0 only */
#define prmAttack       3
#define prmSustain      4
#define prmStaining     5           /* Sustaining ... */
#define prmDecay        6
#define prmRelease      7
#define prmLevel        8
#define prmAm           9
#define prmVib          10
#define prmKsr          11
#define prmFm           12          /* use for opr. 0 only */
#define prmWaveSel      13          /* wave select */

/* globals parameters: */
#define prmAmDepth      14
#define prmVibDepth 15
#define prmNoteSel      16
#define prmPercussion   17

/* percussive voice numbers: */
#define BD              6
#define SD              7
#define TOM             8
#define CYMB            9
#define HIHAT           10

#define MAX_VOLUME      0x7f
#define LOG2_VOLUME     7           /* log2( MAX_VOLUME) */
#define MAX_PITCH       0x3fff
#define MID_PITCH       0x2000

#define MID_C           60          /* MIDI standard mid C */
#define CHIP_MID_C      48          /* sound chip mid C */
#define NR_NOTES        96          /* # of notes we can play on chip */

#define OPL2            1
#define OPL3            2

#define PAN_RIGHT       16
#define PAN_LEFT        32
#define PAN_BOTH        48

extern unsigned char DefInstPiano[];
extern unsigned char DefInstBassDrum[];
extern unsigned char DefInstSnareDrum[];
extern unsigned char DefInstTomTom[];
extern unsigned char DefInstCymbal[];
extern unsigned char DefInstHihat[];

int  CheckAdlib(unsigned port);
int  AutoDetectAdlib(void);
void SoundInit(void);
void SoundClose(void);
void SetVoicePan(unsigned voice, int pan);
void SetMode(int mode);
void SetWaveformSel(int state);
void SetPitchRange(unsigned pR);
void SetGParam(int amD, int vibD, int nSel);
void SetVoiceTimbre(unsigned voice, unsigned char *paramArray);
void SetVoiceVolume(unsigned voice, unsigned volume);
void SetVoicePitch(unsigned voice, unsigned pitchBend);
void NoteOn(unsigned voice, int pitch);
void NoteOff(unsigned voice);

#endif
