#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <malloc.h>
#include "ADLIB.H"
#include "SPINST.H"
#include "SPIMS.H"

void StartTimeOut(int skip);
void StopTimeOut(void);
void SetClkRate(int divisor);
void ClkInstall(void);
void ClkUninstall(void);

#define PLAYINFO_STOP       0
#define PLAYINFO_PLAY       1

unsigned char *IMSData;

IMSHEAD  IMSHeader;

BANKINFO IMSInstInfo;
INSTNAME *IMSInstName;
INSTDATA *IMSInstData;

long PlayByte;
long PlayTick;
int  PlayInfo;

int  DelayTick;
int  Status;

int LoadIMSFile(char *filename)
{
    FILE *fp;

    if ((fp = fopen(filename, "rb")) == NULL) return(1);
    fread(&IMSHeader, sizeof(IMSHeader), 1, fp);
    IMSData = (unsigned char *)malloc(IMSHeader.DataSize);
    fread(IMSData, IMSHeader.DataSize, 1, fp);
    fseek(fp, 1, SEEK_CUR);
    fread(&IMSInstInfo.NeedInst, 2, 1, fp);
    IMSInstName = (INSTNAME *)malloc(IMSInstInfo.NeedInst * 12);
    IMSInstData = (INSTDATA *)malloc(IMSInstInfo.NeedInst * 30);
    for (int i = 0; i < IMSInstInfo.NeedInst; i++) fread(&IMSInstName[i].InstName, 9, 1, fp);
    fclose(fp);

    return(0);
}

void FreeMemory(void)
{
    free(IMSData);
    free(IMSInstName);
    free(IMSInstData);
}

void ChangeInst(int channel)
{
    unsigned char i;

    i = IMSData[PlayByte++] & 0x7F;

    if (IMSInstName[i].Marker) {
        SetVoiceTimbre(channel, IMSInstData[i].InstData);
    }
}

void ChangeVolume(int channel)
{
    unsigned char i;

    i = IMSData[PlayByte++] & 0x7F;
    SetVoiceVolume(channel, i);
}

void ChangePitchBend(int channel)
{
    unsigned Data;

    Data = IMSData[PlayByte++] & 0x7F;
    Data += (unsigned)(IMSData[PlayByte++] & 0x7F) << 7;
    SetVoicePitch(channel, Data);
}

void ChangeTempo(void)
{
    unsigned char Data1, Data2;
    unsigned Tempo;

    Data1 = IMSData[PlayByte++];
    Data2 = IMSData[PlayByte++];

    if (Data1 == 0x7F && Data2 == 0x00) {
        Data1 = IMSData[PlayByte++];
        Data2 = IMSData[PlayByte++];
        Tempo = IMSHeader.BasicTempo;
        Tempo = (Tempo * Data2 >> 7) + Tempo * Data1;
        SetClkRate(1193180 / (IMSHeader.TickPerBeat * Tempo / 60));
        PlayByte++;
    } else {
        PlayByte -= 2;
        while(IMSData[PlayByte++] != 0xF7);
    }
}

void ChangeNote1(int channel)
{
    unsigned char volume, pitch;

    NoteOff(channel);
    pitch = IMSData[PlayByte++] & 0x7F;
    volume = IMSData[PlayByte++] & 0x7F;

    if (volume) {
        SetVoiceVolume(channel, volume);
        NoteOn(channel, pitch);
    }
}

void ChangeNote2(int channel)
{
    unsigned char volume, pitch;

    pitch = IMSData[PlayByte++] & 0x7F;
    volume = IMSData[PlayByte++] & 0x7F;

    if (!volume) {
        NoteOff(channel);
    } else {
        SetVoiceVolume(channel, volume);
        NoteOn(channel, pitch);
    }
}

int TimeOut(void)
{
    int i, channel;

    if (PlayInfo == PLAYINFO_STOP) return(1);

    PlayTick += DelayTick;

    if (PlayByte >= IMSHeader.DataSize || PlayTick >= IMSHeader.TotalTick) {
        PlayInfo = PLAYINFO_STOP;
        return(1);
    }

    DelayTick = 0;

    i = IMSData[PlayByte];

    if (i == 0xF0) {
        PlayByte++;
        ChangeTempo();
    } else if (i != 0xFC) {
        if (i >= 0x80) {
            Status = i;
            PlayByte++;
        }
        channel = 0x0F & Status;
        switch (0xF0 & Status) {
            case 0xA0 : ChangeVolume(channel);
                        break;
            case 0xB0 : PlayByte += 2;
                        break;
            case 0xC0 : ChangeInst(channel);
                        break;
            case 0xD0 : PlayByte++;
                        break;
            case 0xE0 : ChangePitchBend(channel);
                        break;
            case 0x80 : ChangeNote1(channel);
                        break;
            case 0x90 : ChangeNote2(channel);
                        break;
            default   : while (IMSData[PlayByte] < 0x80) PlayByte++;
                        if (IMSData[PlayByte] != 0xF8) PlayByte--;
                        break;
        }
    }
    while(1) {
        if (i == 0xFC) {
            PlayInfo = PLAYINFO_STOP;
            return(DelayTick);
        }
        i = IMSData[PlayByte++];
        if (i != 0xF8) break;
        DelayTick += 240;
    }

    DelayTick += i;

    return(DelayTick);
}

void main(int argc, char **argv)
{
    printf("\nAdLib Sound ToolKit IMS Player for WATCOM C/C++  (c) Kim Youngsik (WOODPARK)\n\n");

    if (argc != 3) {
        printf("Usage : SPIMS [IMS filename] [BNK filename]\n");
        return;
    }

    if (LoadIMSFile(argv[1])) {
        printf("Error : IMS file not found!\n");
        return;
    }

    if (LoadInstFile(argv[2], &IMSInstInfo, IMSInstName, IMSInstData)) {
        FreeMemory();
        printf("Error : BNK file not found!\n");
        return;
    }

    printf("AdLib I/O Port : %Xh", AutoDetectAdlib());
    printf("  Bank Info : %d/%d\n", IMSInstInfo.FoundInst, IMSInstInfo.NeedInst);

    ClkInstall();
    SoundInit();
    SetMode(IMSHeader.SoundMode);
    PlayInfo = 1;
    StartTimeOut(10);

    while(!kbhit());

    SoundClose();
    FreeMemory();
    ClkUninstall();
}

