#include <stdio.h>
#include <string.h>
#include "SPINST.H"

//
//  You must store BankInfo->NeedInfo and InstName structure!
//
int LoadInstFile(char *filename, BANKINFO *BankInfo, INSTNAME *InstName, INSTDATA *InstData)
{
    FILE     *fp;
    short    same;
    long     T, B, M;
    INSTNAME NameRec;
    INSTHEAD InstHead;

    BankInfo->FoundInst = 0;
    if ((fp = fopen(filename, "rb")) == 0) return(1);
    fread((INSTHEAD *)&InstHead, sizeof(INSTHEAD), 1, fp);
    BankInfo->TotalInst = InstHead.TotalInst;

    for (int i = 0; i < BankInfo->NeedInst; i++) {
        T = 0;
        B = InstHead.TotalInst;
        while (B > T) {
            M = (B + T) >> 1;
            fseek(fp, InstHead.ListOff + M * sizeof(INSTNAME), SEEK_SET);
            fread(&NameRec, sizeof(INSTNAME), 1, fp);
            same = stricmp(InstName[i].InstName, NameRec.InstName);
            if (same < 0)      B = M;
            else if (same > 0) T = M + 1;
            else break;
        }
        if (!same) {
            BankInfo->FoundInst++;
            InstName[i].Marker = 1;
            fseek(fp, InstHead.DataOff + NameRec.No * sizeof(INSTDATA), SEEK_SET);
            fread(&InstData[i], sizeof(INSTDATA), 1, fp);
        } else {
            InstName[i].Marker = 0;
        }
    }
    fclose(fp);

    return(0);
}


