#ifndef __SORIPARK_BANK__
#define __SORIPARK_BANK__

typedef struct {
    short unsigned Version;
    char           Signature[6];
    short unsigned TotalInst, MaxInst;
    long           ListOff, DataOff;
    char           Filler[8];
} INSTHEAD;

typedef struct {
    short unsigned No;
    char           Marker;      /* Did you get instrument? Yes=1, No=0 */
    char           InstName[9];
} INSTNAME;

typedef struct {
    char          Mode;         /* See INSTMODE table */
    char          PercVoice;    /* Is this Melody instrument? Yes=1, No=0,Percussion instrument */
    unsigned char InstData[28];
} INSTDATA;

typedef struct {
    long          NeedInst;
    long          FoundInst;
    long          TotalInst;
} BANKINFO;

int  LoadInstFile(char *filename, BANKINFO *BankInfo, INSTNAME *InstName, INSTDATA *InstData);

#endif
