// 8253 Timer Controller Control For Watcom C/C++ (c) Kim Youngsik =-WoodPark-=

#include <dos.h>
#include <conio.h>

#pragma aux Disable = "CLI";
#pragma aux Enable = "STI";

void __interrupt __far (*OldClkInt8)(void);

int TimeOut(void);

int NewTimerTick;
int OldTimerTick;
int TempNewTimerTick;
int TempOldTimerTick;
int WaitCount;
int Timer0Divisor;
int SkipTick;
int SkipTickCount;
int ActTimeOut;

void __interrupt __far ClkInt(void)
{
    Disable();

    SkipTickCount++;
    if (SkipTickCount > SkipTick) {
        if (ActTimeOut) SkipTick = TimeOut();
        SkipTickCount = 0;
    }

    NewTimerTick++;
    if (NewTimerTick == 0xFFFFFFFF) NewTimerTick = 0;
    TempNewTimerTick++;
    if (TempNewTimerTick == 0xFFFFFFFF) TempNewTimerTick = 0;
    if (WaitCount >= 65536L) {
        OldTimerTick++;
        if (OldTimerTick == 0xFFFFFFFF) OldTimerTick = 0;
        TempOldTimerTick++;
        if (TempOldTimerTick == 0xFFFFFFFF) TempOldTimerTick = 0;
        OldClkInt8();
        WaitCount -= 65536L;
    }
    WaitCount += Timer0Divisor;

    outp(0x20, 0x20);
    Enable();
}

void StartTimeOut(int skip)
{
    ActTimeOut = 1;
    SkipTick = skip;
}

void StopTimeOut(void)
{
    ActTimeOut = 0;
}

void SetClkRate(int divisor)
{
    WaitCount  = 0;
    SkipTick = 0;
    Timer0Divisor = divisor;
    if (divisor == 0) Timer0Divisor = 65536L;
    if (Timer0Divisor > 65536L) {
        Timer0Divisor = 65536L;
        divisor = 0;
    }
    outp(0x43, 0x36);
    outp(0x40, divisor & 0xFF);
    outp(0x40, divisor >> 8);
}

void ClkInstall(void)
{
    OldClkInt8 = _dos_getvect(0x08);
    _dos_setvect(0x08, ClkInt);
    SetClkRate(11931800L / 182L);
}

void ClkUninstall(void)
{
    _dos_setvect(0x08, OldClkInt8);
    SetClkRate(11931800L / 182L);
}

