/////////////////////////////////////////
//              CMapField.cpp
//
//            ʵ  Ŭ 
//
//              ۱Ⱓ 
//
//           1996 9 10
//                
//           1996 9 12 
//
//          Ʈ XE47   
//
/////////////////////////////////////////

#include "stdafx.h"
#include "CMapField.h"
#include "DirtDraw.h"
#include "DirtSnd.h"
#include "Music.h"

void CTile::PutTile(LPDIRECTDRAWSURFACE lpSurface, int x, int y)
{
	// 
	// Ŭ ó  Ÿ  Լ
		
	HRESULT ddrval;
	ddrval = lpSurface->BltFast(x, y, lpOffTile, &rcTile,
		                        DDBLTFAST_NOCOLORKEY | DDBLTFAST_WAIT);
}

void CTile::PutTileEx(LPDIRECTDRAWSURFACE lpSurface, int x, int y)
{
	//
	// Ÿ Ŭ  Լ
	//
	
	int iTileSzX = rcTile.right  - rcTile.left;
	int iTileSzY = rcTile.bottom - rcTile.top; // Ʈ ,  ũ⸦ Ѵ
	int ixTileSzX = x + iTileSzX - 1;
	int iyTileSzY = y + iTileSzY - 1;  // ǥ Ʈũ⸦ Ѵ
	RECT rcOldTile = rcTile;
	HRESULT ddrval;	

	// Ʈ ũ    ʴ´
	if (x > 639 || y > 479) return;
	if (ixTileSzX <= 0 || iyTileSzY <= 0) return;  
	
	// Ʈ ũ   ŭ  ʴ´
	//  ũ 簢   Ŭ Ѵ
	if (x < 0) { rcTile.left -= x; x=0; }
	else if (ixTileSzX > 639) rcTile.right  -= (ixTileSzX - 639);
	if (y < 0) { rcTile.top  -= y; y=0; }
	else if (iyTileSzY > 479) rcTile.bottom -= (iyTileSzY - 479);
		
	ddrval = lpSurface->BltFast(x, y, lpOffTile, &rcTile,
		                        DDBLTFAST_NOCOLORKEY | DDBLTFAST_WAIT);
	rcTile = rcOldTile;
}

////////////////////
////////////////////

CMapField::CMapField(CDirtDraw* pCDDraw, CDirtSnd* pCDSound)
{
	pDD = pCDDraw;
	pDS = pCDSound;

	ptStepTable[ 0] = CPoint( 0, 4);	ptStepTable[ 1] = CPoint(-2, 4);
	ptStepTable[ 2] = CPoint(-4, 4);	ptStepTable[ 3] = CPoint(-4, 2);
	ptStepTable[ 4] = CPoint(-4, 0);	ptStepTable[ 5] = CPoint(-4,-2);
	ptStepTable[ 6] = CPoint(-4,-4);	ptStepTable[ 7] = CPoint(-2,-4);
	ptStepTable[ 8] = CPoint( 0,-4);	ptStepTable[ 9] = CPoint( 2,-4);
	ptStepTable[10] = CPoint( 4,-4);	ptStepTable[11] = CPoint( 4,-2);
	ptStepTable[12] = CPoint( 4, 0);	ptStepTable[13] = CPoint( 4, 2);
	ptStepTable[14] = CPoint( 4, 4);	ptStepTable[15] = CPoint( 2, 4);

	ptSMap = CPoint(-32, -32);
	ptStep = CPoint(  0,   0);
}

CMapField::~CMapField()
{
}

void CMapField::LoadMap(char* name)
{
	// ͸ о ,  m_wMap Ѵ
	struct MapHeader_ {
	BYTE  Code,
		  TileSize;   //   16 
	WORD  MapSizeX,
		  MapSizeY;
	DWORD MapSize;
	BYTE  Temp[6];	
	} MapHeader;

	CFile    File;	
	BOOL     frval;
	int MapSize;
	
	frval = File.Open(name, CFile::modeRead | CFile::typeBinary);
	if (!frval) pDD->DirectDrawError("Ʈ ȭ  ");
	//
	File.Read(&MapHeader, sizeof(MapHeader));

    szMapSize.cx = MapHeader.MapSizeX;
	szMapSize.cy = MapHeader.MapSizeY;
	MapSize = szMapSize.cx * szMapSize.cy * sizeof(short);
    //
    m_wMap = (short*) malloc (MapSize);	
    //
	File.Read(m_wMap, MapSize);    
    File.Close();
}
	
void CMapField::LoadTile(char* name)
{
	// Ÿ ҷ TilaArray ޸𸮻 Ѵ
	struct TileHeader_ {	
	BYTE Code, TileCount, TileSizeX, TileSizeY;	
	WORD TileSize;	
	BYTE Temp[2];	
	} TileHeader;
	
	CFile    File;	
	BOOL     frval;	
	LPBYTE   Tile, OffScrBuf;
	HRESULT  ddrval;	
	DDSURFACEDESC ddsd;	  
	int      i, ix, iy, TileCount;
    	
	frval=File.Open(name, CFile::modeRead | CFile::typeBinary);
	if (!frval) pDD->DirectDrawError("Ÿ ȭ  ");
	//   
	File.Read(&TileHeader, sizeof(TileHeader));
	if (TileHeader.Code != 0x77) pDD->DirectDrawError("Ÿ ȭ ƴմϴ");	
	TileCount = TileHeader.TileCount;
	File.SeekToBegin();
	//
	TileArray.SetSize(TileCount);
	//  Ÿ д´		
    for (i=0; i < TileCount; i++)	
	{			
		File.Read(&TileHeader, sizeof(TileHeader));		
        m_Tile = new CTile;
		m_Tile->rcTile.left   = 0;
		m_Tile->rcTile.top    = 0;
		m_Tile->rcTile.right  = TileHeader.TileSizeX;
		m_Tile->rcTile.bottom = TileHeader.TileSizeY;
		Tile = (LPBYTE) malloc(TileHeader.TileSize);
		File.Read(Tile, TileHeader.TileSize);
		// ũ 
		memset(&ddsd, 0, sizeof(ddsd));
		ddsd.dwSize  = sizeof(ddsd);
		ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
		ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
		ddsd.dwHeight = TileHeader.TileSizeY;
		ddsd.dwWidth  = TileHeader.TileSizeX;
		ddrval = pDD->GetDD()->CreateSurface(&ddsd, &(m_Tile->lpOffTile), NULL);
		if (ddrval != DD_OK) pDD->DirectDrawError("Ÿ ũ  ");
		// ũ Ʈ Ѵ
		memset(&ddsd, 0, sizeof(ddsd));
		ddsd.dwSize = sizeof(ddsd);
		m_Tile->lpOffTile->Lock(NULL, &ddsd, 0, NULL);
		OffScrBuf = (LPBYTE) ddsd.lpSurface;			
		for (iy=ix=0; iy < TileHeader.TileSizeY; iy++)
		{
			memcpy(OffScrBuf, Tile+ix, TileHeader.TileSizeX);
			OffScrBuf += ddsd.lPitch;
			ix += TileHeader.TileSizeX;
		}
		m_Tile->lpOffTile->Unlock(ddsd.lpSurface);		
		TileArray[i] = m_Tile;
		free(Tile);
	} 	
	File.Close();	
}

void CMapField::DeleteTileArray()
{	
	int i, count;	

	count = TileArray.GetSize();
	for (i=0; i < count; i++)
	{		
		m_Tile = TileArray[i];		
		m_Tile->lpOffTile->Release(); // ũ 		
		m_Tile->lpOffTile=NULL;
		delete m_Tile;                // TileArray m_Tile Ѵ
	}
	TileArray.RemoveAll();	          // TileArray    ޸𸮸  	
}

void CMapField::DrawTile(CPoint Map, CPoint i)
{
	short TileIndex;
	CPoint FromMap, ToMap(Map.x +22, Map.y+17);	
	int   OldIx = i.x;

	// 1ǥ  Ÿ  20 x 15
	// ũ ⿡ 2Ÿ   22 x 17
	for (FromMap.y = Map.y; FromMap.y < ToMap.y; FromMap.y++)
	{
		for (FromMap.x = Map.x; FromMap.x < ToMap.x; FromMap.x++)
		{
			TileIndex = *(m_wMap + FromMap.y * szMapSize.cx + FromMap.x);
			// Ÿ Ŭ ó
			// x : 639 - 32 = 607, y : 479 - 32 = 447
			if (i.x >= 0 && i.x <= 607 && i.y >= 0 && i.y <= 447)
				TileArray[TileIndex]->PutTile(pDD->lpDDSBack, i.x, i.y);
			else 
				TileArray[TileIndex]->PutTileEx(pDD->lpDDSBack, i.x, i.y);	
			i.x += 32;
		}		
		i.x = OldIx;
		i.y += 32;
	}
}

void CMapField::ScrollMap(int Direction, int Event)
{
	if (Direction != -1) ptStep = ptStepTable[Direction];

	ptSMap += ptStep; ptMapShip -= ptStep;

	if (ptSMap.x > -1)
	{
		ptSMap.x = -32; ptMap.x--; 		
		if (ptMap.x < 1)
		{
			ptMap.x     =  szMapSize.cx - 22 - 2;			
			ptMapShip.x = (szMapSize.cx - 12) * 32;
			if (Event == 0) pDS->Play(TELEPORT);
		}
	}
	if (ptSMap.y > -1)
	{
		ptSMap.y = -32; ptMap.y--; 		
		if (ptMap.y < 1)
		{
			ptMap.y     =  szMapSize.cy - 17 - 1;			
			ptMapShip.y = (szMapSize.cy - 9) * 32 - 16; // == - 7.5 * 32
			if (Event == 0) pDS->Play(TELEPORT);
		}		
	}
	if (ptSMap.x < -63)
	{
		ptSMap.x = -32;	ptMap.x++; 
		if (ptMap.x > szMapSize.cx - 22 - 2)
		{			
			ptMap.x = 1;
			ptMapShip.x = 320 + 32;  // 32 * 10Ÿ
			if (Event == 0) pDS->Play(TELEPORT);			
		}		
	}
	if (ptSMap.y < -63)
	{
		ptSMap.y = -32; ptMap.y++; 
		if (ptMap.y > szMapSize.cy - 17 - 1)
		{			
			ptMap.y = 1;
			ptMapShip.y = 240 + 32;
			if (Event == 0) pDS->Play(TELEPORT);			
		}
	}
	DrawTile(ptMap, ptSMap);	
}