/////////////////////////////////////////
//              CMapField.h 
//
//            ʵ  Ŭ 
//
//              ۱Ⱓ 
//
//           1996 9 10
//                
//           1996 9 12 
//
//          Ʈ XE47   
//
/////////////////////////////////////////

#ifndef __CMAPFIELD_H
#define __CMAPFIELD_H

#include <ddraw.h>

class CDirtDraw;
class CDirtSnd;

class CTile
{
public:	
	RECT  rcTile;
	LPDIRECTDRAWSURFACE lpOffTile;	

public:
	CTile() { lpOffTile = NULL; };
	~CTile() { };
	void PutTile  (LPDIRECTDRAWSURFACE lpSurface, int x, int y);
	void PutTileEx(LPDIRECTDRAWSURFACE lpSurface, int x, int y);
};

class CMapField 
{
private:
	CDirtDraw* pDD;	
	CDirtSnd*  pDS;
	CPoint ptMapShip;       //   ǥ
	CPoint ptMap;           //  ǥ
	CPoint ptSMap;          // ũ  ǥ 
	CPoint ptStep;          //  ũ 
	CPoint ptStepTable[16];	
	CSize  szMapSize;
	short* m_wMap;
	CTile* m_Tile;
	CArray <CTile*, CTile*&> TileArray;

public:
	CMapField(CDirtDraw* pCDDraw, CDirtSnd* pCDSound); 
	~CMapField();
	void LoadTile(char* name);
	void LoadMap(char* name);
	void DrawTile(CPoint Map, CPoint i);
	void ScrollMap(int Direction, int Event);
	inline void PutMapPosition(CPoint Pos) { ptMap = Pos; }
	inline void PutMapShipPosition(CPoint Pos) { ptMapShip = Pos; }
	inline CPoint GetMapShipPosition(void) { return ptMapShip; }
	inline CPoint GetStep(int Direction) { return ptStepTable[Direction]; }
	inline void ReleaseMap(void) { free(m_wMap); }
	void DeleteTileArray();
};

#endif