
#include "stdafx.h"
#include "CSprite.h"
#include "DirtDraw.h"

void SpriteFrame::PutSpriteFx(LPDIRECTDRAWSURFACE lpSurface, CRect rcDest)
{
	lpSurface->Blt(&rcDest, lpOffSpr,
		           &rcSpr, DDBLT_KEYSRC | DDBLT_WAIT, NULL);
}

void SpriteFrame::PutSprite(LPDIRECTDRAWSURFACE lpSurface, int x, int y)
{
	// 
	// Ŭ ó  Ʈ Լ
		
	HRESULT ddrval;
	ddrval = lpSurface->BltFast(x - CenterX, y - CenterY, lpOffSpr, &rcSpr,
		                        DDBLTFAST_SRCCOLORKEY | DDBLTFAST_WAIT);
}

void SpriteFrame::PutSpriteEx(LPDIRECTDRAWSURFACE lpSurface, int x, int y)
{
	//
	// Ʈ Ŭ  Լ
	//
	x -= CenterX; y -= CenterY;

	int iSprSzX = rcSpr.right  - rcSpr.left;
	int iSprSzY = rcSpr.bottom - rcSpr.top; // Ʈ ,  ũ⸦ Ѵ
	int ixSprSzX = x + iSprSzX;
	int iySprSzY = y + iSprSzY;  // ǥ Ʈũ⸦ Ѵ

	RECT rcOldSpr = rcSpr;
	HRESULT ddrval;	

	// Ʈ ũ    ʴ´
	if (x > 639 || y > 479) return;
	if (ixSprSzX <= 0 || iySprSzY <= 0) return;
	
	// Ʈ ũ   ŭ  ʴ´
	//  ũ 簢   Ŭ Ѵ
	if (x < 0) { rcSpr.left -= x; x=0; }
	else if (ixSprSzX > 639) rcSpr.right  -= (ixSprSzX - 639);
	if (y < 0) { rcSpr.top  -= y; y=0; }
	else if (iySprSzY > 479) rcSpr.bottom -= (iySprSzY - 479);

	ddrval = lpSurface->BltFast(x, y, lpOffSpr, &rcSpr,
		                        DDBLTFAST_SRCCOLORKEY | DDBLTFAST_WAIT);
	rcSpr = rcOldSpr;
}

RECT SpriteFrame::GetPosition(int x, int y)
{
	RECT Pos;
	int iSprSzX = rcSpr.right  - rcSpr.left;
	int iSprSzY = rcSpr.bottom - rcSpr.top; // Ʈ ,  ũ⸦ Ѵ

	Pos.left   = x - CenterX;         // ǥ x1
	Pos.top    = y - CenterY;         // ǥ y1
	Pos.right  = Pos.left + iSprSzX;  // ǥ x2
	Pos.bottom = Pos.top  + iSprSzY;  // ǥ y2

	return Pos;
}

//////////////////
//////////////////
//////////////////

void CSprite::DeleteSpriteList()
{	
	int i, count, count2, SprListCount;

	count2 = SprCharArray.GetSize();
	for (i=0; i < count2; i++)
	{		
		Sprite = SprCharArray[i];           
		SprListCount = Sprite->SprList.GetCount(); 
		for (count=0, Sprite->Pos=Sprite->SprList.GetHeadPosition();
		     count < SprListCount; count++) 
		{	
			Sprite->SprFrame = Sprite->SprList.GetAt(Sprite->Pos);
			Sprite->SprFrame->lpOffSpr->Release();  // ũ 			
			Sprite->SprFrame->lpOffSpr=NULL;
			delete Sprite->SprFrame;  // SprList SprFrame Ѵ
			Sprite->SprList.GetNext(Sprite->Pos);
		}
		Sprite->SprList.RemoveAll();  // SprList    ޸𸮸 Ѵ
		delete Sprite;                // SprCharArray Sprite Ѵ 		
	}
	SprCharArray.RemoveAll();	      // SprCharArray    ޸𸮸  
}

void CSprite::LoadSprite(char* name, DWORD ColorKeyL, DWORD ColorKeyH)
{
	// Ʈ ҷ ũ Ѵ
	struct SpriteFileHeader {
	BYTE  Code, SprCharCount;
	} SprFileHeader;
	//  : ƮĴ ¦  о δ 
	//    ) BYTE a;  1Byte ƴ 2byte о δ(  1Byte )
	struct SpriteHeader {	
	BYTE CharType, SprCount, SizeX, SizeY;	
	WORD SprSize;	
	BYTE CenterX, CenterY;	
	} SprHeader;
	// CharType  α׷  ʴ´
	// о    Ʈ  Ѵ
	
	CFile    File;	
	BOOL     frval;
	HRESULT  ddrval;
	int      i, j, ix, iy, SprCount;	
	LPBYTE   Spr, OffScrBuf; // Ǵ LPSTR		
	DDSURFACEDESC ddsd;	  
	
	frval=File.Open(name, CFile::modeRead | CFile::typeBinary);
	if (!frval) pDD->DirectDrawError("Ʈ ȭ  ");

	// Ʈ ȭ  д´
	File.Read(&SprFileHeader, sizeof(SprFileHeader));
	if (SprFileHeader.Code != 0x2F) pDD->DirectDrawError("Ʈ ȭ ƴմϴ");
	SprCharArray.SetSize(SprFileHeader.SprCharCount);

	//  Ʈ д´		
	for (i=0; i < SprFileHeader.SprCharCount; i++)
	{
		Sprite = new Sprites;		
		j = 0;
        do 
		{			
			File.Read(&SprHeader, sizeof(SprHeader));
			if (j == 0) SprCount = SprHeader.SprCount;
			Spr = (LPBYTE) malloc(SprHeader.SprSize);			
			if (Spr == NULL) pDD->DirectDrawError("޸ Ҵ ");
			File.Read(Spr, SprHeader.SprSize);
			//  Ʈ   о    Ѵ 
			Sprite->SprFrame = new SpriteFrame;
			Sprite->SprFrame->iFrame    = j;  // Ʈ  ε 0  ο
			Sprite->SprFrame->iFrameCount = SprCount;
			Sprite->SprFrame->rcSpr.left   = 0;
			Sprite->SprFrame->rcSpr.top    = 0;
			Sprite->SprFrame->rcSpr.right  = SprHeader.SizeX;
			Sprite->SprFrame->rcSpr.bottom = SprHeader.SizeY;
			Sprite->SprFrame->CenterX      = SprHeader.CenterX;
			Sprite->SprFrame->CenterY      = SprHeader.CenterY;
			// ũ 
			memset(&ddsd, 0, sizeof(ddsd));
			ddsd.dwSize  = sizeof(ddsd);
			ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
			ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
			ddsd.dwHeight = SprHeader.SizeY;
			ddsd.dwWidth  = SprHeader.SizeX;
			ddrval = pDD->lpDD->CreateSurface(&ddsd, &(Sprite->SprFrame->lpOffSpr), NULL);
			if (ddrval != DD_OK) pDD->DirectDrawError("ũ  ");

			// ũ Ʈ Ѵ
			memset(&ddsd, 0, sizeof(ddsd));
			ddsd.dwSize = sizeof(ddsd);
			Sprite->SprFrame->lpOffSpr->Lock(NULL, &ddsd, 0, NULL);
			OffScrBuf = (LPBYTE) ddsd.lpSurface;			
			for (iy=ix=0; iy < SprHeader.SizeY; iy++)
			{
				memcpy(OffScrBuf, Spr+ix, SprHeader.SizeX);
				OffScrBuf += ddsd.lPitch;
				ix += SprHeader.SizeX;
			}
			Sprite->SprFrame->lpOffSpr->Unlock(ddsd.lpSurface);
			//  Ʈ  ÷Ű  
			pDD->SetColorKeys(Sprite->SprFrame->lpOffSpr, ColorKeyL, ColorKeyH);		
			// Ʈ     Ϸ, SprList ߰Ѵ 
			Sprite->SprList.AddTail(Sprite->SprFrame);		
			free(Spr);			
		} while (++j < SprCount);

		// ĳͿ     Ϸ, SprCharArray ߰Ѵ 
		Sprite->Pos = Sprite->SprList.GetHeadPosition();					
		SprCharArray[i] = Sprite;
	}	
	File.Close();
}

RECT CSprite::GetSpriteRect(int SprType, int SprAction)
{
	Sprite = SprCharArray[SprType];	
	Pos = Sprite->SprList.FindIndex(SprAction);
	SprFrame = Sprite->SprList.GetAt(Pos);
	return SprFrame->rcSpr;
}

void CSprite::PutSprite(int SprType, int x, int y)
{
	Sprite = SprCharArray[SprType];
	SprFrame = Sprite->SprList.GetAt(Sprite->Pos);
	SprFrame->PutSprite(pDD->lpDDSBack, x, y);
}

void CSprite::PutSprite(int SprType, int SprAction, int x, int y)
{
	Sprite = SprCharArray[SprType];	
	Pos = Sprite->SprList.FindIndex(SprAction);
	SprFrame = Sprite->SprList.GetAt(Pos);
	SprFrame->PutSprite(pDD->lpDDSBack, x, y);
}
void CSprite::PutSpriteEx(int SprType, int x, int y)
{
	Sprite = SprCharArray[SprType];	
	SprFrame = Sprite->SprList.GetAt(Sprite->Pos);
	SprFrame->PutSpriteEx(pDD->lpDDSBack, x, y);
}

void CSprite::PutSpriteEx(int SprType, int SprAction, int x, int y)
{
	Sprite = SprCharArray[SprType];	
	Pos = Sprite->SprList.FindIndex(SprAction);
	SprFrame = Sprite->SprList.GetAt(Pos);
	SprFrame->PutSpriteEx(pDD->lpDDSBack, x, y);
}

void CSprite::PutSpriteFx(int SprType, CRect Dest)
{
	Sprite = SprCharArray[SprType];
	SprFrame = Sprite->SprList.GetAt(Sprite->Pos);
	SprFrame->PutSpriteFx(pDD->lpDDSBack, Dest);
}

void CSprite::PutSpriteFx(int SprType, int SprAction, CRect Dest)
{
	Sprite = SprCharArray[SprType];	
	Pos = Sprite->SprList.FindIndex(SprAction);
	SprFrame = Sprite->SprList.GetAt(Pos);
	SprFrame->PutSpriteFx(pDD->lpDDSBack, Dest);
}

void CSprite::PutSpriteDirect(int SprType, int x, int y)
{
	Sprite = SprCharArray[SprType];
	SprFrame = Sprite->SprList.GetAt(Sprite->Pos);
	SprFrame->PutSprite(pDD->lpDDSPrimary, x, y);
}

void CSprite::PutSpriteDirect(int SprType, int SprAction, int x, int y)
{
	Sprite = SprCharArray[SprType];	
	Pos = Sprite->SprList.FindIndex(SprAction);
	SprFrame = Sprite->SprList.GetAt(Pos);
	SprFrame->PutSprite(pDD->lpDDSPrimary, x, y);
}

void CSprite::PutSpriteDirectFx(int SprType, CRect Dest)
{
	Sprite = SprCharArray[SprType];
	SprFrame = Sprite->SprList.GetAt(Sprite->Pos);
	SprFrame->PutSpriteFx(pDD->lpDDSPrimary, Dest);
}

void CSprite::PutSpriteDirectFx(int SprType, int SprAction, CRect Dest)
{
	Sprite = SprCharArray[SprType];	
	Pos = Sprite->SprList.FindIndex(SprAction);
	SprFrame = Sprite->SprList.GetAt(Pos);
	SprFrame->PutSpriteFx(pDD->lpDDSPrimary, Dest);
}

void CSprite::SprNextFrame(int SprType)
{
	///  Ʈ  Ѵ
	Sprite = SprCharArray[SprType];
	SprFrame = Sprite->SprList.GetNext(Sprite->Pos);
	if (Sprite->Pos == NULL)
	{
		Sprite->Pos = Sprite->SprList.GetHeadPosition();
	}
}

void CSprite::SprPrevFrame(int SprType)
{
	///  Ʈ  Ѵ 
	Sprite = SprCharArray[SprType];
	SprFrame = Sprite->SprList.GetPrev(Sprite->Pos);
	if (Sprite->Pos == NULL)
	{
		Sprite->Pos = Sprite->SprList.GetTailPosition();
	}
}

int CSprite::SprNextFrameKey(int SprType, DWORD Delay)
{
	///  Ʈ  Ѵ	
	SpriteFrame* SprFrame;
	static DWORD LastTick = 0;
	DWORD ThisTick = GetTickCount();
	
	if (ThisTick - LastTick > Delay)
	{
		LastTick = ThisTick;
		Sprite = SprCharArray[SprType];
		SprFrame = Sprite->SprList.GetNext(Sprite->Pos);		
		if (Sprite->Pos == NULL)
		{
			Sprite->Pos = Sprite->SprList.GetHeadPosition();
		}
		// ùٸ iFrame ϱ  ٽ  ´ 
		SprFrame = Sprite->SprList.GetAt(Sprite->Pos);
		return SprFrame->iFrame;			
	}	
	return -1;	
}

int CSprite::SprPrevFrameKey(int SprType, DWORD Delay)
{
	///  Ʈ  Ѵ
	SpriteFrame* SprFrame;
	static DWORD LastTick = 0;
	DWORD ThisTick = GetTickCount();

	if (ThisTick - LastTick > Delay)
	{
		LastTick = ThisTick;
		Sprite = SprCharArray[SprType];
		SprFrame = Sprite->SprList.GetPrev(Sprite->Pos);		
		if (Sprite->Pos == NULL)
		{
			Sprite->Pos = Sprite->SprList.GetTailPosition();
		}		
		// ùٸ iFrame ϱ  ٽ  ´ 
		SprFrame = Sprite->SprList.GetAt(Sprite->Pos);
		return SprFrame->iFrame;	
	}	
	return -1;
}

BOOL CSprite::DelayTime(int Index, DWORD Delay)
{	
	static DWORD LastTick[11] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
	DWORD ThisTick[11];

	ThisTick[Index] = GetTickCount();

	if (LastTick[Index] == 0)   // ̸ 
	{
		LastTick[Index] = ThisTick[Index];
		return FALSE;
	}
	if (ThisTick[Index] - LastTick[Index] > Delay)
	{
		LastTick[Index] = ThisTick[Index];		
		return TRUE;    // ð 
	}
	return FALSE;       // ð ᰡ ʵ 
}

BOOL CSprite::AnimateSprite(int SprType, int x, int y, int Index, DWORD Delay)
{
	//   TRUE̸ ִϸ̼ 	
	static DWORD LastTick[11] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
	static int   Frame[11] =    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
	DWORD ThisTick[11];

	ThisTick[Index] = GetTickCount();

	if (ThisTick[Index] - LastTick[Index] > Delay)
	{
		LastTick[Index] = ThisTick[Index];
		//
		Sprite = SprCharArray[SprType];
		if (Sprite->Pos != NULL)
		{			

			SprFrame = Sprite->SprList.GetAt(Sprite->Pos);
			if (Frame[Index] <  SprFrame->iFrameCount) Frame[Index]++;
			if (Frame[Index] == SprFrame->iFrameCount)
			{
				Frame[Index] = 0;
				return TRUE;
			}
		}
	}
	PutSprite(SprType, Frame[Index], x, y);
	return FALSE;
}

BOOL CSprite::AnimateSpriteEx(int SprType, int x, int y, int Index, DWORD Delay)
{
	//   FALSE̸ ִϸ̼ 	
	static DWORD LastTick[11] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
	static int   Frame[11] =    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
	DWORD ThisTick[11];

	ThisTick[Index] = GetTickCount();

	if (ThisTick[Index] - LastTick[Index] > Delay)
	{
		LastTick[Index] = ThisTick[Index];
		//
		Sprite = SprCharArray[SprType];
		if (Sprite->Pos != NULL)
		{			

			SprFrame = Sprite->SprList.GetAt(Sprite->Pos);
			if (Frame[Index] <  SprFrame->iFrameCount) Frame[Index]++;
			if (Frame[Index] == SprFrame->iFrameCount)
			{
				Frame[Index] = 0;
				return TRUE;
			}
		}
	}
	PutSpriteEx(SprType, Frame[Index], x, y);
	return FALSE;
}

RECT CSprite::GetPosition(int SprType, int x, int y)
{
	Sprite = SprCharArray[SprType];	
	SprFrame = Sprite->SprList.GetAt(Sprite->Pos);
	return SprFrame->GetPosition(x, y);
}
