/////////////////////////////////////////
//              CSprite.h 
//
//          Ʈ Ŭ 
//
//              ۱Ⱓ 
//
//           1996 9   
//                
//           1996 9  8 
//
//          Ʈ XE47   
//
/////////////////////////////////////////

#ifndef __CSPRITE_H
#define __CSPRITE_H

#include <ddraw.h>

class CDirtDraw;

class SpriteFrame
{
public:	
	int   iFrame;
	int   iFrameCount;
	
	RECT  rcSpr;
	int   CenterX, CenterY;
	LPDIRECTDRAWSURFACE lpOffSpr;	

public:
	SpriteFrame() { lpOffSpr=NULL; };
	~SpriteFrame() { };
	void PutSpriteFx(LPDIRECTDRAWSURFACE lpSurface, CRect rcDest);
	void PutSprite  (LPDIRECTDRAWSURFACE lpSurface, int x, int y);
	void PutSpriteEx(LPDIRECTDRAWSURFACE lpSurface, int x, int y);
	RECT GetPosition(int x, int y);
};

class Sprites
{
public:
	POSITION Pos;
	SpriteFrame*  SprFrame;
	CList  <SpriteFrame*, SpriteFrame*&> SprList;

public:
	Sprites() {};
	~Sprites() {};
};

class CSprite
{
public:	
	CDirtDraw*    pDD;
	Sprites*      Sprite;                  // SprCharList ҴϿ , PutSprite
	SpriteFrame*  SprFrame;                // PutSprite 
	POSITION      Pos;                     // PutSprite 
	CArray <Sprites*, Sprites*&> SprCharArray;	

public:
	CSprite(CDirtDraw* pCDDraw) { pDD = pCDDraw; } ;
	~CSprite() { };	
	void LoadSprite(char *name, DWORD ColorKeyL, DWORD ColorKeyH);	
	RECT GetSpriteRect(int SprType, int SprAction);
	void PutSprite  (int SprType, int x, int y);
	void PutSprite  (int SprType, int SprAction, int x, int y);
	void PutSpriteEx(int SprType, int x, int y);
	void PutSpriteEx(int SprType, int SprAction, int x, int y);
	void PutSpriteFx(int SprType, CRect Dest);
	void PutSpriteFx(int SprType, int SprAction, CRect Dest);
	void PutSpriteDirect(int SprType, int x, int y);
	void PutSpriteDirect(int SprType, int SprAction, int x, int y);
	void PutSpriteDirectFx(int SprType, CRect Dest);
	void PutSpriteDirectFx(int SprType, int SprAction, CRect Dest);
	void SprNextFrame(int SprType);
	void SprPrevFrame(int SprType);
	int  SprNextFrameKey(int SprType, DWORD Delay = 0);
	int  SprPrevFrameKey(int SprType, DWORD Delay = 0);
	BOOL DelayTime(int Index, DWORD Delay = 500);
	BOOL AnimateSprite  (int SprType, int x, int y, int Index, DWORD Delay = 100);
	BOOL AnimateSpriteEx(int SprType, int x, int y, int Index, DWORD Delay = 100);
	RECT GetPosition(int SprType, int x, int y);
	void DeleteSpriteList(void);
};

#endif