/////////////////////////////////////////
//
//             DirtDraw.cpp
//        ̷Ʈ ο Ŭ 
//    
/////////////////////////////////////////

#include "stdafx.h"
#include "DirtDraw.h"

CDirtDraw::CDirtDraw(HWND hWindow)
{
	hWnd = hWindow;
	lpDD = NULL;
	lpDDSPrimary = NULL;
	lpDDSBack    = NULL;
	lpDDPal      = NULL;
	DirectDrawInit();
}

CDirtDraw::~CDirtDraw()
{
	if (lpDD) DDObjectRelease();
}

BOOL CDirtDraw::DirectDrawInit()
{
	DDSURFACEDESC  ddsd;    // ǥ  ϴ ü	
	DDSCAPS        ddscaps; // DDCAPS ü Ϻ DirectDrawSurface ɷ 
	HRESULT        ddrval;  // DirectDrawԼ ϰ ´
	
	// DirectDraw ü  
	ddrval=DirectDrawCreate(NULL, &lpDD, NULL);
	if (ddrval != DD_OK) return DirectDrawError("ο ü  ");
	
	// Ÿ Ǯũ  ()	
	ddrval=lpDD->SetCooperativeLevel(hWnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN);

	// ػ 
	ddrval=lpDD->SetDisplayMode(640, 480, 8);
	if (ddrval != DD_OK) return DirectDrawError("ػ  ");

	// ϳ 2ǥ  1ǥ 
	ddsd.dwSize =sizeof(ddsd);
	ddsd.dwFlags=DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
	ddsd.ddsCaps.dwCaps   =DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP | DDSCAPS_COMPLEX;
	ddsd.dwBackBufferCount=1;

	// 1ǥ Ѵ
	ddrval=lpDD->CreateSurface(&ddsd, &lpDDSPrimary, NULL);
	if (ddrval != DD_OK) return DirectDrawError("1 ǥ  ");

	// 1ǥ  2ǥ Ѵ
	ddscaps.dwCaps=DDSCAPS_BACKBUFFER;	
	ddrval=lpDDSPrimary->GetAttachedSurface(&ddscaps, &lpDDSBack);
	if (ddrval != DD_OK) return DirectDrawError("2 ǥ  ");

	ClearSurface(lpDDSPrimary);
	ClearSurface(lpDDSBack);

	return TRUE;
}

BOOL CDirtDraw::DirectDrawError(char* Message)
{
	::ShowCursor(TRUE);	
	::MessageBox(hWnd, Message, "̷Ʈ ο", MB_OK);	
	if (lpDD) DDObjectRelease();		
	return FALSE;
}

void CDirtDraw::SetColorKeys(LPDIRECTDRAWSURFACE lpOffScr, int ColorKeyLow, int ColorKeyHigh)
{
	// ÷Ű 
	DDCOLORKEY ddck;
	ddck.dwColorSpaceLowValue  = ColorKeyLow;
	ddck.dwColorSpaceHighValue = ColorKeyHigh;
	lpOffScr->SetColorKey(DDCKEY_SRCBLT, &ddck);		
}

void CDirtDraw::DDObjectRelease(void)
{		
	if (lpDD != NULL)
	{
		if (lpDDSPrimary != NULL)
		{
			lpDDSPrimary->Release();
			lpDDSPrimary=NULL;
		}
		if (lpDDPal != NULL)
		{
			lpDDPal->Release();
			lpDDPal=NULL;
		}		
		lpDD->RestoreDisplayMode();
		lpDD->Release();
		lpDD=NULL;
	}
}

void CDirtDraw::ClearSurface(LPDIRECTDRAWSURFACE lpSurface)
{
	DDSURFACEDESC ddsd;
	LPBYTE        SurfaceBuf;
	UINT          SurfaceWidth, SurfaceHeight;

	memset(&ddsd, 0, sizeof(DDSURFACEDESC));
	ddsd.dwSize = sizeof(DDSURFACEDESC);

	lpSurface->Lock(NULL, &ddsd, DDLOCK_SURFACEMEMORYPTR | DDLOCK_WAIT, NULL);

	SurfaceWidth  = ddsd.lPitch;
	SurfaceHeight = ddsd.dwHeight;
	SurfaceBuf = (LPBYTE) ddsd.lpSurface;
	memset(SurfaceBuf, 0, SurfaceWidth * SurfaceHeight);

	lpSurface->Unlock(ddsd.lpSurface);
}

void CDirtDraw::FillSurface(LPDIRECTDRAWSURFACE lpSurface, DWORD dwColor)
{
	DDBLTFX ddbltfx;

	ddbltfx.dwSize = sizeof(ddbltfx);
	ddbltfx.dwFillColor = dwColor;

	lpSurface->Blt(NULL, NULL, NULL, DDBLT_COLORFILL | DDBLT_WAIT, &ddbltfx);
}

void CDirtDraw::FlipSurfaces(void)
{
	HRESULT ddrval;

	ddrval = lpDDSPrimary->Flip(NULL, DDFLIP_WAIT);
}

void CDirtDraw::LoadPalette(char* name)
{
	// ȷƮ ε  
	CFile   File;
	BOOL    frval;
	HRESULT ddrval;
	int     i, j;
	BYTE         Pal[768];

	frval=File.Open(name, CFile::modeRead | CFile::typeBinary);
	if (!frval) DirectDrawError("ȷƮ ȭ  ");

	File.Read(Pal, 768);	
	for (i=j=0; i < 256; i++, j+=3)
	{
		PalEntry[i].peRed   = Pal[j]; 
		PalEntry[i].peGreen = Pal[j+1];
		PalEntry[i].peBlue  = Pal[j+2];		
	}
	ddrval=lpDD->CreatePalette(DDPCAPS_8BIT, PalEntry, &lpDDPal, NULL);	
	if (ddrval != DD_OK) DirectDrawError("ȷƮ ü  ");
	lpDDSPrimary->SetPalette(lpDDPal);

	File.Close();
}

void CDirtDraw::FadeOut(int step)
{
	int i, j;
	PALETTEENTRY palen[256];
	
	for (j=step; j>0; j--)
	{
		for (i=0; i<256; i++)
		{
			palen[i].peRed    = PalEntry[i].peRed * j   / step;  
			palen[i].peGreen  = PalEntry[i].peGreen * j / step;
			palen[i].peBlue   = PalEntry[i].peBlue  * j / step;
		}
		lpDD->WaitForVerticalBlank(DDWAITVB_BLOCKBEGIN, NULL);
		lpDDPal->SetEntries(0, 0, 256, palen);
	}
}

void CDirtDraw::FadeIn(int step)
{
	int i, j;
	PALETTEENTRY palen[256];		
	
	for (j=0; j<step; j++)
	{
		for (i=0; i<256; i++)
		{
			palen[i].peRed    = PalEntry[i].peRed * j   / step;  
			palen[i].peGreen  = PalEntry[i].peGreen * j / step;
			palen[i].peBlue   = PalEntry[i].peBlue  * j / step;
		}

		lpDD->WaitForVerticalBlank(DDWAITVB_BLOCKBEGIN, NULL);
		lpDDPal->SetEntries(0, 0, 256, palen);
	}
}

