/////////////////////////////////////////
//              DirtDraw.h 
//
//         ̷Ʈ ο Ŭ 
//
//              ۱Ⱓ 
//
//           1996 8 27
//                
//           1996 9 30 
//
//          Ʈ XE47   
//
/////////////////////////////////////////

#ifndef __DIRTDRAW_H
#define __DIRTDRAW_H

#include <ddraw.h>

class CMapField;
class CSprite;

class CDirtDraw
{	
	friend CMapField;
	friend CSprite;
private:
	LPDIRECTDRAW        lpDD;
	LPDIRECTDRAWSURFACE lpDDSPrimary;
	LPDIRECTDRAWSURFACE lpDDSBack;
	LPDIRECTDRAWPALETTE lpDDPal;
	HWND         hWnd;
	PALETTEENTRY PalEntry[256];

private:	
	BOOL DirectDrawInit(void);
	BOOL DirectDrawError(char* Message);
	
public:
	CDirtDraw(HWND hWindow);
	~CDirtDraw();
	
	void DDObjectRelease(void);	
	void ClearSurface(LPDIRECTDRAWSURFACE lpSurface);
	void FillSurface(LPDIRECTDRAWSURFACE lpSurface, DWORD dwColor);	
	void SetColorKeys(LPDIRECTDRAWSURFACE lpOffScr, int ColorKeyLow, int ColorKeyHigh);
	void FlipSurfaces(void);
	void LoadPalette(char* name);
	void FadeIn(int step = 110);
	void FadeOut(int step = 110);

    inline LPDIRECTDRAW        GetDD(void)             { return lpDD; }
	inline LPDIRECTDRAWSURFACE GetSurfaceBack(void)    { return lpDDSBack; }
	inline LPDIRECTDRAWSURFACE GetSurfacePrimary(void) { return lpDDSPrimary; }	
};

#endif
