/////////////////////////////////////////
//              DirtPlay.cpp
//
//         ̷Ʈ ÷ Ŭ 
//
//            Ʈ XE47   
//
/////////////////////////////////////////

#include "stdafx.h"
#include "DirtPlay.h"
#include "DirtPlayDlg.h"
#include "GuidCyberX.h"
#include "resource.h"

CDirtPlay::CDirtPlay()
{	
	int i;

	lpDP = NULL;
	m_dwMsgLen     = 50; // 128;
	m_iPlayerIndex = 0;  // ÷̾ ID ε
	m_iPlayerCount = 0;  //  ÷̾ 

	m_iConnectCount= MaxConnect;
	m_bIsSolo      = FALSE;
	m_bIsSession   = FALSE;
	m_bAllPlayerConnect = FALSE;
	//
	for (i=1; i <= MaxConnect; i++) 
	{
		//   ʱȭ
		m_BattleShip[i].iDirection = 0;
		m_BattleShip[i].iLife  = 240;
		m_BattleShip[i].bIsHit    = FALSE;
		m_BattleShip[i].bIsHitAni = FALSE;
		m_BattleShip[i].iHitWho   = 0;
		m_BattleShip[i].iHitCount = 0;
		//   ʱȭ
		m_ShipLaser[i].ptPos = CPoint(320, 240);
		m_ShipLaser[i].iDirection = 0;
		m_ShipLaser[i].bLife = FALSE;
	}
	for (i=0; i < 256; i++) m_byMessage[i] = NULL;

	DirectPlayInit();
	
	CSessionBeginDlg dlgBeginSession;
	if (dlgBeginSession.DoModal() == IDOK)
		 CreateSession();
	else ConnectSession();

}

CDirtPlay::~CDirtPlay()
{
	DirectPlayRelease();
}

void CDirtPlay::PutBattleShipPosition(int Index, int x, int y)
{
	m_BattleShip[Index].ptPos.x = x;
	m_BattleShip[Index].ptPos.y = y;
}

BOOL CDirtPlay::DirectPlayInit()
{
	CServerSelDlg dlgSelectServer;

	if (dlgSelectServer.DoModal() == IDOK)
		return (DirectPlayCreate(dlgSelectServer.GetSelServer(), &lpDP, NULL) == DP_OK);

	return FALSE;
}

void CDirtPlay::DirectPlayRelease()
{
	EndSession();

	if (lpDP)
	{
		lpDP->Release();
		lpDP = NULL;
	}
}

BOOL CDirtPlay::CreateSession()
{
	DPSESSIONDESC dpsd;
	CSessionInfoDlg dlgCreateSession;

	if (dlgCreateSession.DoModal() == IDOK)
	{
		m_iConnectCount = dlgCreateSession.GetConnectCount();
		memset(&dpsd, 0, sizeof(DPSESSIONDESC));
		dpsd.dwSize       = sizeof(DPSESSIONDESC);
		dpsd.dwMaxPlayers = m_iConnectCount;
		dpsd.dwFlags      = DPOPEN_CREATESESSION;
		dpsd.guidSession  = GUID_CYBERX;
		strcpy(dpsd.szSessionName, dlgCreateSession.GetName());

		 // ׽Ʈ (1) 
		if (m_iConnectCount == 1)
		{
			lpDP->Open(&dpsd);
			m_bIsSession = TRUE;
			CreatePlayerInfo();
			m_bIsSolo = m_bAllPlayerConnect = TRUE;				
			return TRUE;
		}

		//
		if (lpDP->Open(&dpsd) == DP_OK)
		{			
			lpDP->EnableNewPlayers(TRUE);
			if (CreatePlayerInfo())
			{
				m_bIsSession = TRUE;
				return TRUE;
			}
		}
	}
	return FALSE;
}

BOOL CDirtPlay::ConnectSession()
{
	DPSESSIONDESC dpsd;
	CSessionSelDlg dlgConnectSession(lpDP);

	if (dlgConnectSession.DoModal() == IDOK)
	{
		memset(&dpsd, 0, sizeof(DPSESSIONDESC));
		dpsd.dwSize      = sizeof(DPSESSIONDESC);
		dpsd.dwFlags     = DPOPEN_OPENSESSION;
		dpsd.guidSession = GUID_CYBERX;
		dpsd.dwSession   = dlgConnectSession.GetSelSession();
		if (lpDP->Open(&dpsd) == DP_OK)
		{			
			lpDP->EnableNewPlayers(TRUE);
			if (CreatePlayerInfo()) return TRUE;			
		}
	}

	return FALSE;
}

void CDirtPlay::EndSession()
{
	DestroyPlayerInfo();
	m_dpidMyPlayer = 0;
	lpDP->Close();
}

BOOL CDirtPlay::CreatePlayerInfo()
{
	CPlayerInfoDlg dlgCreatePlayer;

	if (dlgCreatePlayer.DoModal() == IDOK)
	{
		m_iPlayerCount++;
		return (lpDP->CreatePlayer(&m_dpidMyPlayer,
		                           dlgCreatePlayer.GetFriendlyName(),
		                           "FORMAL",
								   &m_hDPEvent) == DP_OK);
	}
	return FALSE;
}

BOOL CDirtPlay::DestroyPlayerInfo()
{
	if (lpDP->DestroyPlayer(m_dpidMyPlayer) == DP_OK)
	{
		m_dpidMyPlayer = 0;
		return TRUE;
	}

	return FALSE;
}

CString CDirtPlay::GetPlayerName(DPID ID)
{		
	LPSTR Name = " ";
	DWORD Len=10;

	lpDP->GetPlayerName(ID, Name, &Len, NULL, NULL);

	return Name;
}

void CDirtPlay::DPReceiveMessage()
{
	HRESULT dprval;
	DPID    dpidFrom, dpidTo;
	
	// ť  ޽ о 
	while(1)
	{
		dprval = lpDP->Receive(&dpidFrom, &dpidTo, DPRECEIVE_ALL,
			                   m_byMessage, &m_dwMsgLen);
		if (dprval == DP_OK)
		{
			if (dpidFrom == NameServer) ProcessSystemMSG();			
			else    					ProcessGameMSG(dpidFrom);			
		}
		else return;
	}
}

void CDirtPlay::ProcessSystemMSG()
{
	// Ӽ   ޽ óѴ 
	CString sText;
	DPMSG_GENERIC* Msg = (DPMSG_GENERIC*) m_byMessage;
	
	switch(Msg->dwType)
	{
	case DPSYS_CONNECT     :
		TRACE("ǿ  Ǿϴ");		
        break;							 
	case DPSYS_ADDPLAYER   : 
		sText.Format("ο ÷̾ : %s", ((DPMSG_ADDPLAYER*) Msg)->szShortName);
		TRACE(sText);		
		if (m_bIsSession)
		{			
			m_iPlayerCount++;
			//DPSendMessage(((DPMSG_ADDPLAYER*) Msg)->dpId, MSG_CONNECTCOUNT);
			DPSendMessage(NameServer, MSG_CONNECTCOUNT);
			if (m_iPlayerCount == m_iConnectCount)
			{					
				DPSendMessage(NameServer, MSG_CONNECTEND);				
				m_bAllPlayerConnect = TRUE;				
			}
		}
		break;
	case DPSYS_SESSIONLOST :
        TRACE(" Ҿϴ");
        DirectPlayRelease();
        break;
	}
}

void CDirtPlay::ProcessGameMSG(DPID dpidFrom)
{	
	LPCONNECTENDMSG   lpConnectEnd;
	LPCONNECTCOUNTMSG lpConnectCount;
	LPSHIPMSG         lpShip;	

	switch(m_byMessage[0])
	{
	case MSG_SHIP:          // ޽  ÷̾ ͸ ޾ Ѵ
		lpShip = (LPSHIPMSG) m_byMessage;		
		m_BattleShip[dpidFrom] = lpShip->Ship;		
		m_ShipLaser[dpidFrom]  = lpShip->Laser;		
		break;
	case MSG_CONNECTCOUNT:
		lpConnectCount  = (LPCONNECTCOUNTMSG) m_byMessage;
		m_iConnectCount = lpConnectCount->ConnectCount;				
		break;
	case MSG_CONNECTEND:
		lpConnectEnd = (LPCONNECTENDMSG) m_byMessage;
		m_bAllPlayerConnect = TRUE;
		break;
	default : 
		char dBuf[256];
		wsprintf(dBuf, "˼  ޽Դϴ: %d\n", m_byMessage[0]);
		OutputDebugString(dBuf);
		break;
	}
}

void CDirtPlay::DPSendMessage(DPID To, BYTE MsgCode)
{
	int     nBytes;
	HRESULT dprval;
	DWORD  MsgType = DPSEND_TRYONCE;
	LPCONNECTENDMSG   lpConnectEnd;
	LPCONNECTCOUNTMSG lpConnectCount;
	LPSHIPMSG         lpShip;	

	switch(MsgCode)
	{
	case MSG_SHIP:         // ڽ ͸ 
		lpShip = (LPSHIPMSG) m_byMessage;
		lpShip->MsgCode = MsgCode;		
		lpShip->Ship    = m_BattleShip[m_dpidMyPlayer]; 
		lpShip->Laser   = m_ShipLaser[m_dpidMyPlayer];
		nBytes = sizeof(SHIPMSG);		
		break;
	case MSG_CONNECTCOUNT:
		lpConnectCount  = (LPCONNECTCOUNTMSG) m_byMessage;
		lpConnectCount->MsgCode = MsgCode;
		lpConnectCount->ConnectCount = m_iConnectCount;
		nBytes = sizeof(CONNECTCOUNTMSG);
		MsgType = DPSEND_GUARANTEE | DPSEND_HIGHPRIORITY;
		break;
	case MSG_CONNECTEND:
		lpConnectEnd = (LPCONNECTENDMSG) m_byMessage;		
		lpConnectEnd->MsgCode = MsgCode;
		nBytes = sizeof(CONNECTENDMSG);
		MsgType = DPSEND_GUARANTEE | DPSEND_HIGHPRIORITY;
		break;
	}	
	dprval=lpDP->Send(m_dpidMyPlayer, To, MsgType, (LPBYTE) m_byMessage, nBytes);
}