/////////////////////////////////////////
//              DirtPlay.h 
//
//         ̷Ʈ ÷ Ŭ 
//
//              ۱Ⱓ 
//
//           1996 9 23
//                
//           199610 22 
//
//          Ʈ XE47   
//
/////////////////////////////////////////

#ifndef __DIRTPLAY_H
#define __DIRTPLAY_H

#include <dplay.h>

#define MSG_RESET        0x00
#define MSG_CONNECTCOUNT 0x11
#define MSG_CONNECTEND   0x22
#define MSG_SHIP         0x33

typedef struct _LASER
{
	CPoint ptPos;	
	int    iDirection;
	//int    iCount;
	BOOL   bLife;
} LASER_, *LPLASER;

typedef struct _SHIP
{
	//BYTE    ShipType;
	CPoint  ptPos;         //   ǥ
	int     iDirection;    //  
	int     iLife;         //  
	BOOL    bIsHit;        //   ޾ 
	BOOL    bIsHitAni;     //   ִϸ̼ Ῡ
	int     iHitWho;       //    ޾Ҵ
	int     iHitCount;     // 븦  Ƚ
} SHIP, *LPSHIP;

typedef struct _SHIPRANK
{
	DPID    GameID;
	int     iHitCount;
} SHIPRANK;

// ޽

typedef struct _CONNECTCOUNTMSG
{
	BYTE MsgCode;
	int  ConnectCount;	
} CONNECTCOUNTMSG, *LPCONNECTCOUNTMSG;

typedef struct _CONNECTENDMSG
{
	BYTE MsgCode;
} CONNECTENDMSG, *LPCONNECTENDMSG;

typedef struct _SHIPMSG
{
	BYTE   MsgCode;	
	SHIP   Ship;
	LASER_ Laser;
} SHIPMSG, *LPSHIPMSG;

class CDirtPlay
{
private:
	LPDIRECTPLAY lpDP;
	HANDLE       m_hDPEvent;      //  
	enum         { NameServer = 0, MaxConnect = 5};
	int          m_iPlayerIndex;
	DPID         m_dpidMyPlayer;
	DWORD        m_dwPlayerNameLen[MaxConnect + 1];
	BYTE         m_byMessage[256];
	DWORD        m_dwMsgLen;	
	int          m_iConnectCount; // ο
	int          m_iPlayerCount;  //  ÷̾ 
	SHIP         m_BattleShip[MaxConnect + 1];   // 0 迭  ʴ´
	LASER_       m_ShipLaser[MaxConnect + 1];	

private:
	BOOL DirectPlayInit(void);
	void DirectPlayRelease(void);
	void EndSession(void);
	BOOL CreatePlayerInfo(void);
	BOOL DestroyPlayerInfo(void);
	BOOL CreateSession(void);
	BOOL ConnectSession(void);
	void ProcessSystemMSG(void);
	void ProcessGameMSG(DPID dpidFrom);	

public:	
	BOOL  m_bAllPlayerConnect;
	BOOL  m_bIsSession;      //   ߴ 
	BOOL  m_bIsSolo;         // 1ο 

public:
	CDirtPlay();
	~CDirtPlay();
	
	void DPReceiveMessage(void);
	void DPSendMessage(DPID To, BYTE MsgCode);
	int  GetConnectCount(void)   { return m_iConnectCount; }
	DPID GetMyPlayerID(void)     { return m_dpidMyPlayer;  }
	CString GetPlayerName(DPID ID);	
	void PutBattleShipPosition(int Index, int x, int y);
	SHIP GetBattleShipData(int Index) { return m_BattleShip[Index]; }
	void PutBattleShipData(int Index, SHIP Ship) { m_BattleShip[Index] = Ship; }
	LASER_ GetShipLaserData(int Index) { return m_ShipLaser[Index]; }
	void PutShipLaserData(int Index, LASER_ Laser) { m_ShipLaser[Index] = Laser; }
};

#endif