#include "StdAfx.h"
#include "DirtPlayDlg.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

//
//  ι̴  
//

BEGIN_MESSAGE_MAP(CServerSelDlg, CDialog)
  ON_LBN_DBLCLK(IDC_LB_SERVERS, OnDblClkList)
END_MESSAGE_MAP()

CServerSelDlg::CServerSelDlg(CWnd* pParent)
  : CDialog(CServerSelDlg::IDD, pParent), m_pguidSelServer(NULL)
{
}

CServerSelDlg::~CServerSelDlg()
{
}

BOOL CServerSelDlg::OnInitDialog() 
{
  CDialog::OnInitDialog();
  
  if (::DirectPlayEnumerate(EnumServers, (LPVOID)this) == DP_OK)
    m_lbServers.SetCurSel(1);
  else
    EndDialog(FALSE);

  return TRUE;
}

void CServerSelDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  
  DDX_Control(pDX, IDC_LB_SERVERS, m_lbServers);
}

void CServerSelDlg::OnOK()
{ 
  int iIndex = m_lbServers.GetCurSel();
  if (iIndex != LB_ERR)
  {
    m_pguidSelServer = (LPGUID)m_lbServers.GetItemData(iIndex);
    CDialog::OnOK();
  }
}

BOOL FAR PASCAL
CServerSelDlg::EnumServers(LPGUID pguidID, LPSTR pszName, DWORD
  dwMajorVersion, DWORD dwMinorVersion, LPVOID pData)
{  
  ASSERT((CServerSelDlg*)pData);
  ((CServerSelDlg*)pData)->EnumServers((DWORD)pguidID, pszName);

  return TRUE;
}

void CServerSelDlg::EnumServers(DWORD dwID, const CString& sName)
{
  int iIndex = m_lbServers.AddString(sName);
  m_lbServers.SetItemData(iIndex, dwID);
}

void CServerSelDlg::OnDblClkList()
{
  OnOK();
}


//
// ̸  ο Է
//

BEGIN_MESSAGE_MAP(CSessionInfoDlg, CDialog)
END_MESSAGE_MAP()

CSessionInfoDlg::CSessionInfoDlg(CWnd* pParent)
  : CDialog(CSessionInfoDlg::IDD, pParent)
{
}

CSessionInfoDlg::~CSessionInfoDlg()
{
}

void CSessionInfoDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);

  DDX_Text(pDX, IDC_EB_NAME, m_sName);
  DDX_Text(pDX, IDC_EB_NAME2, m_sConnectCount);
}

//
//   
//

BEGIN_MESSAGE_MAP(CSessionSelDlg, CDialog)
  ON_LBN_DBLCLK(IDC_LB_SESSIONS, OnDblClkList)
END_MESSAGE_MAP()

CSessionSelDlg::CSessionSelDlg(LPDIRECTPLAY pDirectPlay, CWnd*
  pParent)
  : CDialog(CSessionSelDlg::IDD, pParent),
    m_pDirectPlay(pDirectPlay)
{
}

CSessionSelDlg::~CSessionSelDlg()
{
}

BOOL CSessionSelDlg::OnInitDialog() 
{
  CDialog::OnInitDialog();
  
  DPSESSIONDESC dpsdDesc;
  ::ZeroMemory(&dpsdDesc, sizeof(DPSESSIONDESC));
  dpsdDesc.dwSize = sizeof(DPSESSIONDESC);
  dpsdDesc.guidSession = GUID_CYBERX;
  if (m_pDirectPlay->EnumSessions(&dpsdDesc, 5000, EnumSessions,
    (LPVOID)this, DPENUMSESSIONS_ALL) == DP_OK)
    m_lbSessions.SetCurSel(0);
  else
    EndDialog(FALSE);

  return TRUE;
}

void
CSessionSelDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);  
  DDX_Control(pDX, IDC_LB_SESSIONS, m_lbSessions);
}

void CSessionSelDlg::OnOK()
{
  int iIndex = m_lbSessions.GetCurSel();
  if (iIndex != LB_ERR)
  {
    m_dwSelSession = m_lbSessions.GetItemData(iIndex);
    CDialog::OnOK();
  }
}

BOOL FAR PASCAL CSessionSelDlg::EnumSessions(LPDPSESSIONDESC pdpsdDesc, LPVOID
  pData, LPDWORD pdwTimeOut, DWORD dwFlags)
{  
  ASSERT((CSessionSelDlg*)pData);
  return ((CSessionSelDlg*)pData)->EnumSessions(*pdpsdDesc, dwFlags);
}

BOOL CSessionSelDlg::EnumSessions(const DPSESSIONDESC& dpsdDesc, DWORD dwFlags)
{
  if (dwFlags & DPESC_TIMEDOUT) return FALSE;

  int iIndex = m_lbSessions.AddString(dpsdDesc.szSessionName);
  m_lbSessions.SetItemData(iIndex, dpsdDesc.dwSession);

  return TRUE;
}

void
CSessionSelDlg::OnDblClkList()
{
  OnOK();
}


//
// ÷̾  ID Է
//

BEGIN_MESSAGE_MAP(CPlayerInfoDlg, CDialog)
END_MESSAGE_MAP()

CPlayerInfoDlg::CPlayerInfoDlg(CWnd* pParent)
  : CDialog(CPlayerInfoDlg::IDD, pParent)
{
}

CPlayerInfoDlg::~CPlayerInfoDlg()
{
}

//-----------------------------------------------------------------
// CPlayerInfoDlg Protected Methods
//-----------------------------------------------------------------
void
CPlayerInfoDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);  
  DDX_Text(pDX, IDC_EB_FRIENDLYNAME, m_sFriendlyName);
  
}

//
//    
//

BEGIN_MESSAGE_MAP(CSessionBeginDlg, CDialog)
END_MESSAGE_MAP()

CSessionBeginDlg::CSessionBeginDlg(CWnd* pParent)
  : CDialog(CSessionBeginDlg::IDD, pParent)
{
}

CSessionBeginDlg::~CSessionBeginDlg()
{
}