/////////////////////////////////////////
//
//             DirtSnd.cpp
//        ̷Ʈ  Ŭ 
//
/////////////////////////////////////////

#include "stdafx.h"
#include "DirtSnd.h"

CDirtSnd::CDirtSnd(const char* WavList, HWND hWindow)
{	
	lpDSBuf    = 0;
	m_iBufCount= 0;	
	hWnd       = hWindow;
	DirectSoundInit();
	LoadWavAll(WavList);
}

CDirtSnd::~CDirtSnd()
{
	if (lpDS) DSObjectRelease();
}

void CDirtSnd::DirectSoundInit()
{
	// ̷Ʈ  ü
	HRESULT dsrval = DirectSoundCreate(NULL, &lpDS, NULL);
	if (dsrval != DS_OK) DirectSoundError("ü  ");
	// ̷Ʈ   ȯ Ѵ.
	dsrval = lpDS->SetCooperativeLevel(hWnd, DSSCL_NORMAL);
	if (dsrval != DS_OK) DirectSoundError("  ");
}

void CDirtSnd::DirectSoundError(char* Message)
{
	if (lpDS) DSObjectRelease();
	::MessageBox(hWnd, Message, "̷Ʈ ", MB_OK);	
}

void CDirtSnd::DSObjectRelease()
{
	StopAll();
	lpDS->Release();
	delete [] lpDSBuf;
}

void CDirtSnd::LoadWavAll(const char* WavList)
{
	FILE* fp;
	m_iBufCount = 0;		
	char *p;
	char *FileName;	
	char str[_MAX_DIR];
	CArray<char*, char*> FileList;	
		
	fp = fopen(WavList,"r");
	if (!fp) DirectSoundError("WAV   ");
	
	// ȭ  д´
	while (!feof(fp))
	{
		FileName = fgets(str, _MAX_DIR, fp);
		p = strchr(str,'\n');
		if (p) *p = NULL;
		if (FileName)
		{
			char* WaveName = new char[strlen(str) + 1];
			strcpy(WaveName, str);
			FileList.Add(WaveName);			
		}
	}
	fclose(fp);	

	m_iBufCount = FileList.GetSize();
	lpDSBuf     = new LPDIRECTSOUNDBUFFER[m_iBufCount];	

	// Waveȭ  ŭ оδ
	for (int i=0; i < m_iBufCount; i++)
	{		
		LoadWav(FileList[i], i);
		delete [] FileList[i];
	}
	FileList.RemoveAll();
}

void CDirtSnd::LoadWav(const char* wav,int index)
{
	int  ret;
	WORD wExtraAlloc;	
	UINT i, DataIn;

	HMMIO          hmmioIn;	
	MMIOINFO       mmioinfoIn;
	MMCKINFO       ckInfo, ckInfoRIFF;
	LPWAVEFORMATEX lpWaveFormat=0;	
	PCMWAVEFORMAT  pcmWaveFormat;

	LPBYTE  lpData;
	LPVOID  lpWrapPtr;	
	DWORD   dwBSize, dwWavSize, dwDataSize, dwWrapBSize;

	DSBUFFERDESC    dsbd;
    
	// ȭ  
	hmmioIn=mmioOpen((char*)wav, NULL, MMIO_ALLOCBUF | MMIO_READ);
	if (!hmmioIn) DirectSoundError("WAV ȭ  ");

	// ȭ RIFF WAVEȭ ȮѴ    
    ckInfoRIFF.fccType = mmioFOURCC('W','A','V','E');
    if (mmioDescend(hmmioIn, &ckInfoRIFF, NULL, MMIO_FINDRIFF) != 0)
	{
        DirectSoundError("RIFF WAVE ȭ ƴմϴ");        
    }

	// 'fmt' Chunk ȮѴ
	ckInfo.ckid = mmioFOURCC('f', 'm', 't', ' ');
	if (mmioDescend(hmmioIn, &ckInfo,&ckInfoRIFF, MMIO_FINDCHUNK) != 0)
	{
		DirectSoundError("ȭ fmt Chunk ƴմϴ");        
	}

	// ȭ д´
	ret = mmioRead(hmmioIn, (HPSTR) &pcmWaveFormat, (long) sizeof(pcmWaveFormat));
	if (ret != (long) sizeof(pcmWaveFormat))
	{
		DirectSoundError("ȭ б ");        
	}

	//  ȭ PCM ȮѴ
	if (pcmWaveFormat.wf.wFormatTag == WAVE_FORMAT_PCM)
		wExtraAlloc = 0;                                       
	else
	{
		ret = mmioRead(hmmioIn, (LPSTR) &wExtraAlloc,(long) sizeof(wExtraAlloc));
		if (ret != (long) sizeof(wExtraAlloc))
		{
			DirectSoundError("ȭ б ");        
		}
	}
 	
	lpWaveFormat = (LPWAVEFORMATEX) malloc(sizeof(WAVEFORMATEX)+wExtraAlloc);
	memcpy(lpWaveFormat, &pcmWaveFormat, sizeof(pcmWaveFormat));
	lpWaveFormat->cbSize = wExtraAlloc;

	if (wExtraAlloc != 0)
	{
		ret = mmioRead(hmmioIn,
			           (LPSTR)(((BYTE*)&(lpWaveFormat->cbSize))+sizeof(wExtraAlloc)),
					   (long)(wExtraAlloc));
		if (ret != (long) sizeof(wExtraAlloc))
		{
			DirectSoundError("ȭ б ");        
		}		
	}
	
	if (mmioAscend(hmmioIn, &ckInfo, 0) != MMSYSERR_NOERROR)
	{
		DirectSoundError("");
	}
 
    
    if (mmioSeek(hmmioIn, ckInfoRIFF.dwDataOffset+sizeof(FOURCC),SEEK_SET) == -1)
	{
		DirectSoundError("");
	}

	// 'data' Chunk ã´
	MMCKINFO    pckIn;
    pckIn.ckid = mmioFOURCC('d', 'a', 't', 'a');
    if (mmioDescend(hmmioIn,&pckIn,&ckInfoRIFF, MMIO_FINDCHUNK) != MMSYSERR_NOERROR)
	{
		DirectSoundError("Data Chunk ƴմϴ");
	}

	dwDataSize = pckIn.cksize;
	lpData     = NULL;
    
	// ƽ 2 ۸   ü Ѵ.
	//    , ¿ 뷱, ļ  ϵ Ѵ
	memset(&dsbd, 0, sizeof(DSBUFFERDESC));
	dsbd.dwSize = sizeof(DSBUFFERDESC);
	dsbd.dwFlags = DSBCAPS_CTRLDEFAULT | DSBCAPS_STATIC;
	dsbd.dwBufferBytes = dwDataSize;
	dwWavSize = lpWaveFormat->cbSize + sizeof(WAVEFORMATEX);
	
	dsbd.lpwfxFormat = (LPWAVEFORMATEX) malloc(dwWavSize);
	memcpy( dsbd.lpwfxFormat, lpWaveFormat, dwWavSize );
	free(lpWaveFormat);
	
	// 2  ۸ Ѵ.
	if (lpDS->CreateSoundBuffer(&dsbd, &lpDSBuf[index],NULL) != DS_OK)
	{
		DirectSoundError(" ");
	}
	free(dsbd.lpwfxFormat);

	//  ۿ Ѵ
	ret = lpDSBuf[index]->Lock(0, dwDataSize, (LPLPVOID)&lpData,&dwBSize, 
		                       &lpWrapPtr, &dwWrapBSize, 0L);
	if (ret != DS_OK)
	{
		DirectSoundError("");        
	}
	dwDataSize = dwBSize;

	// ȭ (Ȳ) ˾ƿ´	
	if (mmioGetInfo(hmmioIn, &mmioinfoIn, 0) != MMSYSERR_NOERROR)
	{
		DirectSoundError("");
	}
                
	DataIn = dwDataSize;
	if (DataIn > pckIn.cksize) DataIn = pckIn.cksize;   
	pckIn.cksize -= DataIn;
    
	for (i = 0; i < DataIn; i++)
	{
		if (mmioinfoIn.pchNext == mmioinfoIn.pchEndRead)
		{
			ret = mmioAdvance(hmmioIn, &mmioinfoIn, MMIO_READ);
			if (ret != MMSYSERR_NOERROR) DirectSoundError("");			
		}      
		*((BYTE*)lpData + i) = *((BYTE*)mmioinfoIn.pchNext++);
	}
	if (mmioSetInfo(hmmioIn, &mmioinfoIn, 0) != MMSYSERR_NOERROR)
	{
		DirectSoundError("");
	}	
}

////////

BOOL CDirtSnd::IsBufIndex(int index)
{
	if (index > 0 && index <= m_iBufCount)
		return TRUE;
	else
		return FALSE;
}

void CDirtSnd::Play(int index)
{
	if (IsBufIndex(index))
	{
		lpDSBuf[index-1]->SetCurrentPosition(0); // ϰ ó 
		lpDSBuf[index-1]->Play(0, 0, 0);		 //
	}
}

void CDirtSnd::Loop(int index)
{
	if (IsBufIndex(index))
	{
		lpDSBuf[index-1]->SetCurrentPosition(0);		
		lpDSBuf[index-1]->Play(0, 0, DSBPLAY_LOOPING);		
	}
}

void CDirtSnd::Stop(int index)
{
	if (IsBufIndex(index)) lpDSBuf[index-1]->Stop();	
}

void CDirtSnd::StopAll()
{
	for (int i=0; i < m_iBufCount; i++) lpDSBuf[i]->Stop();
}

BOOL CDirtSnd::IsPlaying(int index)
{
	if (IsBufIndex(index))
	{
		DWORD Status;
		lpDSBuf[index-1]->GetStatus(&Status);
		return Status & DSBSTATUS_PLAYING;
	}
	return FALSE;
}

BOOL CDirtSnd::IsLooping(int index)
{
	if (IsBufIndex(index))
	{
		DWORD Status;
		lpDSBuf[index-1]->GetStatus(&Status);
		return Status & DSBSTATUS_LOOPING;
	}
	return FALSE;
}

void CDirtSnd::SetPan(int index,long pan)
{
	if (IsBufIndex(index)) lpDSBuf[index-1]->SetPan(pan);	
}

void CDirtSnd::GetPan(int index,long& pan)
{
	if (IsBufIndex(index)) lpDSBuf[index-1]->GetPan(&pan);	
}

void CDirtSnd::SetVol(int index,long vol)
{
	if (IsBufIndex(index)) lpDSBuf[index-1]->SetVolume(vol);	
}

void CDirtSnd::GetVol(int index,long& vol)
{
	if (IsBufIndex(index)) lpDSBuf[index-1]->GetVolume(&vol);	
}

void CDirtSnd::SetFreq(int index,DWORD freq)
{
	if (IsBufIndex(index)) lpDSBuf[index-1]->SetFrequency(freq);	
}

void CDirtSnd::GetFreq(int index,DWORD& freq)
{
	if (IsBufIndex(index)) lpDSBuf[index-1]->GetFrequency(&freq);	
}