// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "SprAni.h"

#include "MainFrm.h"

#include "Music.h"
#include "SprChar.h"

#include "DirtDraw.h"
#include "DirtSnd.h"

#include "CMapField.h"
#include "CSprite.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_DESTROY()
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	m_pApp = (CCyberXApp*) AfxGetApp();		
	m_dwFrameCount = 0;
	m_iEvent = 0;
	m_bIsMsgInit = TRUE;
	//
	ptLaserStep[ 0] = CPoint(  0, 20);	ptLaserStep[ 1] = CPoint(-10, 20);
	ptLaserStep[ 2] = CPoint(-20, 20);	ptLaserStep[ 3] = CPoint(-20, 10);
	ptLaserStep[ 4] = CPoint(-20,  0);	ptLaserStep[ 5] = CPoint(-20,-10);
	ptLaserStep[ 6] = CPoint(-20,-20);	ptLaserStep[ 7] = CPoint(-10,-20);
	ptLaserStep[ 8] = CPoint(  0,-20);	ptLaserStep[ 9] = CPoint( 10,-20);
	ptLaserStep[10] = CPoint( 20,-20);	ptLaserStep[11] = CPoint( 20,-10);
	ptLaserStep[12] = CPoint( 20,  0);	ptLaserStep[13] = CPoint( 20, 10);
	ptLaserStep[14] = CPoint( 20, 20);	ptLaserStep[15] = CPoint( 10, 20);
	//
	m_Ship[1].ptPos.x = 1600; m_Ship[1].ptPos.y = 1600; //    2         3    
	m_Ship[2].ptPos.x = 1120; m_Ship[2].ptPos.y = 1120; //                   
	m_Ship[3].ptPos.x = 2080; m_Ship[3].ptPos.y = 1120; //         1          
	m_Ship[4].ptPos.x = 1120; m_Ship[4].ptPos.y = 2080; //                    
	m_Ship[5].ptPos.x = 2080; m_Ship[5].ptPos.y = 2080; //    4         5     
}

CMainFrame::~CMainFrame()
{
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	cs.x = cs.y = 0;                           //   ġ	
	cs.cx = ::GetSystemMetrics( SM_CXSCREEN );  
	cs.cy = ::GetSystemMetrics( SM_CYSCREEN ); //   ũ
	cs.style = WS_POPUP;                       // ŸƲ ٸ 
	cs.dwExStyle = WS_EX_TOPMOST;              //  찡   ġѴ
	cs.hMenu = 0;                              // ޴ 

	return CFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

void CMainFrame::ProgressNet()
{
	int  ID;

	//	
	for (ID=1; ID <= 5; ID++) 
	{
		//   ʱȭ 
		m_Ship[ID].iDirection = 0;
		m_Ship[ID].iLife  = 240;
		m_Ship[ID].bIsHit    = FALSE;
		m_Ship[ID].bIsHitAni = FALSE;
		m_Ship[ID].iHitWho   = 0;
		m_Ship[ID].iHitCount = 0;
		//   ʱȭ 
		m_Laser[ID].ptPos = CPoint(320, 240);
		m_Laser[ID].iDirection = 0;
		m_Laser[ID].bLife = FALSE;
		// DirectPlay Ŭ  ǥ 
		pDP->PutBattleShipPosition(ID, m_Ship[ID].ptPos.x, m_Ship[ID].ptPos.y);
	}
	//        
	pSpr->PutSpriteDirectFx(CONNECTBRD, 0, CRect(160, 190, 480, 290));	
	//    
	if (pDP->m_bIsSession)		
		pSpr->PutSpriteDirect(CONNECTBRD, 1, 320, 240);	
	else	
		pSpr->PutSpriteDirect(CONNECTBRD, 2, 320, 240);
}

void CMainFrame::DirectXBegin()
{	
	::ShowCursor(FALSE);
	m_pApp->SetIdleEvent(this);	
	//
	pDD  = new CDirtDraw(m_hWnd);
	pDS  = new CDirtSnd("SndDir.txt", m_hWnd);	
	//
	pMap = new CMapField(pDD, pDS);
	pSpr = new CSprite(pDD);
	//
	pDD->LoadPalette ("CyberX.plt");	
	pSpr->LoadSprite ("CyberX.spr", 255, 255);
	pMap->LoadMap    ("CyberX.map");	
	pMap->LoadTile   ("CyberX.til");

	//		
	pDD->GetDD()->FlipToGDISurface();
	MessageBox("[ մϴ ]", "CyberX",MB_OK);

	AnimateConnect();	
	DrawConnect();

	//
	pSpr->DelayTime(1, 600); //  ߻ ʱ 

	pDS->Loop(CONNECT);	
	pDP  = new CDirtPlay;	
	ProgressNet();  // ũũ  óѴ		
}

void CMainFrame::AnimateConnect()
{
	int i, i2;
	int Type[9]={0,1,1,0,0,1,1,0,2};
	CPoint CyberX[9], Dest[9], MyShip[4];
	MyShip[0]=CPoint(310, -10); MyShip[1]=CPoint(310, 490);
	MyShip[2]=CPoint( -10,240); MyShip[3]=CPoint(650, 240);
	CyberX[0]=CyberX[1]=CyberX[2]=CyberX[3]=CyberX[4]=CPoint(320,240);
	CyberX[5]=CyberX[6]=CyberX[7]=CyberX[8]=CPoint(320, 240);
	Dest[0] = CPoint(120, 40); Dest[4] = CPoint(520, 40);
	Dest[1] = CPoint(220,140); Dest[5] = CPoint(420,140);
	Dest[2] = CPoint(220,340); Dest[6] = CPoint(420,340);
	Dest[3] = CPoint(120,440); Dest[7] = CPoint(520,440); Dest[8] = CPoint(320,240); 
	
	pDS->Play(FIRE);
	for (i=0; i < 40; i++)
	{
		pDD->FillSurface(pDD->GetSurfaceBack(), 151);
		pSpr->PutSpriteEx(MYSHIPL, 310, MyShip[0].y); MyShip[0].y += 2;
		pSpr->PutSpriteEx(MYSHIPL, 310, MyShip[1].y); MyShip[1].y -= 2;
		pSpr->PutSpriteEx(MYSHIPL, MyShip[2].x, 240); MyShip[2].x += 2;
		pSpr->PutSpriteEx(MYSHIPL, MyShip[3].x, 240); MyShip[3].x -= 2;
		for (i2=0; i2 < 9; i2++)
		{
			pSpr->PutSprite(CYBERX, Type[i2], CyberX[i2].x, CyberX[i2].y);
			if ((i2 == 0 || i2 == 1) && CyberX[i2] != Dest[i2])		
				{ CyberX[i2].x-=5; CyberX[i2].y-=5; }
			if ((i2 == 2 || i2 == 3) && CyberX[i2] != Dest[i2])
				{ CyberX[i2].x-=5; CyberX[i2].y+=5; }
			if ((i2 == 4 || i2 == 5) && CyberX[i2] != Dest[i2])
				{ CyberX[i2].x+=5; CyberX[i2].y-=5; }
			if ((i2 == 6 || i2 == 7) && CyberX[i2] != Dest[i2])
				{ CyberX[i2].x+=5; CyberX[i2].y+=5; }			
		}
		pDD->FlipSurfaces();
	}
}

void CMainFrame::DrawConnect()
{
	pDD->FillSurface(pDD->GetSurfacePrimary(), 151);		

	int i, Type[9]={0,1,1,0,0,1,1,0,2};
	CPoint Pos[9];
	Pos[0] = CPoint(120, 40); Pos[4] = CPoint(520, 40);
	Pos[1] = CPoint(220,140); Pos[5] = CPoint(420,140);
	Pos[2] = CPoint(220,340); Pos[6] = CPoint(420,340);
	Pos[3] = CPoint(120,440); Pos[7] = CPoint(520,440); Pos[8] = CPoint(320,240); 

	pSpr->PutSpriteDirect(MYSHIPL, 310, 70);
	pSpr->PutSpriteDirect(MYSHIPL, 310, 410);
	pSpr->PutSpriteDirect(MYSHIPL,  70, 240);
	pSpr->PutSpriteDirect(MYSHIPL, 570, 240);
	for (i=0; i < 9; i++)
		pSpr->PutSpriteDirect(CYBERX, Type[i], Pos[i].x, Pos[i].y);
	
	pDD->GetDD()->FlipToGDISurface();
}

void CMainFrame::ReceiveMsgInit()
{
	// ÷̾  ޽     ݺ
	pDP->DPReceiveMessage();

	if (pDP->m_bAllPlayerConnect)
	{
		DPID MyPlayerID = pDP->GetMyPlayerID();
		CPoint Pos;
		//   ڽſ  ͸ ޴´		
		// MapShip ǥ Mapǥ ȯؼ 
		Pos   = m_Ship[MyPlayerID].ptPos;
		pMap->PutMapShipPosition(Pos);
		Pos.x = Pos.x / 32 - 10;
		Pos.y = Pos.y / 32 - 7;
	    pMap->PutMapPosition(Pos);				
		//
		m_bIsMsgInit = FALSE;
		m_iEvent = RADAR;
		//
		pDS->Stop(CONNECT);
		pDS->Play(COIN);		
		pDS->SetVol(BGM1, -200);
		pDS->Loop(BGM1);
		m_dwStartTime = timeGetTime();
	}
}

void CMainFrame::OnDestroy() 
{
	CFrameWnd::OnDestroy();	

	if (pSpr) { pSpr->DeleteSpriteList(); delete pSpr; }
	if (pMap) { pMap->DeleteTileArray();  pMap->ReleaseMap(); delete pMap; }
	if (pDD)  { pDD->DDObjectRelease();   delete pDD; }	
	if (pDS)  delete pDS;
	if (pDP)  delete pDP;
	
	::ShowCursor(TRUE);	
}

void CMainFrame::GameLoop(void)
{	
	int  MyPlayerID = pDP->GetMyPlayerID();
	int  ID, ConnectCount = pDP->GetConnectCount();
	////// ޽ ޴´
	pDP->DPReceiveMessage();
	// ޾ƿ     ͸ DirectPlay Ŭ ޾ƿ´	
	for (ID=1; ID <= ConnectCount; ID++)
	{
		if (ID != MyPlayerID)
		{
			m_Ship[ID]  = pDP->GetBattleShipData(ID);		
			m_Laser[ID] = pDP->GetShipLaserData(ID);
		}
	} 

	////// ŰԷ ޴´
	pMap->ScrollMap(PushKey(), m_iEvent);

	// ڽ  ǥ ´
	m_Ship[MyPlayerID].ptPos = pMap->GetMapShipPosition();
	
	//  ߻ ó
	FireLaser();

	////// ĳ͸ Ѵ
	PutCharacters();

	// 浹ó
	Collide();

	// Ÿ  
	PutOthers();	

	//    ͸ DirectPlay Ŭ 	
	pDP->PutBattleShipData(MyPlayerID, m_Ship[MyPlayerID]);
	pDP->PutShipLaserData (MyPlayerID, m_Laser[MyPlayerID]);

	////// ޽ 
	pDP->DPSendMessage(0, MSG_SHIP);  // Ӽ 	

	if (m_Ship[MyPlayerID].bIsHit)
	{
		for (ID=1; ID <= ConnectCount; ID++)
			if (m_Ship[ID].iHitWho == MyPlayerID) break;
		m_Laser[ID].bLife = FALSE;
		m_Ship[MyPlayerID].bIsHit = FALSE;
		m_Ship[MyPlayerID].iHitWho = 0;
	}

	////// ȭ ø Ų
	pDD->FlipSurfaces();
	//
	m_dwFrameCount++;
}

void CMainFrame::PutCharacters()
{
	int MyPlayerID = pDP->GetMyPlayerID();
	int ID, ConnectCount = pDP->GetConnectCount();
	int EnemyPosX, EnemyPosY;	
	
	for (ID=1; ID <= ConnectCount; ID++)
	{
		if (ID != MyPlayerID)
		{
			EnemyPosX = 320 - (m_Ship[MyPlayerID].ptPos.x - m_Ship[ID].ptPos.x);
			EnemyPosY = 240 - (m_Ship[MyPlayerID].ptPos.y - m_Ship[ID].ptPos.y);
			//   ÷̾ ȭȿ  
			if (m_Ship[ID].iLife > 0 &&
				EnemyPosX > -50 && EnemyPosX < 690 &&
				EnemyPosY > -50 && EnemyPosY < 530)
			{
				pSpr->PutSpriteEx(BADSHIP, m_Ship[ID].iDirection, EnemyPosX, EnemyPosY);
			}
		}
	}
	if (m_Ship[MyPlayerID].iLife > 0) pSpr->PutSprite(MYSHIP, 320, 240);
}

void CMainFrame::PutOthers()
{	
	int MyPlayerID = pDP->GetMyPlayerID();
	int x, To = m_Ship[MyPlayerID].iLife / 10 * 9 + 17;

	if (m_iEvent == 0) 
	{
		// 
		pSpr->PutSprite(SHIELDBAR, 5, 5);
		//for (x=233; x >= To; x-=18)	pSpr->PutSprite(SHIELDBAR, 2, x, 16);
		for (x=233; x >= To; x-=9)	pSpr->PutSprite(SHIELDBAR, 1, x, 16);
		// ̴ 
		pSpr->PutSprite(RADAR, 0, 580, 60);
		DrawShipRadar();
		// ŸƲ 		
		pSpr->PutSprite(CYBERX, 0, 435, 23);
		//  ð 
		ShowTime();
		// ʴ Ӽ
		ShowFrames();
		//  Ƚ
		ShowHit();
		// ڽ  ID
		PutGameID(pDP->GetPlayerName(MyPlayerID));
	}

	switch(m_iEvent)
	{
	case GAMEOVER : GameOver();      break;
	case RADAR    : AnimateRadar();  break;
	case RANKBRD  : ShowRankBoard(); break;
	}	
}

void CMainFrame::GameOver()
{	
	static CRect rcDest(185, 240, 455, 240);		
	
	if (pDS->IsPlaying(EXPLOD2) == FALSE)
	{
		pSpr->PutSpriteFx(GAMEOVER, rcDest);
		
		if (pSpr->DelayTime(2, 50))
		{	
			if (rcDest.top    > 220) rcDest.top    -= 1;		
			if (rcDest.bottom < 260) rcDest.bottom += 1;
		}
		if (pDS->IsPlaying(BGM1))
		{
			pDS->Stop(BGM1);
			pDS->Play(GAMEOVERBGM);
		}
		if (pDS->IsPlaying(GAMEOVERBGM) == FALSE)
		{
			pDS->StopAll();
			m_iEvent = 0;
		}
	}
}

void CMainFrame::AnimateRadar()
{	
	static CRect rcSrc (530, 60, 630,  60);	
	static CRect rcDest(530, 10, 630, 110);

	pSpr->PutSpriteFx(RADAR, 0, rcSrc);	

	rcSrc.top    -= 2;
	rcSrc.bottom += 2;
	if (rcSrc == rcDest) m_iEvent = 0;
}

void CMainFrame::DrawShipRadar()
{	
	static int RadarLineY = 11;
	int MyPlayerID = pDP->GetMyPlayerID();
	int ID, ConnectCount = pDP->GetConnectCount();
	int RadarX, RadarY;

	//  
	for (ID=1; ID <= ConnectCount; ID++)
	{	
		if (m_Ship[ID].iLife > 0)
		{
			RadarX = m_Ship[ID].ptPos.x / 32 + 530;
			RadarY = m_Ship[ID].ptPos.y / 32 + 11;
					
			if (ID == MyPlayerID)
				pSpr->PutSprite(RADAR, 1, RadarX, RadarY);
			else 
				pSpr->PutSprite(RADAR, 2, RadarX, RadarY);
		}
	}
	// ̴  
	pSpr->PutSprite(RADAR, 3, 530, RadarLineY++);		
	if (RadarLineY > 109) RadarLineY = 11;
}

void CMainFrame::ShowRankBoard()
{
	int i, iy, ConnectCount = pDP->GetConnectCount();;
	static First = TRUE;
	static CRect rcSrc (320,  90, 320, 390);	
	static CRect rcDest(140,  90, 500, 390);

	if (First)
	{
		if (pDS->IsPlaying(BGM1)) pDS->Stop(BGM1);
		pDS->Play(RANKBRDBGM);
		RankSort();
		First = FALSE;
	}
	if (pSpr->DelayTime(3, 17000))   // ð ش
	{
		if (pDS->IsPlaying(RANKBRDBGM)) pDS->Stop(RANKBRDBGM);		
		rcSrc = rcDest;
		First = TRUE;
		m_iEvent = 0;
		//   ó
		pDD->FadeOut();
		pDS->StopAll();
        PostMessage(WM_CLOSE);
	}

	pSpr->PutSpriteFx(RANKBRD, rcSrc);	
	
	if (rcSrc != rcDest) { rcSrc.left -= 5; rcSrc.right += 5; }
	else
	{
		for (i=1, iy=155; i <= ConnectCount; iy+=47,i++)
		{
			PutString(iy, pDP->GetPlayerName(m_ShipRank[i].GameID));
		}
	}
}

void CMainFrame::RankSort()
{
	int ID, ConnectCount = pDP->GetConnectCount();
	int To, Flag = ConnectCount;
	
	for (ID=1; ID <= ConnectCount; ID++)
	{
		m_ShipRank[ID].GameID = ID;
		m_ShipRank[ID].iHitCount = m_Ship[ID].iHitCount;
	}

	do
	{
		To = Flag - 1;
		Flag = 0;
		for (ID=1; ID <= To; ID++)
		{
			if (m_ShipRank[ID].iHitCount < m_ShipRank[ID+1].iHitCount)
			{
				m_ShipRank[0]    = m_ShipRank[ID];      // temp
				m_ShipRank[ID  ] = m_ShipRank[ID+1];
				m_ShipRank[ID+1] = m_ShipRank[0];
				Flag = ID;
			}
		}
	} while (Flag > 0);
}

void CMainFrame::PutString(int y, CString str)
{
	BYTE Alphabet;
	RECT rcSprite;
	int i, ix, Step, TotalStep = 0;
	int x, Len = str.GetLength();

	str.MakeUpper();	
	for (i=0; i < Len; i++) 
	{
		Alphabet = str.GetAt(i) - 65;
		if (Alphabet > -1 && Alphabet < 26)
		{
			rcSprite = pSpr->GetSpriteRect(ALPHABET, Alphabet);
			Step = rcSprite.right+3;
			TotalStep += Step;
		}
	}
	x = 325 - TotalStep / 2;
	for (ix = x, i = 0; i < Len; ix += Step, i++)
	{
		Alphabet = str.GetAt(i) - 65;
		if (Alphabet > -1 && Alphabet < 26)
		{		
			pSpr->PutSprite(ALPHABET, Alphabet, ix, y);		
			rcSprite = pSpr->GetSpriteRect(ALPHABET, Alphabet);
			Step = rcSprite.right+3;
		}
		else Step = 0;
	}
}

void CMainFrame::PutGameID(CString str)
{
	BYTE Alphabet;
	RECT rcSprite;
	int i, ix, x, Step;
	int TotalStep = 0, Len = str.GetLength();
		
	str.MakeUpper();		
	for (i=0; i < Len; i++) 
	{
		Alphabet = str.GetAt(i) - 65;
		if (Alphabet > -1 && Alphabet < 26)
		{
			rcSprite = pSpr->GetSpriteRect(ALPHABET, Alphabet);
			Step = rcSprite.right+3;
			TotalStep += Step;
		}
	}
	x = 635 - TotalStep;
	for (ix = x, i = 0; i < Len; ix += Step, i++)
	{
		Alphabet = str.GetAt(i) - 65;
		if (Alphabet > -1 && Alphabet < 26)
		{			
			pSpr->PutSprite(ALPHABET, Alphabet, ix, 445);		
			rcSprite = pSpr->GetSpriteRect(ALPHABET, Alphabet);
			Step = rcSprite.right+3;
		}
		else Step = 0;
	}
}

void CMainFrame::ShowTime()
{	
	DWORD Seconds=(timeGetTime() - m_dwStartTime) / 1000;
	int   Time, TimeHigh, TimeLow;

	Time = 59 - Seconds;
	if (Time > 0)
	{
		TimeHigh = Time / 10;
		TimeLow  = Time - (TimeHigh * 10);
		pSpr->PutSprite(NUMBER, TimeHigh, 302, 8);
		pSpr->PutSprite(NUMBER, TimeLow,  324, 8);
	}
	else 
	{
		pSpr->PutSprite(NUMBER, 0, 302, 8);
		pSpr->PutSprite(NUMBER, 0, 324, 8);
		if (pDS->IsPlaying(BGM1)) pDS->Stop(BGM1);
		m_iEvent = RANKBRD;
	}
}

void CMainFrame::ShowHit()
{
	int MyPlayerID = pDP->GetMyPlayerID();
	int HitHigh, HitLow;

	pSpr->PutSprite(HIT, 5, 445);
	if (m_Ship[MyPlayerID].iHitCount > 0)
	{
		HitHigh = m_Ship[MyPlayerID].iHitCount / 10;
		HitLow  = m_Ship[MyPlayerID].iHitCount - (HitHigh * 10);
		pSpr->PutSprite(NUMBER, HitHigh, 100, 445);
		pSpr->PutSprite(NUMBER, HitLow,  122, 445);
	}
	else 
	{
		pSpr->PutSprite(NUMBER, 0, 100, 445);
		pSpr->PutSprite(NUMBER, 0, 122, 445);		
	}
}

void CMainFrame::ShowFrames()
{
	DWORD Frames, FrameHigh, FrameLow;
	DWORD Seconds = (timeGetTime() - m_dwStartTime) / 1000;

	if (Seconds>0)
		Frames = m_dwFrameCount / Seconds;
	else
		Frames = 0;
	if (m_dwFrameCount && Seconds > 2)
	{
		if (Frames > 99) FrameHigh = FrameLow = 9;
		else
		{
			FrameHigh = Frames / 10;
			FrameLow  = Frames - (FrameHigh * 10);
		}
		pSpr->PutSprite(NUMBER, FrameHigh,  5, 410); // 5, 593
		pSpr->PutSprite(NUMBER, FrameLow,  27, 410); // 27,615
	}
}

void CMainFrame::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	switch(nChar)
	{	
	case VK_F11    : // pDD->FadeOut();  pDD->FadeIn();
		             break;
	case VK_ESCAPE : pDS->StopAll();
		             PostMessage(WM_CLOSE);
	}

	CFrameWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}

int CMainFrame::PushKey()
{	
	int FrameIndex = -1;	
	DPID MyPlayerID = pDP->GetMyPlayerID();

	// if (m_iEvent != 0) return FrameIndex;
	if (m_Ship[MyPlayerID].iLife > 0)
	{
		if (::GetKeyState(VK_LEFT)&  0x80)
		{
			FrameIndex = pSpr->SprPrevFrameKey(MYSHIP, 70);
			if (FrameIndex != -1) m_Ship[MyPlayerID].iDirection = FrameIndex;			
		}
		if (::GetKeyState(VK_RIGHT)& 0x80)
		{
			FrameIndex = pSpr->SprNextFrameKey(MYSHIP, 70);
			if (FrameIndex != -1) m_Ship[MyPlayerID].iDirection = FrameIndex;					
		}
		if ((::GetKeyState(VK_SPACE)& 0x80) &&
			m_iEvent == 0 && pSpr->DelayTime(1, 600))			
		{			
			pDS->Play(FIRE);
			m_Laser[MyPlayerID].bLife = TRUE;		
			m_Laser[MyPlayerID].ptPos = m_Ship[MyPlayerID].ptPos;        
			m_Laser[MyPlayerID].iDirection = m_Ship[MyPlayerID].iDirection;
		}
	}

	return FrameIndex;
}

void CMainFrame::FireLaser()
{
	int MyPlayerID = pDP->GetMyPlayerID();
	int ID, LaserDistX, LaserDistY,
		ConnectCount = pDP->GetConnectCount();

	LaserDistX = abs(m_Ship[MyPlayerID].ptPos.x - m_Laser[MyPlayerID].ptPos.x);
	LaserDistY = abs(m_Ship[MyPlayerID].ptPos.y - m_Laser[MyPlayerID].ptPos.y);
	if (m_Laser[MyPlayerID].bLife && LaserDistX < 320 && LaserDistY < 240)
	{		
		m_Laser[MyPlayerID].ptPos -= ptLaserStep[m_Laser[MyPlayerID].iDirection];
		int LaserPosX = 320 - (m_Ship[MyPlayerID].ptPos.x - m_Laser[MyPlayerID].ptPos.x);
		int LaserPosY = 240 - (m_Ship[MyPlayerID].ptPos.y - m_Laser[MyPlayerID].ptPos.y);
		pSpr->PutSprite(LASER, m_Laser[MyPlayerID].iDirection, LaserPosX, LaserPosY);
	}
	else
	{		
		m_Laser[MyPlayerID].bLife = FALSE;
	}

	for (ID=1; ID <= ConnectCount; ID++)
	{
		if (ID != MyPlayerID)
		{
			LaserDistX = abs(m_Ship[MyPlayerID].ptPos.x - m_Laser[ID].ptPos.x);
			LaserDistY = abs(m_Ship[MyPlayerID].ptPos.y - m_Laser[ID].ptPos.y);
			if (m_Laser[ID].bLife && LaserDistX < 320 && LaserDistY < 240)
			{		
				m_Laser[ID].ptPos -= ptLaserStep[m_Laser[ID].iDirection];
				int LaserPosX = 320 - (m_Ship[MyPlayerID].ptPos.x - m_Laser[ID].ptPos.x);
				int LaserPosY = 240 - (m_Ship[MyPlayerID].ptPos.y - m_Laser[ID].ptPos.y);
				//  ÷̾ ȭȿ  
				if (LaserPosX > -50 && LaserPosX < 690 &&
					LaserPosX > -50 && LaserPosY < 530)
				{
					pDS->Play(FIRE);
					pSpr->PutSprite(LASER, m_Laser[ID].iDirection, LaserPosX, LaserPosY);
				}
			}
			else
			{			
				m_Laser[ID].bLife = FALSE;
			}
		}
	}
}

BOOL CMainFrame::IsHit(int SprType1, POINT Pos1, int SprType2, POINT Pos2)
{
	CRect rc;
	CRect rcSprType1 = pSpr->GetPosition(SprType1, Pos1.x, Pos1.y);
	CRect rcSprType2 = pSpr->GetPosition(SprType2, Pos2.x, Pos2.y);
	
	return rc.IntersectRect(rcSprType1, rcSprType2);	
}

void CMainFrame::Collide()
{
	int MyPlayerID = pDP->GetMyPlayerID();
	int ID, ConnectCount = pDP->GetConnectCount();
	
	// ڽ    浹
	if (m_Laser[MyPlayerID].bLife)
	{
		for (ID=1; ID <= ConnectCount; ID++)
		{
			if (ID != MyPlayerID && m_Ship[ID].iLife > 0 &&
				m_Ship[ID].bIsHit && m_Ship[ID].iHitWho == MyPlayerID)
				{
					m_Laser[MyPlayerID].bLife = FALSE;					
					m_Ship[MyPlayerID].iHitCount++;
					if (m_Ship[ID].iLife > 0)
						pDS->Play(EXPLOD1);
					else
						pDS->Play(EXPLOD2);
				}
		}
	}

	//   ڽ  浹
	for (ID=1; ID <= ConnectCount; ID++)
	{
		if (ID != MyPlayerID && m_Laser[ID].bLife)
		{
			if (m_Ship[MyPlayerID].iLife > 0 &&
				IsHit(LASER, m_Laser[ID].ptPos, MYSHIP, m_Ship[MyPlayerID].ptPos)
				&& m_Ship[MyPlayerID].bIsHitAni == FALSE)
			{
				m_Ship[MyPlayerID].bIsHit    = TRUE;
				m_Ship[MyPlayerID].bIsHitAni = TRUE;
				m_Ship[MyPlayerID].iHitWho   = ID;
				m_Laser[ID].bLife            = FALSE;
				m_Ship[MyPlayerID].iLife -= 10;
				if (m_Ship[MyPlayerID].iLife > 0)
					pDS->Play(EXPLOD1);
				else 
				{
					pDS->Play(EXPLOD2);
					m_iEvent = GAMEOVER;
				}
			}			
		}
	}	

	int Death = 1;
	//  ִϸ̼ ó
	for (ID=1; ID <= ConnectCount; ID++)
	{			
		if (m_Ship[ID].bIsHitAni) 
		{		
			BOOL rval;
			int ExplodPosX = 320 - (m_Ship[MyPlayerID].ptPos.x - m_Ship[ID].ptPos.x);
			int ExplodPosY = 240 - (m_Ship[MyPlayerID].ptPos.y - m_Ship[ID].ptPos.y);
			if (m_Ship[ID].iLife > 0)
				rval = pSpr->AnimateSpriteEx(EXPLOD1ANI, ExplodPosX, ExplodPosY, ID, 80);
			else
				rval = pSpr->AnimateSpriteEx(EXPLOD2ANI, ExplodPosX, ExplodPosY, ID, 100);
			if (rval == TRUE) m_Ship[ID].bIsHitAni = FALSE;
		}
		//
		if (ID != MyPlayerID && m_Ship[ID].iLife < 1) Death++;
		if (Death == ConnectCount && pDP->m_bIsSolo == FALSE) m_iEvent = RANKBRD;
	}	
}