#include "GDDRAW.h"
#include "GObject.h"
#include "Lsp.h"
#include "TestChar.h"

#define GetMyKeyState( vkey ) HIBYTE(GetAsyncKeyState( vkey ))
#define GetMyKeyPush( vkey )  LOBYTE(GetAsyncKeyState( vkey ))

////////////////////////////////
//  Ŭ 
///////////////////////////////
GDDRAW			gddraw;					//̷Ʈ Ʈο Ŭ GDDraw    .h .cpp
LSP				lsp;					//LSP Ŭ			 Lsp       .h .cpp
GObjectManager	OBM;					//Ʈ Ŵ Ŭ GObject   .h .cpp
TESTCHAR		char1, char2, char3 ;	//׽Ʈĳ Ŭ	 TestClass .h .cpp


///////////////////////////////
//
//   InitApp
//
///////////////////////////////
BOOL InitApp()
{
	//////////////////////////////
	//  Ŭ ʱȭ
	//////////////////////////////
	if( lsp.Init() == FALSE ) return FALSE;
	if( OBM.Init() == FALSE ) return FALSE;
	
	///////////////////////////////
	// ȷ о Ѵ.
	///////////////////////////////
	HFILE hfile;
    BYTE palette[768];
	
	hfile = _lopen( "stage1-1.pal", OF_READ );
	if( hfile == -1 ) return FALSE; 
    if( _lread( hfile, palette, 768) == HFILE_ERROR ) return FALSE; 
	_lclose( hfile );

	gddraw.SetPalette( (LPBYTE)palette );

	///////////////////////////////////////////
	//  ĳ͸ ʱȭ Ѵ.
	// (޸𸮳  ϳ εؼ 
	// ͸ .)
	///////////////////////////////////////////
	char1.LoadSprite();
	char2.Sprite = char1.Sprite ; 
	char3.Sprite = char1.Sprite ; 

	char1.x = 100; char1.y = 100;
	char2.x = 200; char2.y = 100;
	char3.x = 300; char3.y = 100;

	//////////////////////////////////////////////
	// Ʈ ޴ Ʈ Ѵ.
	///////////////////////////////////////////////
	OBM.AddObject( &char1 );
	OBM.AddObject( &char2 );
	OBM.AddObject( &char3 );

	return TRUE;
};

///////////////////////////////
//
//   Main
//
///////////////////////////////
void Main()
{
	//////////////////////////////
	// ⺻ ƾ...
	//////////////////////////////
    static  int  frame;

    frame = (frame+1)%40;
	char1.Frame = frame;
	char2.Frame = frame/2;
	char3.Frame = frame/4;

	if( GetMyKeyPush( VK_ESCAPE ) ){ PostQuitMessage(0); return; };
	
	/////////////////////////////
	// ȭ鿡 ׸ κ...
	/////////////////////////////
	if( gddraw.FrameSkip() ) //  Ű
	{
		lsp.ResetLsp();

		//////////////////////////////////////////////////////
		// ϵ  Ʈ  ޼ .
		//////////////////////////////////////////////////////
		OBM.SendMessageAll( _MSG_RENDER_, (DWORD)&lsp, 0 );
		
		/////////////////////////////////////////////
		// lsp   ȭ鿡 Ѵ.
		/////////////////////////////////////////////
		LPBYTE _PPTR = gddraw.BeginPaint();
		if( _PPTR == NULL ){ PostQuitMessage(0); return; };
	    lsp.PutScreen( _PPTR );
		gddraw.EndPaint();
	};
};

///////////////////////////////
//
//   WndProc
//
///////////////////////////////
LRESULT CALLBACK WndProc(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
	switch( Msg )
	{
	case WM_DESTROY:
		PostQuitMessage(0);
		return 0;
	}
	
	// ø̼ Ȱȭ ¸ ϱ...
	gddraw.GDDProc( Msg, wParam, lParam); 

	return  DefWindowProc(hWnd, Msg, wParam, lParam);
};

///////////////////////////////
//
//   WinMain
//
///////////////////////////////
int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR CmdLine, int CmdShow )
{
	/////////////////////////
	// ø̼ ʱȭ
	/////////////////////////
	if(	gddraw.Init( hInstance, "GDDRAW test", WndProc ) == FALSE ) return 0;
	if( InitApp() == FALSE ) return 0;

	//////////////////////
    // ӽŰغ!!
	//////////////////////
	gddraw.SetTimer();

	///////////////////////
	// ޼  ~~~ 
	////////////////////////
	MSG     msg;
    int     done = 1;

	while(done) 
	{
        while( PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) !=0 ) 
		{
            if( !GetMessage( &msg, NULL, 0, 0) )
			{
				done = 0;
				break;
			}
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        };

        if (gddraw.IsActive()) Main();		
    };

	///////////////////
	//α׷ ...
	///////////////////
	char2.Sprite = NULL;
	char3.Sprite = NULL;
	
	return msg.wParam;
};


